//创建一个新的Java日期对象 ,注意不是JavaScript的日期对象
function newDate() {
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "dateFunction",
        {
            method: 'newDate'
        }
    );
    //return new Date(ret.value);
    //在 ios 下或 Safari下， 日期间隔不是用.或- ,是用/
    return   spreadsheet.db.ObjectTool.changeType( ret.value ,  spreadsheet.core.UniformDataType.$Datetime );
}


function clientDate() {
    return new Date();

}

//服务端脚本，日期格式遵循java格式，所以这里对日期的格式化，没有用原先js的处理方式，而是用远程调用保持与服务端脚本执行得到相同的格式
function formatDate(d, format) {
    if(d==null) return null;

    return date2str( d, format);

    /*
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "dateFunction",
        {
            method: 'formatDate',
            date: d.Format('yyyy-MM-dd HH:mm:ss.S'),
            format: format
        }
    );
    return ret.value;
*/

}

/**
 格式化显示日期时间

  参数x : 待显示的日期时间，示例： new Date()

  参数y: 需要显示的格式，示例：yyyy-MM-dd HH:mm:ss
*/
function date2str(x, y) {

	if( x==null || y==null) return "";
    var z = {
        y: x.getYear()+1900,
        M: x.getMonth() + 1,
        d: x.getDate(),
        h: x.getHours(),
        H:x.getHours(),
        m: x.getMinutes(),
        s: x.getSeconds()
    };

    return y.replace(/(y+|M+|d+|h+|H+|m+|s+)/g, function(v) {
        return ((v.length > 1 ? "0" : "") + eval('z.' + v.slice(-1))).slice(-(v.length > 2 ? v.length : 2))

    });

}


function createDate(year, month, day) {
    return new Date(year, month-1, day);
}

function createDate2(year, month, day, hour, minute, second) {
    return new Date(year, month-1, day, hour, minute, second);
}

function date2yyyymmdd(d, split) {
    if( split==undefined) split='.';
    return date2str( d , 'yyyy'+split+'MM'+split+'dd');

}

function date2int(d) {

    return date2yyyymmdd(d, '');

}


function hoursBetween(big, small) {
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "dateFunction",
        {
            method: 'hoursBetween',
            big: big.Format('yyyy-MM-dd HH:mm:ss.S'),
            small: small.Format('yyyy-MM-dd HH:mm:ss.S')
        }
    );
    return ret.value;


}

function daysBetween(big, small) {
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "dateFunction",
        {
            method: 'daysBetween',
            big: big.Format('yyyy-MM-dd HH:mm:ss.S'),
            small: small.Format('yyyy-MM-dd HH:mm:ss.S')
        }
    );
    return ret.value;
}


function minutesBetween(big, small) {
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "dateFunction",
        {
            method: 'minutesBetween',
            big: big.Format('yyyy-MM-dd HH:mm:ss.S'),
            small: small.Format('yyyy-MM-dd HH:mm:ss.S')
        }
    );
    return ret.value;
}

function secondsBetween(big, small) {
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "dateFunction",
        {
            method: 'secondsBetween',
            big: big.Format('yyyy-MM-dd HH:mm:ss.S'),
            small: small.Format('yyyy-MM-dd HH:mm:ss.S')
        }
    );
    return ret.value;
}


function yyyymmdd2Date(s) {
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "dateFunction",
        {
            method: 'yyyymmdd2Date',
            str: s
        }
    );
    return  new Date(  ret.value);
}

//保证 星期一是1
function getDayOfWeek(d) {
    return d.getDay();
}

function isMonday(d) {
    var week = d.getDay();
    return week=1;

}

function isTuesday(d) {
    var week = d.getDay();
    return week=2;
}

function isWednesday(d) {
    var week = d.getDay();
    return week=3;
}

function isThursday(d) {
    var week = d.getDay();
    return week=4;
}

function isFriday(d) {
    var week = d.getDay();
    return week=5;
}

function isSaturday(d) {
    var week = d.getDay();
    return week=6;
}


function isSunday(d) {
    var week = d.getDay();
    return week=0;
}

function getDayOfMonth(d) {
    return d.getDate();
}

function getDayOfYear(d) {
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "dateFunction",
        {
            method: 'getDayOfYear',
            d: d.Format('yyyy-MM-dd HH:mm:ss.S')

        }
    );
    return ret.value;
}

function getHourOfDay(d) {
    return d.getHours();
}

function getHour(d) {
    return d.getHours();
}


function getSecond(d) {
    return d.getSeconds();
}

function getMinute(d) {
    return d.getMinutes();
}

function getWeekOfMonth(d) {
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "dateFunction",
        {
            method: 'getWeekOfMonth',
            d: d.Format('yyyy-MM-dd HH:mm:ss.S')

        }
    );
    return ret.value;
}

function getWeekOfYear(d) {
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "dateFunction",
        {
            method: 'getWeekOfYear',
            d: d.Format('yyyy-MM-dd HH:mm:ss.S')

        }
    );
    return ret.value;
}

function isAfterDate(d1, d2) {
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "dateFunction",
        {
            method: 'isAfterDate',
            d1: d1.Format('yyyy-MM-dd HH:mm:ss.S'),
            d2: d2.Format('yyyy-MM-dd HH:mm:ss.S')
        }
    );
    return ret.value;
}

function isBeforeDate(d1, d2) {
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "dateFunction",
        {
            method: 'isBeforeDate',
            d1: d1.Format('yyyy-MM-dd HH:mm:ss.S'),
            d2: d2.Format('yyyy-MM-dd HH:mm:ss.S')
        }
    );
    return ret.value;
}

function nextDate(d_, n, what) {
	
	 let d=  spreadsheet.util.Util.clone(d_);
	 if( ! spreadsheet.util.Util.isDate(d))  d= spreadsheet.db.ObjectTool.changeType(d , spreadsheet.core.UniformDataType.$Datetime);


	    
    if (typeof(what) == 'undefined') what = 'day';
    

    if (typeof(what) == 'undefined') what="day";
    if( what=='year') d.setYear(1900+ d.getYear()+n);
    if( what=='month') d.setMonth( d.getMonth()+n);
    if( what=='day')  d.setTime( d.getTime()+  n*24*60*60*1000);
    if( what=='hour')  d.setTime( d.getTime()+  n*60*60*1000);
    if( what=='minute')  d.setTime( d.getTime()+  n*60*1000);
    if( what=='second')  d.setTime( d.getTime()+  n*1000);

    return d;
    
    
    
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "dateFunction",
        {
            method: 'nextDate',
            d: d.Format('yyyy-MM-dd HH:mm:ss.S'),
            n: n,
            what: what
        }
    );
    return  new Date(ret.value);

}


function getYear(d) {
    return   d.getYear() +1900;
}


function getMonth(d) {
    return  d.getMonth()+1;
}


function int2Date(v) {
    var rq = '' + v;
    rq = mid(rq, 0, 4) + "." + mid(rq, 4, 6) + "." + mid(rq, 6, 8);
    return yyyymmdd2Date(rq);
}


function thisMonthFirstDay(y, m) {
    var d1 = createDate(y, m, 1); //月初
    return d1;
}

function thisMonthLastDay(y, m) {
    var d1 = nextMonthFirstDay(y, m); //下月初
    return nextDate(d1, -1);
}


function nextMonthFirstDay(y, m) {

    var y2 = y;
    var m2 = parseInt( ''+ m ) ;
    if (m2 < 12)  //如果月份小于12，那么月份加１
    {
        m2 = m2 + 1;
    } else //否则年份加１，月份设置还１
    {
        m2 = 1;
        y2 = y2 + 1;
    }

    var d2 = createDate(y2, m2, 1); //下一个月的月初


    return d2;

}



function timestamp2Date( s)
{
    var  d= new Date(   s *1000);
    return d;
}



