
/*
 * 删除单据时，把删除单据之后的所有单据号重排
 * 
 * 注意：只能一张一张地删除单据，每删除一张，单据号重排一次
 * 
 *  参数说明： id 被删除单据的id 
 *  
 *  原理：把被删除单据号之后的单据取出来，依次把号码设置成前一张单据的号码
 *  细节：1 只把单据号长度相等的那些单据号重排。因此单据号务必保持相同的长度 
 *  
 * */

function  buildSQLForReSortBillNoAfterDeleteOne( id , where)
{   
	
	
    var ret=[];
    var table= flow.getMasterTableName();
    
    var ds=newDataStore('',"select id, billno , billtype from "+table+ " order by billno asc");//一定要按单据号排序
     
    ds.retrieve("id='"+id+"'");
    println( ds.getRowCount());
    if( ds.getRowCount()!=1)  return JSON.toString(ret);
    
    //检索在此单据之后的所有单据，并重排单据号
    var billtype= ds.getInt(0,"billtype");
    var billno= ds.getString(0,"billno");
    
    if( where==undefined)  where="";
    
    //注意，一定要加上单据号长度相同的那一些号才重排
    where= appendWhere(where, " billtype="+billtype+" and  billno >='"+billno+"' and len(billno)= "+len(billno) , "and") ;
    
    println(where);
    var n=ds.retrieve( where);
    for(var i=1;i<n;i++) // i==0的那行是将要删除的单据，所以它不用重排单据号
    {
        var lastBillNo=ds.getString( i-1,"billno");
        var thisBillID=ds.getString( i, "id");
        ret.push( "update "+table+" set billno='"+lastBillNo+"' where id='"+thisBillID+"'");
    }
    println( JSON.toString(ret));
  	return JSON.toString(ret);
    
} 


function  reloadBillInfo(gguid)
{
	webEval( " reloadBillInfo ('"+ gguid+"')");

}

function  getCurrentMasterTableName()
{
	return ''+ flow.getMasterTableName();
}

function getCurrentBillType()
{
	return flow.BILLTYPE;
}