/**

 服务端脚本中大量扩展函数是通过一个名为 app的对象提供了， 为了浏览器端也使用相似的脚本
 在此也提供一个 app对象

 */


var $app = {};

/**
 * httpPost ,注意是同步访问
 * @param url
 * @param config  一定是字符串，如果是对象，请先JSON.stringify
 * @returns {*}
 */
$app.httpPost = function (url, config, callback) {


    if (!callback) {
        var ret = $ajax.rpc("script", "debug.ScriptAgent", "httpPost",
            {
                url: url,
                config: config
            }
        );

        return ret;
    } else {
        $ajax.rpc("script", "debug.ScriptAgent", "httpPost",
            {
                url: url,
                config: config
            }, function (ret) {


                callback(ret);
            });

    }
}

/**
 * 创建结果集
 * @param dsn
 * @param select
 * @returns {*|Promise}
 */
$app.newDataStore = function (dsn, select) {

    var t = window.location.href;
    var homeURL = t.substring(0, t.lastIndexOf('/' ));
    //先得到字段清单，数据库类型
    // book.newQueryId
    // book.templateId  在 book创建时已经初始化了

    var t = $ajax.post("DataStore/newDataStore", {
        newQueryId: book.newQueryId,
        templateId: book.templateId,
        dsn: dsn,
        select: select,
        authorizationKey: $('meta[name="AuthorizationKey"]').attr("content") || '',
        authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr("content") || ''
    }, null, 'text', false).responseText;
    var ret = JSON.parse(t);
    if (!ret.success) {
        console.error(ret.message);
        return null;
    }
    //再传入book，创建dataStore
    var ds = book.newDataStore(dsn, select, homeURL, ret.dialect, ret.value);

    //下面几个属性必须设置，不然，没法执行retrieve
    ds.label = "客户端临时创建的DataStore";

    ds.name = ret.table;
    ds.id = ret.tableid;
    ds.templateid = ret.templateid;

    return ds;

}



