/**
 * ajax的简单实现
 * 本类的目的是以同步的方式调用服务端功能，
 * 把调用方式缺省改成了同步。
 */



var $ajax = function () {


    var objToString = Object.prototype.toString;

    function isString(value) {
        return objToString.call(value) === '[object String]';
    }

    function isObject(value) {

        var type = typeof value;
        return type === 'function' || (!!value && type == 'object');
    }


//当没有包含jquery时， 返回下面的实现，注音，它与jquery的 ajax ，及 get, post 具有相同的参数 定义和使用方法

    var ajax = function (opt) {
            var url = opt.url;
            var asyncCall = opt.asyncCall || false;//缺省是同步，程序上容易控制，但可能会卡死浏览器
            var method = (opt.type || 'GET').toUpperCase();
            var data = opt.data || null;
            var success = opt.success || function () {
            };
            var failure = opt.failure || function () {
            };
            var timeout = opt.timeout || 1000 * 300;
            var isTimeout = false;

            var xhr = window.XMLHttpRequest ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            xhr.onreadystatechange = function () {
                if (xhr.readyState == 4) {
                    var s = xhr.status;
                    if (s >= 200 && s < 300 || s == 304) {
                        success(xhr.responseText);
                    } else {
                        failure(xhr.responseText);
                    }
                } else {
                    if (isTimeout) {
                        clearTimeout(timer);
                        failure("timeout");
                        return;
                    }

                }
            };

            var time = false;//是否超时
            var timer = setTimeout(function () {
                isTimeout = true;
                xhr.abort();//请求中止
            }, timeout);

            //当是get方式时，请直接拼好data ,这里不接受json对象
            if (method == 'GET' && data) {
                url += (url.indexOf('?') == -1 ? '?' : '&') + data;
                data = null;
            }

            xhr.withCredentials = opt.withCredentials || false;
            xhr.open(method, url, asyncCall);
            if (method == 'POST') {
                xhr.setRequestHeader('Content-type', 'application/json');
            }
            //超级大坑，如果不转换成String，那么会出现cors错误

            if (isString(data)) {
                xhr.send(data);
            } else if (isObject(data)) {
                xhr.send(JSON.stringify(data));
            }
            return xhr;
        }
    ;

    var get = function (url, data, success, dataType, asyncCall) {
        return ajax({url: url, data: data, success: success, dataType: dataType, asyncCall: asyncCall});
    };

    var post = function (url, data, success, dataType, asyncCall) {
        return ajax({type: 'POST', url: url, data: data, success: success, dataType: dataType, asyncCall: asyncCall});
    };


    function rpc(serviceName, className, method, jsonParamString, success) {


        var timestamp = new Date().getTime();

        var paramString = jsonParamString;
        if (jsonParamString == undefined) paramString = {};  //可能没有参数


        var ret = '';


        var asyncCall = false;//缺省是同步调用
        if (!success) {
            success = function (data) {
                ret = data;
            };
        } else {
            asyncCall = true; //异步
        }


        post("RPCRouter?timestamp=" + timestamp,
            JSON.stringify({  //需转成字符串，不然，会以 key ,value 的形式传递
                $servicename: serviceName,
                classname: className,
                methodname: method,
                parameter: paramString
            })
            , success, 'text', asyncCall);

        try {
            return JSON.parse(ret);
        } catch (err) {
            return ret;
        }


    }


    return {ajax: ajax, get: get, post: post, rpc: rpc};
}();

