/**
 *  JSON在对字符串转译成对象时， 对于对于超过15位长度的数字， 解析后会缺失精度，下面的parsse2 是把长度超过15位的数字，强制转成字符串
 *
 *
 *
 * 原理是： 1 先解析一遍，找出其中的数字型属性，做为需要修正 的对象
 *            2  当它是超过15位长度时，把源中的内容强制拼上引号，转成字符串
 *            3 再次对替换后的字符串解析
 *
 * @param baseStr
 * @returns {any}
 */


JSON.toString= JSON.stringify; 

JSON.parse2 = function (baseStr) {

    var ret = getRealJsonData(baseStr);

    return ret;


//主入口
    function getRealJsonData(baseStr) {

        // javaClassName 在 util.js中
        // 本脚本在服务器端执行时，传入的 baseStr 可能是 java.lang.String对象 ，此时  typeof baseStr =='Object'而不是  'string'，需要把它转换成js的String
        // 浏览器端执行时，不存在javaClasee的问题，所以在 util.js中  javaClassName 返回 的就是 typeof

        var javaClass = javaClassName(baseStr);
        //println( javaClass);
        if (javaClass == 'java.lang.String') baseStr = '' + baseStr;


        if (!baseStr || typeof baseStr != 'string') return;

        var jsonData = null;
        try {
            jsonData = JSON.parse(baseStr);
        } catch (err) {
            println("error");
            println(JSON.toString(err));
            return null;
        }


        var needReplaceStrs = [];

        loopFindArrOrObj(jsonData, needReplaceStrs);

        // println ( JSON.toString( needReplaceStrs));

        for (var i = 0; i < needReplaceStrs.length; i++) {
            var replaceInfo = needReplaceStrs[i];
            /*
                   属性与值间的: 前后可能存在空格
                   数字可能是负的，即 - 开头
                   \\s 是因为 要用 eval( '    ') 来创建一个正则对象 \\表示 \ ,然后与s 拼成\s 表示空格
                   * 是匹配0或N次 ， ？是匹配0或1次  , {15,}是至少匹配15次

                    代码参考自  https://www.jianshu.com/p/5519f8d1ed3b
                    原来的代码没有考虑空格，负数
             */

            //println( replaceInfo.key);
            //var matchArr = baseStr.match(eval('/"'+ replaceInfo.key + '"\\s*:\\s*-?[0-9]{15,}/'));
            // 上面的 eval方式，在浏览器中运行没问题， 在 服务端脚本中运行不正常 ， 因为没有原生的eval函数，换成 new RegExp方式兼容性比较 好
            var re = new RegExp('"' + replaceInfo.key + '"\\s*:\\s*-?[0-9]{15,}');
            var matchArr = baseStr.match(re);

            //println( matchArr);

            if (matchArr) {
                var str = matchArr[0];
                var replaceStr = str;
                replaceStr = replaceStr.replace(/\s*:\s*/g, ':"') + '"';
                baseStr = baseStr.replace(str, replaceStr);
            }
        }

        var returnJson = null;
        try {
            returnJson = JSON.parse(baseStr);
        } catch (err) {
            return null;
        }
        return returnJson;
    }

//遍历对象类型的
    function getNeedRpStrByObj(obj, needReplaceStrs) {
        for (var key in obj) {
            var value = obj[key];
            if (typeof value == 'number') {
                needReplaceStrs.push({key: key});
            }
            loopFindArrOrObj(value, needReplaceStrs);
        }
    }

//遍历数组类型的
    function getNeedRpStrByArr(arr, needReplaceStrs) {
        for (var i = 0; i < arr.length; i++) {
            var value = arr[i];
            loopFindArrOrObj(value, needReplaceStrs);
        }
    }

//递归遍历
    function loopFindArrOrObj(value, needRpStrArr) {
        var valueTypeof = Object.prototype.toString.call(value);
        if (valueTypeof == '[object Object]') {
            needRpStrArr.concat(getNeedRpStrByObj(value, needRpStrArr));
        }
        if (valueTypeof == '[object Array]') {
            needRpStrArr.concat(getNeedRpStrByArr(value, needRpStrArr));
        }
    }

}

