define({ "api": [
  {
    "type": "sum",
    "url": "函数",
    "title": "sum",
    "description": "<p>sum( p1 [,p2,p3....pn]  ) <br><br> 将所有参数加在一起，求和。如果其中任意一个参数是字符串，本函数则将它们串接成一个长字符串 <br> <font color=red>特别注意：本函数仅用在单元格的公式定义中，不能用在脚本中</font></p>",
    "name": "sum",
    "group": "AggregateGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "variant",
            "optional": false,
            "field": "p1",
            "description": "<p>, p2, ...pn   要累加的单元格名称或别名或常数 ，可以是多个单元格。当单元格绑定到多行结果集中字段时，本函数将该字段所有数据累加</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "variant",
            "optional": false,
            "field": "-",
            "description": "<p>返回数字或字符串</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\n=sum(a1) \n=sum(a1,b1)\n=sum(a1,b1,100)\n=sum(a1,100, b1, 'abc')",
        "type": "js"
      }
    ],
    "filename": "globalscript/doc.js",
    "groupTitle": "聚合函数"
  },
  {
    "type": "hideInfo",
    "url": "函数",
    "title": "hideInfo",
    "description": "<p>hideInfo(   ) <br><br> 关闭由showInfo 打开的模态提示信息窗口 <br></p>",
    "name": "hideInfo",
    "group": "DialogGroup",
    "version": "1.0.0",
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nshowInfo(\"*正在处理中... \");\n\n\nhideInfo();",
        "type": "js"
      }
    ],
    "filename": "globalscript/dialog.js",
    "groupTitle": "弹窗函数"
  },
  {
    "type": "inputBox",
    "url": "函数",
    "title": "inputBox",
    "description": "<p>inputBox( title , prompt ,defaultValue , placeHolder , callback) <br><br> 弹出一个模态窗口，允许输入一个数据 <br></p>",
    "name": "inputBox",
    "group": "DialogGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "title",
            "description": "<p>标题</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "prompt",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "defaultValue",
            "description": "<p>默认值</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "placeHolder",
            "description": "<p>输入框中的提示</p>"
          },
          {
            "group": "Parameter",
            "type": "Function",
            "optional": false,
            "field": "callback",
            "description": "<p>回调函数</p>"
          },
          {
            "group": "Parameter",
            "type": "boolean",
            "optional": false,
            "field": "nullable",
            "description": "<p>[可先参数] 输入的内容是否允许为空字符串，默认是false</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\ninputBox(\"提示\", \"请输入名称\", \"\",\"\" , function(val){alert(val);});",
        "type": "js"
      }
    ],
    "filename": "globalscript/dialog.js",
    "groupTitle": "弹窗函数"
  },
  {
    "type": "openDialog",
    "url": "函数",
    "title": "openDialog",
    "description": "<p>openDialog( title, type, id, width, height, param, urlParamString, callback) <br><br> 在弹出窗口中显示一个模板界面 <br></p>",
    "name": "openDialog",
    "group": "DialogGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "title",
            "description": "<p>窗口标题</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "type",
            "description": "<p>模板类型 可以是</p> <ul><li>\"billlist\" :表示是单据列表模板 </li> <li>\"bill\"  : 表示是单据模板</li> <li>\"report\"  : 表示是报表模板 </li> </ul>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "id",
            "description": "<p>单据或报表的ID，注意不是模板ID</p>"
          },
          {
            "group": "Parameter",
            "type": "number",
            "optional": false,
            "field": "width",
            "description": "<p>窗口宽度</p>"
          },
          {
            "group": "Parameter",
            "type": "number",
            "optional": false,
            "field": "height",
            "description": "<p>窗口高度</p>"
          },
          {
            "group": "Parameter",
            "type": "Object",
            "optional": false,
            "field": "param",
            "description": "<p>传入的数据，是一个JSON对象</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "urlParamString",
            "description": "<p>拼接到URL中的参数</p>"
          },
          {
            "group": "Parameter",
            "type": "Function",
            "optional": false,
            "field": "callback",
            "description": "<p>当弹出的窗口点击确认关闭窗口后执行此回调函数 ,如果不提供本参数，则对话框不显示下面的确认及关闭按钮</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nopenDialog( \"选择人员\" ,\"report\" , \"xxcsxxxx\" , 700,500, {a:1,b:2} , \"code=1&name=abc\" , function(val){alert(val);});",
        "type": "js"
      }
    ],
    "filename": "globalscript/dialog.js",
    "groupTitle": "弹窗函数"
  },
  {
    "type": "openSelectUserDialog",
    "url": "函数",
    "title": "openSelectUserDialog",
    "description": "<p>openSelectUserDialog( callback ) <br><br> 弹出显示一个选择人员的模态窗口 <br></p>",
    "name": "openSelectUserDialog",
    "group": "DialogGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Function",
            "optional": false,
            "field": "callback",
            "description": "<p>选择人员后的回调函数</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nopenSelectUserDialog( function(selectedUsers}{ console.dir( selectedUsers);});",
        "type": "js"
      }
    ],
    "filename": "globalscript/dialog.js",
    "groupTitle": "弹窗函数"
  },
  {
    "type": "openWindow",
    "url": "函数",
    "title": "openWindow",
    "description": "<p>openWindow( url ) <br><br>  在新的窗口中打开指定的URL地址</p> <p>当使用本系统开发钉钉H5微应用时，可以在单据编辑，单据列表及报表窗口中使用本函数实现在新窗口上打开链接 当本函数在PC端执行时， 它是新打开一个浏览器级的Tab页 <br></p>",
    "name": "openWindow",
    "group": "DialogGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "url",
            "description": "<p>要打开的地址，可以是相对地址，也可以是绝对地址</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nopenWindow( \"bill.jsp?id=abc\");\nopenWindow(\"http://www.jssheet.cn\");",
        "type": "js"
      }
    ],
    "filename": "globalscript/dialog.js",
    "groupTitle": "弹窗函数"
  },
  {
    "type": "showAttachmentList",
    "url": "函数",
    "title": "showAttachmentList",
    "description": "<p>showAttachmentList(  tableName , gguid , width ,height , readOnly) <br><br> 显示附件列表 <br></p>",
    "name": "showAttachmentList",
    "group": "DialogGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "tableName",
            "description": "<p>主表名称</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "gguid",
            "description": "<p>数据记录的GGUID</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "width",
            "description": "<p>窗口宽度</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "height",
            "description": "<p>窗口高度</p>"
          },
          {
            "group": "Parameter",
            "type": "boolean",
            "optional": false,
            "field": "readOnly",
            "description": "<p>只读</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nshowAttachmentList( \"abc\" , \"xafaed-sfafaefa-aseer2s454\" , 700,400, true);",
        "type": "js"
      }
    ],
    "filename": "globalscript/dialog.js",
    "groupTitle": "弹窗函数"
  },
  {
    "type": "showInfo",
    "url": "函数",
    "title": "showInfo",
    "description": "<p>showInfo( info ) <br><br> 弹出显示一个模态的提示信息窗口 <br><ul> <li>它并不阻塞脚本的执行，但是屏蔽了用户的鼠标键盘操作.  与showInfoPane不同的是，showInfoPane并不阻塞界面， 用户仍可以操作UI</li></p> <li>与toastr.info 不同的是，无论执行多少次 showInfo ,只需要一次 hideInfo 即可关闭提示信息小窗口。因为每次showInfo执行时，会自动将上次 的信息窗口关闭。而 toastr.info 会将每个信息都显示出来，并自动排版它们的位置，并逐一自动关闭 <li> showInfo 不会自动关闭，除非 调用 hideInfo( ) </li> </ul>",
    "name": "showInfo",
    "group": "DialogGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "info",
            "description": "<p>要显示的提示信息，</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nshowInfo(\"*正在处理中... \");\nshowInfo(\" 正在下载\");\n\nhideInfo();",
        "type": "js"
      }
    ],
    "filename": "globalscript/dialog.js",
    "groupTitle": "弹窗函数"
  },
  {
    "type": "buildSmartRetrieveWhere",
    "url": "函数",
    "title": "buildSmartRetrieveWhere",
    "description": "<p>buildSmartRetrieveWhere( sheet , dsn  ) <br><br> 根据用户输入的数据，构建动态检索条件 <br></p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "WorkSheet",
            "optional": false,
            "field": "sheet",
            "description": "<p>指定解析动态条件的工作表，通常是结果集绑定显示的工作表</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dsn",
            "description": "<p>结果集名称</p>"
          }
        ]
      }
    },
    "group": "FormGroup",
    "version": "1.0.0",
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "String",
            "optional": false,
            "field": "-",
            "description": "<p>返回构建好的where条件</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nbuildSmartRetrieveWhere( book.sheet0 , 'query1');",
        "type": "js"
      }
    ],
    "filename": "js/form/form.js",
    "groupTitle": "表单功能函数",
    "name": "Buildsmartretrievewhere"
  },
  {
    "type": "$popup",
    "url": "函数",
    "title": "$popup",
    "description": "<p>$popup(  title, url, width, height) <br><br> 在当前模板中弹出显示一个对话框（没有关闭按钮，没有确定取消等按钮）显示单据编辑或查看 界面。 通常用来在报表或单据列表窗口中，显示相关单据详情或弹出编辑相关单据 <br>如果是弹出单据编辑或查看而面，则弹框右上角不显示默认的X按钮， 而是使用工具栏上的返回按钮关闭弹框</p>",
    "name": "_popup",
    "group": "FormGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "title",
            "description": "<p>标题</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "url",
            "description": "<p>要打开的URL地址</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "width",
            "description": "<p>弹窗宽度，单位: px</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "height",
            "description": "<p>弹窗高度,单位: px</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\n$popup( \"详情\" , \"billedit.jsp?action=view&gguid=AB9A3030-61DB-4094-B581-2F0EB2E30383&id=rytree\", 1000,6000  );",
        "type": "js"
      }
    ],
    "filename": "js/form/form.js",
    "groupTitle": "表单功能函数"
  },
  {
    "type": "buildRetrieveContext",
    "url": "函数",
    "title": "buildRetrieveContext",
    "description": "<p>buildRetrieveContext( triggerSheet, dsn ) <br><br> 构建动态检索数据上下文。 <br></p>",
    "name": "buildRetrieveContext",
    "group": "FormGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "WorkSheet",
            "optional": false,
            "field": "triggerSheet",
            "description": "<p>用来解析公式的worksheet，默认在此WorkSheet上查找公式中的别名</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dsn",
            "description": "<p>结果集名称 ，即在数据库定义中的结果集的名称</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "Object",
            "optional": false,
            "field": "-",
            "description": "<p>返回一个对象</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nvar data = form.buildRetrieveContext( book.sheet0 , \"query1\");",
        "type": "js"
      }
    ],
    "filename": "js/form/form.js",
    "groupTitle": "表单功能函数"
  },
  {
    "type": "buildSmartRetrieveWhere",
    "url": "函数",
    "title": "buildSmartRetrieveWhere",
    "description": "<p>buildSmartRetrieveWhere( triggerSheet, dsn, join ) <br><br> 构建动态检索条件 <br></p>",
    "name": "buildSmartRetrieveWhere",
    "group": "FormGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "WorkSheet",
            "optional": false,
            "field": "triggerSheet",
            "description": "<p>用来解析公式的worksheet，默认在此WorkSheet上查找公式中的别名</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dsn",
            "description": "<p>结果集名称 ，即在数据库定义中的结果集的名称</p>"
          },
          {
            "group": "Parameter",
            "type": "join",
            "optional": false,
            "field": "true",
            "description": "<p>表示把各个动态条件 用  'and'   连接后的字符串，false 表示不用连接，直接返回条件数组</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "variant",
            "optional": false,
            "field": "-",
            "description": "<p>返回一个字符串，或一个字符串数组</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nvar where= form.buildSmartRetrieveWhere( book.sheet0 , \"query1\", true);",
        "type": "js"
      }
    ],
    "filename": "js/form/form.js",
    "groupTitle": "表单功能函数"
  },
  {
    "type": "isSaveNeeded",
    "url": "函数",
    "title": "isSaveNeeded",
    "description": "<p>isSaveNeeded(   ) <br><br> 判断当前表单是否需要保存（发生修改后，需要保存） <br></p>",
    "name": "isSaveNeeded",
    "group": "FormGroup",
    "version": "1.0.0",
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "boolean",
            "optional": false,
            "field": "-",
            "description": "<p>true 表示需要保存， false表示表单未发生修改，不需要保存</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nif(  form.isSaveNeeded())\n{\n\n    $alert(\"请在保存后，再执行本操作\");\n    return;\n}",
        "type": "js"
      }
    ],
    "filename": "js/form/form.js",
    "groupTitle": "表单功能函数"
  },
  {
    "type": "refreshRetrieve",
    "url": "函数",
    "title": "refreshRetrieve",
    "description": "<p>refreshRetrieve( id  ) <br><br> 当数据库中的数据有变化，需要刷新检索主结果集中 id为指定值的那一行。 本函数正确执行的先决条件是 结果集当前行一定就是 id=指定ID的那行上。如果主结果集中并没有检索出 id为指定ID的数据行，那么以追加检索的方式将该行数据追加显示在最后一行。 主结果集是指以单据主表名称来命名的结果集 <br></p>",
    "name": "refreshRetrieve",
    "group": "FormGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "id",
            "description": "<p>需要刷新显示的数据的ID字段值</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nform.refreshRetrieve( id  );",
        "type": "js"
      }
    ],
    "filename": "js/form/form.js",
    "groupTitle": "表单功能函数"
  },
  {
    "type": "save",
    "url": "函数",
    "title": "save",
    "description": "<p>save( showTipInfo ) <br><br> 保存单据表单 <br></p>",
    "name": "save",
    "group": "FormGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "boolean",
            "optional": false,
            "field": "showTipInfo",
            "description": "<p>true 表示在保存过程中，如果保存失败，那么显示提示信息， false  表示仅做保存操作，即使有错误也不提示</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nform.save(false);\n\nif( form.isSaveNeeded()) $alert(''保存失败);",
        "type": "js"
      }
    ],
    "filename": "js/form/form.js",
    "groupTitle": "表单功能函数"
  },
  {
    "type": "search",
    "url": "函数",
    "title": "search",
    "description": "<p>search( someKeys ) <br><br> 在单据列表模板中按给定的关键字 someKeys查询单据 <br></p>",
    "name": "search",
    "group": "FormGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "someKeys",
            "description": "<p>关键字</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nform.search( 'abc');",
        "type": "js"
      }
    ],
    "filename": "js/form/form.js",
    "groupTitle": "表单功能函数"
  },
  {
    "type": "smartRetrieve",
    "url": "函数",
    "title": "smartRetrieve",
    "description": "<p>smartRetrieve( sheet, dsn , resetPage ) <br><br> 根据动态条件，检索指定的结果集。“检索按钮”点击后，会根据操作者输入的条件， 构建数据检索条件，然后检索指定的结果集，点击这个“检索按钮”与执行本函数是一样的效果。 <br></p>",
    "name": "smartRetrieve",
    "group": "FormGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "WorkSheet",
            "optional": false,
            "field": "sheet",
            "description": "<p>指定解析动态条件的工作表，通常是结果集绑定显示的工作表</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dsn",
            "description": "<p>结果集名称</p>"
          },
          {
            "group": "Parameter",
            "type": "boolean",
            "optional": false,
            "field": "resetPage",
            "description": "<p>[可选参数，默认是true] true表示页码复位，重新检索第一页，false表示检索当前页码指定的数据</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nsmartRetrieve( book.sheet0 , 'query1');\n\n smartRetrieve( book.sheet0 , 'query1' , false);",
        "type": "js"
      }
    ],
    "filename": "js/form/form.js",
    "groupTitle": "表单功能函数"
  },
  {
    "type": "smartRetrieve",
    "url": "函数",
    "title": "smartRetrieve",
    "description": "<p>smartRetrieve( sheet, dsn, resetPage ) <br><br> 根据动态检索条件查询指定的结果集 <br></p>",
    "name": "smartRetrieve",
    "group": "FormGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "WorkSheet",
            "optional": false,
            "field": "sheet",
            "description": "<p>默认使用此WorkSheet来解析公式中的别名</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dsn",
            "description": "<p>要检索的结果集</p>"
          },
          {
            "group": "Parameter",
            "type": "boolean",
            "optional": false,
            "field": "resetPage",
            "description": "<p>true 表示清空当前查询结果后重新检索， false 表示所检索的结果追加到当前检索结果后</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nform.smartRetrieve( book.sheet0  ,  \"query1\", true);",
        "type": "js"
      }
    ],
    "filename": "js/form/form.js",
    "groupTitle": "表单功能函数"
  },
  {
    "type": "barcodeScan",
    "url": "函数",
    "title": "barcodeScan",
    "description": "<p>barcodeScan(   ) <br><br> 调用移动设备的扫码功能 <br></p>",
    "name": "barcodeScan",
    "group": "H5APP",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "type",
            "description": "<p>条码类型。type为qrCode(二维码)、barCode(条形码)、all(全部)。若有qrCode、barCode扫描不出来，请修改type为all</p>"
          },
          {
            "group": "Parameter",
            "type": "Function",
            "optional": false,
            "field": "callback",
            "description": "<p>回调函数，扫描的内容做为参数代入执行此回调函数</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nbarcodeScan('all',  function(val) { alert(val);} );",
        "type": "js"
      }
    ],
    "filename": "globalscript/h5app.js",
    "groupTitle": "移动应用函数"
  },
  {
    "type": "onPushMessage",
    "url": "函数",
    "title": "onPushMessage",
    "description": "<p>onPushMessage( topic , callback ) <br><br> 关注服务器或其它用户推送来的关于topic 的消息 <br></p>",
    "name": "onPushMessage",
    "group": "MessageGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "topic",
            "description": "<p>关注的消息主题</p>"
          },
          {
            "group": "Parameter",
            "type": "Function",
            "optional": false,
            "field": "callback",
            "description": "<p>收到消息后的回调函数   函数原型:   function onMsg( msg) {}</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "service",
            "description": "<p>连接到哪个服务 ，如果未指定，则默认为 &quot;script&quot; ,通常不用指定</p>"
          },
          {
            "group": "Parameter",
            "type": "boolean",
            "optional": false,
            "field": "oneOff",
            "description": "<p>[可选参数]默认是false，  true表示连接是一次性的,即收到消息后，立即自动关闭连接</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "timeout",
            "description": "<p>[可选参数]超时时间，单位：秒。默认是30秒， 当oneOff ==true时，如果在指定时间内没有收到消息，那么就强制断开， 当oneOff==off时，本参数无效</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nfunction formOpen()\n{\n\n     onPushMessage(\"test1\" , function(msg){ alert ( msg);} );\n\n}\n\n //在服务端脚本中或某个模板中使用 postMessage( \"test1\", \"aaa\",1); 发送消息 ，上面的脚本就能接收消息",
        "type": "js"
      }
    ],
    "filename": "globalscript/message.js",
    "groupTitle": "消息函数"
  },
  {
    "type": "$.alert",
    "url": "函数",
    "title": "$.alert",
    "description": "<p>$.alert( info ) <br><br> 显示一个提示信息（异步显示，并不阻塞脚本的继续执行) 如果要在点击关闭后再执行 一点什么，请使用 $alert 函数 <br></p>",
    "name": "__alert",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "info",
            "description": "<p>要显示的信息</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nalert(\"1\"); //同步显示的，在关闭前，脚本处于阻塞状态\n$.alert(\"2\"); //异步的，所以下面的3会先显示\nalert(\"3\");\n\n//上述示例，将弹出显示 1， 3 ， 最后显示 2",
        "type": "js"
      }
    ],
    "filename": "globalscript/dialog.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "$.confirm",
    "url": "函数",
    "title": "$.confirm",
    "description": "<p>$.confirm( config ) <br><br> 显示一个带有指定消息和 OK 及取消按钮的对话框 <br></p>",
    "name": "__confirm",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Object",
            "optional": false,
            "field": "config",
            "description": "<p>设置信息，详见示例</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\n\n\n $.confirm({\n    title: '提示!',\n    content: '删除无法恢复，确信要删除吗?',\n    buttons: {\n        confirm: {\n            text: \"确定\",\n            action: function () {\n                 // 按下确定按钮后执行\n            }\n\n        },\n        cancel: {\n            text: '取消',\n            action: function () {\n                  // 按下确定按钮后执行\n            }\n        }\n    }\n});",
        "type": "js"
      }
    ],
    "filename": "globalscript/dialog.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "$alert",
    "url": "函数",
    "title": "$alert",
    "description": "<p>$alert( title, info ,callback ) <br><br> 显示一个提示信息（异步显示，并不阻塞脚本的继续执行。并在点击关闭后，执行 一个回调函数 <br></p>",
    "name": "_alert",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "title",
            "description": "<p>标题</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "info",
            "description": "<p>要显示的信息</p>"
          },
          {
            "group": "Parameter",
            "type": "Function",
            "optional": false,
            "field": "callback",
            "description": "<p>点击关闭后的回调函数</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\n$alert('提示','保存成功' , function() {  alert('ok');} );",
        "type": "js"
      }
    ],
    "filename": "globalscript/dialog.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "$confirm",
    "url": "函数",
    "title": "$confirm",
    "description": "<p>$confirm( title, info , callback_ok , callback_cancel ) <br><br> 显示一个带有指定消息和 OK 及取消按钮的对话框 ， 本函数是对$.confirm的简化 <br></p>",
    "name": "_confirm",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "title",
            "description": "<p>标题</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "info",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Parameter",
            "type": "Function",
            "optional": false,
            "field": "callback_ok",
            "description": "<p>点击确认后执行的回调函数</p>"
          },
          {
            "group": "Parameter",
            "type": "Function",
            "optional": false,
            "field": "callback_cancel",
            "description": "<p>点击取消后执行的回调函数，可选参数</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\n$confirm(\"提示\",\"确信要删除吗?\", function(){ delete();}   function(){alert(\"cancel\")});",
        "type": "js"
      }
    ],
    "filename": "globalscript/dialog.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "count",
    "url": "函数",
    "title": "count",
    "description": "<p>count( nameOrAlias ) <br><br> 通常用来返回绑定多行结果集字段的数据的个数 <br><font color=red>特别注意：本函数仅用在单元格的公式定义中，不能用在脚本中</font></p>",
    "name": "count",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "nameOrAlias",
            "description": "<p>单元格名称或别名</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "int",
            "optional": false,
            "field": "-",
            "description": "<p>整数</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\n=count( amount)",
        "type": "js"
      }
    ],
    "filename": "globalscript/doc.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "currentAction",
    "url": "函数",
    "title": "currentAction",
    "description": "<p>currentAction(  ) <br><br> 得到当前模板的动作，通常只用在单据编辑模板中。值如下 ： <br> <ul><li>new: 表示当前正在新增单据</li> <li>edit: 表示当前正在编辑单据</li> <li>view:表示当前正在查看单据</li> </ul></p>",
    "name": "currentAction",
    "group": "SystemGroup",
    "version": "1.0.0",
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "String",
            "optional": false,
            "field": "-",
            "description": "<p>当前单据正在做什么</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nvar action= currentAction();",
        "type": "js"
      }
    ],
    "filename": "globalscript/currentInfo.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "currentMasterTableName",
    "url": "函数",
    "title": "currentMasterTableName",
    "description": "<p>currentMasterTableName(  ) <br><br> 得到当前模板主表，通常用在单据编辑模板中，或单据列表模板中，在报表中，本函数无意义</p>",
    "name": "currentMasterTableName",
    "group": "SystemGroup",
    "version": "1.0.0",
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "String",
            "optional": false,
            "field": "-",
            "description": "<p>当前模板的主表</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nvar table= currentMasterTableName();",
        "type": "js"
      }
    ],
    "filename": "globalscript/currentInfo.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "deleteUploadedFile",
    "url": "函数",
    "title": "deleteUploadedFile",
    "description": "<p>deleteUploadedFile( dbpool, logTable, attachmentID) <br><br> 删除上传的文件。 本函数先从上传文件的日志记录中找到该文件实际存放的地址， 然后把文件删除，如果有缩略图，则一并删除。 最后删除该文件的上传日志 <br></p>",
    "name": "deleteUploadedFile",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dbpool",
            "description": "<p>删除的文件信息记录在哪个连接池中，''表示当前主数据库</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "logTable",
            "description": "<p>删除的文件信息记录在哪个表中，'' 表示默认表app_fileupload</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "attachmentID",
            "description": "<p>删除的文件信息记录的ID，</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "JSON",
            "optional": false,
            "field": "-",
            "description": "<p>{success:true, message:'提示信息'}  success: true 表示删除成功，否则在 message中记录了错误提示</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nvar b= deleteUploadedFile('','', 'xxeaifslfafafsaeaadsgp938df' );",
        "type": "js"
      }
    ],
    "filename": "globalscript/upload.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "getUrlParameter",
    "url": "函数",
    "title": "getUrlParameter",
    "description": "<p>getUrlParameter( name , defaultValue) <br><br> 得到URL地址上的指定的参数值，如果不存在该参数，则返回defaultValue <br></p>",
    "name": "getUrlParameter",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>参数名称</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "defaultValue",
            "description": "<p>默认值</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "String",
            "optional": false,
            "field": "-",
            "description": "<p>返回参数的值，如果不存在指定的参数，则返回defaultValue</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\ngetUrlParameter(\"abc\", \"1\");",
        "type": "js"
      }
    ],
    "filename": "globalscript/system.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "iif",
    "url": "函数",
    "title": "iif",
    "description": "<p>iif( boolExpression , trueValue , falseValue ) <br><br> 根据表达式的值的真假，返回相应的数据 <br> 主要用于表单公式中。在脚本中，通常使用  (boolExpression?trueValue:falseValue)的方式</p>",
    "name": "iif",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "bool",
            "optional": false,
            "field": "boolExpression",
            "description": "<p>一个条件表达式，结果是boolean型</p>"
          },
          {
            "group": "Parameter",
            "type": "Variant",
            "optional": false,
            "field": "trueValue",
            "description": "<p>当表达式值为true是的返回值</p>"
          },
          {
            "group": "Parameter",
            "type": "Variant",
            "optional": false,
            "field": "falseValue",
            "description": "<p>当表达式值为false是的返回值</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "Variant",
            "optional": false,
            "field": "-",
            "description": "<p>任意类型</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\niif(  a1>10 ,   'abc', 'def')\n\niif( a1>10 , rgb(255,255 ,0)  , 'red')",
        "type": "js"
      }
    ],
    "filename": "globalscript/system.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "isMobileDevice",
    "url": "函数",
    "title": "isMobileDevice",
    "description": "<p>isMobileDevice(   ) <br><br> 当前客户端环境是移动设备吗 <br></p>",
    "name": "isMobileDevice",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "variant",
            "optional": false,
            "field": "info",
            "description": "<p>要输出显示的信息，</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nvar b= isMobileDevice();",
        "type": "js"
      }
    ],
    "filename": "globalscript/system.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "max",
    "url": "函数",
    "title": "max",
    "description": "<p>max( p1 [,p2,p3....pn]  ) <br><br> 返回若干 数据中最大的一个，如果都是数字型，则按数字型比较大小，如果有一个是字符型，则按字符进行比较大小 <br><font color=red>特别注意：本函数仅用在单元格的公式定义中，不能用在脚本中</font></p>",
    "name": "max",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "variant",
            "optional": false,
            "field": "p1",
            "description": "<p>, p2, ...pn   要累加的单元格名称或别名或常数 ，可以是多个单元格。当单元格绑定到多行结果集中字段时，本函数返回该字段的最大值</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "variant",
            "optional": false,
            "field": "-",
            "description": "<p>根据参数返回相应的类型</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\n=max( a1)\n=max(a1,b1)\n=max( name)\n=max( amount)",
        "type": "js"
      }
    ],
    "filename": "globalscript/doc.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "min",
    "url": "函数",
    "title": "min",
    "description": "<p>min( p1 [,p2,p3....pn]  ) <br><br> 返回若干 数据中最小的一个，如果都是数字型，则按数字型比较大小，如果有一个是字符型，则按字符进行比较大小 <br><font color=red>特别注意：本函数仅用在单元格的公式定义中，不能用在脚本中</font></p>",
    "name": "min",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "variant",
            "optional": false,
            "field": "p1",
            "description": "<p>, p2, ...pn   要累加的单元格名称或别名或常数 ，可以是多个单元格。当单元格绑定到多行结果集中字段时，本函数返回该字段的最小值</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "variant",
            "optional": false,
            "field": "-",
            "description": "<p>根据参数返回相应的类型</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\n=min( a1)\n=min(a1,b1)\n=min( name)\n=min( amount)",
        "type": "js"
      }
    ],
    "filename": "globalscript/doc.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "newUser",
    "url": "函数",
    "title": "newUser",
    "description": "<p>newUser(name,showName,password,email,mobile) <br><br> 注册新用户 <br></p>",
    "name": "newUser",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>用户名</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "showName",
            "description": "<p>用户实名</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "password",
            "description": "<p>登录密码</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>邮箱</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "mobile",
            "description": "<p>手机号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "Object",
            "optional": false,
            "field": "-",
            "description": ""
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nvar p= newUser('test','测试','1234', '', '');",
        "type": "js"
      }
    ],
    "filename": "globalscript/userAndDepartment.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "newUserAsDepartmentMaster",
    "url": "函数",
    "title": "newUserAsDepartmentMaster",
    "description": "<p>newUserAsDepartmentMaster(  name,showName,password,email,mobile , departmentName) <br><br> 增加用户，增加（我的部门的下级）部门，并把用户设置成部门的管理员, 本函数执行的前提是，我必须是部门管理员 <br></p>",
    "name": "newUserAsDepartmentMaster",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>用户名</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "showName",
            "description": "<p>用户实名</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "password",
            "description": "<p>登录密码</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>邮箱</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "mobile",
            "description": "<p>手机号</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "departmentName",
            "description": "<p>部门名称</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "Object",
            "optional": false,
            "field": "-",
            "description": ""
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nvar ret= newUserAsDepartmentMaster('test','测试','1234', '', '13512345678','某某代理商');",
        "type": "js"
      }
    ],
    "filename": "globalscript/userAndDepartment.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "openInMainFrame",
    "url": "函数",
    "title": "openInMainFrame",
    "description": "<p>openInMainFrame( url, newWindow, img, name ) <br><br>  在报表或单据模板中通知系统工作台打开一个新的工作tab窗口。执行本函数的模板，并不一定必须位于工作台Tab页中， 在新窗口中打开的表单也能执行本函数。本函数是通过服务器向客户端推送消息来实现消息传递的。基于如下理由：</p> <ul>     <li>在工作台tab页中打开的表单，与工作台可能并不属于一个域名下，所以不能通过 parent.parent......这样的链路来访问工作台页面</li>    <li>当表单是在新窗口中打开时，无法访问工作台所在的窗口</li>     </ul> <br>     由于实现是基于消息推送，所以一个负作用是，当以同一个帐号在不同电脑上登录，一台电脑上执行本函数，则所有相同帐号登录的电脑上都会打开页面",
    "name": "openInMainFrame",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "url",
            "description": "<p>需要打开的URL地址，它可以系统工作台上的地址，也可以是其它任意的URL地址</p>"
          },
          {
            "group": "Parameter",
            "type": "boolean",
            "optional": false,
            "field": "newWindow",
            "description": "<p>true表示在新窗口中打开， false表示在系统工作台的新tab页中打开</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "img",
            "description": "<p>显示在tab左角的图标，比如  'fa-pencil', 'fa-cog'  , 可用的字体图标，参看 http://www.fontawesome.com.cn/faicons/</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>如果在工作台Tab页中打开， name表示tab页的标题文字，如果名称为name的tab页已经打开，那么激活该页，否则打开它。 即使多次调用函数，只要name对应的tab页已打开，就不会重复再打开。</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\n function cb1_onClick()\n {\n\n  openInMainFrame('https://www.qq.com' , false, 'fa-pencil', 'QQ' );\n\n}\n\n function cb2_onClick()\n {\n\n  openInMainFrame('report.jsp?id=postgres_page' , false, 'fa-pencil', '呵呵了' );\n\n}",
        "type": "js"
      }
    ],
    "filename": "globalscript/message.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "rgb",
    "url": "函数",
    "title": "rgb",
    "description": "<p>println( info ) <br><br> 将字段串转换成小写 <br></p>",
    "name": "println",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "variant",
            "optional": false,
            "field": "info",
            "description": "<p>要输出显示的信息，</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nprintln( \"ABC\");",
        "type": "js"
      }
    ],
    "filename": "globalscript/system.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "openDialogURL",
    "url": "函数",
    "title": "openDialogURL",
    "description": "<p>openDialogURL( title, url, width, height ,callback) <br><br> 将指定的URL在一个模态弹出窗口中显示 <br></p>",
    "name": "println",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "title",
            "description": "<p>标题</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "url",
            "description": "<p>在窗口中打开的URL地址</p>"
          },
          {
            "group": "Parameter",
            "type": "number",
            "optional": false,
            "field": "width",
            "description": "<p>窗口宽度</p>"
          },
          {
            "group": "Parameter",
            "type": "number",
            "optional": false,
            "field": "height",
            "description": "<p>窗口高度</p>"
          },
          {
            "group": "Parameter",
            "type": "Function",
            "optional": false,
            "field": "callback",
            "description": "<p>当弹出的窗口点击确认关闭窗口后执行此回调函数</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nopenDialogURL(\"选择用户\" , homePage+\"/selectUser.jsp?style=multi\", 850, 500, function(val){ alert( val);});",
        "type": "js"
      }
    ],
    "filename": "globalscript/dialog.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "updateAll",
    "url": "函数",
    "title": "updateAll",
    "description": "<p>updateAll( ds1,ds2,ds3,ds4,ds5) <br><br> 将多个结果集对象在一个事务中保存，要么都成功，要每都失败 <br></p>",
    "name": "updateAll",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "ds1",
            "optional": false,
            "field": "DataStore",
            "description": "<p>要保存的结果集（必选参数）</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "String",
            "optional": false,
            "field": "-",
            "description": "<p>如果保存成功，返回空字符串'' , 否则返回错误信息</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nvar err= updateAll( ds1, ds2 , ds3);\nif( err=='')\n{\n    toastr.info(\"保存成功\");\n}else\n{\n    toastr.error( err);\n}",
        "type": "js"
      }
    ],
    "filename": "globalscript/system.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "uploadFile",
    "url": "函数",
    "title": "uploadFile",
    "description": "<p>uploadFile( config ,callback   ) <br><br> 上传文件到服务器<br> 上传客户端文件到文件服务器， 默认情况下，系统内建一个简易的文件服务，提供文件存储及访问服务。 服务在启动时，可以通过 appFileRoot 指明一个目录，该目录被系统做为应用中需要生成文件的根目录。 appFileRoot/FileRoot 做为默认文件服务根目录。当在Docker中部署时，需要将 /usr/local/appFileRoot 映射到宿主机的目录。 更好的方案是使用成熟的分布式文件服务，比如Minio . 本函数并不选择服务器，由系统在服务端适配 文件服务器 。</p>  <ul>   <li>本函数被系统用于单据附件上传，但它并不局限于单据附件上传，可以通过tableName  + gguid  来规定附件的关联关系 </li>   <li>默认情况下，文件上传的日志信息记录在系统表app_fileupload中，但不局限于此，可以按需要指定上传日志保存到哪个数据库哪个表，   自定义的表，建议提供与app_fileload 类似的表结构，相关的字段信息会自动填入</li>   <li>在记录上传日志的同时，还可以保存额外的信息，详见下面的config.data 的说明</li>   <li>在日志表中查询到 bucketName ,  objectName , fileName , 可以通过如下地址直接访问文件    http://server:port/formEngine/fileServer?bucketName={bucketName}&objectName={objectName}&fileName={fileName}&action=view <p>注意两点：1 {fileName}注意进行编码  2  action=view表示在线查看  =download 表示下载</p>    </li>    <li>上述访问上传的文件方式，仅适用于少量文件的应用 。如果上传文件较多，请使用成熟的分布式文件管理服务。 </li>    </ul> <br>",
    "name": "uploadFile",
    "group": "SystemGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Object",
            "optional": false,
            "field": "config",
            "description": "<p>它是一个JSON对象 ，用来配置上传文件的配置信息</p> <ul> <li>serverIndex  上传到哪个对象存储服务器。系统允许设置5个对象存储服务，本参数表明文件将上传到哪个对象存储服务器上。默认为1 </li>  <li>fileType   上传文件的类型， *.* 表示所有类型的文件 。可以使用用逗号隔开的文件扩展名或的用逗号隔开MIME 类型列表(比如：  audio/mp4,video/mp4  ，  更多在类型可搜索“file accept ” )来表明仅允许上传特定的文件， 多个类型之间用逗号分隔。 如果不提供本设置项，则默认为 \"jpg,jpeg,png,gif,bmp\"</li> <li>bucketName  存储分片名称，或者称为存储桶，它与文件服务器相关，如果不提供本设置项，则使用默认值：Attachment ，如果它不存在，则自动创建 </li> <li>logTable  上传后，记录上传详细信息的表，每上传一个文件，就记录一个日志。如果不提供本设置项，则使用默认值：app_fileupload </li> <li>dbpool   logTable 保存在哪个数据库连接池中。如果不提供本设置项，则使用默认值：default 即系统主数据库 </li> <li>tableName  上传的文件与哪个表相关。比如单据模块中的上传附件，此设置项即单据主表名称 </li> <li>gguid  上传的文件与表{tableName} 的哪条记录相关</li> <li>path  文件上传到哪个子路径中，可以是多级目录，目录如果不存在，则自动创建。如果不提供本设置项，则使用默认值： {tableName}/年/月/日/ </li> <li>thumbnailBucketName  如果附件是图片，允许同时生成一个缩略图，本参数指定缩略图放在哪个存储分片中，如果不提供本设置项，表明使用 {bucketName} 相同的存储分区</li> <li> maxThumbnailSize 缩略图的最大尺寸。当图片宽度大于高度时，它表明缩略图的宽度，反之则表明缩略图的高度。如果不提供本设置项，默认使用256 (单位：像素) </li>  <li>data  是一个JSON对象，其中的属性值会保存到表 {tableName}中同名的字段中 。 详见示例 </ul>"
          },
          {
            "group": "Parameter",
            "type": "Function",
            "optional": false,
            "field": "callback",
            "description": "<p>上传成功后的回调函数 ，它是如下格式的函数 <br> function  callbck( info) {   } 参数 info 记录了上传文件在服务器上的存储相关的信息。它就是上传成功后，在logTable中保存的信息。如果是使用系统默认的app_fileupload表， 其中如下几项比较重要</p>    <ul>  <li>id  本记录的ID </li>  <li>userid  int 上传人ID </li>  <li>usershowname varchar(100) null, --上传人姓名 </li>  <li>serverindex   int   NULL , -- 哪个对象存储服务器 </li>  <li>filename    varchar (255)  NULL , 文件原始名称 </li>  <li>filesize    int null, --文件大小 ，字节数</li>  <li>filesizetip  varchar(40) null, </li>  <li>fileextname   varchar(10) null, -- 文件扩展名</li>  <li>imagewidth  int null,  --图片宽度</li>  <li>imageheight int null,  --图片高度</li>  <li>thumbnailwidth int null,  --</li>  <li>thumbnailheight int null,</li>  <li>bucketname    varchar(100) NULL ,  -- 存储分片名称</li>  <li>objectname   varchar(1000) NULL ,  --对象存储路径</li>  <li>thumbnailbucketname    varchar(100) NULL ,   --缩微图分片名称</li>  <li>thumbnailobjectname   varchar(1000) NULL ,  --缩微图对象存储路径</li>  <li>tablename   varchar(40) null,  --是哪个单据上传的 </li>  <li>gguid  varchar(40) null,     -- 表示本附件与 tablename.gguid 相关联。即 本表.gguid= {tablename}.gguid  </li>  <li>info1  varchar(100) null,     --自定义附加信息 </li>  <li>info2  varchar(200) null,     -- 自定义附加信息 </li>  <li>info3  varchar(500) null,     -- 自定义附加信息 </li>  <li>info4  varchar(1000) null,     -- 自定义附加信息 </li>        </ul>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例1：",
        "content": "\n //上传word或 excel文件\n uploadFile (  { fileType: \"doc,xls,docx,xlsx\" } ,  function(info){ alert( JSON.stringify(info);)} } ;\n\n //上传到指定分区下\n\n uploadFile (  { fileType: \"doc,xls,docx,xlsx\"\n                     bucketName: '存档' } ,  function(info){ alert( JSON.stringify(info);)} } ;\n\n //指定缩略图大小\n\n uploadFile (  { fileType: \"jpg,jpeg,png,gif,bmp\",\n                     maxThumbnailSize: 64} ,  function(info){ alert( JSON.stringify(info);)} } ;\n\n//上传日志记录到另外的表中\n\nuploadFile (  {   serverIndex:2 ,  // 上传到第2个对象存储服务器上\n                      fileType: \"jpg,jpeg,png,gif,bmp\" ,\n                     dbpool:'pool1' ,\n                     logFile: 'my_uploadLog' ,\n                     tableName: 'test1' ,\n                     data:{ col1: 'value1' , col2: 'value2' } ,  -- 上传日志中同时保存两个字段col1, col2\n                     maxThumbnailSize: 64} ,  function(info){ alert( JSON.stringify(info);)} } ;",
        "type": "js"
      },
      {
        "title": "示例2：自定义日志表：",
        "content": "     //上传结果，系统保存在主数据库的app_fileupload表中， 如果需要保存到另外的数据库及自定义名称的表中，建议该表至少需要如下字段\n\nid varchar(40)   NOT NULL ,\nuserid int  null,  --上传人ID\nusershowname varchar(100) null, --上传人姓名\nfilename    varchar (255)  NULL ,\nfilesize    int null, --文件大小 ，字节数\nfilesizetip  varchar(40) null,\nfileextname   varchar(10) null, -- 文件扩展名\nimagewidth  int null,  --图片宽度\nimageheight int null,  --图片高度\nthumbnailwidth int null,  --\nthumbnailheight int null,\nbucketname    varchar(100) NULL ,  -- 存储分片名称\nobjectname   varchar(1000) NULL ,  --对象存储路径\nthumbnailbucketname    varchar(100) NULL ,   --缩微图分片名称\nthumbnailobjectname   varchar(1000) NULL ,  --缩微图对象存储路径\ntablename   varchar(40) null,  --是哪个单据上传的\ngguid  varchar(40) null,     -- 单据的ID",
        "type": "js"
      }
    ],
    "filename": "globalscript/upload.js",
    "groupTitle": "系统函数"
  },
  {
    "type": "getUrlArgs",
    "url": "函数",
    "title": "getUrlArgs",
    "description": "<p>getUrlArgs(   ) <br><br> URL地址中的参数访问 <br></p>",
    "name": "getUrlArgs",
    "group": "UIGroup",
    "version": "1.0.0",
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "Object",
            "optional": false,
            "field": "-",
            "description": "<p>返回一个对象 ， URL地址栏中的参数做为此对象的属性</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\n//页面url为  http://server:port/formEngien/bill.jsp?id=abcd&code=1234\n\nvar p= getUrlArgs();\nalert( p.id);\nalert( p.code);",
        "type": "js"
      }
    ],
    "filename": "js/core/domutil.js",
    "groupTitle": "UI函数"
  },
  {
    "type": "hideInfoPane",
    "url": "函数",
    "title": "hideInfoPane",
    "description": "<p>hideInfoPane(   ) <br><br> 关闭信息显示窗口 <br></p>",
    "name": "hideInfoPane",
    "group": "UIGroup",
    "version": "1.0.0",
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nshowInfoPane(\"<div style='width:300px; padding:15px;text-align:center;'>正在检索...</div>\");\nsetTimeout( function() {\n       hideInfoPane();\n    },2000);",
        "type": "js"
      }
    ],
    "filename": "js/design/loadTemplate.js",
    "groupTitle": "UI函数"
  },
  {
    "type": "showInfoPane",
    "url": "函数",
    "title": "showInfoPane",
    "description": "<p>showInfoPane( info [,x ,y ]) <br><br> 显示一个提示信息，信息窗口按内容自动布局，显示于屏幕正中间 <br></p>",
    "name": "showInfoPane",
    "group": "UIGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "info",
            "description": "<p>要输出显示的信息，可以是html</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "x",
            "description": "<p>x坐标。可选参数，如果为null表示让系统自动水平居中显示</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "y",
            "description": "<p>y坐标。可选参数，如果为null表示让系统自动垂直居中显示</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "delayMS",
            "description": "<p>可选参数，如果定义了本参数，表明在delayMS毫秒后，关闭提示信息</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nshowInfoPane(\"<div style='width:300px; padding:15px;text-align:center;'>正在检索...</div>\");\n\nshowInfoPane(\"*正在检索...\");  //试试这句的效果",
        "type": "js"
      }
    ],
    "filename": "js/design/loadTemplate.js",
    "groupTitle": "UI函数"
  },
  {
    "type": "toastr.error",
    "url": "函数",
    "title": "toastr.error",
    "description": "<p>toastr.error( info ) <br><br> 显示一段异常信息，并在2秒后自动关闭 <br></p>",
    "name": "toastr_error",
    "group": "UIGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "info",
            "description": "<p>要显示的信息，</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\ntoastr.error(\"操作异常\");",
        "type": "js"
      }
    ],
    "filename": "js/design/loadTemplate.js",
    "groupTitle": "UI函数"
  },
  {
    "type": "toastr.info",
    "url": "函数",
    "title": "toastr.info",
    "description": "<p>toastr.info( info ) <br><br> 显示一段提示信息，并在2秒后自动关闭 <br></p>",
    "name": "toastr_info",
    "group": "UIGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "info",
            "description": "<p>要显示的信息，</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\ntoastr.info(\"成功完成\");",
        "type": "js"
      }
    ],
    "filename": "js/design/loadTemplate.js",
    "groupTitle": "UI函数"
  },
  {
    "type": "toastr.warning",
    "url": "函数",
    "title": "toastr.warning",
    "description": "<p>toastr.warning( info ) <br><br> 显示一段警告信息，并在2秒后自动关闭 <br></p>",
    "name": "toastr_warning",
    "group": "UIGroup",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "info",
            "description": "<p>要显示的信息，</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "void",
            "optional": false,
            "field": "-",
            "description": "<p>无返回值</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\ntoastr.warning(\"成功完成\");",
        "type": "js"
      }
    ],
    "filename": "js/design/loadTemplate.js",
    "groupTitle": "UI函数"
  },
  {
    "type": "getUserRoles",
    "url": "函数",
    "title": "getUserRoles",
    "description": "<p>getUserRoles(userid) <br><br> 得到指定人员的角色清单</p>",
    "name": "getUserRoles",
    "group": "UserManage",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "userid",
            "description": "<p>用户的ID</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "Array",
            "optional": false,
            "field": "-",
            "description": "<p>返回角色ID的数组</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\n\nvar roles= getUserRoles( currentUserId());",
        "type": "js"
      }
    ],
    "filename": "globalscript/userAndRole.js",
    "groupTitle": "用户及角色"
  },
  {
    "type": "grantRoleToUser",
    "url": "函数",
    "title": "grantRoleToUser",
    "description": "<p>grantRoleToUser( userid, roleid) <br><br> 将角色 roleid 授与 userid ,如果userid已经具有roleid角色，那么什么都不会发生 <br> <span style='color:red'>提示：本函数仅允许在服务端执行</span> <br></p>",
    "name": "grantRoleToUser",
    "group": "UserManage",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "userid",
            "description": "<p>操作员ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "roleid",
            "description": "<p>角色ID ,在后台管理中的角色管理中，可以查看角色的ID</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "String",
            "optional": false,
            "field": "-",
            "description": "<p>成功则返回空字符串， 否则返回异常信息</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\ngrantRoleToUser(currentUserId() ,  roleName2RoleId('合同管理员') );",
        "type": "js"
      }
    ],
    "filename": "globalscript/userAndRole.js",
    "groupTitle": "用户及角色"
  },
  {
    "type": "isDepartmentMaster",
    "url": "函数",
    "title": "isDepartmentMaster",
    "description": "<p>isDepartmentMaster( userId,departmentId) <br><br> 判断某个用户是否是指定部门的部门管理员 <br> <span style=\"color:red\">参看 ：</span><a href=\"/docview?path=F5ZGK4DFOJ2G64TZF5WGSYTSMFZHSL3EN5RS6OJZF3T3HO7HXOP6PLVB46IIML7HX2SOPO4E46XKDZ4QQYXG2ZA\"     target=\"blank\" >部门管理员</a> <br></p>",
    "name": "isDepartmentMaster",
    "group": "UserManage",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "userid",
            "description": "<p>操作员ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "departmentId",
            "description": "<p>部门的ID</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "boolean",
            "optional": false,
            "field": "-",
            "description": "<p>true表示userid对应的用户被授与了roleIdOrName对应的角色</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nif (! isRoleGrantedToUser(currentUserId() , \"xaseadsaeae1fafaaedfgnh\")) alert('sorry');",
        "type": "js"
      }
    ],
    "filename": "globalscript/userAndRole.js",
    "groupTitle": "用户及角色"
  },
  {
    "type": "isRoleGrantedToUser",
    "url": "函数",
    "title": "isRoleGrantedToUser",
    "description": "<p>isRoleGrantedToUser( userid, roleIdOrName) <br><br> 判断某个用户是否有某个角色</p>",
    "name": "isRoleGrantedToUser",
    "group": "UserManage",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "userid",
            "description": "<p>操作员ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "roleIdOrName",
            "description": "<p>角色ID或角色名称 ,在后台管理中的角色管理中，可以查看角色的ID</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "boolean",
            "optional": false,
            "field": "-",
            "description": "<p>true表示userid对应的用户被授与了roleIdOrName对应的角色</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nif (! isRoleGrantedToUser(currentUserId() , \"xaseadsaeae1fafaaedfgnh\")) alert('sorry');",
        "type": "js"
      }
    ],
    "filename": "globalscript/userAndRole.js",
    "groupTitle": "用户及角色"
  },
  {
    "type": "revokeRoleFromUser",
    "url": "函数",
    "title": "revokeRoleFromUser",
    "description": "<p>revokeRoleFromUser( userid, roleid) <br><br> 取消userid的 roleid角色，如果userid本来就没有roleid,那么什么都不会发生。 <br><span  style=' background-color:yellow; color:red;'>如果userid 是部门管理员。并且某些用户是由他注册的，当该userid用户的某个角色被取消时，由他 注册的所有用户的roleid角色也会被强制取消</span> <br> <br> <span style=\"color:red\">参看 ：</span><a href=\"/docview?path=F5ZGK4DFOJ2G64TZF5WGSYTSMFZHSL3EN5RS6OJZF3T3HO7HXOP6PLVB46IIML7HX2SOPO4E46XKDZ4QQYXG2ZA\"     target=\"blank\" >部门管理员</a> <br> <br> <span style='color:red'>提示：本函数仅允许在服务端执行</span> <br></p>",
    "name": "revokeRoleFromUser",
    "group": "UserManage",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "userid",
            "description": "<p>操作员ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "roleid",
            "description": "<p>角色ID ,在后台管理中的角色管理中，可以查看角色的ID</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "String",
            "optional": false,
            "field": "-",
            "description": "<p>成功则返回空字符串， 否则返回异常信息</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nrevokeRoleFromUser(currentUserId() ,  roleName2RoleId('合同管理员') );",
        "type": "js"
      }
    ],
    "filename": "globalscript/userAndRole.js",
    "groupTitle": "用户及角色"
  },
  {
    "type": "roleName2RoleId",
    "url": "函数",
    "title": "roleName2RoleId",
    "description": "<p>roleName2RoleId( info ) <br><br> 把角色名称转换成角色ID</p>",
    "name": "roleName2RoleId",
    "group": "UserManage",
    "version": "1.0.0",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "variant",
            "optional": false,
            "field": "info",
            "description": "<p>要输出显示的信息，</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "返回值": [
          {
            "group": "返回值",
            "type": "String",
            "optional": false,
            "field": "-",
            "description": "<p>角色的ID</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "示例：",
        "content": "\nvar roleId= roleName2RoleId('基本角色');\nvar b=  isRoleGrantedToUser( currentUserId() , roleId);",
        "type": "js"
      }
    ],
    "filename": "globalscript/userAndRole.js",
    "groupTitle": "用户及角色"
  }
] });
