<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ page import="util.FF" %>
<%@ page import="app.User" %>
<%@ page import="rbac.URLFilter" %>
<%@ page import="org.json.JSONArray" %>
<%@ page import="rbac.MoreOperationID" %>
<%@ page import="org.json.JSONObject" %>
<%@ page import="util.AppCache" %>
<%@ page import="java.net.URLEncoder" %>
<%@ page import="java.util.Iterator" %>
<%@ page import="util.TimeStamp" %>
<%@ page import="jun.db.util.Base32Coder" %>
<%@include file="nocache.jsp" %>
<%@include file="ssoLoginCheck.jsp" %>
<%@ taglib prefix="ss" uri="http://jun.zeng.com" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>


<%

    TimeStamp tm = new TimeStamp(true);

    String qs = request.getQueryString();
    if (qs == null) qs = "";
    if (!qs.equals("")) qs = "?" + qs;
    FF.pageContextSetAttribute(pageContext, "querystring", qs);

    String url = URLFilter.getShortURL(request);
    int p = url.indexOf(".jsp");
    url = "bill" + url.substring(p); //拼成bill.jsp?参数  的形式，用来取权限设置

    User user = User.getUserFromLocalSession(request);
    FF.pageContextSetAttribute(pageContext, "isSysUser", user.isSysUser());
    FF.pageContextSetAttribute(pageContext, "isArchitect", user.isArchitect());

    //这里的url ,不会量很大，这是单据列表，不是单据编辑 ， url中不会有与业务数据还关的内容，所能不会几何级地膨胀
    FF.pageContextSetAttribute(pageContext, "authorizationURL", FF.getCachedEncryptedString(url));
    FF.pageContextSetAttribute(pageContext, "authorizationTarget", FF.getCachedEncryptedString("" + user.getId()));


    tm.stamp("权限加载完成");

    FF.pageContextSetAttribute(pageContext, "isMobile", FF.isMobile(request));
    FF.pageContextSetAttribute(pageContext, "isDD", FF.isDD(request));


%>

<!DOCTYPE html>
<head>
    <title></title>
    <meta http-equiv="pragma" content="no-cache">
    <meta http-equiv="cache-control" content="no-cache">
    <meta http-equiv="expires" content="0">

    <meta name="AuthorizationURL" content="<c:out value='${authorizationURL}'/>">
    <meta name="AuthorizationTarget" content="<c:out value='${authorizationTarget}'/>">

    <script>const queryString = '<c:out value="${querystring}"/>';</script>

    <jsp:include page="form.jsp?type=billlist&&action=view&<%=request.getQueryString()%>" flush="true"/>

</head>
<body>
<div id="page-wrapper">
    <div id="page-container" class="header-fixed-top  ">
        <!-- Main Container -->
        <div id="main-container  ">

            <c:if test="${! (isMobile && isDD )}">
                <header class="navbar navbar-nav-custom navbar-fixed-top  bk_efefef "
                        style=";height:62px; margin:0;">


                    <table border="0 " cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <td rowspan="2" align="center" valign="center" style="width:62px;">
                                <i class="fa " id="billIcon" style="font-size:40px; text-shadow: 1px 1px 1px #fff;"></i>
                            </td>

                            <td>
                                <div id="titleContainer" style="height:30px; line-height:30px;">
                                <span id="billTitle"
                                      style=" padding-left:15px; font-size:18px; text-shadow: 1px 1px 1px #fff;"></span>

                                </div>
                            </td>
                            <td rowspan="2">
                                <ul class="nav navbar-nav-custom pull-right   ">
                                    <li style="padding-top:2px; padding-right:10px;">
                                        <div id=keySearchContainer style="display:none; position:relative;height:25px; border:1px solid  lightgray; border-radius:12px; width:200px;
                                        background-color:white; padding-left:12px;padding-top:0px;margin:0;">
                                            <input type="text" id=keys onkeydown="if(event.keyCode==13 ){ $form.search();}"
                                                   style=" position:absolute; top:1px;border:0px solid red;height:22px;
                                             line-height:22px;width:160px;" placeholder="智能搜索">
                                            <a href="javascript: form.search();"><i class="fa fa-search"
                                                                                    style="position:absolute; left:175px;top:5px;"></i></a>
                                        </div>
                                    </li>
                                </ul>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <div style="width:100%;">

                                    <!--   工具栏 -->


                                    <!-- Left Header Navigation -->
                                    <ul class="nav navbar-nav-custom  " id="mainToolBar">
                                        <!-- Main Sidebar Toggle Button -->
                                        <!-- hiddenToolbar 样式没有生效，只能直接style ,待查-->
                                        <li id="toolbar_billnew" class=" hiddenToolbar authorization newBill "
                                            style="display:none;">
                                            <a href="javascript:void(0)"
                                               onclick="this.blur();form.newBill('${querystring}');">
                                                <i class="fa fa-star-o fa-fw"></i>&nbsp;新增
                                            </a>
                                        </li>


                                        <li id="toolbar_billview" class="hiddenToolbar authorization viewBill"
                                            style="display:none;">
                                            <a href="javascript:void(0)" onclick="this.blur();form.viewBill();">

                                                <i class="fa fa-eye fa-fw"></i>&nbsp;查看
                                            </a>
                                        </li>


                                        <li id="toolbar_billedit" class="hiddenToolbar authorization editBill"
                                            style="display:none;">
                                            <a href="javascript:void(0)" onclick="this.blur();form.editBill();">
                                                <i class="fa fa-edit fa-fw"></i>&nbsp;编辑
                                            </a>
                                        </li>


                                        <li id="toolbar_billdelete" class="hiddenToolbar authorization deleteBill"
                                            style="display:none;">
                                            <a href="javascript:void(0)" onclick="this.blur();form.deleteBill();">
                                                <i class="fa fa-trash-o fa-fw"></i>&nbsp;删除
                                            </a>
                                        </li>


                                        <li id="toolbar_verify" class="hiddenToolbar authorization verifyBill"
                                            style="display:none;">
                                            <a href="javascript:void(0)" onclick="this.blur();form.verifyBill();">
                                                <i class="fa fa-tags fa-fw"></i>&nbsp;审核
                                            </a>
                                        </li>


                                        <li id="cb_fullScreen">
                                            <a href="javascript:void(0)" onclick=" launchFullScreen(document.documentElement);
                                                                                      $('#cb_exitFullScreen').show();
                                                                                        $('#cb_fullScreen').hide();this.blur();">
                                                <i class="fa fa-arrows-alt fa-fw"></i>&nbsp;全屏
                                            </a>
                                        </li>
                                        <li id="cb_exitFullScreen" style="display:none;">
                                            <a href="javascript:void(0)"
                                               onclick=" exitFullscreen(); $('#cb_exitFullScreen').hide();$('#cb_fullScreen').show(); this.blur();">
                                                <i class="fa fa-compress fa-fw"></i>&nbsp;退出全屏
                                            </a>
                                        </li>

                                        <li id="cb_refresh">
                                            <a href="javascript:void(0)" onclick=" location.reload(true);">
                                                <i class="fa fa-refresh fa-fw"></i>&nbsp;刷新
                                            </a>
                                        </li>

                                        <li id="cb_resize">
                                            <a href="javascript:void(0)" id="cb_enableOrDisableResize"
                                               onclick="this.blur(); form.enableOrDisableResize();">
                                                <i class="fa fa-arrows-h fa-fw"></i>&nbsp;调整
                                            </a>
                                        </li>

                                        <!-- END Main Sidebar Toggle Button -->

                                        <!-- Template Options -->
                                        <!-- Change Options functionality can be found in js/app.js - templateOptions() -->


                                        <li id="cb_export" class="dropdown hiddenToolbar authorization listExport"
                                            style="display:none;">
                                            <a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="fa fa-share-square-o"></i>&nbsp;导出
                                            </a>
                                            <ul class="dropdown-menu dropdown-custom dropdown-options">


                                                <li><a href="javascript:form.export_excel();">
                                                    <i class="fa fa-file-excel-o"></i>&nbsp;导出为excel格式
                                                </a>
                                                </li>
                                                <li><a href="javascript:form.export_excel2();">
                                                    <i class="fa fa-file-excel-o"></i>&nbsp;导出为所见所得excel格式
                                                </a>
                                                </li>

                                                <li style="display:none;"><a href="javascript:form.export_pdf( );">
                                                    <i class="fa fa-file-pdf-o"></i>&nbsp;导出为pdf格式
                                                </a>
                                                </li>
                                                <li><a href="javascript:form.export_txt( );">
                                                    <i class="fa fa-file-text-o"></i>&nbsp;导出为txt文件
                                                </a>
                                                </li>
                                                <li><a href="javascript:form.export_csv( );">
                                                    <i class="fa fa-file-text-o"></i>&nbsp;导出为csv文件
                                                </a>
                                                </li>


                                            </ul>
                                        </li>


                                        <li id="cb_print" class="dropdown hiddenToolbar authorization listPrint"
                                            style="display:none;">
                                            <a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown">
                                                <i class="fa fa-print"></i>&nbsp;打印
                                            </a>
                                            <ul class="dropdown-menu dropdown-custom dropdown-options">


                                                <li><a href="javascript:form.print_preview_byPrintAgent( );">
                                                    <i class="fa fa-file-image-o"></i>&nbsp;打印预览
                                                </a>
                                                </li>

                                                <li><a href="javascript:form.print_printout_byPrintAgent( );">
                                                    <i class="fa fa-print"></i>&nbsp;打印
                                                </a>
                                                </li>

                                                <li><a href="javascript:form.print_preview_byOtherPrintAgent( );">
                                                    <i class="fa fa-print"></i>&nbsp;网络打印
                                                </a>
                                                </li>


                                            </ul>
                                        </li>


                                        <c:if test="${isSysUser || (isArchitect && false)  }">

                                            <li id="cb_setting" class="dropdown">
                                                <a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown">
                                                    <i class="gi gi-settings"></i>&nbsp;设置
                                                </a>

                                                <ul class="dropdown-menu dropdown-custom dropdown-options">
                                                    <li>
                                                        <a id=cb_setting_billsetting onclick="this.blur();"
                                                           target="_blank">
                                                            <i class="gi gi-settings"></i>&nbsp;单据设置
                                                        </a>
                                                    </li>

                                                    <li>
                                                        <a id=a_design_list href="index.jsp?type=design&id="
                                                           onclick="this.blur();"
                                                           target="_blank">
                                                            <i class="gi gi-settings"></i>&nbsp;列表模板设计
                                                        </a>
                                                    </li>

                                                    <li>
                                                        <a id=a_design_edit href="index.jsp?type=design&id="
                                                           onclick="this.blur();"
                                                           target="_blank">
                                                            <i class="gi gi-settings"></i>&nbsp;编辑模板设计
                                                        </a>
                                                    </li>

                                                    <li>
                                                        <a id=a_package onclick="this.blur();"
                                                           target="_blank">
                                                            <i class="gi gi-disk_export"></i>&nbsp;一键发布
                                                        </a>
                                                    </li>


                                                </ul>
                                            </li>

                                        </c:if>

                                    </ul>
                                    <!-- END Left Header Navigation -->


                                    <!-- END Template Options -->


                                    <!--  工具栏结束 -->

                                </div>
                            </td>
                        </tr>
                    </table>
                </header>
            </c:if> <!-- end of  not  isMobile -->

            <!-- Page content -->
            <div id="page-content">
                <div id=mainContainer class="common_background"
                     <c:if test="${!( isMobile && isDD) }">style=" top: 62px;"</c:if>
                     <c:if test="${isMobile && isDD}">style=" top: 0px;"</c:if> >
                    <div id=workBookContainer></div>
                </div><!-- END Dummy Content -->
            </div><!-- END Page Content -->



        </div><!-- END Main Container -->
    </div>  <!-- END Page Container -->
</div><!-- END Page Wrapper -->



<script src="js/app/toolbar_billlist.js?ver=<ss:ver>js/app/toolbar_billlist.js</ss:ver>"></script>
</body>
</html>
<%
    tm.stamp("整个页面处理完成 ");
%>