<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ page import="util.FF" %>
<%@ page import="app.User" %>
<%@ page import="rbac.URLFilter" %>
<%@ page import="org.json.JSONArray" %>
<%@ page import="rbac.MoreOperationID" %>
<%@ page import="org.json.JSONObject" %>
<%@ page import="util.AppCache" %>
<%@ page import="java.util.Iterator" %>
<%@ page import="java.net.URLEncoder" %>
<%@ page import="config.CacheConfig" %>
<%@include file="nocache.jsp" %>
<%@include file="ssoLoginCheck.jsp" %>
<%@ taglib prefix="ss" uri="http://jun.zeng.com" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>


<%

    //是否使用CDN加速
    FF.pageContextSetAttribute(pageContext, "CDN_enabled", CacheConfig.get("/CDN/CDN加速", true));
    int userid = User.getUserFromRequest(request).getId();

    FF.pageContextSetAttribute(pageContext, "currentUserId", userid);


%>


<!DOCTYPE html>
<head>


    <c:if test="${CDN_enabled}">
        <link href="https://cdn.bootcss.com/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet">
        <script src="https://cdn.bootcss.com/jquery/1.12.4/jquery.min.js"></script>

    </c:if>

    <c:if test="${!CDN_enabled}">
        <link rel="stylesheet"
              href="js/spreadsheet/css/bootstrap.min.css?ver=<ss:ver>js/spreadsheet/css/bootstrap.min.css</ss:ver>">
        <script src="js/spreadsheet/base/jquery.js?ver=<ss:ver>js/spreadsheet/base/jquery.js</ss:ver>"></script>
    </c:if>

    <!-- plugin.css 就是字体  -->
    <link rel="stylesheet" href="css/plugins.css?ver=<ss:ver>css/plugins.css</ss:ver>">
    <!--较大-->
    <link rel="stylesheet" href="css/main.css?ver=<ss:ver>css/main.css</ss:ver>">


    <!--下面几个比较小，也没有CDN，自已压缩一下就好了 -->
    <script src="js/spreadsheet/base/jquery.base64.js?ver=<ss:ver>js/spreadsheet/base/jquery.base64.js</ss:ver>"></script>
    <script src="js/spreadsheet/base/jquery.div.resize.js?ver=<ss:ver>js/spreadsheet/base/jquery.div.resize.js</ss:ver>"></script>
    <script src="js/spreadsheet/base/BootstrapMenu.min.js?ver=<ss:ver>js/spreadsheet/base/BootstrapMenu.min.js</ss:ver>"></script>
    <script src="js/design/designUtil.js?ver=<ss:ver>js/design/designUtil.js</ss:ver>"></script>


    <script src="js/spreadsheet/base/jst.js?ver=<ss:ver>js/spreadsheet/base/jst.js</ss:ver>"></script>
    <script src="js/core/domutil.js?ver=<ss:ver>js/core/domutil.js</ss:ver>"></script>
    <script src="js/spreadsheet/base/zrpc.js?ver=<ss:ver>js/spreadsheet/base/zrpc.js</ss:ver>"></script>
    <script src="js/spreadsheet/base/patch.js?ver=<ss:ver>js/spreadsheet/base/patch.js</ss:ver>"></script>

    <script src="ui/jquery-ui/jquery-ui.min.js?ver=<ss:ver>ui/jquery-ui/jquery-ui.min.js</ss:ver>"></script>
    <link rel="stylesheet" href="ui/jquery-ui/jquery-ui.min.css?ver=<ss:ver>ui/jquery-ui/jquery-ui.min.css</ss:ver>">


    <c:if test="${CDN_enabled}">
        <link href="https://cdn.bootcss.com/jqueryui/1.12.1/jquery-ui.min.css" rel="stylesheet">


        <script src="https://cdn.bootcss.com/touchjs/0.2.14/touch.min.js"></script>
        <script src="https://cdn.bootcss.com/jquery-mousewheel/3.1.13/jquery.mousewheel.min.js"></script>

        <link href="https://cdn.bootcss.com/toastr.js/latest/toastr.min.css" rel="stylesheet">
        <script src="https://cdn.bootcss.com/toastr.js/latest/toastr.min.js"></script>


        <script src="https://cdn.bootcss.com/twitter-bootstrap/3.3.7/js/bootstrap.min.js"></script>
        <script src="https://cdn.bootcss.com/jqueryui/1.12.1/jquery-ui.min.js"></script>


        <!-- confirm -->
        <link href="https://cdn.bootcss.com/jquery-confirm/3.3.2/jquery-confirm.min.css" rel="stylesheet">
        <script src="https://cdn.bootcss.com/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>


    </c:if>
    <c:if test="${!CDN_enabled}">
        <link rel="stylesheet"
              href="js/spreadsheet/base/jquery-ui.min.css?ver=<ss:ver>js/spreadsheet/base/jquery-ui.min.css</ss:ver>">


        <script src="js/spreadsheet/base/touch-0.2.14.min.js?ver=<ss:ver>js/spreadsheet/base/touch-0.2.14.min.js</ss:ver>"></script>
        <script src="js/spreadsheet/base/jquery.mousewheel.min.js?ver=<ss:ver>js/spreadsheet/base/jquery.mousewheel.min.js</ss:ver>"></script>

        <link rel="stylesheet" href="ui/toastr/toastr.css?ver=<ss:ver>ui/toastr/toastr.css</ss:ver>">
        <script src="ui/toastr/toastr.min.js?ver=<ss:ver>ui/toastr/toastr.min.js</ss:ver>"></script>


        <script src="js/spreadsheet/base/bootstrap.min.js?ver=<ss:ver>js/spreadsheet/base/bootstrap.min.js</ss:ver>"></script>
        <script src="js/spreadsheet/base/jquery-ui.min.js?ver=<ss:ver>js/spreadsheet/base/jquery-ui.min.js</ss:ver>"></script>


        <!-- confirm -->
        <link rel="stylesheet"
              href="ui/confirm/dist/jquery-confirm.min.css?ver=<ss:ver>ui/confirm/dist/jquery-confirm.min.css</ss:ver>">
        <script src="ui/confirm/js/jquery-confirm.js?ver=<ss:ver>ui/confirm/js/jquery-confirm.js</ss:ver>"></script>

    </c:if>


    <script type="text/javascript"
            src="js/core/toastr.options.js?ver=<ss:ver>js/core/toastr.options.js</ss:ver>"></script>


    <!--需要放在 esl之前 -->
    <script type="text/javascript"
            src="ui/plupload/js/plupload.full.min.js?ver=<ss:ver>ui/plupload/js/plupload.full.min.js</ss:ver>"></script>


    <!-- esl 有定制,以支持js文件的版本号，所以不能用标准的cdn版本-->
    <script src="js/spreadsheet/base/esl.js?ver=<ss:ver>js/spreadsheet/base/esl.js</ss:ver>"></script>


</head>
<body style="background-color: white;overflow:auto;">
<div id="page-wrapper" style="background-color: white;">



    <div style="padding:15px;">
        <ul id="attachmentContainer" style="margin: 0;padding:0;"  class="sortable">

        </ul>

    </div><!-- END Page Wrapper -->



    <script type="text/javascript">


        const currentUserId = parseInt('<c:out value="${currentUserId}"/>');
        const readOnly = '<c:out  value="${param.readOnly}"/>'=='true';


        $(document).ready(function () {

            loadAttachment(urlArgs.dbpool, urlArgs.logTable, urlArgs.tableName, urlArgs.gguid);

        });


    </script>
    <script src="js/form/attachment.js?ver=<ss:ver>js/form/attachment.js</ss:ver>"></script>

</body>
</html>