<!--
/*---------------------------------------------------------------------------*\
|  Subject:       Web TreeView Class                                          |
|  Version:       1.0                                                         |
|  Author:        黄方荣【meizz】【梅花雪】                                   |
|  FileName:      MzTreeView.js                                               |
|  Created:       2004-10-18                                                  |
|  LastModified:  2005-03-10                                                  |
|  Download:      http://www.meizz.com/Web/Download/MzTreeView10.rar          |
|  Explain:       http://www.meizz.com/Web/Article.asp?id=436                 |
|  Demo:          http://www.meizz.com/Web/Demo/MzTreeView10.htm              |
|                                                                             |
|                 You may use this code on your item                          |
|                 this entire copyright notice appears unchanged              |
|                 and you clearly display a link to http://www.meizz.com/     |
|                                                                             |
|-----------------------------------------------------------------------------|
|  MSN: huangfr@msn.com   QQ: 112889082   http://www.meizz.com                |
|  CSDN Community ID: meizz      Copyright (c) 2004-2005 meizz                |


2005.09.24 曾军增加
  常用函数说明：
     
     在使用时，请使用  var tree= new MzTreeView('tree'); 来实例化一个树对象，注意其中的'tree' 
     使用 tree.setIconPath(""); 来设置 本文件相对于jsp文件的路径
     使用 tree.nodes["0_a1"] = "text:WEB 编程"; 来增加节点
           其中  "0_a1" 表示 父结点id＝0 ,增加的子结点ID＝a1 。
                           用下划线作分隔符。前面的是父ID，后面的是增加结点的ID但是，这并不表明可能用
                           下划线前后的ID来访问其中的结点。它仅是表明一个父子关系，如果要访问具体的结点，那么
                           整个串作为一个标识来访问 ，参看下面的访问结点的方法
           它的定义格式如下：
           用键值对的方式来定义，多个键什对间用分号分开，其中系统支持的key有：
                                   text  表示显示的label
                                   target  
                                   url   
                                   data  有点不详，好象是追加到 url后做参数
                                   checked: true | false  定义CheckBox的Check状态。如果定义了，表示显示一个CheckBox，
                        但作为中间的结点，不建议设置成true,而最好是false
                              除了上述的键，还可以自已任意定义
            注意结点的ID和内部ID。 tree.getElementById 使用的是用tree.nodes定义数据时指定的ID
                         而内部ID是内部分配的一个数字                                                    
  
           tree.node[id] 来访问其中的结点对象。注意 id 是内部的一个数字型的ID，它并不是在定义tree的数据时给的ID
           
         如何访问结点的数据：
         
                       1 用内部ID（已经证实）
                          var node= tree.node[ innerid];
					  	  var source = tree.nodes[node.sourceIndex];
					  	  var userid = tree.getAttribute(source, "userid");
					  	  var username=tree.getAttribute(source, "username");
					  	  var showname=tree.getAttribute(source, "showname");  	    
					  	  但内部ID仅是运行时才能得到，所以是不方便的，且不能直接得到。

                      2 用外部ID (已经证实)
           这个外部ID就是在用tree.nodes["pid_thisID"] 定义数据时的整个"pid_thisID"
                          var node=  tree.nodes[ sourceIndex]; //这个sourceIndex 就是pid_thisID这个串
					  	  var source = tree.nodes[node.sourceIndex];
					  	  var userid = tree.getAttribute(source, "userid");
					  	  var username=tree.getAttribute(source, "username");
					  	  var showname=tree.getAttribute(source, "showname");  	    
  
    zengjun于2006.04.12 增加是不是智能模式的开关,如果是智能模式，那么当节点
    的checked状态发生改变时，要同步修改下级和上级的状态，参看函数 checkSubTreeSwidth
                       
\*---------------------------------------------------------------------------*/


//MzTreeView1.0网页树类, 在实例化的时候请把实例名作参数传递进来
function MzTreeView(Tname)
{
  if(typeof(Tname) != "string" || Tname == "")
    throw(new Error(-1, '创建类实例的时候请把类实例的引用变量名传递进来！'));
  
  //【property】
  this.smartMode =true; // zengjun于2006.04.12 增加是不是智能模式的开关,如果是智能模式，那么当节点的checked状态发生改变时，要同步修改下级和上级的状态，参看函数 checkSubTreeSwidth
  this.url      = "#";
  this.target   = "_self";
  this.name     = Tname;
  this.wordLine = false;
  this.currentNode = null;
  this.useArrow = true;
  this.nodes = {};
  this.node  = {};
  this.names = "";
  this._d    = "\x0f";
  this.index = 0;
  this.divider   = "_";
  this.node["root"] =
  {
    "id": "root",
    "path": "",
    "isLoad": false,
    "childNodes": [],
    "childAppend": "",
    "sourceIndex": "root"
  };

  this.colors   =
  {
    "highLight" : "#7070ff",
    "highLightText" : "#FFFFFF",
    "mouseOverBgColor" : "#D4D0C8"
  };
  this.icons    = {
    L0        :'line4.gif', // 'L0.gif',  //┏
    L1        :'line3.gif' ,// 'L1.gif'  ,  //┣
    L2        : 'line2.gif' , // 'L2.gif',  //┗
    L3        :  'line5.gif', //'L3.gif',  //━
    L4        : 'line1.gif' , //'L4.gif',  //┃
    PM0       : 'plus4.gif' , //'P0.gif',  //＋┏
    PM1       : 'plus3.gif' , //'P1.gif',  //＋┣
    PM2       :  'plus2.gif' , //'P2.gif',  //＋┗
    PM3       :  'plus5.gif' , //'P3.gif',  //＋━
    empty     : 'blank.gif' , // 'L5.gif',     //空白图
    root      : 'wisesoft.gif', //  'root.gif',   //缺省的根节点图标
    folder    : 'folder.gif', //缺省的文件夹图标
    file      :  'leaf.gif' , // 'file.gif',   //缺省的文件图标
    exit      : 'exit.gif'
  };
  this.iconsExpand = {  //存放节点图片在展开时的对应图片
    PM0       :'minus4.gif', // 'M0.gif',     //－┏
    PM1       :'minus3.gif', // 'M1.gif',     //－┣
    PM2       :'minus2.gif', // 'M2.gif',     //－┗
    PM3       :'minus5.gif', // 'M3.gif',     //－━
    folder    : 'folderopen.gif',

    exit      : 'exit.gif'
  };

  //扩展 document.getElementById(id) 多浏览器兼容性
  //id 要查找的对象 id
  this.getElementById = function(id)
  {
    if (typeof(id) != "string" || id == "") return null;
    if (document.getElementById) return document.getElementById(id);
    if (document.all) return document.all(id);
    try {return eval(id);} catch(e){ return null;}
  }

  //MzTreeView 初始化入口函数
  this.toString = function()
  {
    this.browserCheck();
    this.dataFormat();
    this.setStyle();
    this.load("root");
    var rootCN = this.node["root"].childNodes;
    var str = "<A id='"+ this.name +"_RootLink' href='#' style='DISPLAY: none'></A>";
    
    if(rootCN.length>0)
    {
      this.node["root"].hasChild = true;
      for(var i=0; i<rootCN.length; i++)
        str += this.nodeToHTML(rootCN[i], i==rootCN.length-1);
      setTimeout(this.name +".expand('"+ rootCN[0].id +"', true); "+ 
        this.name +".focusClientNode('"+ rootCN[0].id +"'); "+ this.name +".atRootIsEmpty()",10);
    }

    if (this.useArrow)  //使用方向键控制跳转到上级下级父级子级节点
    {
      if (document.attachEvent)
          document.attachEvent("onkeydown", this.onkeydown);
      else if (document.addEventListener)
          document.addEventListener('keydown', this.onkeydown, false);
    }
    return "<DIV class='MzTreeView' "+
      "onclick='"+ this.name +".clickHandle(event)' "+
      "ondblclick='"+ this.name +".dblClickHandle(event)' "+
      ">"+ str +"</DIV>";
  };

  this.onkeydown= function(e)
  {
    e = window.event || e; var key = e.keyCode || e.which;
    switch(key)
    {
      case 37 : eval(Tname).upperNode(); break;  //Arrow left, shrink child node
      case 38 : eval(Tname).pervNode();  break;  //Arrow up
      case 39 : eval(Tname).lowerNode(); break;  //Arrow right, expand child node
      case 40 : eval(Tname).nextNode();  break;  //Arrow down
    }
  };
}

//浏览器类型及版本检测
MzTreeView.prototype.browserCheck = function()
{
  var ua = window.navigator.userAgent.toLowerCase(), bname;
  if(/msie/i.test(ua))
  {
    this.navigator = /opera/i.test(ua) ? "opera" : "";
    if(!this.navigator) this.navigator = "msie";
  }
  else if(/gecko/i.test(ua))
  {
    var vendor = window.navigator.vendor.toLowerCase();
    if(vendor == "firefox") this.navigator = "firefox";
    else if(vendor == "netscape") this.navigator = "netscape";
    else if(vendor == "") this.navigator = "mozilla";
  }
  else this.navigator = "msie";
  if(window.opera) this.wordLine = false;
};

//给 TreeView 树加上样式设置
MzTreeView.prototype.setStyle = function()
{
  /*
    width: 16px; \
    height: 16px; \
    width: 20px; \
    height: 20px; \
  */
  var style = "<style>"+
  "DIV.MzTreeView DIV IMG{border: 0px solid #FFFFFF;}"+
  "DIV.MzTreeView DIV SPAN IMG{border: 0px solid #FFFFFF;}";
  if(this.wordLine)
  {
    style +="\
    DIV.MzTreeView DIV\
    {\
      height: 20px;"+
      (this.navigator=="firefox" ? "line-height: 20px;" : "" ) +
      (this.navigator=="netscape" ? "" : "overflow: hidden;" ) +"\
    }\
    DIV.MzTreeView DIV SPAN\
    {\
      vertical-align: middle; font-size: 21px; height: 20px; color: #D4D0C8; cursor: default;\
    }\
    DIV.MzTreeView DIV SPAN.pm\
    {\
      width: "+ (this.navigator=="msie"||this.navigator=="opera" ? "11" : "9") +"px;\
      height: "+ (this.navigator=="netscape"?"9":(this.navigator=="firefox"?"10":"11")) +"px;\
      font-size: 7pt;\
      overflow: hidden;\
      margin-left: -16px;\
      margin-right: 5px;\
      color: #000080; \
      vertical-align: middle;\
      border: 1px solid #D4D0C8;\
      cursor: "+ (this.navigator=="msie" ? "hand" : "pointer") +";\
      padding: 0 2px 0 2px;\
      text-align: center;\
      background-color: #F0F0F0;\
    }";
  }
  style += "<\/style>";
  document.write(style);
};

//当根节点为空的时候做的处理
MzTreeView.prototype.atRootIsEmpty = function()
{
  var RCN = this.node["root"].childNodes;
  for(var i=0; i<RCN.length; i++)
  {
    if(!RCN[i].isLoad) this.expand(RCN[i].id);
    if (RCN[i].text=="")
    {
      var node = RCN[i].childNodes[0], HCN  = node.hasChild;
      if(this.wordLine)
      {
        var span = this.getElementById(this.name +"_tree_"+ node.id);
        span = span.childNodes[0].childNodes[0].childNodes[0];
        span.innerHTML = RCN[i].childNodes.length>1 ? "┌" : "─";
      }
      else
      {
        node.iconExpand  =  RCN[i].childNodes.length>1 ? HCN ? "PM0" : "L0" : HCN ? "PM3" : "L3"
        this.getElementById(this.name +"_expand_"+ node.id).src = this.icons[node.iconExpand].src;
      }
    }
  }
};

//初始化数据源里的数据以便后面的快速检索
MzTreeView.prototype.dataFormat = function()
{
  var a = new Array();
  for (var id in this.nodes) a[a.length] = id;
  this.names = a.join(this._d + this._d);
  this.totalNode = a.length; a = null;
};

//在数据源检索所需的数据节点
//id  客户端节点对应的id
MzTreeView.prototype.load = function(id)
{
  var node = this.node[id], d = this.divider, _d = this._d;
  var sid = node.sourceIndex.substr(node.sourceIndex.indexOf(d) + d.length);
  var reg = new RegExp("(^|"+_d+")"+ sid +d+"[^"+_d+d +"]+("+_d+"|$)", "g");
  var cns = this.names.match(reg), tcn = this.node[id].childNodes; if (cns){
  reg = new RegExp(_d, "g"); for (var i=0; i<cns.length; i++)
  tcn[tcn.length] = this.nodeInit(cns[i].replace(reg, ""), id); }
  node.isLoad = true;
};

//初始化节点信息, 根据 this.nodes 数据源生成节点的详细信息
//sourceIndex 数据源中的父子节点组合的字符串 0_1
//parentId    当前树节点在客户端的父节点的 id
MzTreeView.prototype.nodeInit = function(sourceIndex, parentId)
{
  this.index++;
  var source= this.nodes[sourceIndex], d = this.divider;
  var text  = this.getAttribute(source, "text");
  var hint  = this.getAttribute(source, "hint");
  var sid   = sourceIndex.substr(sourceIndex.indexOf(d) + d.length);
  this.node[this.index] =
  {
    "id"    : this.index,
    "text"  : text,
    "hint"  : hint ? hint : text,
    "icon"  : this.getAttribute(source, "icon"),
    "path"  : this.node[parentId].path + d + this.index,
    "isLoad": false,
    "isExpand": false,
    "parentId": parentId,
    "parentNode": this.node[parentId],
    "sourceIndex" : sourceIndex,
    "childAppend" : ""
  };
     this.nodes[sourceIndex] = "index:"+ this.index +";"+ source;
     this.node[this.index].hasChild = this.names.indexOf(this._d + sid + d)>-1;
  if(this.node[this.index].hasChild)  this.node[this.index].childNodes = [];
  return this.node[this.index];
};

//从XML格式字符串里提取信息
//source 数据源里的节点信息字符串(以后可以扩展对XML的支持)
//name   要提取的属性名
MzTreeView.prototype.getAttribute = function(source, name)
{
  var reg = new RegExp("(^|;|\\s)"+ name +"\\s*:\\s*([^;]*)(\\s|;|$)", "i");
  if (reg.test(source)) return RegExp.$2.replace(/[\x0f]/g, ";"); return "";
};

//根据节点的详细信息生成HTML
//node   树在客户端的节点对象
//AtEnd  布尔值  当前要转换的这个节点是否为父节点的子节点集中的最后一项
MzTreeView.prototype.nodeToHTML = function(node, AtEnd)
{
 
  var source = this.nodes[node.sourceIndex];
  var target = this.getAttribute(source, "target");
  var data = this.getAttribute(source, "data");
  var url  = this.getAttribute(source, "url");
  var checked  = this.getAttribute(source, "checked");
  
  if(!url) url = this.url;
  if(data) url += (url.indexOf("?")==-1?"?":"&") + data;
  if(!target) target = this.target;

  var id   = node.id;
  var HCN  = node.hasChild, isRoot = node.parentId=="root";
  if(isRoot && node.icon=="") node.icon = "root";
  if(node.icon=="" || typeof(this.icons[node.icon])=="undefined")
    node.icon = HCN ? "folder" : "file";
  node.iconExpand  = AtEnd ? "└" : "├";

  var HTML = "<DIV noWrap='True'><NOBR>";
  if(!isRoot)
  {
    node.childAppend = node.parentNode.childAppend + (AtEnd ? "　" : "│");
    if(this.wordLine)
    {
      HTML += "<SPAN>"+ node.parentNode.childAppend + (AtEnd ? "└" : "├") +"</SPAN>";
      if(HCN) HTML += "<SPAN class='pm' id='"+ this.name +"_expand_"+ id +"'>+</SPAN>";
    }
    else
    {
      node.iconExpand  = HCN ? AtEnd ? "PM2" : "PM1" : AtEnd ? "L2" : "L1";
      HTML += "<SPAN>"+ this.word2image(node.parentNode.childAppend) +"<IMG "+
        "align='absmiddle' id='"+ this.name +"_expand_"+ id +"' "+
        "src='"+ this.icons[node.iconExpand].src +"' style='cursor: "+ (!node.hasChild ? "":
        (this.navigator=="msie"||this.navigator=="opera"? "hand" : "pointer")) +"'></SPAN>";
    }
  }
  

    var data3= this.getAttribute(source, "showname") ;
     var data2= this.getAttribute(source, "username") ;
     var data1= this.getAttribute(source, "userid") ;
       
   var ss="  onpropertychange = \"   treeItemCheckedChanged( this.checked , '"+data1+"','"+data2+"','"+data3   +"');   \" " ;
 
 
 
//    " onchanged=\" try {  treeItemCheckedChanged(this.checked , "+data1+",'"+data2+"','"+data3   +"'); }catch(err){ } \" "+
       
  HTML += "<IMG "+
    "align='absMiddle' "+
    "id='"+ this.name +"_icon_"+ id +"' "+
    "src='"+ this.icons[node.icon].src +"'>"+
    ( checked==''? '':"<input id=chk_"+id+"   name=chk_name_"+data1+"   type=\"checkbox\"  "+ // 如果定义了checked属性，那么增加一个CheckBox
      ss+
      "   onclick=\"return "+ this.name +".checkSubTreeSwidth('"+ id +"')\"  "
     +   (checked=='true'?' checked ':'') // 设置checked 属性
       + ( HCN?'  disabled ':''  )+ "  >")+ // 如果本节点有子项，那么在子项没有展开之前，它是不允许点击的。所以在expand函数中，会把disabled开放成false
	"<A "+
    "class='MzTreeview' hideFocus "+
    "id='"+ this.name +"_link_"+ id +"' "+
    "href='"+ url +"' "+
    "target='"+ target +"' "+
    "title='"+ node.hint +"' "+
    "onfocus=\""+ this.name +".focusLink('"+ id +"')\" "+
    "onclick=\"return "+ this.name +".nodeClick('"+ id +"')\">"+   node.text +
  "</A></NOBR></DIV>";
  if(isRoot && node.text=="") HTML = "";

  HTML = "\r\n<SPAN id='"+ this.name +"_tree_"+ id +"'>"+ HTML 
  HTML +="<SPAN style='DISPLAY: none'></SPAN></SPAN>";
  return HTML;
};

//在使用图片的时候对 node.childAppend 的转换
MzTreeView.prototype.word2image = function(word)
{
  var str = "";
  for(var i=0; i<word.length; i++)
  {
    var img = "";
    switch (word.charAt(i))
    {
      case "│" : img = "L4"; break;
      case "└" : img = "L2"; break;
      case "　" : img = "empty"; break;
      case "├" : img = "L1"; break;
      case "─" : img = "L3"; break;
      case "┌" : img = "L0"; break;
    }
    if(img!="")
      str += "<IMG align='absMiddle' src='"+ this.icons[img].src +"' height='20'>";
  }
  return str;
}


//将某个节点下的所有子节点转化成详细的<HTML>元素表达
//id 树的客户端节点 id
MzTreeView.prototype.buildNode = function(id)
{
  if(this.node[id].hasChild)
  {
    var tcn = this.node[id].childNodes, str = "";
    for (var i=0; i<tcn.length; i++)
      str += this.nodeToHTML(tcn[i], i==tcn.length-1);
    var temp = this.getElementById(this.name +"_tree_"+ id).childNodes;
    temp[temp.length-1].innerHTML = str;
  }
};

//聚集到客户端生成的某个节点上
//id  客户端树节点的id
MzTreeView.prototype.focusClientNode      = function(id)
{
  if(!this.currentNode) this.currentNode=this.node["root"];

  var a = this.getElementById(this.name +"_link_"+ id); if(a){  try{a.focus()} catch(err){} 
  var link = this.getElementById(this.name +"_link_"+ this.currentNode.id);
  if(link)with(link.style){color="";   backgroundColor="";}
  with(a.style){color = this.colors.highLightText;
  backgroundColor = this.colors.highLight;}
  this.currentNode= this.node[id];}
};

//焦点聚集到树里的节点链接时的处理
//id 客户端节点 id
MzTreeView.prototype.focusLink= function(id)
{
  if(this.currentNode && this.currentNode.id==id) return;
  this.focusClientNode(id);
};

//点击展开树节点的对应方法
MzTreeView.prototype.expand   = function(id, sureExpand)
{
 
  var node  = this.node[id];
  if (sureExpand && node.isExpand) return;
  if (!node.hasChild) return;
  
  // 2005.09.24 修改
  //如果这个结点允许有CheckBox，那么，把它设置成Enabled
  var source = this.nodes[node.sourceIndex];
  var checked  = this.getAttribute(source, "checked");
  if ( checked!='')
  {
  		var chk=document.getElementById('chk_'+id);
  		if ( chk.disabled)  chk.disabled=false;
  }
  
  
  var area  = this.getElementById(this.name +"_tree_"+ id);
  if (area)   area = area.childNodes[area.childNodes.length-1];
  if (area)
  {
    var icon  = this.icons[node.icon];
    var iconE = this.iconsExpand[node.icon];
    var Bool  = node.isExpand = sureExpand || area.style.display == "none";
    var img   = this.getElementById(this.name +"_icon_"+ id);
    if (img)  img.src = !Bool ? icon.src :typeof(iconE)=="undefined" ? icon.src : iconE.src;
    var exp   = this.icons[node.iconExpand];
    var expE  = this.iconsExpand[node.iconExpand];
    var expand= this.getElementById(this.name +"_expand_"+ id);
    if (expand)
    {
      if(this.wordLine) expand.innerHTML = !Bool ? "+"  : "-";
      else expand.src = !Bool ? exp.src : typeof(expE) =="undefined" ? exp.src  : expE.src;
    }
    if(!Bool && this.currentNode.path.indexOf(node.path)==0 && this.currentNode.id!=id)
    {
      try{this.getElementById(this.name +"_link_"+ id).click();}
      catch(e){this.focusClientNode(id);}
    }
    area.style.display = !Bool ? "none" : "block";//(this.navigator=="netscape" ? "block" : "");
    if(!node.isLoad)
    {
      this.load(id);
      if(node.id=="root") return;

      //当子节点过多时, 给用户一个正在加载的提示语句
      if(node.hasChild && node.childNodes.length>200)
      {
        setTimeout(this.name +".buildNode('"+ id +"')", 1);
        var temp = this.getElementById(this.name +"_tree_"+ id).childNodes;
        temp[temp.length-1].innerHTML = "<DIV noWrap><NOBR><SPAN>"+ (this.wordLine ?
        node.childAppend +"└" : this.word2image(node.childAppend +"└")) +"</SPAN>"+
        "<IMG border='0' height='20' align='absmiddle' src='"+this.icons["file"].src+"'>"+
        "<A style='background-Color: "+ this.colors.highLight +"; color: "+
        this.colors.highLightText +"; font-size: 9pt'>请稍候...</A></NOBR></DIV>";
      }
      else this.buildNode(id);
    }
  }
};

//节点链接单击事件处理方法
//id 客户端树节点的 id
MzTreeView.prototype.nodeClick = function(id)
{
    var source = this.nodes[this.node[id].sourceIndex];
    var method=(this.getAttribute(source, "method"));

    method=method.replace( /@id/g, id);  // 动态对数替换  2005.09.24 曾军增加

   
    var a = this.node[id];
    
     if(! a.hasChild) //如果是未级结点，那么点击文字时，也处理Checkbox
     {
  		var chk=document.getElementById('chk_'+id);
  		if ( chk!=null)  chk.checked=! chk.checked;
  	 }
     
     eval(method);
     
     
     return !(!this.getAttribute(source, "url") && this.url=="#");
};


// 把指定ID的 节点的子树的所有项目都设置成一样的
// 当点击某相节点时，它的整个子树都设置成相同的checked属性
// 同时当结点的Checkbox的Check改变时，也要检查一下上级结点的Check属性
MzTreeView.prototype.checkSubTreeSwidth = function(id  )     
{
    if ( this.smartMode)
    {
	 var chk=document.getElementById('chk_'+id);
	 var checked =chk.checked ;
	 this.checkSubTree( id, checked);
	 this.checkParentRoute(id); // 设置上级结点状态
	 }
}
      
// 2005.09.24 曾军增加      
 MzTreeView.prototype.checkSubTree = function(id , checked)     
 {
	 var chk=document.getElementById('chk_'+id);
	 
	  // 当这个checkbox是不允许点击时，那么表明它有子项，且自己还没有被展开，那么
	  // 执行它的expand 函数，把它展开，然后再次调用expand把它收拢
   　
	
     var a = this.node[id];
     if ( chk.disabled) 　
     {
            if(a.hasChild) 
          {
          this.expand(id);
          this.expand(id);
          }
     } 
     
	 chk.checked=checked;
     
     
     if(a.hasChild)
     {
       
	      for (var k=0; k<a.childNodes.length; k++)
	      {
	           var  sub   = a.childNodes[k];
	           this.checkSubTree( sub.id, checked);
	      }
      }
 }
 
// 2005.09.24 曾军增加
 MzTreeView.prototype.checkParentRoute = function(id )     
 {
 	  // 2006.10.19去掉了此功能 
     return ;
   
 	// 如果是根，那么不用再做了
	  if ( id=='0') return ;
	  var pid = this.node[id].parentId;
      var pnode= this.node[pid];
      
	  var chk=document.getElementById('chk_'+pid);
	  //如果是CheckBox，那么检查如果所有子项是Checked，那么把自己改成Checked
	  // 如果所有子项都是unchecked ,那么把自己也改成unchecked
	  // 如果有的是Checked，有的是UnChecked， 那么把自己也改成Unchecked
	  if ( chk!=null)  
	  {
	 	  var allChecked=true;
		  var allUnchecked=true; 
		  
		  for (var k=0; k<pnode.childNodes.length; k++)
		  {
		           var  sub   = pnode.childNodes[k];
		           var subid= sub.id;
		           var subChk=document.getElementById('chk_'+subid);
		           if ( subChk==null) continue; // 有可能某个子项不是Checkbox
		           if ( subChk.disabled) continue; // 如果是灰的，那么忽略它
		           if ( subChk.checked) allUnchecked=false;
		           if ( !subChk.checked) allChecked=false;
		           
	      }
	      
	      if ( allUnchecked) chk.checked=false;
	      if ( allChecked) chk.checked=true;
	      if ( ! allChecked) chk.checked=false;
      }
      //继续检查上级
      this.checkParentRoute(pnode.id); // 一定要加this. 不然不会调用
 }
  
  

//为配合系统初始聚集某节点而写的函数, 得到某节点在数据源里的路径
//sourceId 数据源里的节点 id
MzTreeView.prototype.getPath= function(sourceId)
{
  
Array.prototype.indexOf = function(item)
  {
    for(var i=0; i<this.length; i++)
    {
      if(this[i]==item) return i;
    }
    return -1;
  };
  var _d = this._d, d = this.divider;
  var A = new Array(), id=sourceId; A[0] = id;
  while(id!="root" && id!="")
  {
    var str = "(^|"+_d+")([^"+_d+d+"]+"+d+ id +")("+_d+"|$)";
    if (new RegExp(str).test(this.names))
    {
      id = RegExp.$2.substring(0, RegExp.$2.indexOf(d));
      if(A.indexOf(id)>-1) break;
      A[A.length] = id;
    }
    else break;
  }
  return A.reverse();
};

//在源代码里指定 MzTreeView 初始聚集到某个节点
//sourceId 节点在数据源里的 id
MzTreeView.prototype.focus = function(sourceId, defer)
{
  if (!defer)
  {
    setTimeout(this.name +".focus('"+ sourceId +"', true)", 100);
    return;
  }
  var path = this.getPath(sourceId);
  if(path[0]!="root")
  {
    alert("节点 "+ sourceId +" 没有正确的挂靠有效树节点上！\r\n"+
      "节点 id 序列 = "+ path.join(this.divider));
    return;
  }
  var root = this.node["root"], len = path.length;
  for(var i=1; i<len; i++)
  {
    if(root.hasChild)
    {
      var sourceIndex= path[i-1] + this.divider + path[i];
      for (var k=0; k<root.childNodes.length; k++)
      {
        if (root.childNodes[k].sourceIndex == sourceIndex)
        {
          root = root.childNodes[k];
          if(i<len - 1) this.expand(root.id, true);
          else this.focusClientNode(root.id);
          break;
        }
      }
    }
  }
};

//树的单击事件处理函数
MzTreeView.prototype.clickHandle = function(e)
{
  e = window.event || e; e = e.srcElement || e.target;
  //alert(e.tagName)
  switch(e.tagName)
  {
    case "IMG" :
      if(e.id)
      {
        if(e.id.indexOf(this.name +"_icon_")==0)
          this.focusClientNode(e.id.substr(e.id.lastIndexOf("_") + 1));
        else if (e.id.indexOf(this.name +"_expand_")==0)
          this.expand(e.id.substr(e.id.lastIndexOf("_") + 1));
      }
      break;
    case "A" :
      if(e.id) this.focusClientNode(e.id.substr(e.id.lastIndexOf("_") + 1));
      break;
    case "SPAN" :
      if(e.className=="pm")
        this.expand(e.id.substr(e.id.lastIndexOf("_") + 1));
      break;
    default :
      if(this.navigator=="netscape") e = e.parentNode;
      if(e.tagName=="SPAN" && e.className=="pm")
        this.expand(e.id.substr(e.id.lastIndexOf("_") + 1));
      break;
  }
};

//MzTreeView 双击事件的处理函数
MzTreeView.prototype.dblClickHandle = function(e)
{
  e = window.event || e; e = e.srcElement || e.target;
  if((e.tagName=="A" || e.tagName=="IMG")&& e.id)
  {
    var id = e.id.substr(e.id.lastIndexOf("_") + 1);
    if(this.node[id].hasChild) this.expand(id);
  }
};

//回到树当前节点的父层节点
MzTreeView.prototype.upperNode = function()
{
  if(!this.currentNode) return;
  if(this.currentNode.id=="root" || this.currentNode.parentId=="root") return;
  if (this.currentNode.hasChild && this.currentNode.isExpand)
    this.expand(this.currentNode.id, false);
  else this.focusClientNode(this.currentNode.parentId);
};

//展开当前节点并
MzTreeView.prototype.lowerNode = function()
{
  if (!this.currentNode) this.currentNode = this.node["root"];
  if (this.currentNode.hasChild)
  {
    if (this.currentNode.isExpand)
      this.focusClientNode(this.currentNode.childNodes[0].id);
    else this.expand(this.currentNode.id, true);
  }
}

//聚集到树当前节点的上一节点
MzTreeView.prototype.pervNode = function()
{
  if(!this.currentNode) return; var e = this.currentNode;
  if(e.id=="root") return; var a = this.node[e.parentId].childNodes;
  for(var i=0; i<a.length; i++){if(a[i].id==e.id){if(i>0){e=a[i-1];
  while(e.hasChild){this.expand(e.id, true);
  e = e.childNodes[e.childNodes.length - 1];}
  this.focusClientNode(e.id); return;} else {
  this.focusClientNode(e.parentId); return;}}}
};

//聚集到树当前节点的下一节点
MzTreeView.prototype.nextNode = function()
{
  var e = this.currentNode; if(!e) e = this.node["root"];
  if (e.hasChild){this.expand(e.id, true);
  this.focusClientNode(e.childNodes[0].id); return;}
  while(typeof(e.parentId)!="undefined"){
  var a = this.node[e.parentId].childNodes;
  for(var i=0; i<a.length; i++){ if(a[i].id==e.id){
  if(i<a.length-1){this.focusClientNode(a[i+1].id); return;}
  else e = this.node[e.parentId];}}}
};

//展开树的所有节点
MzTreeView.prototype.expandAll = function()
{
  if(this.totalNode>500) if(
    confirm("您是否要停止展开全部节点？\r\n\r\n节点过多！展开很耗时")) return;
  if(this.node["root"].childNodes.length==0) return;
  var e = this.node["root"].childNodes[0];
  var isdo = t = false;
  while(e.id != "root")
  {
    var p = this.node[e.parentId].childNodes, pn = p.length;
    if(p[pn-1].id==e.id && (isdo || !e.hasChild)){e=this.node[e.parentId]; isdo = true;}
    else
    {
      if(e.hasChild && !isdo)
      {
        this.expand(e.id, true), t = false;
        for(var i=0; i<e.childNodes.length; i++)
        {
          if(e.childNodes[i].hasChild){e = e.childNodes[i]; t = true; break;}
        }
        if(!t) isdo = true;
      }
      else
      {
        isdo = false;
        for(var i=0; i<pn; i++)
        {
          if(p[i].id==e.id) {e = p[i+1]; break;}
        }
      }
    }
  }
};

//本树将要用动的图片的字义及预载函数
//path 图片存放的路径名
MzTreeView.prototype.setIconPath  = function(path)
{
  var k = 0, d = new Date().getTime();
  for(var i in this.icons)
  {
    var tmp = this.icons[i];
    this.icons[i] = new Image();
    this.icons[i].src = path + tmp;
    // if(k==9 && (new Date().getTime()-d)>20)    this.wordLine = true;   为什么这么做，不清楚，当 wordLine=true时，结点连接
    // 会使用字符，而不是图片 。 2005.09.25曾军注释掉了这句
    k++;
  }
  for(var i in this.iconsExpand)
  {
    var tmp = this.iconsExpand[i];
    this.iconsExpand[i]=new Image();
    this.iconsExpand[i].src = path + tmp;
  }
};

//设置树的默认链接
//url 默认链接  若不设置, 其初始值为 #
MzTreeView.prototype.setURL     = function(url){this.url = url;};

//设置树的默认的目标框架名 target
//target 目标框架名  若不设置, 其初始值为 _self
MzTreeView.prototype.setTarget  = function(target){this.target = target;};
// -->



   
 // 2005.09.24 曾军增加      
 // 取得多选的数据
 //  propName 属性的名称
 //  split 分隔符号
 //  includeGroup 是否包含中间的选中节点
 MzTreeView.prototype.getDataListOfAllSelectedNode = function( propName , split , includeGroup)     
 {
 
 	return this.getDataListOfAllSelectedSubNode( "root"  , propName, split , includeGroup);
 }
 
 
MzTreeView.prototype.getDataListOfAllSelectedSubNode = function( id , propName , split ,includeGroup)   
{
      var ret="";
      var node = this.node[id];
      
	  var chk=document.getElementById('chk_'+id);
 
	  
	 
      if ( chk!=null)
      {
            //alert ( node.text+ '    '+ chk.checked+'    '+ node.hasChild);
        	   
	 	   if ( chk.checked && (  !node.hasChild  || includeGroup) )     // 如果是选中状态，并且是否是未级结点或者允许中间节点
	 	   {
	 	   		
	 	   		var source = this.nodes[node.sourceIndex];
    			var data=(this.getAttribute(source, propName));
	 	        ret=data;
	 	   }
	  }
	 	   
           //处理子结点
   
	     if(node.hasChild)
     	 {
              
	          for (var k=0; k<node.childNodes.length; k++)
	         {
	             var  sub   = node.childNodes[k];
	             
	             var  t=this.getDataListOfAllSelectedSubNode( sub.id , propName , split); 
	             
	             if ( ret=="") 
	             {
	                ret=t;
	               }else
	               {
	                  if ( t!='')  ret=ret+split+t;
	               }
	          }
         }
      
       
       return ret;  
         
 }
 
  // 不是通用的函数，是对选择多用户特制的函数
  MzTreeView.prototype.getAllSelectedUser = function( propName , propName2 ,propName3)     
 {
     if ( propName3 == undefined) propName3='showname';
 	 this.getAllSelectedUserSubNode( "root"  , propName, propName2 ,propName3);
 }
 
 
 // 不是通用的函数，是对选择多用户特制的函数
MzTreeView.prototype.getAllSelectedUserSubNode = function( id , propName,propName2 ,propName3 )   
{
      var node = this.node[id];
	  var chk=document.getElementById('chk_'+id);
       if ( chk!=null)
      {
	 	   if ( chk.checked && !node.hasChild)     // 如果是选中状态，并且是未级结点
	 	   {
	 	   		var source = this.nodes[node.sourceIndex];
				var data3= this.getAttribute(source, propName3) ;
	 	   		var data2= this.getAttribute(source, propName2) ;
    			var data1= this.getAttribute(source, propName) ;
    	 
	 	        try
	 	        {
	 	        	parent.SelecUserWithoutClose( data1, data2 , data3);
	 	        }catch(err)
	 	        {
	 	        }
	 	   }
	  }
       
   
         //处理子结点
	     if(node.hasChild)
     	 {
	          for (var k=0; k<node.childNodes.length; k++)
	         {
	             var  sub   = node.childNodes[k];
	             this.getAllSelectedUserSubNode( sub.id , propName,propName2 , propName3); 
	           }
         }
 }
 
 
   // 不是通用的函数，是对选择多用户组特制的函数
  MzTreeView.prototype.getAllSelectedGroup = function( propName , propName2 )     
 {
     
 	 this.getAllSelectedGroupSubNode( "root"  , propName, propName2);
 }
 
 
 // 不是通用的函数，是对选择多用户组特制的函数
MzTreeView.prototype.getAllSelectedGroupSubNode = function( id , propName,propName2  )   
{
      var node = this.node[id];
	  var chk=document.getElementById('chk_'+id);
       if ( chk!=null)
      {
	 	   if ( chk.checked )     // 如果是选中状态 
	 	   {
	 	   		var source = this.nodes[node.sourceIndex];
	 	   		var data2= this.getAttribute(source, propName2) ;
    			var data1= this.getAttribute(source, propName) ;
     
	 	        try
	 	        {
	 	        	parent.SelecGroupWithoutClose( data1, data2);
	 	        }catch(err)
	 	        {
	 	        }
	 	   }
	  }
         //处理子结点
	     if(node.hasChild)
     	 {
	          for (var k=0; k<node.childNodes.length; k++)
	         {
	             var  sub   = node.childNodes[k];
	             this.getAllSelectedGroupSubNode( sub.id , propName,propName2); 
	           }
         }
 }
 
 function treeItemCheckedChanged(checked , id, name , showname)
  {
           try
           {
            if ( event.propertyName=='checked'  && id!='' )          selectOrUnSelectUser( checked , id, name , showname)
            }catch(err)
            {
            }  
  }
  
  