// 每次表单打开时都会执行名为　flowOpen的函数，可以在这个函数里做一些初始化的操作
// 值得注意的是，这个函数是在每当表单打开时都会执行 
function flowOpen()
{
	book.getDataSource('query_kchw').getDataStore().insertRow(0);
	book.getWorkSheet(1).cells("classname").removeBrick(book.getWorkSheet(1).cells("classname").getBrick(0).getName());
	book.getDataSource('query_kchw2').getDataStore().insertRow(0);
	book.getWorkSheet(0).cells("classname").removeBrick(book.getWorkSheet(0).cells("classname").getBrick(0).getName());
	
	book.getWorkSheet(0).cells("hwid_").setCursorName("hand");
	book.getWorkSheet(0).cells("gg_").setCursorName("hand");
	book.getWorkSheet(0).cells("chdd_").setCursorName("hand");
	 
	checkView();
}

function checkView()
{
	
	var sql="create view v_kc_xjxc as  "+
		"select b.id,b.rq as orderrq, b.rq ,b.inner_xh ,b.hwid,isnull(b.gg,'') as gg,b.chdd,a.bz, "+
		"       1 as type_ , 1 as crk, '入库' as lx ,a.wldwmc ,b.jldw, b.sl as sl_rk ,b.dj as dj_rk ,b.je as je_rk , "+
		"       null as sl_ck , null as dj_ck , null as je_ck, null as sl_jc , null as dj_jc , null as je_jc "+
		"   from flow_kc_rk a , flow_kc_rkmx b "+
		"   where a.gguid=b.gguid "+
		" union "+
		"   select b.id,b.rq as orderrq, b.rq, b.inner_xh ,b.hwid,isnull(b.gg,'') as gg,b.chdd,a.bz, "+
		"       1 as type_, -1 as crk,'出库' as lx ,c.name , b.jldw,null ,null, null, b.sl , b.dj, b.je , null ,null, null "+
		"   from flow_kc_ck a , flow_kc_ckmx b , oa_mygroup c "+
		"   where a.gguid=b.gguid and a.bm=c.id "+
		" union "+
		"   select b.id,b.rq as orderrq, getDate() as rq , b.inner_xh ,b.hwid,isnull(b.gg,'') as gg,b.chdd, a.bz,"+
		"       2 as type_, 0 as crk,'结存' as lx ,a.wldwmc ,b.jldw, null ,null, null,null ,null, null,b.jcsl ,b.dj ,b.jcje "+
		"   from flow_kc_rk a , flow_kc_rkmx b "+
		"   where a.gguid=b.gguid and jcsl>0";
		
		//从该视图取数时，需要按 type_ ,orderrq , inner_xh排序 ,  出入库的type_ 都==1是因为出入库业务是没有绝对先后的
//  order by type_ , orderrq ,inner_xh ";
  
  	println(sql);
  	runSQL('', sql);
  
}



function cb_detail_onclick()
{
	var sheet=book.getWorkSheet(1);
	var ds=book.getDataSource('query_kchw').getDataStore();
	var hwid=""+ds.getString(0,"id");
	if( hwid=="")
	{
		alert('必须先选择一个存货。');
		return;
	}
	
	var gg= ""+sheet.cells("gg").getValueString();
	var chdd=""+sheet.cells("chdd").getValueString();
	if( chdd=="")
	{
		alert('必须先选择一个存货地点。');
		return;
	}
	var where=" hwid='"+hwid+"' and gg='"+gg+"' and chdd='"+chdd+"'";
	var rq= ""+sheet.cells("rq").getValueString();
	if( rq!="") where=appendWhere(where," rq>='"+date2yyyymmdd(sheet.cells("rq").getValue())+"'" ," and ");
	println(where);
	
	book.getDataSource('query_2').getDataStore().retrieve(where);
	
}

//sheet 表明被点击的是哪个workSheet
//cell 表明是哪个单元格被点击了
// innerRow 如果单元格是绑定到一个多行数据源的字段上，本参数表明点击的是第几行

function cellClicked(sheet, cell, innerRow)
{
	var bind=cell.getBind();
	if(bind!=null  )
	{
		if( bind.getDataSource()=='query_1')
		{
			var col=bind.getDBCol();
			if(col=='hwid' || col=='gg' || col=='chdd')
			{
				var ds=book.getDataSource('query_1').getDataStore();
				if( ds.getRowCount()==0) return;
				var hwid=ds.getString(innerRow,'hwid');
				var gg=ds.getString(innerRow,'gg');
				var chdd=ds.getString(innerRow,'chdd');
				var ds_kchw=book.getDataSource('query_kchw').getDataStore();
				
				setTreeCodeHelpEnabled(false); //先关掉代码帮助，
				ds_kchw.setValue(0,'id', hwid);
				ds_kchw.setValue(0,'classname', getStringFromSQL("select classname from kc_dm_kchw where id='"+hwid+"'"));
				setTreeCodeHelpEnabled(true); //再打开代码帮助
				
				book.getWorkSheet(1).cells('gg').setValue(gg);
				book.getWorkSheet(1).cells('chdd').setValue(chdd);
				cb_detail_onclick();
				book.setActiveSheet(1);
				
			}
		}
		
		if( bind.getDataSource()=='query_2')
		{
			var col=bind.getDBCol();
			if(col=='je_rk'  )
			{
				var ds=book.getDataSource('query_2').getDataStore();
				if( ds.getInt(innerRow,'crk')==1)
				{
					var param={crkid:ds.getString(innerRow,'id') , rksl:ds.getDouble(innerRow,'sl_rk') };
					openReportDialog('该入库记录对应的出库明细',640,400,"入库对应的出库明细",param);
				}
 
			}

			if(col=='je_ck'  )
			{
				var ds=book.getDataSource('query_2').getDataStore();
				if( ds.getInt(innerRow,'crk')==-1)
				{
					var param={crkid:ds.getString(innerRow,'id')  };
					openReportDialog('该入库记录对应的出库明细',640,400,"出库的成本明细",param);
				}
 
			}

		}
	}

}

function cb_pypk_onclick()
{
	var sheet=book.getWorkSheet(0);
	var cpm=sheet.getColumnPropertyManage();
	cpm.setColumnWidth(sheet.cells("sl_jc1").getColumnIndex(),100);
	cpm.setColumnWidth(sheet.cells("pypk").getColumnIndex(),100);

	var c1=sheet.cells("sl_rk").getColumnIndex();
	var c2=sheet.cells("je_ck").getColumnIndex();
	for(var i=c1;i<=c2;i++)
	{
		cpm.setColumnWidth(i,0);
	}

	sheet.setXOffset(100); //先设置一下，让水平卷滚条重新计算
	sheet.setXOffset(0); //再次设置，滚到最右边

}

function cb_py_onclick()
{

	var data=[];
	var ds=book.getDataSource('query_1').getDataStore();
	var n=ds.getRowCount();
	for( var i=0;i<n;i++)
	{
		if( ds.getInt(i,"pypk")<=0) continue;
		var rowData={};
		rowData.hwid= ds.getString(i,"hwid");
		rowData.hwmc= getStringFromSQL("select classname from kc_dm_kchw where id='"+ds.getString(i,"hwid")+"'" );
		rowData.jldw= ds.getString(i,"jldw");
		rowData.gg=ds.getString(i,"gg");
		rowData.chdd=ds.getString(i,"chdd");
		rowData.sl=ds.getDouble(i,"pypk");
		rowData.dj=ds.getString(i,"dj_jc");
		data[data.length]=rowData;
	}

	if ( data.length ==0 ) 
	{
		alert('没有盘盈数据（差异>0的数据）');
		return;
	}

	if(!confirm( "确信把差异>0的记录生成一笔入库单吗？")) return;

	var s= JSON.toString( data) ;

	//设置数据
	setConfig( "盘盈_"+currentUserId()  , s);
	//
	var url="flow_step.jsp?flowid="+getStringFromSQL("select id from oa_flow where code='kcrk'");

	openWindow( url);


}


function cb_pk_onclick()
{

	var data=[];
	var ds=book.getDataSource('query_1').getDataStore();
	var n=ds.getRowCount();
	for( var i=0;i<n;i++)
	{
		if( ds.getInt(i,"pypk")>=0) continue;
		var rowData={};
		rowData.hwid= ds.getString(i,"hwid");
		rowData.hwmc= getStringFromSQL("select classname from kc_dm_kchw where id='"+ds.getString(i,"hwid")+"'" );
		rowData.jldw= ds.getString(i,"jldw");
		rowData.gg=ds.getString(i,"gg");
		rowData.chdd=ds.getString(i,"chdd");
		rowData.sl=abs(ds.getDouble(i,"pypk"));
		rowData.dj=ds.getString(i,"dj_jc");
		data[data.length]=rowData;
	}

	if ( data.length ==0 ) 
	{
		alert('没有盘亏数据（差异<0的数据）');
		return;
	}

	if(!confirm( "确信把差异<0的记录生成一笔出库单吗？")) return;

	var s= JSON.toString( data) ;

	//设置数据
	setConfig( "盘亏_"+currentUserId()  , s);
	//
	var url="flow_step.jsp?flowid="+getStringFromSQL("select id from oa_flow where code='kcck'");

	openWindow( url);


}