CREATE TABLE wx_order  --微信订单
(
	id varchar(40) NOT NULL ,
	userid int NULL , -- 对应用户ＩＤ，可能无意义
	appid varchar(32) null , -- 公众账号ID
	mch_id varchar(32) null , --微信支付分配的商户号
	device_info varchar(32) null, --终端设备号(门店号或收银设备ID)
	body varchar(128) null, -- 	商品或支付单简要描述
	detail varchar(8192) null, --商品详情
	attach varchar(127) null, --附加数据 该字段主要用于商户携带订单的自定义数据
	out_trade_no varchar(32) null, --商户系统内部的订单号,32个字符内、可包含字母
	fee_type varchar(16) null, --符合ISO 4217标准的三位字母代码，默认人民币：CNY
	total_fee  numeric(20) null, --订单总金额，单位为分
	spbill_create_ip  varchar(16) null, --终端IP
	time_start varchar(14) null, --订单生成时间，格式为yyyyMMddHHmmss
	time_expire varchar(14) null, --订单交易结束时间
    goods_tag varchar(32) null, --商品标记，代金券或立减优惠功能的参数
    trade_type varchar(16) null, -- 交易类型 取值如下：JSAPI，NATIVE，APP
	product_id varchar(32) null, --商品ID	,	trade_type=NATIVE，此参数必传。此id为二维码中包含的商品ID，商户自行定义
	openid varchar(128)  NULL , --用户标识
	prepay_id varchar(64) null, -- 预支付订单号
	payrequest text null,  -- 根据上面的数据计算出的支付参数，用于放弃支付后的重新支付
	-- --------------------------------------------------以上为订单信息，以下为支付结果
	result_code varchar(16) null, --业务结果 SUCCESS/FAIL
	err_code varchar(16) null, --错误代码
	err_code_des	varchar(128) null, --错误返回的信息描述
	time_end varchar(14) null, --支付完成时间，格式为yyyyMMddHHmmss
	xml_payresult  text null, --支付返回结果的源数据 
	transaction_id varchar(32) null, --微信支付订单号
	-----------------------------------------------------以下是关闭订单的返回
	close_result_code varchar(32) null, -- 关闭订单结果 
	close_err_code_des varchar(128) null, -- 关闭订单错误提示
	close_date  date null, --关闭订单时间
	-----------------------------------------------------以下是退款相关信息
	refund_result_code varchar(32) null, --退款结果
	refund_err_code_des varchar(128) null, -- 退款错误信息
	refund_id  varchar(32) null, --退款号
	refund_date date null, --退款时间
	
	
	
	
	primary key(id)
)
