create procedure wiseoaNewWork 
( @userid int , -- 起草人ID    
    @flowid int , --  流程类型    
    @subject char(255) , -- 工作主题    
    @level int , -- 紧急程度 1加急 0 普通    
    @rq datetime ,-- 工作起草日期    
    @ret_guid varchar(40) output  ,  --  返回生成的新工作的guid
    @ret_error varchar(255)  output  -- 返回错误提示(暂时未使用，保留)
)
 as 
 begin 
        select @ret_error = '' 
        declare @rateddays int -- 定额工作日    
        declare @templateid int 
        declare @unit int 
        declare @flowname varchar(255) 
        declare @guid varchar(40) 
        -- 得到流程的一些配置信息    
        Select @templateid = template_id , @unit= unit , @flowname= name , @rateddays= needdays from oa_flow where id= @flowid 
        -- 如果日期没有提供，那么就用当前日期    
        if ( @rq is null) select @rq= getdate() 
        -- 取一个新的GUID    
        select @guid= newid() 
        
        select @ret_guid= @guid 
        -- 生成工作主体信息    
 
        INSERT    INTO      oa_mywork 
                (   userid,                     flowid,                     flowname,                     templateid, 
                    guid,                     state,                     noflow,                     querymobile, 
                    ontime,                     laststatisticsdateint,                     lasttip,                     unit, 
                    rateddays,                     needdays,                     content,                     subject, 
                    level_,                     rq              ) 
                VALUES 
                ( 
                    @userid,                     @flowid,                     @flowname,                     @templateid, 
                    @guid,                     0,0,                     '',                     0,0, 
                    '正在起草',                     @unit,                     @rateddays,                     @rateddays, 
                    '',                     @subject,                     @level,                     @rq 
                ) 
                
                -- 得到刚才生成的工作的ID    
        declare @workid int 
        
        SELECT                 @workid= id             FROM                 oa_mywork             WHERE                 guid= @guid                 -- 生成第一步受理信息    

        declare @firstStepGuid varchar(40) 
        SELECT                 @firstStepGuid= guid            FROM                 oa_flow_node             WHERE                 type_     = 1                 and flowid= @flowid 

        INSERT          INTO              oa_mywork_process 
                (  guid,                     workid,                     flowid,                     nodeguid, 
                    executorid,                     executorid_origin,                     owner_id,                     isfirst, 
                    state,                     commitdate,                     needdays,                     rateddays, 
                    ontime,                     needdayslog                 ) 
          VALUES 
                ( 
                    newid() ,                     @workid,                     @flowid,                     @firstStepGuid, 
                    @userid,                     @userid,                     @userid,                     1,0, 
                    @rq,                     @rateddays,                     @rateddays,                     0, 
                    '' 
                ) 
               
END


 
            
            