create table edu_exercise
(
	id				int   not null,    -- 不要自动编号
	no			int   null , -- 第几题
	libraryid	varchar(40)  null ,   -- 本题对应的题库的ID
	itemid		varchar(40) null,    -- 试题的ID
	itemtype   varchar(4) null, -- 题目的类型
	body  		clob null , -- 题目的主体
	difficulty 	int  null,  --难度
	candidate clob  null, -- 候选项
	itemanswer   	clob  null, -- 答案
	useranswer  clob  null, -- 考生的答案,用来评分
    answerpaper  clob  null, -- 答案纸 ，用来恢复答案到界面
	emphasis    int  null, -- 是不是重点复习的
    summary   clob  null, -- 批注
    userscore  number(6 ,2) null ,  --   考生的得分  以下的字段与 edu_exam_answerpaper是一样的，便于使用相同的评分处理
    itemscore    number(6,2)  null ,  -- 题目的分数,都是1
    rightpercent   number(6,2) null , --  正确率
    teacherid    int  null, -- 评卷老师的ID ，在此地意义，仅为与edu_exam_answerpaper保持一致
    evaldate   date  null, -- 评卷日期
    evaled    int null, -- 是否已经评分
    evaltip    clob  null ,  --  评分原因 , jsonArray , 记录多个老师的评语
    logcount  int  null , -- 学习笔记条数
primary key ( id) 
)

-- 练习的明细。没有记录exercise_id 和user_id 是因为每个练习会单独建表，而每个用户是单独的数据库，
-- 所以没有必要有这两个信息
-- 客观题自动评分与考试的评分是使用相同的方法，所以需要保持一此字段与edu_exam_answerpaper相同
-- 因为本表相当于考试中的答纸与题目的答案记录合并在一起了，相当于一道练习题就是一次考试
-- 所以存在 useranswer 和 answerpaper两个字段，前者用来评分，后者用来恢复用户答案到界面




			 