
// 每次新录入单据在表单打开后都会执行名为newOpen的函数，
//可以在这个函数里针对新录入的单据做一些数据初始化的操作，
//注意它与 flowOpen的区别，flowOpen是无论执行什么操作，只要是页面打开时都会触发，
// 而newOpen 仅在新增录入单据时触发
function newOpen() 
{
       
       //取当前操作员最后一个税务机关
       var sql="select swjg from yj_jkd where  userid="+currentUserId()+" and swjg  is not null order by billdate desc ";
       var swjg= getStringFromSQL(sql);
       $yj_jkd_ds.setValue(0,"swjg",swjg);
}


// dsname 数据源名称
//  row  哪行数据发生变化
//　col 　哪个字段的值发生变化
function DataStoreItemChanged(dsname, row, col)
{
    if( col=='swjg')  //输入税务机关后，自动取银行帐号，　因为同一个分局，　基本上银行帐号是固定的
    {
        var swjg=$yj_jkd_ds.getString(0,"swjg");
        var sql="select * from yj_jkd where swjg='"+swjg+"' and skrzh is not null order by billdate desc ";
        var tds=newDataStore("",sql);
        tds.setOnceRetrieveCount(1);
        tds.retrieve();
        var cols=['skrhm','skrzh','skrkhyx']; 
        for( var i=0;i<cols.length;i++)
        {
            if( $yj_jkd_ds.getString(0,cols[i])=='') $yj_jkd_ds.setValue(0,cols[i], tds.getString(0,cols[i]));
        }
    }
} 



function cb_print_onclick()
{
    book.getWorkSheet(2).getWorkSheetView().printWithDefaultDevice();
    
}

 



//当新增单据时，单据需要生成一个单据号，缺省情况下，系统将按单据类型(billtype)自动生成一个流水号
//有时需要按照某些规则生成单据号，则可在本事件中进行处理，按需要返回一个单据号，如果本函数返回了一个单据号，那么系统缺省的单据号将被放弃。
 // table   单据的主表的表名
//  billType :单据类型 
function newBillNo(table, billType)
{
    //系统自带的流水号，在生成后，无论单据是否保存，该号都不会再使用。因此如果需要连续的号码 
    //可以使用下面的思路：取最长的号码中最大的号码，增加1做为新的号码。 
    //不用担心单据号重号。因为在数据库级创建中 billno+billtype的唯一索引。当重号时，
    //本函数本再次调用以获取一个新的单据号直到不重复为止。
    var where= "billtype="+billType ; 
    var maxLen= getIntFromSQL("select max( len(billno)) from "+table+" where "+where); 
    //单据号长度最长的，并且最大 
    if( maxLen>0) where= appendWhere ( where , " len(billno)="+maxLen, "and");
    var sql= "select max(billno) from "+table+" where "+where;
    var maxNo=''+getStringFromSQL(sql);
    if(maxNo=='') maxNo='00000000';
    maxNo=stringInc(maxNo);
    return maxNo;

} 



 


 
 







 


 
 







 
