// Decompiled by DJ v3.7.7.81 Copyright 2004 Atanas Neshkov  Date: 2006-11-14 9:34:14
// Home Page : http://members.fortunecity.com/neshkov/dj.html  - Check often for new version!
// Decompiler options: packimports(3) 
// Source File Name:   ScrollableResultSet.java

package oracle.jdbc.driver;

import java.io.*;
import java.math.BigDecimal;
import java.sql.*;
import java.util.*;
import oracle.jdbc.dbaccess.*;
import oracle.sql.*;

// Referenced classes of package oracle.jdbc.driver:
//            BaseResultSet, OracleConnection, OracleResultSetCacheImpl, OracleResultSet, 
//            OracleResultSetMetaData, OracleStatement, UpdatableResultSet, OraclePreparedStatement, 
//            ScrollRsetStatement, OracleResultSetCache, OracleResultSetImpl

public class ScrollableResultSet extends BaseResultSet
{

    public ScrollableResultSet(ScrollRsetStatement scrollrsetstatement, OracleResultSetImpl oracleresultsetimpl, int i, int j)
        throws SQLException
    {
        m_conn = (OracleConnection)scrollrsetstatement.getConnection();
        m_rset = oracleresultsetimpl;
        m_metadata = null;
        m_scrollStmt = scrollrsetstatement;
        m_type = i;
        m_update = j;
        m_autoRefetch = scrollrsetstatement.getAutoRefetch();
        m_beginColumnIndex = needIdentifier(i, j) ? 1 : 0;
        m_columnCount = 0;
        m_wasNull = -1;
        m_cache = scrollrsetstatement.getResultSetCache();
        if(m_cache == null)
            m_cache = new OracleResultSetCacheImpl();
        else
            try
            {
                m_cache.clear();
            }
            catch(IOException ioexception)
            {
                DBError.throwSqlException(ioexception);
            }
        m_currentRow = 0;
        m_numRowsCached = 0;
        m_allRowsCached = false;
        m_lastRefetchSz = 0;
        m_refetchRowids = null;
        m_refetchStmt = null;
        m_usrFetchDirection = 1000;
    }

    public synchronized void close()
        throws SQLException
    {
        if(m_rset != null)
            m_rset.close();
        if(m_refetchStmt != null)
            m_refetchStmt.close();
        if(m_scrollStmt != null)
            m_scrollStmt.notify_close_rset();
        if(m_refetchRowids != null)
            m_refetchRowids.removeAllElements();
        m_rset = null;
        m_scrollStmt = null;
        m_refetchStmt = null;
        m_refetchRowids = null;
        m_metadata = null;
        m_conn = null;
        try
        {
            if(m_cache != null)
            {
                m_cache.clear();
                m_cache.close();
            }
        }
        catch(IOException ioexception)
        {
            DBError.throwSqlException(ioexception);
        }
        m_cache = null;
    }

    public synchronized boolean wasNull()
        throws SQLException
    {
        if(m_wasNull == -1)
            DBError.throwSqlException(24);
        return m_wasNull == 1;
    }

    public synchronized Statement getStatement()
        throws SQLException
    {
        return (Statement)m_scrollStmt;
    }

    synchronized void resetBeginColumnIndex()
    {
        m_beginColumnIndex = 0;
    }

    synchronized ResultSet getResultSet()
    {
        return m_rset;
    }

    synchronized int removeRowInCache(int i)
        throws SQLException
    {
        if(!isEmptyResultSet() && isValidRow(i))
        {
            removeCachedRowAt(i);
            m_numRowsCached--;
            if(i >= m_currentRow)
                m_currentRow--;
            return 1;
        } else
        {
            return 0;
        }
    }

    synchronized int refreshRowsInCache(int i, int j, int k)
        throws SQLException
    {
        OracleResultSet oracleresultset = null;
        int l = 0;
        l = get_refetch_size(i, j, k);
        try
        {
            if(l > 0)
            {
                if(l != m_lastRefetchSz)
                {
                    if(m_refetchStmt != null)
                        m_refetchStmt.close();
                    m_refetchStmt = prepare_refetch_statement(l);
                    m_lastRefetchSz = l;
                }
                prepare_refetch_binds(m_refetchStmt, l);
                oracleresultset = (OracleResultSet)m_refetchStmt.executeQuery();
                save_refetch_results(oracleresultset, i, l, k);
            }
        }
        finally
        {
            if(oracleresultset != null)
                oracleresultset.close();
        }
        return l;
    }

    public synchronized boolean next()
        throws SQLException
    {
        if(isEmptyResultSet())
            return false;
        if(m_currentRow < 1)
            m_currentRow = 1;
        else
            m_currentRow++;
        return isValidRow(m_currentRow);
    }

    public synchronized boolean isBeforeFirst()
        throws SQLException
    {
        return !isEmptyResultSet() && m_currentRow < 1;
    }

    public synchronized boolean isAfterLast()
        throws SQLException
    {
        return !isEmptyResultSet() && m_currentRow > 0 && !isValidRow(m_currentRow);
    }

    public synchronized boolean isFirst()
        throws SQLException
    {
        return m_currentRow == 1;
    }

    public synchronized boolean isLast()
        throws SQLException
    {
        return !isEmptyResultSet() && isValidRow(m_currentRow) && !isValidRow(m_currentRow + 1);
    }

    public synchronized void beforeFirst()
        throws SQLException
    {
        if(!isEmptyResultSet())
            m_currentRow = 0;
    }

    public synchronized void afterLast()
        throws SQLException
    {
        if(!isEmptyResultSet())
            m_currentRow = getLastRow() + 1;
    }

    public synchronized boolean first()
        throws SQLException
    {
        if(isEmptyResultSet())
        {
            return false;
        } else
        {
            m_currentRow = 1;
            return isValidRow(m_currentRow);
        }
    }

    public synchronized boolean last()
        throws SQLException
    {
        if(isEmptyResultSet())
        {
            return false;
        } else
        {
            m_currentRow = getLastRow();
            return isValidRow(m_currentRow);
        }
    }

    public synchronized int getRow()
        throws SQLException
    {
        if(isValidRow(m_currentRow))
            return m_currentRow;
        else
            return 0;
    }

    public synchronized boolean absolute(int i)
        throws SQLException
    {
        if(i == 0)
            DBError.throwSqlException(68, "absolute (0)");
        if(isEmptyResultSet())
            return false;
        if(i > 0)
            m_currentRow = i;
        else
        if(i < 0)
            m_currentRow = getLastRow() + 1 + i;
        return isValidRow(m_currentRow);
    }

    public synchronized boolean relative(int i)
        throws SQLException
    {
        if(isEmptyResultSet())
            return false;
        if(isValidRow(m_currentRow))
        {
            m_currentRow += i;
            return isValidRow(m_currentRow);
        } else
        {
            DBError.throwSqlException(82, "relative");
            return false;
        }
    }

    public synchronized boolean previous()
        throws SQLException
    {
        if(isEmptyResultSet())
            return false;
        if(isAfterLast())
            m_currentRow = getLastRow();
        else
            m_currentRow--;
        return isValidRow(m_currentRow);
    }

    public synchronized Datum getOracleObject(int i)
        throws SQLException
    {
        m_wasNull = -1;
        if(!isValidRow(m_currentRow))
            DBError.throwSqlException(11);
        if(i < 1 || i > getColumnCount())
            DBError.throwSqlException(3);
        Datum datum = getCachedDatumValueAt(m_currentRow, i + m_beginColumnIndex);
        m_wasNull = datum != null ? 0 : 1;
        return datum;
    }

    public synchronized String getString(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.stringValue();
        else
            return null;
    }

    public synchronized boolean getBoolean(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.booleanValue();
        else
            return false;
    }

    public synchronized byte getByte(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.byteValue();
        else
            return 0;
    }

    public synchronized short getShort(int i)
        throws SQLException
    {
        long l = getLong(i);
        if(l > 0x10001L || l < 0xfffffffffffefffeL)
            DBError.check_error(26, "getShort");
        return (short)(int)l;
    }

    public synchronized int getInt(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.intValue();
        else
            return 0;
    }

    public synchronized long getLong(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.longValue();
        else
            return 0L;
    }

    public synchronized float getFloat(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.floatValue();
        else
            return 0.0F;
    }

    public synchronized double getDouble(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.doubleValue();
        else
            return 0.0D;
    }

    public synchronized BigDecimal getBigDecimal(int i, int j)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.bigDecimalValue();
        else
            return null;
    }

    public synchronized byte[] getBytes(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof RAW)
                return ((RAW)datum).shareBytes();
            DBError.check_error(4, "getBytes");
        }
        return null;
    }

    public synchronized Date getDate(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.dateValue();
        else
            return null;
    }

    public synchronized Time getTime(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.timeValue();
        else
            return null;
    }

    public synchronized Timestamp getTimestamp(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.timestampValue();
        else
            return null;
    }

    public synchronized InputStream getAsciiStream(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.asciiStreamValue();
        else
            return null;
    }

    public synchronized InputStream getUnicodeStream(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            DBConversion dbconversion = m_conn.conversion;
            byte abyte0[] = datum.shareBytes();
            if(datum instanceof RAW)
                return dbconversion.ConvertStream(new ByteArrayInputStream(abyte0), 3);
            if(datum instanceof CHAR)
                return dbconversion.ConvertStream(new ByteArrayInputStream(abyte0), 1);
            DBError.check_error(4, "getUnicodeStream");
        }
        return null;
    }

    public synchronized InputStream getBinaryStream(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.binaryStreamValue();
        else
            return null;
    }

    public synchronized Object getObject(int i)
        throws SQLException
    {
        return getObject(i, m_conn.getTypeMap());
    }

    public synchronized Reader getCharacterStream(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
            return datum.characterStreamValue();
        else
            return null;
    }

    public BigDecimal getBigDecimal(int i)
        throws SQLException
    {
        return getBigDecimal(i, 0);
    }

    public synchronized Object getObject(int i, Map map)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof STRUCT)
                return ((STRUCT)datum).toJdbc(map);
            else
                return datum.toJdbc();
        } else
        {
            return null;
        }
    }

    public synchronized Ref getRef(int i)
        throws SQLException
    {
        return getREF(i);
    }

    public synchronized Blob getBlob(int i)
        throws SQLException
    {
        return getBLOB(i);
    }

    public synchronized Clob getClob(int i)
        throws SQLException
    {
        return getCLOB(i);
    }

    public synchronized Array getArray(int i)
        throws SQLException
    {
        return getARRAY(i);
    }

    public synchronized Date getDate(int i, Calendar calendar)
        throws SQLException
    {
        DATE date = getDATE(i);
        return date == null ? null : date.dateValue(calendar);
    }

    public synchronized Time getTime(int i, Calendar calendar)
        throws SQLException
    {
        DATE date = getDATE(i);
        return date == null ? null : date.timeValue(calendar);
    }

    public synchronized Timestamp getTimestamp(int i, Calendar calendar)
        throws SQLException
    {
        DATE date = getDATE(i);
        return date == null ? null : date.timestampValue(calendar);
    }

    public synchronized ResultSet getCursor(int i)
        throws SQLException
    {
        DBError.check_error(4, "getCursor");
        return null;
    }

    public synchronized ROWID getROWID(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof ROWID)
                return (ROWID)datum;
            DBError.check_error(4, "getROWID");
        }
        return null;
    }

    public synchronized NUMBER getNUMBER(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof NUMBER)
                return (NUMBER)datum;
            DBError.check_error(4, "getNUMBER");
        }
        return null;
    }

    public synchronized DATE getDATE(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof DATE)
                return (DATE)datum;
            DBError.check_error(4, "getDATE");
        }
        return null;
    }

    public synchronized ARRAY getARRAY(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof ARRAY)
                return (ARRAY)datum;
            DBError.check_error(4, "getARRAY");
        }
        return null;
    }

    public synchronized STRUCT getSTRUCT(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof STRUCT)
                return (STRUCT)datum;
            DBError.check_error(4, "getSTRUCT");
        }
        return null;
    }

    public synchronized OPAQUE getOPAQUE(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof OPAQUE)
                return (OPAQUE)datum;
            DBError.check_error(4, "getOPAQUE");
        }
        return null;
    }

    public synchronized REF getREF(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof REF)
                return (REF)datum;
            DBError.check_error(4, "getREF");
        }
        return null;
    }

    public synchronized CHAR getCHAR(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof CHAR)
                return (CHAR)datum;
            DBError.check_error(4, "getCHAR");
        }
        return null;
    }

    public synchronized RAW getRAW(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof RAW)
                return (RAW)datum;
            DBError.check_error(4, "getRAW");
        }
        return null;
    }

    public synchronized BLOB getBLOB(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof BLOB)
                return (BLOB)datum;
            DBError.check_error(4, "getBLOB");
        }
        return null;
    }

    public synchronized CLOB getCLOB(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof CLOB)
                return (CLOB)datum;
            DBError.check_error(4, "getCLOB");
        }
        return null;
    }

    public synchronized BFILE getBFILE(int i)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        if(datum != null)
        {
            if(datum instanceof BFILE)
                return (BFILE)datum;
            DBError.check_error(4, "getBFILE");
        }
        return null;
    }

    public synchronized BFILE getBfile(int i)
        throws SQLException
    {
        return getBFILE(i);
    }

    public synchronized CustomDatum getCustomDatum(int i, CustomDatumFactory customdatumfactory)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        return customdatumfactory.create(datum, 0);
    }

    public synchronized ORAData getORAData(int i, ORADataFactory oradatafactory)
        throws SQLException
    {
        Datum datum = getOracleObject(i);
        return oradatafactory.create(datum, 0);
    }

    public synchronized ResultSetMetaData getMetaData()
        throws SQLException
    {
        return new OracleResultSetMetaData(m_conn, (OracleStatement)m_scrollStmt, m_beginColumnIndex);
    }

    public synchronized int findColumn(String s)
        throws SQLException
    {
        return m_rset.findColumn(s) - m_beginColumnIndex;
    }

    public synchronized void setFetchDirection(int i)
        throws SQLException
    {
        if(i == 1000)
            m_usrFetchDirection = i;
        else
        if(i == 1001 || i == 1002)
        {
            m_usrFetchDirection = i;
            m_warning = DBError.addSqlWarning(m_warning, 87);
        } else
        {
            DBError.throwSqlException(68, "setFetchDirection");
        }
    }

    public synchronized int getFetchDirection()
        throws SQLException
    {
        return 1000;
    }

    public synchronized void setFetchSize(int i)
        throws SQLException
    {
        m_rset.setFetchSize(i);
    }

    public synchronized int getFetchSize()
        throws SQLException
    {
        return m_rset.getFetchSize();
    }

    public int getType()
        throws SQLException
    {
        return m_type;
    }

    public int getConcurrency()
        throws SQLException
    {
        return m_update;
    }

    public void refreshRow()
        throws SQLException
    {
        if(!needIdentifier(m_type, m_update))
            DBError.check_error(23, "refreshRow");
        if(isValidRow(m_currentRow))
        {
            int i = getFetchDirection();
            try
            {
                refreshRowsInCache(m_currentRow, getFetchSize(), i);
            }
            catch(SQLException sqlexception)
            {
                DBError.throwSqlException(sqlexception, 90, "Unsupported syntax for refreshRow()");
            }
        } else
        {
            DBError.throwSqlException(82, "refreshRow");
        }
    }

    public void setCurrentRowValueAt(Object obj, int i, Object obj1)
        throws SQLException
    {
        if(obj instanceof UpdatableResultSet)
            putCachedValueAt(m_currentRow, i, obj1);
        else
            DBError.throwSqlException(1);
    }

    private boolean isEmptyResultSet()
        throws SQLException
    {
        if(m_numRowsCached != 0)
            return false;
        if(m_numRowsCached == 0 && m_allRowsCached)
            return true;
        else
            return !isValidRow(1);
    }

    boolean isValidRow(int i)
        throws SQLException
    {
        if(i > 0 && i <= m_numRowsCached)
            return true;
        if(i <= 0)
            return false;
        else
            return cacheRowAt(i);
    }

    private boolean cacheRowAt(int i)
        throws SQLException
    {
        for(; m_numRowsCached < i && m_rset.next(); m_numRowsCached++)
        {
            for(int j = 0; j < getColumnCount(); j++)
            {
                byte abyte0[] = m_rset.getBytes(j + 1);
                putCachedValueAt(m_numRowsCached + 1, j + 1, abyte0);
            }

        }

        if(m_numRowsCached < i)
        {
            m_allRowsCached = true;
            return false;
        } else
        {
            return true;
        }
    }

    private int cacheAllRows()
        throws SQLException
    {
        while(m_rset.next()) 
        {
            for(int i = 0; i < getColumnCount(); i++)
                putCachedValueAt(m_numRowsCached + 1, i + 1, m_rset.getBytes(i + 1));

            m_numRowsCached++;
        }
        m_allRowsCached = true;
        return m_numRowsCached;
    }

    int getColumnCount()
        throws SQLException
    {
        if(m_columnCount == 0)
        {
            int i = m_rset.statement.defines.getNoOfArgs();
            if(m_rset.statement.defines != null && i > 0)
                m_columnCount = i;
            else
                m_columnCount = getInternalMetadata().getColumnCount();
        }
        return m_columnCount;
    }

    private ResultSetMetaData getInternalMetadata()
        throws SQLException
    {
        if(m_metadata == null)
            m_metadata = m_rset.getMetaData();
        return m_metadata;
    }

    private int getLastRow()
        throws SQLException
    {
        if(!m_allRowsCached)
            cacheAllRows();
        return m_numRowsCached;
    }

    private int get_refetch_size(int i, int j, int k)
        throws SQLException
    {
        byte byte0 = ((byte)(k != 1001 ? 1 : -1));
        int l = 0;
        if(m_refetchRowids == null)
            m_refetchRowids = new Vector(10);
        else
            m_refetchRowids.removeAllElements();
        for(; l < j && isValidRow(i + l * byte0); l++)
            m_refetchRowids.addElement(getCachedDatumValueAt(i + l * byte0, 1));

        return l;
    }

    private OraclePreparedStatement prepare_refetch_statement(int i)
        throws SQLException
    {
        if(i < 1)
            DBError.throwSqlException(68);
        StringBuffer stringbuffer = new StringBuffer();
        String s = m_scrollStmt.getRevisedSql().toUpperCase();
        String s1 = s;
        int j = 0;
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        int l = 0;
        boolean flag3 = false;
        while(j != -1) 
        {
            int i1 = s1.indexOf("'", l);
            j = s1.indexOf("ORDER", l);
            do
            {
                if(i1 == -1 || j == -1 || i1 >= j)
                    break;
                l = trimQuote(s1, i1 + 1);
                if(l <= j)
                    break;
                j = s1.indexOf("ORDER", l);
                i1 = s1.indexOf("'", l);
            } while(true);
            if(j <= 0)
                continue;
            int j1 = trimWhiteSpace(s1, j + 5);
            if(j1 > j + 5)
            {
                l = j1;
                int k = s1.lastIndexOf("BY", l);
                if(k <= 0 || k != l)
                    continue;
                flag1 = true;
                s1 = s1.substring(j, s1.length());
                stringbuffer.append(s.substring(0, j));
                break;
            }
            l = j + 1;
        }
        if(s.indexOf("WHERE") == -1)
        {
            if(!flag1)
                stringbuffer.append(m_scrollStmt.getRevisedSql());
            stringbuffer.append(" WHERE ( ROWID = ?");
        } else
        {
            if(!flag1)
                stringbuffer.append(m_scrollStmt.getRevisedSql());
            stringbuffer.append(" AND ( rowid = ?");
        }
        for(int k1 = 0; k1 < i - 1; k1++)
            stringbuffer.append(" OR rowid = ?");

        stringbuffer.append(" ) ");
        if(flag1)
            stringbuffer.append(s1);
        return (OraclePreparedStatement)m_conn.prepareStatement(stringbuffer.toString());
    }

    private int trimQuote(String s, int i)
    {
        int j = i;
        for(int k = 0; (k = s.indexOf("'", j)) != -1;)
            if(s.charAt(k) == '\'')
                j = k + 1;

        return j;
    }

    private int trimWhiteSpace(String s, int i)
    {
        int j = i;
        for(int k = s.length(); j < k; j++)
        {
            char c = s.charAt(j);
            if(c != ' ' && c != '\t' && c != '\n')
                return j;
        }

        return j;
    }

    private void prepare_refetch_binds(OraclePreparedStatement oraclepreparedstatement, int i)
        throws SQLException
    {
        int j = 0;
        DBDataSet dbdataset = m_scrollStmt.getBinds();
        if(dbdataset != null)
        {
            j = dbdataset.getNoOfArgs();
            for(int k = 0; k < j; k++)
                oraclepreparedstatement.setItem(k, dbdataset.getType(k), dbdataset.getBytesItem(k, 0));

        }
        for(int l = 0; l < i; l++)
            oraclepreparedstatement.setROWID(j + l + 1, (ROWID)m_refetchRowids.elementAt(l));

    }

    private void save_refetch_results(OracleResultSet oracleresultset, int i, int j, int k)
        throws SQLException
    {
        byte byte0 = ((byte)(k != 1001 ? 1 : -1));
        while(oracleresultset.next()) 
        {
            ROWID rowid = oracleresultset.getROWID(1);
            boolean flag = false;
            int l;
            for(l = i; !flag && l < i + j * byte0;)
                if(((ROWID)getCachedDatumValueAt(l, 1)).stringValue().equals(rowid.stringValue()))
                    flag = true;
                else
                    l += byte0;

            if(flag)
            {
                for(int i1 = 0; i1 < getColumnCount(); i1++)
                    putCachedValueAt(l, i1 + 1, oracleresultset.getOracleObject(i1 + 1));

            }
        }
    }

    private Object getCachedValueAt(int i, int j)
        throws SQLException
    {
        try
        {
            return m_cache.get(i, j);
        }
        catch(IOException ioexception)
        {
            DBError.throwSqlException(ioexception);
        }
        return null;
    }

    private Datum getCachedDatumValueAt(int i, int j)
        throws SQLException
    {
        Object obj = null;
        try
        {
            obj = m_cache.get(i, j);
        }
        catch(IOException ioexception)
        {
            DBError.throwSqlException(ioexception);
        }
        Datum datum = null;
        if(obj != null)
            if(obj instanceof Datum)
                datum = (Datum)obj;
            else
            if(((byte[])obj).length > 0)
            {
                int k = getInternalMetadata().getColumnType(j);
                int l = ((OracleResultSetMetaData)getInternalMetadata()).getColumnByteSize(j);
                int i1 = m_scrollStmt.getMaxFieldSize();
                if(i1 > 0 && i1 < l)
                    l = i1;
                String s = null;
                if(k == 2006 || k == 2002 || k == 2008 || k == 2007 || k == 2003)
                    s = getInternalMetadata().getColumnTypeName(j);
                int j1 = SQLUtil.get_internal_type(k);
                short word0 = m_rset.statement.getDBTypeForm(j - 1);
                if(word0 == 2 && (j1 == 96 || j1 == 1 || j1 == 8 || j1 == 999 || j1 == 112))
                    datum = SQLUtil.makeNDatum(m_conn, (byte[])obj, j1, s, word0, l);
                else
                    datum = SQLUtil.makeDatum(m_conn, (byte[])obj, j1, s, l);
                try
                {
                    m_cache.put(i, j, datum);
                }
                catch(IOException ioexception2)
                {
                    DBError.throwSqlException(ioexception2);
                }
            } else
            {
                try
                {
                    m_cache.put(i, j, null);
                }
                catch(IOException ioexception1)
                {
                    DBError.throwSqlException(ioexception1);
                }
            }
        return datum;
    }

    private void putCachedValueAt(int i, int j, Object obj)
        throws SQLException
    {
        try
        {
            m_cache.put(i, j, obj);
        }
        catch(IOException ioexception)
        {
            DBError.throwSqlException(ioexception);
        }
    }

    private void removeCachedRowAt(int i)
        throws SQLException
    {
        try
        {
            m_cache.remove(i);
        }
        catch(IOException ioexception)
        {
            DBError.throwSqlException(ioexception);
        }
    }

    public static boolean needIdentifier(int i, int j)
    {
        return (i != 1003 || j != 1007) && (i != 1004 || j != 1007);
    }

    public static boolean needCache(int i, int j)
    {
        return i != 1003 && (i != 1004 || j != 1007);
    }

    public static boolean supportRefreshRow(int i, int j)
    {
        return i != 1003 && (i != 1004 || j != 1007);
    }

    public int getFirstUserColumnIndex()
    {
        return m_beginColumnIndex;
    }

    public OracleConnection m_conn;
    OracleResultSetImpl m_rset;
    ScrollRsetStatement m_scrollStmt;
    ResultSetMetaData m_metadata;
    private int m_type;
    private int m_update;
    private int m_beginColumnIndex;
    private int m_columnCount;
    private int m_wasNull;
    OracleResultSetCache m_cache;
    int m_currentRow;
    private int m_numRowsCached;
    private boolean m_allRowsCached;
    private int m_lastRefetchSz;
    private Vector m_refetchRowids;
    private OraclePreparedStatement m_refetchStmt;
    private int m_usrFetchDirection;
}