/*
 * Decompiled with CFR 0.152.
 */
package excel.ui.chktree;

import javax.swing.tree.DefaultMutableTreeNode;

public class CheckBoxTreeNode
extends DefaultMutableTreeNode {
    protected boolean isSelected;

    public CheckBoxTreeNode() {
        this(null);
    }

    public CheckBoxTreeNode(Object userObject) {
        this(userObject, true, false);
    }

    public CheckBoxTreeNode(Object userObject, boolean allowsChildren) {
        this(userObject, allowsChildren, false);
    }

    public CheckBoxTreeNode(Object userObject, boolean allowsChildren, boolean isSelected) {
        super(userObject, allowsChildren);
        this.isSelected = isSelected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean _isSelected) {
        this.setSelected(_isSelected, true);
    }

    public void setSelected(boolean _isSelected, boolean recursion) {
        this.isSelected = _isSelected;
        if (!recursion) {
            return;
        }
        if (_isSelected) {
            CheckBoxTreeNode pNode;
            if (this.children != null) {
                for (Object obj : this.children) {
                    CheckBoxTreeNode node = (CheckBoxTreeNode)obj;
                    if (_isSelected == node.isSelected()) continue;
                    node.setSelected(_isSelected);
                }
            }
            if ((pNode = (CheckBoxTreeNode)this.parent) != null) {
                int index = 0;
                while (index < pNode.children.size()) {
                    CheckBoxTreeNode pChildNode = (CheckBoxTreeNode)pNode.children.get(index);
                    if (!pChildNode.isSelected()) break;
                    ++index;
                }
                if (index == pNode.children.size() && pNode.isSelected() != _isSelected) {
                    pNode.setSelected(_isSelected);
                }
            }
        } else {
            CheckBoxTreeNode pNode;
            if (this.children != null) {
                int index = 0;
                while (index < this.children.size()) {
                    CheckBoxTreeNode childNode = (CheckBoxTreeNode)this.children.get(index);
                    if (!childNode.isSelected()) break;
                    ++index;
                }
                if (index == this.children.size()) {
                    int i = 0;
                    while (i < this.children.size()) {
                        CheckBoxTreeNode node = (CheckBoxTreeNode)this.children.get(i);
                        if (node.isSelected() != _isSelected) {
                            node.setSelected(_isSelected);
                        }
                        ++i;
                    }
                }
            }
            if ((pNode = (CheckBoxTreeNode)this.parent) != null && pNode.isSelected() != _isSelected) {
                pNode.setSelected(_isSelected);
            }
        }
    }
}

