/*
 * Decompiled with CFR 0.152.
 */
package excel.jep.function.VBScript;

import excel.jep.ParseException;
import excel.jep.function.PostfixMathCommand;
import java.math.BigDecimal;
import java.util.Stack;
import java.util.Vector;

public class Multiply
extends PostfixMathCommand {
    public Multiply() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object product = stack.pop();
        int i = 1;
        while (i < this.curNumberOfParameters) {
            Object param = stack.pop();
            product = this.mul(product, param);
            ++i;
        }
        stack.push(product);
    }

    public Object mul(Object param1, Object param2) throws ParseException {
        if (param1 == null || param2 == null) {
            return null;
        }
        if (param1 instanceof Vector || param2 instanceof Vector) {
            return this.TwoVectorMultiply(param1, param2);
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            return this.mul((Number)param1, (Number)param2);
        }
        return null;
    }

    public Object mul(Number d1, Number d2) {
        if (d1 instanceof BigDecimal || d2 instanceof BigDecimal || d1 instanceof Double || d2 instanceof Double || d1 instanceof Float || d2 instanceof Float) {
            BigDecimal b1 = d1 instanceof BigDecimal ? (BigDecimal)d1 : new BigDecimal(d1.doubleValue());
            BigDecimal b2 = d2 instanceof BigDecimal ? (BigDecimal)d2 : new BigDecimal(d2.doubleValue());
            return b1.multiply(b2);
        }
        Long l1 = d1 instanceof Long ? (Long)d1 : new Long(d1.longValue());
        Long l2 = d2 instanceof Long ? (Long)d2 : new Long(d2.longValue());
        return new Long(l1 * l2);
    }

    public Object TwoVectorMultiply(Object p1, Object p2) throws ParseException {
        int i;
        Vector<Object> v1 = new Vector<Object>();
        if (p1 instanceof Vector) {
            v1.addAll((Vector)p1);
        } else {
            v1.add(p1);
        }
        Vector<Object> v2 = new Vector<Object>();
        if (p2 instanceof Vector) {
            v2.addAll((Vector)p2);
        } else {
            v2.add(p2);
        }
        int delta = v1.size() - v2.size();
        if (delta > 0) {
            Object lastP2 = null;
            if (v2.size() > 0) {
                lastP2 = v2.get(v2.size() - 1);
            }
            i = 0;
            while (i < delta) {
                v2.add(lastP2);
                ++i;
            }
        }
        if (delta < 0) {
            Object lastP1 = null;
            if (v1.size() > 0) {
                lastP1 = v1.get(v1.size() - 1);
            }
            i = 0;
            while (i < Math.abs(delta)) {
                v1.add(lastP1);
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < v1.size()) {
            v1.set(i2, this.mul(v1.get(i2), v2.get(i2)));
            ++i2;
        }
        v2.clear();
        v2 = null;
        return v1;
    }
}

