/*
 * Decompiled with CFR 0.152.
 */
package excel.jep.function.VBScript;

import excel.jep.ParseException;
import excel.jep.function.PostfixMathCommand;
import java.math.BigDecimal;
import java.util.Stack;
import java.util.Vector;

public class IsNaN
extends PostfixMathCommand {
    public IsNaN() {
        this.numberOfParameters = 1;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.isNaN(param));
    }

    public Object isNaN(Object param) throws ParseException {
        if (param == null) {
            return Boolean.TRUE;
        }
        if (param instanceof Number) {
            return Boolean.FALSE;
        }
        if (param instanceof Vector) {
            return this.vectorIsNaN(param);
        }
        try {
            String s = param.toString();
            s = s.trim().replaceAll(",", "");
            BigDecimal b = new BigDecimal(s);
            return Boolean.FALSE;
        }
        catch (NumberFormatException e) {
            return Boolean.TRUE;
        }
    }

    public Object vectorIsNaN(Object param) throws ParseException {
        Vector<Object> ret = new Vector<Object>();
        Vector v1 = (Vector)param;
        int cc = v1.size();
        int i = 0;
        while (i < cc) {
            ret.add(this.isNaN(v1.get(i)));
            ++i;
        }
        return ret;
    }
}

