/*
 * Decompiled with CFR 0.152.
 */
package excel.jep.function.VBScript;

import excel.core.DataSourceConfig;
import excel.core.WorkBook;
import excel.jep.ParseException;
import excel.jep.function.PostfixMathCommand;
import java.util.Stack;
import java.util.Vector;
import jun.db.core.DataStore;

public class FindValueFromDS
extends PostfixMathCommand {
    WorkBook book;
    String dsname;
    String dbcol;

    public FindValueFromDS(WorkBook book, String ds, String col) {
        this.book = book;
        this.dsname = ds;
        this.dbcol = col;
        this.numberOfParameters = 2;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object p2 = inStack.pop();
        Object p1 = inStack.pop();
        inStack.push(this.findValueFromDS(p1, p2));
    }

    public Object findValueFromDS(Object p1, Object p2) {
        if (this.book == null) {
            return null;
        }
        if (p1 == null || p2 == null) {
            return null;
        }
        if (p2 instanceof Vector) {
            return this.vectorFindValueFromDS(p1, p2);
        }
        String findCol = p1.toString();
        DataSourceConfig dsc = this.book.getDataSource(this.dsname);
        if (dsc == null) {
            return null;
        }
        DataStore ds = dsc.getDataStore();
        int dbrow = ds.fastFind(findCol, p2);
        if (dbrow < 0) {
            return null;
        }
        Object v = ds.getValue(dbrow, this.dbcol);
        return v;
    }

    public Object vectorFindValueFromDS(Object p1, Object p2) {
        Vector v1 = (Vector)p2;
        int i = 0;
        while (i < v1.size()) {
            v1.set(i, this.findValueFromDS(p1, v1.get(i)));
            ++i;
        }
        return v1;
    }
}

