/*
 * Decompiled with CFR 0.152.
 */
package excel.event.impl;

import excel.brick.Chart;
import excel.core.Cell;
import excel.core.WorkSheet;
import excel.core.WorkSheetView;
import excel.event.WorkBookEventManage;
import excel.event.WorkBookListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;

public class WorkSheetEventManage_
implements WorkBookEventManage {
    private ArrayList m_ListenerList = new ArrayList();

    public void addListener(WorkBookListener listener) {
        this.addListener(listener, 1, "");
    }

    public void addListener(WorkBookListener listener, int order, String name) {
        listener.setOrder(order);
        listener.setName(name);
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            WorkBookListener WSL = (WorkBookListener)this.m_ListenerList.get(i);
            if (listener.getOrder() < WSL.getOrder()) {
                this.m_ListenerList.add(i, listener);
                return;
            }
            ++i;
        }
        this.m_ListenerList.add(listener);
    }

    public void removeListener(String name) {
        int n = this.m_ListenerList.size();
        boolean rc = false;
        int i = n - 1;
        while (i >= 0) {
            WorkBookListener pDSL = (WorkBookListener)this.m_ListenerList.get(i);
            if (pDSL.getName().equals(name)) {
                this.m_ListenerList.remove(i);
            }
            --i;
        }
    }

    public void removeListener(WorkBookListener listener) {
        if (this.m_ListenerList.contains(listener)) {
            this.m_ListenerList.remove(listener);
        }
    }

    public void fireNameChanged(WorkSheet sheet, String oldName, String newName) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.NameChanged(sheet, oldName, newName);
            ++mi;
        }
    }

    public void fireCellValueChanged(WorkSheet sheet, Cell cell, Object oldValue, Object newValue, int innerRow) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.CellValueChanged(sheet, cell, oldValue, newValue, innerRow);
            ++mi;
        }
    }

    public void fireCellValueChangedByEdit(WorkSheet sheet, Cell cell, Object newValue, int innerRow) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.CellValueChangedByEdit(sheet, cell, newValue, innerRow);
            ++mi;
        }
    }

    public boolean fireCellValueChangeAccept(WorkSheet sheet, Cell cell, Object oldValue, Object newValue) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            boolean accept = listener.CellValueChangeAccept(sheet, cell, oldValue, newValue);
            if (!accept) {
                return false;
            }
            ++mi;
        }
        return true;
    }

    public void fireCellPropertyChanged(WorkSheet sheet, Cell cell, String propertyName, Object oldPropertyValue, Object newPropertyValue) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.CellPropertyChanged(sheet, cell, propertyName, oldPropertyValue, newPropertyValue);
            ++mi;
        }
    }

    public void fireCellNeedRecalculate(WorkSheet sheet, Cell cell) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.CellNeedRecalculate(sheet, cell);
            ++mi;
        }
    }

    public void fireError(String errorInfo) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.Error(errorInfo);
            ++mi;
        }
    }

    public void fireAfterNewWorkSheet(WorkSheet sheet) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.AfterNewWorkSheet(sheet);
            ++mi;
        }
    }

    public boolean fireWorkSheetDeletePermit(WorkSheet sheet) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            boolean permit = listener.WorkSheetDeletePermit(sheet);
            if (!permit) {
                return false;
            }
            ++mi;
        }
        return true;
    }

    public void fireCellFocusGained(WorkSheet sheet, int row, int col) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.CellFocusGained(sheet, row, col);
            ++mi;
        }
    }

    public void fireCellFocusLost(WorkSheet sheet, int row, int col) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.CellFocusLost(sheet, row, col);
            ++mi;
        }
    }

    public void fireVirtualButtonClicked(WorkSheet sheet, Cell cell, String name) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.VirtualButtonClicked(sheet, cell, name);
            ++mi;
        }
    }

    public void fireLoadPrintConfig(WorkSheet sheet) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.LoadPrintConfig(sheet);
            ++mi;
        }
    }

    public void FireSavePrintConfig(WorkSheet sheet) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.SavePrintConfig(sheet);
            ++mi;
        }
    }

    public void fireBeginEdit(WorkSheet sheet, int row, int col, int dbRow) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.beginEdit(sheet, row, col, dbRow);
            ++mi;
        }
    }

    public void fireEndEdit(WorkSheet sheet, int row, int col, int dbRow, boolean enterKeyPressed, boolean isShiftDown, boolean isControlDown) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.endEdit(sheet, row, col, dbRow, enterKeyPressed, isShiftDown, isControlDown);
            ++mi;
        }
    }

    public void fireKeyPressed(WorkSheet sheet, KeyEvent e, int editingRow, int editingCol, int dbRow) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.keyPressed(sheet, e, editingRow, editingCol, dbRow);
            ++mi;
        }
    }

    public void fireKeyReleased(WorkSheet sheet, KeyEvent e, int editingRow, int editingCol, int dbRow) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.keyReleased(sheet, e, editingRow, editingCol, dbRow);
            ++mi;
        }
    }

    public void fireAfterPrintWorkSheet(WorkSheet sheet) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.afterPrintWorkSheet(sheet);
            ++mi;
        }
    }

    public void fireCellClicked(WorkSheet sheet, Cell cell, int innerRow) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.CellClicked(sheet, cell, innerRow);
            ++mi;
        }
    }

    public void fireCellDblClicked(WorkSheet sheet, Cell cell, int innerRow) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.CellDblClicked(sheet, cell, innerRow);
            ++mi;
        }
    }

    public void fireCellRightClicked(WorkSheet sheet, Cell cell, int innerRow) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.CellRightClicked(sheet, cell, innerRow);
            ++mi;
        }
    }

    public void fireChartDataDecorate(WorkSheet sheet, Chart chart, ArrayList data) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.chartDataDecorate(sheet, chart, data);
            ++mi;
        }
    }

    public Map fireGetDynamicDDLB(String ddlbConfig, int innerRow) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            Map ret = listener.buildDynamicDDLB(ddlbConfig, innerRow);
            if (ret != null) {
                return ret;
            }
            ++mi;
        }
        return null;
    }

    public void fireEditFocusChanged(WorkSheet sheet, int lastRow, int lastCol, int newRow, int newCol) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.editFocusChanged(sheet, lastRow, lastCol, newRow, newCol);
            ++mi;
        }
    }

    public void fireRefreshEditStyleOfCell(WorkSheet sheet, Cell cell, int innerRow) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.refreshEditStyleOfCell(sheet, cell, innerRow);
            ++mi;
        }
    }

    public void fireSheetActiveStateChanged(WorkSheet activeSheet, WorkSheet deActiveSheet) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.sheetActiveStateChanged(activeSheet, deActiveSheet);
            ++mi;
        }
    }

    public void fireOnMouseMove(WorkSheetView pView, Cell cell, MouseEvent evt) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.onMouseMove(pView, cell, evt);
            ++mi;
        }
    }

    public void fireOnContextMenuClicked(WorkSheet sheet, Cell cell, int innerRow, String menuName) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.onContextMenuClicked(sheet, cell, innerRow, menuName);
            ++mi;
        }
    }

    public Object afterEditFocusLostAndBeforeWriteBackToCell(WorkSheet sheet, Cell cell, Object value, int innerRow) {
        Object ret = value;
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            ret = listener.afterEditFocusLostAndBeforeWriteBackToCell(sheet, cell, value, innerRow);
            ++mi;
        }
        return ret;
    }

    public boolean fireIsCellEditable(WorkSheet sheet, Cell cell, int innerRow) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            boolean editable = listener.isCellEditable(sheet, cell, innerRow);
            if (!editable) {
                return false;
            }
            ++mi;
        }
        return true;
    }

    public void fireCurrentBindRowChanged(String dsname, int row) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.currentBindRowChanged(dsname, row);
            ++mi;
        }
    }

    public String fireBuildToolTip(WorkSheet sheet, Cell cell, int innerRow) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            String t = listener.buildToolTip(sheet, cell, innerRow);
            if (t != null) {
                return t;
            }
            ++mi;
        }
        return null;
    }

    public void firePopupedWorkSheetOnOK(WorkSheet sheet) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.popupedWorkSheetOnOK(sheet);
            ++mi;
        }
    }

    public void firePopupedWorkSheetOnCancel(WorkSheet sheet) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.popupedWorkSheetOnCancel(sheet);
            ++mi;
        }
    }

    public void fireOnDragDrop(String type, String data, WorkSheet sheet, Cell cell) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.onDragDrop(type, data, sheet, cell);
            ++mi;
        }
    }

    public void fireOnTreeSelectionChanged(String treeName, String group, String text, String data) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.onTreeSelectionChanged(treeName, group, text, data);
            ++mi;
        }
    }

    public void fireOnScroll(WorkSheet sheet, int dir) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            listener.onScroll(sheet, dir);
            ++mi;
        }
    }

    public boolean fireIsBalloonTipEditPermit(String dsname, String dbcol, int innerRow) {
        int mi = 0;
        while (mi < this.m_ListenerList.size()) {
            WorkBookListener listener = (WorkBookListener)this.m_ListenerList.get(mi);
            if (!listener.isBalloonTipEditPermit(dsname, dbcol, innerRow)) {
                return false;
            }
            ++mi;
        }
        return true;
    }
}

