/*
 * Decompiled with CFR 0.152.
 */
package excel.edit;

import excel.core.Cell;
import excel.core.EditStyle;
import excel.core.Property;
import excel.core.impl.Cell_;
import excel.edit.BasicEdit;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class CheckBoxEdit
extends BasicEdit {
    boolean checked;
    String tipText;
    EditStyle ES;

    public CheckBoxEdit(EditStyle es) {
        this.ES = es;
    }

    public void buildEditText(String value) {
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        this.checked = cell.isCheckOn(this.currentDBRow);
        this.setEditable(false);
        this.tipText = this.ES.getCheckBoxTipText();
        this.setText("aa");
    }

    public Object getWriteBackValue() {
        Object v = null;
        if (this.checked) {
            v = this.ES.getCheckOnValue();
        }
        if (!this.checked) {
            v = this.ES.getCheckOffValue();
        }
        v = this.Sheet.getWorkBook().getEM().afterEditFocusLostAndBeforeWriteBackToCell(this.Sheet, this.Sheet.cells(this.Row, this.Col), v, this.currentDBRow);
        return v;
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 32: {
                this.checked = !this.checked;
                this.repaint();
                break;
            }
            case 67: {
                if (e.isControlDown()) {
                    this.copyCell();
                }
            }
            default: {
                super.keyPressed(e);
            }
        }
    }

    public void copyCell() {
        Object v = null;
        if (this.checked) {
            v = this.ES.getCheckOnValue();
        }
        if (!this.checked) {
            v = this.ES.getCheckOffValue();
        }
        StringSelection contents = new StringSelection(v == null ? "" : v.toString());
        Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
        sysc.setContents(contents, this.Sheet);
    }

    public void paint(Graphics g) {
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        Rectangle rc = this.getBounds();
        int w = rc.width;
        int h = rc.height;
        rc.x = cell.getProperty().get("padding-left", 1) - 1;
        rc.y = cell.getProperty().get("padding-top", 1);
        rc.width -= 1 + rc.x + cell.getProperty().get("padding-right", 1);
        rc.height -= 1 + rc.y + cell.getProperty().get("padding-bottom", 1);
        Font font = this.getFont();
        Property prop = cell.getProperty();
        int background_mode = prop.get("background-mode", 1);
        Color background_color = prop.get("background-color", Color.WHITE);
        if (background_mode == 0) {
            background_color = this.Sheet.getPaperColor();
        }
        if (this.borderTimer != null) {
            background_color = this.getBackground();
        }
        g.setColor(background_color);
        g.fillRect(0, 0, w, h);
        Color font_color = prop.get("font-color", Color.BLACK);
        String font_name = prop.get("font-name", "\u5b8b\u4f53");
        int font_size = prop.get("font-size", 12);
        boolean font_bold = prop.get("font-bold", false);
        boolean font_italic = prop.get("font-italic", false);
        boolean font_underline = prop.get("font-underline", false);
        int align_h = prop.get("align-h", 0);
        int align_v = prop.get("align-v", 2);
        Tools.DrawCheckBoxOrRadioButtonString(this, (Graphics2D)g, rc, this.tipText, background_mode, background_color, font_color, font_name, font_size, font_bold, font_italic, font_underline, align_h, align_v, this.checked, true, true);
    }

    public void mouseClicked(MouseEvent e) {
        this.checked = !this.checked;
        Object value = this.getWriteBackValue();
        Cell cell = this.Sheet.Cells(this.Row, this.Col);
        cell.setValue(value, this.currentDBRow);
        this.requestFocusInWindow();
        this.repaint();
        this.Sheet.getWorkBook().getEM().fireCellValueChangedByEdit(this.Sheet, cell, value, this.currentDBRow);
        super.mouseClicked(e);
    }

    public void adjustEditRect() {
    }
}

