/*
 * Decompiled with CFR 0.152.
 */
package excel.dragdrop;

import excel.core.Cell;
import excel.core.WorkSheet;
import excel.core.impl.WorkSheetView_;
import excel.dragdrop.TreeData;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;

public class DragAndDropDropTargetListener
implements DropTargetListener {
    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
        DropTarget dt = (DropTarget)e.getSource();
        WorkSheetView_ View = (WorkSheetView_)dt.getComponent();
        int row = View.GetRowAtPoint(false, e.getLocation().y);
        int col = View.GetColAtPoint(false, e.getLocation().x, row);
        WorkSheet sheet = View.getWorkSheet();
        Cell cell = sheet.cells(row, col);
        if (cell != null) {
            sheet.setSelection(cell);
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        TreeData data = null;
        try {
            Object obj = t.getTransferData(DataFlavor.stringFlavor);
            if (!(obj instanceof TreeData)) {
                return;
            }
            data = (TreeData)obj;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
        }
        DropTarget dt = (DropTarget)e.getSource();
        WorkSheetView_ View = (WorkSheetView_)dt.getComponent();
        int row = View.GetRowAtPoint(false, e.getLocation().y);
        int col = View.GetColAtPoint(false, e.getLocation().x, row);
        WorkSheet sheet = View.getWorkSheet();
        Cell cell = sheet.cells(row, col);
        if (cell != null && cell.isMerged()) {
            cell = cell.getLeftTopCorner();
        }
        sheet.getWorkBook().getEM().fireOnDragDrop(data.type, data.data, sheet, cell);
    }
}

