/*
 * Decompiled with CFR 0.152.
 */
package excel.core.mouseaction;

import excel.core.ColumnPropertyManage;
import excel.core.RowPropertyManage;
import excel.core.impl.Range_;
import excel.core.impl.WorkSheetView_;
import excel.core.mouseaction.DrawTool;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class ColumnHeadTool
extends DrawTool {
    int m_col;
    int m_DownCol;
    Point m_LastDrawPos = new Point();
    Rectangle m_headrect = new Rectangle();
    String m_lastInfo = "";

    public ColumnHeadTool() {
        super(4);
        this.m_mousestate = 8;
    }

    public void OnLButtonDown(WorkSheetView_ pView, MouseEvent e) {
        super.OnLButtonDown(pView, e);
        Point point = e.getPoint();
        this.m_mousestate = 9;
        Rectangle rect = new Rectangle();
        Rectangle rectLT = new Rectangle();
        Rectangle rectLB = new Rectangle();
        Rectangle rectRT = new Rectangle();
        Rectangle rectRB = new Rectangle();
        Rectangle rectCenter = new Rectangle();
        Rectangle client = pView.getBounds();
        ColumnPropertyManage CPM = pView.getWorkSheet().getColumnPropertyManage();
        RowPropertyManage RPM = pView.getWorkSheet().getRowPropertyManage();
        int fixedRowHeight = Math.max(20, RPM.getFixedRowHeight());
        this.m_DownCol = this.m_col = pView.GetColumnHeadRect(point, rect);
        this.m_LastDrawPos.x = rect.x;
        this.m_LastDrawPos.y = rect.y + rect.height;
        this.m_headrect = (Rectangle)rect.clone();
        rectLT.setBounds(rect.x, rect.y, 3, rect.height / 4);
        rectLB.setBounds(rect.x, rect.y + rect.height / 4, 3, rect.height * 3 / 4 + fixedRowHeight);
        rectRT.setBounds(rect.x + rect.width - 3, rect.y, 3, rect.height / 4);
        rectRB.setBounds(rect.x + rect.width - 3, rect.y + rect.height / 4, 3, rect.height * 3 / 4 + fixedRowHeight);
        rectCenter.setBounds(rect.x + 3, rect.y, rect.width - 6, rect.height);
        if (this.m_col > -1) {
            if (rectLT.contains(point)) {
                pView.setCursor(ColumnHeadTool.GetCursor("LT.gif", pView));
                this.m_mousestate = 0;
            }
            if (rectLB.contains(point)) {
                pView.setCursor(ColumnHeadTool.GetCursor("LB.gif", pView));
                this.m_mousestate = 1;
            }
            if (rectRT.contains(point)) {
                pView.setCursor(ColumnHeadTool.GetCursor("RT.gif", pView));
                this.m_mousestate = 2;
            }
            if (rectRB.contains(point)) {
                pView.setCursor(ColumnHeadTool.GetCursor("RB.gif", pView));
                this.m_mousestate = 3;
            }
            if (rectCenter.contains(point)) {
                pView.setCursor(ColumnHeadTool.GetCursor("down.gif", pView));
                this.m_mousestate = 4;
                int col = pView.GetColAtPoint(false, e.getX());
                int rc = RPM.getRowCount();
                pView.getWorkSheet().setSelection(new Range_(0, col, rc - 1, col));
            }
        }
        if (this.m_mousestate == 0 || this.m_mousestate == 1 || this.m_mousestate == 2 || this.m_mousestate == 3) {
            pView.DrawXorLine(point.x, client.y, point.x, client.y + client.height);
        }
    }

    public void OnLButtonDblClk(WorkSheetView_ pView, MouseEvent e) {
    }

    public void OnLButtonUp(WorkSheetView_ pView, MouseEvent e) {
        super.OnLButtonUp(pView, e);
        Point point = e.getPoint();
        Rectangle rect = new Rectangle();
        ColumnPropertyManage CPM = pView.getWorkSheet().getColumnPropertyManage();
        RowPropertyManage RPM = pView.getWorkSheet().getRowPropertyManage();
        int areaCount = CPM.getColumnCount();
        Rectangle client = pView.getBounds();
        if (this.m_col > -1) {
            switch (this.m_mousestate) {
                case 0: 
                case 2: {
                    int col2;
                    int col1;
                    if (this.m_mousestate == 0) {
                        col1 = this.m_col - 1;
                        col2 = this.m_col;
                    } else {
                        col1 = this.m_col;
                        col2 = this.m_col;
                        while (++col2 < areaCount - 1 && CPM.getColumnWidth(col2) <= 0) {
                        }
                    }
                    pView.DrawXorLine(point.x, client.y, point.x, client.y + client.height);
                    if (col2 >= areaCount) break;
                    int delta = Math.max(0, point.x - (RPM.getRowHeadWidth() + CPM.getColumnX(col1) - (col1 >= CPM.getFixedColumnCount() ? pView.getWorkSheet().getXOffset() : 0)));
                    pView.getWorkSheet().setWidthBetweenTwoColumn(col1, col2, delta);
                    break;
                }
                case 1: 
                case 3: {
                    int col1 = this.m_mousestate == 1 ? this.m_col - 1 : this.m_col;
                    pView.DrawXorLine(point.x, client.y, point.x, client.y + client.height);
                    int delta = Math.max(0, point.x - (RPM.getRowHeadWidth() + CPM.getColumnX(col1) - (col1 >= CPM.getFixedColumnCount() ? pView.getWorkSheet().getXOffset() : 0)));
                    pView.getWorkSheet().setColumnWidth(col1, delta);
                    break;
                }
                case 4: {
                    pView.setCursor(ColumnHeadTool.GetCursor("DEFAULT", pView));
                }
            }
        }
        pView.repaint();
        this.m_mousestate = 8;
    }

    public boolean canDoResizeColumnWidth(WorkSheetView_ pView, MouseEvent e) {
        Point point = e.getPoint();
        Point delta = new Point(3, 0);
        Rectangle rect = new Rectangle();
        Rectangle rectLT = new Rectangle();
        Rectangle rectLB = new Rectangle();
        Rectangle rectRT = new Rectangle();
        Rectangle rectRB = new Rectangle();
        Rectangle rectCenter = new Rectangle();
        if (this.m_mousestate == 8 || this.m_mousestate == 9) {
            this.m_col = pView.GetColumnHeadRect(point, rect);
            this.m_headrect = (Rectangle)rect.clone();
        }
        int fixedRowHeight = Math.max(20, pView.getWorkSheet().getRowPropertyManage().getFixedRowHeight());
        rectLT.setBounds(rect.x, rect.y, 3, rect.height / 4);
        rectLB.setBounds(rect.x, rect.y + rect.height / 4, 3, rect.height * 3 / 4 + fixedRowHeight);
        rectRT.setBounds(rect.x + rect.width - 3, rect.y, 3, rect.height / 4);
        rectRB.setBounds(rect.x + rect.width - 3, rect.y + rect.height / 4, 3, rect.height * 3 / 4 + fixedRowHeight);
        rectCenter.setBounds(rect.x + 3, rect.y, rect.width - 6, rect.height);
        if (rectLT.contains(point)) {
            return true;
        }
        if (rectRT.contains(point)) {
            return true;
        }
        if (rectLB.contains(point)) {
            return true;
        }
        return rectRB.contains(point);
    }

    public void OnMouseMove(WorkSheetView_ pView, MouseEvent e) {
        Point point = e.getPoint();
        Point delta = new Point(3, 0);
        Rectangle rect = new Rectangle();
        Rectangle rectLT = new Rectangle();
        Rectangle rectLB = new Rectangle();
        Rectangle rectRT = new Rectangle();
        Rectangle rectRB = new Rectangle();
        Rectangle rectCenter = new Rectangle();
        String hCur = "DEFAULT";
        if (this.m_mousestate == 8 || this.m_mousestate == 9) {
            this.m_col = pView.GetColumnHeadRect(point, rect);
            this.m_headrect = (Rectangle)rect.clone();
        } else {
            rect = (Rectangle)this.m_headrect.clone();
        }
        if (this.m_col > -1) {
            int fixedRowHeight = Math.max(20, pView.getWorkSheet().getRowPropertyManage().getFixedRowHeight());
            rectLT.setBounds(rect.x, rect.y, 3, rect.height / 4);
            rectLB.setBounds(rect.x, rect.y + rect.height / 4, 3, rect.height * 3 / 4 + fixedRowHeight);
            rectRT.setBounds(rect.x + rect.width - 3, rect.y, 3, rect.height / 4);
            rectRB.setBounds(rect.x + rect.width - 3, rect.y + rect.height / 4, 3, rect.height * 3 / 4 + fixedRowHeight);
            rectCenter.setBounds(rect.x + 3, rect.y, rect.width - 6, rect.height);
            if (rectLT.contains(point)) {
                hCur = "LT.gif";
            }
            if (rectRT.contains(point)) {
                hCur = "RT.gif";
            }
            if (rectLB.contains(point)) {
                hCur = "LB.gif";
            }
            if (rectRB.contains(point)) {
                hCur = "RB.gif";
            }
            if (rectCenter.contains(point)) {
                hCur = "down.gif";
            }
            pView.setCursor(ColumnHeadTool.GetCursor(hCur, pView));
        }
        super.OnMouseMove(pView, e);
        if (!pView.IsOnColumnHeader(point) && !c_IsDraging && hCur == "DEFAULT") {
            pView.setCursor(ColumnHeadTool.GetCursor("DEFAULT", pView));
            DrawTool.c_drawShape = 0;
        }
    }

    public void drawXORString(WorkSheetView_ pView, int x, int y, String info) {
        Graphics2D dc = (Graphics2D)pView.getGraphics();
        dc.setXORMode(new Color(255, 255, 255));
        Rectangle textRect = new Rectangle();
        textRect.x = x;
        textRect.y = y;
        textRect.height = 20;
        textRect.width = 80;
        Tools.DrawString(dc, textRect, info, 0, null, Color.BLACK, "Arial", 12, false, false, false, 0, 0, true);
        dc.setPaintMode();
    }

    public void OnMouseDrag(WorkSheetView_ pView, MouseEvent e) {
        Point point = e.getPoint();
        Point delta = new Point(3, 0);
        Rectangle rect = new Rectangle();
        if (this.m_mousestate == 8 || this.m_mousestate == 9) {
            this.m_col = pView.GetColumnHeadRect(point, rect);
            this.m_headrect = (Rectangle)rect.clone();
        } else {
            rect = (Rectangle)this.m_headrect.clone();
        }
        if (this.m_col > -1) {
            switch (this.m_mousestate) {
                case 0: 
                case 1: {
                    if (this.m_mousestate == 0) {
                        pView.setCursor(ColumnHeadTool.GetCursor("LT.gif", pView));
                    }
                    if (this.m_mousestate == 1) {
                        pView.setCursor(ColumnHeadTool.GetCursor("LB.gif", pView));
                    }
                    Rectangle client = pView.getBounds();
                    pView.DrawXorLine(ColumnHeadTool.c_last.x, client.y, ColumnHeadTool.c_last.x, client.y + client.height);
                    pView.DrawXorLine(point.x, client.y, point.x, client.y + client.height);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.m_mousestate == 2) {
                        pView.setCursor(ColumnHeadTool.GetCursor("RT.gif", pView));
                    }
                    if (this.m_mousestate == 3) {
                        pView.setCursor(ColumnHeadTool.GetCursor("RB.gif", pView));
                    }
                    Rectangle client = pView.getBounds();
                    pView.DrawXorLine(ColumnHeadTool.c_last.x, client.y, ColumnHeadTool.c_last.x, client.y + client.height);
                    pView.DrawXorLine(point.x, client.y, point.x, client.y + client.height);
                    break;
                }
                case 4: {
                    pView.setCursor(ColumnHeadTool.GetCursor("down.gif", pView));
                    RowPropertyManage RPM = pView.getWorkSheet().getRowPropertyManage();
                    int col1 = pView.GetColAtPoint(false, ColumnHeadTool.c_down.x);
                    int col2 = pView.GetColAtPoint(false, e.getX());
                    int rc = RPM.getRowCount();
                    pView.getWorkSheet().setSelection(new Range_(0, col1, rc - 1, col2));
                }
            }
        }
        super.OnMouseDrag(pView, e);
    }

    public void OnRButtonDown(WorkSheetView_ pView, MouseEvent e) {
        super.OnRButtonDown(pView, e);
    }
}

