/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.brick.Brick;
import excel.core.Cell;
import excel.core.CellPanel;
import excel.core.ColumnPropertyManage;
import excel.core.DBBindConfig;
import excel.core.DataSourceConfig;
import excel.core.EditStyle;
import excel.core.MergedRange;
import excel.core.Range;
import excel.core.RowCol;
import excel.core.RowPropertyManage;
import excel.core.WorkBook;
import excel.core.WorkSheet;
import excel.core.WorkSheetView;
import excel.core.impl.BackGroundImageConfig;
import excel.core.impl.CellPanel_;
import excel.core.impl.Cell_;
import excel.core.impl.DrawBorderTask;
import excel.core.impl.FloatBar;
import excel.core.impl.PrintRange_;
import excel.core.impl.Range_;
import excel.core.impl.WorkBookAdapterIns;
import excel.core.impl.WorkBookView_;
import excel.core.impl.WorkBook_;
import excel.core.impl.WorkSheet_;
import excel.core.mouseaction.ActionTool;
import excel.core.mouseaction.ColumnHeadTool;
import excel.core.mouseaction.DrawTool;
import excel.core.mouseaction.RowHeadTool;
import excel.core.mouseaction.SelectTool;
import excel.dragdrop.DragAndDropDropTargetListener;
import excel.edit.BasicEdit;
import excel.edit.DropDownListBox;
import excel.edit.Edit;
import excel.event.WorkSheetViewEventManage;
import excel.event.impl.WorkSheetViewEventManage_;
import excel.print.PrintPreview;
import excel.print.PrintSetupDialog;
import excel.util.Tools;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DropTarget;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import jun.db.core.DataStore;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkSheetView_
extends WorkSheetView
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private WorkSheet_ Sheet;
    private ColumnPropertyManage CPM;
    private RowPropertyManage RPM;
    private WorkSheetViewEventManage EM;
    public BufferedImage snapShot = null;
    public static SelectTool selectTool = new SelectTool();
    public static ColumnHeadTool columnHeadTool = new ColumnHeadTool();
    public static RowHeadTool rowHeadTool = new RowHeadTool();
    public static Color SelectedHeaderBackgroundColor = new Color(182, 189, 210);
    public static Color NormalHeaderBackgroundColor = null;
    HashMap drawBorderMap = new HashMap();
    HashMap drawBindBorderMap = new HashMap();
    private Rectangle CurrentEditControlBounds = null;
    private Edit currentEditingEdit = null;
    private String currentEditintDSN = "";
    private int lastToolTipShowOnCellRow = -1;
    private int lastToolTipShowOnCellCol = -1;
    private int lastToolTipShowOnCellInnerRow = -1;
    private String lastToolTipText = "";
    private FloatBar floatToolBar = new FloatBar(this);
    Timer findSplashTimer = null;
    boolean splashOn = false;

    public WorkSheetView_(WorkSheet sheet) {
        NormalHeaderBackgroundColor = new Color(15526360);
        this.setOpaque(false);
        this.Sheet = (WorkSheet_)sheet;
        this.CPM = this.Sheet.getColumnPropertyManage();
        this.RPM = this.Sheet.getRowPropertyManage();
        WorkBookAdapterIns wsai = new WorkBookAdapterIns(this);
        this.Sheet.getWorkBook().getEM().addListener(wsai);
        this.Sheet.setWorkSheetView(this);
        this.EM = new WorkSheetViewEventManage_();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setToolTipText("");
        DropTarget dropTarget = new DropTarget(this, new DragAndDropDropTargetListener());
    }

    public void getCurrentSnapShot() {
        if (!this.isVisible()) {
            return;
        }
        if (this.snapShot != null) {
            return;
        }
        Rectangle rc = this.getBounds();
        if (rc.width <= 0 || rc.height <= 0) {
            return;
        }
        this.snapShot = new BufferedImage(rc.width, rc.height, 1);
        Graphics tg = this.snapShot.getGraphics();
        tg.setClip(0, 0, rc.width, rc.height);
        this.OnDraw((Graphics2D)tg);
    }

    @Override
    public JToolTip createToolTip() {
        int dismissDelay = Integer.MAX_VALUE;
        ToolTipManager.sharedInstance().setDismissDelay(dismissDelay);
        JToolTip tip = new JToolTip(){

            public Insets getInsets() {
                return new Insets(10, 10, 10, 10);
            }
        };
        tip.setComponent(this);
        tip.setBackground(Color.yellow);
        return tip;
    }

    @Override
    public WorkSheet getWorkSheet() {
        return this.Sheet;
    }

    @Override
    public WorkSheetViewEventManage EM() {
        return this.EM;
    }

    @Override
    public void update(Graphics g) {
        this.paintComponent(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.Sheet.isPaintPermit()) {
            this.OnDraw(g2);
        } else if (this.snapShot != null) {
            g2.drawImage(this.snapShot, null, 0, 0);
        }
    }

    public void OnDraw(Graphics2D g) {
        this.drawBorderMap.clear();
        this.drawBindBorderMap.clear();
        Shape rc = g.getClip();
        Rectangle client = this.getBounds();
        Rectangle clipRC = rc == null ? client : rc.getBounds();
        this.OnDraw(g, client, clipRC);
    }

    public void OnDraw(Graphics2D g, Rectangle client, Rectangle clipRC) {
        double scale = (double)this.Sheet.getViewScale() / 100.0;
        g.scale(scale, scale);
        this.drawBorderMap.clear();
        this.drawBindBorderMap.clear();
        AlphaComposite ac5 = AlphaComposite.getInstance(3, 0.5f);
        g.setComposite(ac5);
        g.setColor(this.Sheet.getPaperColor());
        g.fill(client);
        AlphaComposite ac10 = AlphaComposite.getInstance(3, 1.0f);
        g.setComposite(ac10);
        g.fill(client);
        g.setColor(this.Sheet.getPaperColor());
        g.fill(clipRC);
        if (this.Sheet.getContainerCellPanel() != null) {
            this.DrawContainerCellImageInRect(false, clipRC, client, g);
        }
        this.DrawBackGroundImageInRect(false, clipRC, client, g);
        this.DrawObjectInRect(false, clipRC, client, g);
        this.DrawBorder(this.drawBindBorderMap, g);
        this.DrawBorder(this.drawBorderMap, g);
        this.DrawFreezeLine(g);
        this.DrawSelection(g);
        this.DrawMovingSelection(g);
        this.DrawTipInfo(g);
        this.DrawFocusRange(g);
        this.DrawSplash(g);
    }

    public void DrawFocusRange(Graphics2D g) {
        if (!this.Sheet.getWorkBook().isFocusRangeVisible()) {
            return;
        }
        ArrayList<Range> fl = this.Sheet.getFocusRangeList();
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.6f);
        Composite oldAC = g.getComposite();
        BasicStroke stoke = new BasicStroke(2.0f, 0, 2);
        Stroke oldStoke = g.getStroke();
        g.setStroke(stoke);
        int i = 0;
        while (i < fl.size()) {
            g.setComposite(ac);
            Range r = fl.get(i);
            Rectangle rc = this.getRectangleOfRange(false, r);
            rc.x += 2;
            rc.y += 2;
            rc.width -= 4;
            rc.height -= 4;
            g.setColor(Color.blue);
            g.drawRect(rc.x, rc.y, rc.width, rc.height);
            g.setComposite(oldAC);
            String t = "" + (i + 1);
            Rectangle textRC = Tools.getStringBounds(g, t, "Arial", 12, false, false, false);
            textRC.x = rc.x + 5;
            textRC.y = rc.y + 5;
            ++textRC.width;
            ++textRC.height;
            Tools.DrawString(g, textRC, t, 1, Color.red, Color.white, "Arial", 12, false, false, false, 0, 0);
            ++i;
        }
        g.setStroke(oldStoke);
        g.setComposite(oldAC);
    }

    public void DrawTipInfo(Graphics2D g) {
        if (this.Sheet.tipInfo == null) {
            return;
        }
        AlphaComposite ac5 = AlphaComposite.getInstance(3, 0.5f);
        AlphaComposite ac10 = AlphaComposite.getInstance(3, 1.0f);
        AlphaComposite ac9 = AlphaComposite.getInstance(3, 0.9f);
        g.setComposite(ac9);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle infoBound = Tools.getStringBounds(g, this.Sheet.tipInfo, "\u5b8b\u4f53", 12, false, false, false);
        int x = 5 + this.Sheet.getRowPropertyManage().getRowHeadWidth();
        int y = 5 + this.Sheet.getColumnPropertyManage().getColumnHeadHeight();
        int h = infoBound.height + 10;
        int w = infoBound.width + h;
        g.setColor(new Color(0xFFFF24));
        int arc = h;
        g.fillRoundRect(x, y, w, h, arc, arc);
        g.setColor(new Color(1989888));
        BasicStroke size = new BasicStroke(3.0f, 0, 2);
        Stroke oldStoke = g.getStroke();
        g.setStroke(size);
        g.setComposite(ac5);
        g.drawRoundRect(x - 1, y - 1, w + 2, h + 2, arc, arc);
        g.setStroke(oldStoke);
        g.setColor(new Color(0));
        g.drawRoundRect(x, y, w, h, arc, arc);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setStroke(oldStoke);
        g.setComposite(ac10);
        Tools.DrawString(g, new Rectangle(x + h / 2, y + 4, infoBound.width, infoBound.height + 5), this.Sheet.tipInfo, 0, Color.white, Color.black, "\u5b8b\u4f53", 12, false, false, false, 0, 0);
    }

    public void OnPrintPageHeader(Graphics2D g, Rectangle2D.Double client) {
        this.drawBorderMap.clear();
        g.setClip(client);
        Cell_ cell = (Cell_)this.Sheet.getPageHeader();
        cell.setInvalid();
        Rectangle cellRect = client.getBounds();
        cell.drawBackground(g, cellRect);
        cell.drawBorder(g, cellRect);
        cell.draw(true, g, cellRect);
        this.DrawBorder(this.drawBorderMap, g);
    }

    public void OnPrintPageFooter(Graphics2D g, Rectangle2D.Double client) {
        this.drawBorderMap.clear();
        g.setClip(client);
        Cell_ cell = (Cell_)this.Sheet.getPageFooter();
        cell.setInvalid();
        Rectangle cellRect = client.getBounds();
        cell.drawBackground(g, cellRect);
        cell.drawBorder(g, cellRect);
        cell.draw(true, g, cellRect);
        this.DrawBorder(this.drawBorderMap, g);
    }

    public void OnPrint(Graphics2D g, Rectangle2D.Double client) {
        this.drawBorderMap.clear();
        this.drawBindBorderMap.clear();
        PageFormat pageFormat = this.Sheet.getPageFormat();
        boolean isPrint = g.getDeviceConfiguration().getDevice().getType() == 1;
        Rectangle2D.Double rcClip = (Rectangle2D.Double)client.clone();
        int pageIndex = this.Sheet.getCurrentPrintingPage();
        ArrayList pageRange = this.Sheet.getPageRange();
        PrintRange_ range = (PrintRange_)pageRange.get(pageIndex);
        rcClip.height -= (double)range.getRowBlank();
        rcClip.width -= (double)range.getColumnBlank();
        g.setClip(rcClip);
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
        g.setComposite(ac);
        g.setColor(this.Sheet.getPaperColor());
        g.fill(client);
        ac = AlphaComposite.getInstance(3, 1.0f);
        g.setComposite(ac);
        g.fill(client);
        this.DrawBackGroundImageInRect(true, rcClip.getBounds(), client.getBounds(), g);
        this.DrawObjectInRect(true, rcClip.getBounds2D(), client.getBounds(), g);
        this.DrawBorder(this.drawBindBorderMap, g);
        this.DrawBorder(this.drawBorderMap, g);
        g.setColor(this.Sheet.getPaperColor());
        g.fill(new Rectangle2D.Double(0.0, rcClip.y + rcClip.height, rcClip.width, range.getRowBlank()));
    }

    private void DrawBorder(HashMap map, Graphics2D g) {
        Set clips = map.keySet();
        Shape oldClip = g.getClip();
        for (Shape rcClip : clips) {
            ArrayList taskList = (ArrayList)map.get(rcClip);
            try {
                try {
                    Tools.clip(g, rcClip);
                    int ti = 0;
                    while (ti < taskList.size()) {
                        DrawBorderTask task = (DrawBorderTask)taskList.get(ti);
                        WorkSheetView_.DrawCellBorderLine(g, task.border_style, task.border_width, task.border_color, task.x1, task.y1, task.x2, task.y2, this.Sheet);
                        ++ti;
                    }
                }
                catch (Exception exception) {
                    Tools.setClip(g, oldClip);
                    continue;
                }
            }
            catch (Throwable throwable) {
                Tools.setClip(g, oldClip);
                throw throwable;
            }
            Tools.setClip(g, oldClip);
        }
        Tools.setClip(g, oldClip);
    }

    private void DrawFreezeLine(Graphics2D g) {
        if (this.RPM.getFixedRowCount() > 0 && this.Sheet.isDesignMode()) {
            AlphaComposite ac = AlphaComposite.getInstance(3, 0.3f);
            Stroke oldStroke = g.getStroke();
            Composite oldac = g.getComposite();
            g.setStroke(Tools.getStroke(2.0f, 0, 0));
            g.setComposite(ac);
            g.setColor(Color.blue);
            int y = this.RPM.getFixedRowHeight() + this.CPM.getColumnHeadHeight();
            g.drawLine(0, y, this.getWidth(), y);
            g.setStroke(oldStroke);
            g.setComposite(oldac);
        }
        if (this.CPM.getFixedColumnCount() > 0 && this.Sheet.getXOffset() > 0 || this.CPM.getFixedColumnCount() > 0 && this.Sheet.isDesignMode()) {
            int rc = this.Sheet.getRowCount();
            int col = this.CPM.getFixedColumnCount();
            int y2 = this.getHeight();
            int row = this.RPM.getFixedRowCount();
            while (row < rc) {
                if (this.Sheet.cells(row, col).getBind() == null) {
                    y2 = this.RPM.getRowY(row);
                    Rectangle rect = this.getRectangleOfCell(false, row, col);
                    y2 = rect.y;
                    break;
                }
                ++row;
            }
            int thick = 3;
            int x = this.CPM.getFixedColumnWidth() + this.RPM.getRowHeadWidth();
            int y = this.RPM.getFixedRowHeight() + this.CPM.getColumnHeadHeight();
            int i = 0;
            while (i < thick) {
                AlphaComposite ac = AlphaComposite.getInstance(3, (float)(thick - i) * 0.2f - 0.1f);
                Stroke oldStroke = g.getStroke();
                g.setStroke(Tools.getStroke(1.0f, 0, 0));
                Composite oldac = g.getComposite();
                g.setComposite(ac);
                g.setColor(Color.black);
                g.drawLine(x + i + 1, y, x + i + 1, Math.max(y, y2));
                g.setStroke(oldStroke);
                g.setComposite(oldac);
                ++i;
            }
        }
    }

    void DrawContainerCellImageInRect(boolean isPrint, Rectangle rect, Rectangle client, Graphics2D g) {
        if (this.Sheet.getContainerCellPanel() == null) {
            return;
        }
        if (this.Sheet.getContainerCellPanel().getParentSheet() == null) {
            return;
        }
        WorkSheetView_ pv = (WorkSheetView_)this.Sheet.getContainerCellPanel().getParentSheet().getWorkSheetView();
        CellPanel_ cp = (CellPanel_)this.Sheet.getContainerCellPanel();
        Rectangle rc = cp.getBounds();
        int xOffset = -rc.x;
        int yOffset = -rc.y;
        pv.DrawBackGroundImageInRect(isPrint, rect, client, g, this, xOffset, yOffset);
    }

    void DrawBackGroundImageInRect(boolean isPrint, Rectangle rect, Rectangle client, Graphics2D g) {
        this.DrawBackGroundImageInRect(isPrint, rect, client, g, this, 0, 0);
    }

    void DrawBackGroundImageInRect(boolean isPrint, Rectangle rect, Rectangle client, Graphics2D g, ImageObserver observer, int xOffset, int yOffset) {
        TreeMap<Integer, HashMap<String, BackGroundImageConfig>> map = this.Sheet.backgroundImageMap;
        for (Integer layer : map.keySet()) {
            HashMap<String, BackGroundImageConfig> layerMap = map.get(layer);
            for (String id : layerMap.keySet()) {
                BackGroundImageConfig config = layerMap.get(id);
                if (isPrint && !config.needPrint) continue;
                RowCol rc1 = this.Sheet.cellNameToRowColumn(config.startCell);
                RowCol rc2 = this.Sheet.cellNameToRowColumn(config.endCell);
                Range_ range = new Range_(rc1.row, rc1.col, rc2.row, rc2.col);
                Rectangle rc = this.getRectangleOfRange(isPrint, range);
                Tools.setClip(g, rect);
                Rectangle intersection = (Rectangle)rc.createIntersection(rect);
                if (!config.endCell.equals("")) {
                    try {
                        Tools.clip(g, intersection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!rect.intersects(rc)) continue;
                int x0 = config.getX(rc, this) + xOffset;
                int y0 = config.getY(rc, this) + yOffset;
                ArrayList xList = config.getAllX(x0, rc, rect, this);
                ArrayList yList = config.getAllY(y0, rc, rect, this);
                Image img = config.getImage(this);
                int w = config.getImageWidth(this);
                int h = config.getImageHeight(this);
                int xi = 0;
                while (xi < xList.size()) {
                    int x = (Integer)xList.get(xi);
                    int yi = 0;
                    while (yi < yList.size()) {
                        int y = (Integer)yList.get(yi);
                        if (rect.intersects(x, y, w, h)) {
                            g.drawImage(img, x, y, observer);
                        }
                        ++yi;
                    }
                    ++xi;
                }
            }
        }
        Tools.setClip(g, rect);
    }

    private void DrawObjectInRect(boolean isPrint, Rectangle2D rect, Rectangle client, Graphics2D g) {
        Point p = new Point((isPrint ? 0 : this.RPM.getRowHeadWidth()) + this.CPM.getFixedColumnWidth(), (isPrint ? 0 : this.CPM.getColumnHeadHeight()) + this.RPM.getFixedRowHeight());
        int startRow = this.GetRowAtPoint(isPrint, p.y);
        int startCol = this.GetColAtPoint(isPrint, p.x);
        int endRow = this.GetRowAtPoint(isPrint, client.height);
        int endCol = this.GetColAtPoint(isPrint, client.width);
        if (endRow == -1) {
            endRow = this.RPM.getRowCount() - 1;
        }
        if (endCol == -1) {
            endCol = this.CPM.getColumnCount() - 1;
        }
        boolean rowBlank = false;
        this.DrawCells(isPrint, rect, client, g, startRow, startCol, endRow, endCol);
        this.DrawColumnHeader(isPrint, rect, client, g, startRow, startCol, endRow, endCol);
        this.DrawRowHeader(isPrint, rect, client, g, startRow, startCol, endRow, endCol);
        this.DrawColumnRowHeader(isPrint, rect, client, g, startRow, startCol, endRow, endCol);
    }

    private void DrawColumnHeader(boolean isPrint, Rectangle2D rect, Rectangle client, Graphics2D g, int startRow, int startCol, int endRow, int endCol) {
        boolean forceDraw = false;
        int i = 0;
        while (i <= this.RPM.getFixedRowCount()) {
            if (!this.RPM.isColumnScrollEnabled(i)) {
                startCol = this.CPM.getFixedColumnCount();
                forceDraw = true;
                break;
            }
            ++i;
        }
        Rectangle rcClip = new Rectangle();
        rcClip.x = (isPrint ? 0 : this.RPM.getRowHeadWidth()) + this.CPM.getFixedColumnWidth() - 1;
        rcClip.y = 0;
        rcClip.width = client.width - rcClip.x;
        rcClip.height = this.CPM.getColumnHeadHeight() + this.RPM.getFixedRowHeight() + 1;
        Shape oc = g.getClip();
        Rectangle2D.Double realClip = new Rectangle2D.Double(rcClip.x, rcClip.y, rcClip.width, rcClip.height);
        if (!forceDraw && !rcClip.intersects(oc.getBounds())) {
            return;
        }
        try {
            try {
                int h;
                Tools.clip(g, realClip);
                int x0 = (isPrint ? 0 : this.RPM.getRowHeadWidth()) + this.CPM.getColumnX(startCol) - (isPrint ? this.Sheet.getXPrintOffset() : this.Sheet.getXOffset());
                int y0 = isPrint ? 0 : this.CPM.getColumnHeadHeight();
                Rectangle cellRect = new Rectangle();
                int y = y0;
                int row = 0;
                while (row < this.RPM.getFixedRowCount()) {
                    h = this.RPM.getRowHeight(row);
                    int x = x0;
                    if (!this.RPM.isColumnScrollEnabled(row)) {
                        x = (isPrint ? 0 : this.RPM.getRowHeadWidth()) + this.CPM.getColumnX(startCol) - (isPrint ? this.Sheet.getXPrintOffset() : 0);
                    }
                    int col = startCol;
                    while (col <= endCol) {
                        boolean needDraw = true;
                        int drawRow = row;
                        int drawCol = col;
                        Cell drawCell = this.Sheet.$Cells(row, col);
                        int w = this.CPM.getColumnWidth(col);
                        cellRect.setBounds(x, y, w, h);
                        if (drawCell != null && drawCell.isMerged()) {
                            Range r = ((MergedRange)this.Sheet.getMergeMap().get(drawCell)).getMergedRange();
                            drawRow = r.getStartRow();
                            drawCol = r.getStartCol();
                            drawCell = this.Sheet.Cells(drawRow, drawCol);
                            needDraw = false;
                            if (drawRow == row && drawCol == col) {
                                needDraw = true;
                            }
                            if (row == drawRow && col == startCol) {
                                needDraw = true;
                            }
                            cellRect = this.getRectangleOfRange(isPrint, r);
                        }
                        if ((needDraw || forceDraw) && (forceDraw || realClip.intersects(cellRect))) {
                            this.DrawCell(isPrint, drawCell, cellRect, rect, client, g, drawRow, drawCol);
                        }
                        x += w;
                        ++col;
                    }
                    y += h;
                    ++row;
                }
                if (!isPrint) {
                    int x = x0;
                    y = 0;
                    h = y0;
                    int SelectedStartCol = this.Sheet.getSelection().getStartCol();
                    int SelectedEndCol = this.Sheet.getSelection().getEndCol();
                    int col = startCol;
                    while (col <= endCol) {
                        int w = this.CPM.getColumnWidth(col);
                        cellRect.setBounds(x, y, w, h);
                        if (realClip.intersects(cellRect)) {
                            g.setColor(col >= SelectedStartCol && col <= SelectedEndCol ? SelectedHeaderBackgroundColor : NormalHeaderBackgroundColor);
                            g.fill(cellRect);
                            g.setColor(Color.GRAY);
                            g.draw(cellRect);
                            Tools.DrawString(g, cellRect, this.CPM.getColumnShowText(col), 0, null, Color.BLACK, "\u5b8b\u4f53", 16, false, false, false, 2, 2);
                        }
                        x += w;
                        ++col;
                    }
                }
            }
            catch (Exception exception) {
                Tools.setClip(g, oc);
            }
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    private void DrawRowHeader(boolean isPrint, Rectangle2D rect, Rectangle client, Graphics2D g, int startRow, int startCol, int endRow, int endCol) {
        Rectangle rcClip = new Rectangle();
        rcClip.x = 0;
        rcClip.y = (isPrint ? 0 : this.CPM.getColumnHeadHeight()) + this.RPM.getFixedRowHeight();
        rcClip.width = this.RPM.getRowHeadWidth() + this.CPM.getFixedColumnWidth() + 1;
        rcClip.height = client.height - rcClip.y;
        Shape oc = g.getClip();
        Rectangle2D.Double realClip = new Rectangle2D.Double(rcClip.x, rcClip.y, rcClip.width, rcClip.height);
        if (!rcClip.intersects(oc.getBounds())) {
            return;
        }
        try {
            try {
                int w;
                Tools.clip(g, realClip);
                int x0 = isPrint ? 0 : this.RPM.getRowHeadWidth();
                int y0 = (isPrint ? 0 : this.CPM.getColumnHeadHeight()) + this.RPM.getRowY(startRow) - (isPrint ? this.Sheet.getYPrintOffset() : this.Sheet.getYOffset());
                Rectangle cellRect = new Rectangle();
                int x = x0;
                int col = 0;
                while (col < this.CPM.getFixedColumnCount()) {
                    w = this.CPM.getColumnWidth(col);
                    int y = y0;
                    int row = startRow;
                    while (row <= endRow) {
                        boolean needDraw = true;
                        int drawRow = row;
                        int drawCol = col;
                        Cell drawCell = this.Sheet.$Cells(row, col);
                        int h = this.RPM.getRowHeight(row);
                        cellRect.setBounds(x, y, w, h);
                        if (drawCell != null && drawCell.isMerged()) {
                            Range r = ((MergedRange)this.Sheet.getMergeMap().get(drawCell)).getMergedRange();
                            drawRow = r.getStartRow();
                            drawCol = r.getStartCol();
                            drawCell = this.Sheet.Cells(drawRow, drawCol);
                            needDraw = false;
                            if (drawRow == row && drawCol == col) {
                                needDraw = true;
                            }
                            if (row == startRow && col == drawCol) {
                                needDraw = true;
                            }
                            cellRect = this.getRectangleOfRange(isPrint, r);
                        }
                        if (needDraw && realClip.intersects(cellRect)) {
                            this.DrawCell(isPrint, drawCell, cellRect, rect, client, g, drawRow, drawCol);
                        }
                        y += h;
                        ++row;
                    }
                    x += w;
                    ++col;
                }
                if (!isPrint) {
                    int y = y0;
                    x = 0;
                    w = x0;
                    int SelectedStartRow = this.Sheet.getSelection().getStartRow();
                    int SelectedEndRow = this.Sheet.getSelection().getEndRow();
                    int row = startRow;
                    while (row <= endRow) {
                        int h = this.RPM.getRowHeight(row);
                        cellRect.setBounds(x, y, w, h);
                        if (realClip.intersects(cellRect)) {
                            g.setColor(row >= SelectedStartRow && row <= SelectedEndRow ? SelectedHeaderBackgroundColor : NormalHeaderBackgroundColor);
                            g.fill(cellRect);
                            if (this.RPM.getBindedCount(row) == 0 || this.RPM.getMaxDBRowCount(row) <= 1) {
                                g.setColor(Color.GRAY);
                                g.draw(cellRect);
                                Tools.DrawString(g, cellRect, String.valueOf(row + 1), 0, null, Color.BLACK, "\u5b8b\u4f53", 16, false, false, false, 2, 2);
                            } else {
                                DataStore ds = this.RPM.getMaximalDataSourceConfig(row).getDataStore();
                                g.setColor(NormalHeaderBackgroundColor);
                                g.fillRect(cellRect.x + 10, cellRect.y, cellRect.width - 10, cellRect.height);
                                g.setColor(Color.GRAY);
                                g.draw(cellRect);
                                g.drawLine(cellRect.x + 10, cellRect.y, cellRect.x + 10, cellRect.y + cellRect.height);
                                int dbRowHeight = this.RPM.getDBRowHeight(row);
                                int groupRowHeight = this.RPM.getGroupRowHeight(row);
                                int subY = cellRect.y;
                                int bottom = cellRect.y + cellRect.height;
                                int subRow = this.RPM.getRowScrolledRowCount(row);
                                Rectangle subRect = new Rectangle();
                                subRect.x = cellRect.x + 10;
                                subRect.width = cellRect.width - 10;
                                subRect.y = cellRect.y;
                                subRect.height = dbRowHeight;
                                WorkBook book = this.Sheet.getWorkBook();
                                boolean groupRowVisible = this.RPM.isGroupRowVisible(row);
                                while (subY < bottom) {
                                    boolean font_bold = false;
                                    subY += dbRowHeight;
                                    if (groupRowVisible) {
                                        Integer key = new Integer(subRow);
                                        Hashtable MapGroups = (Hashtable)ds.getFriendlyProperty("m_MapGroups");
                                        if (MapGroups.containsKey(key)) {
                                            ArrayList pVec = (ArrayList)MapGroups.get(key);
                                            int gc = pVec.size();
                                            subY += gc * groupRowHeight;
                                        }
                                    }
                                    ++subRow;
                                    int col2 = startCol;
                                    while (col2 <= endCol) {
                                        DataSourceConfig dsc;
                                        DBBindConfig bind;
                                        Cell_ cell = (Cell_)this.Sheet.$Cells(row, col2);
                                        if (cell != null && (bind = cell.getBind()) != null && (dsc = book.getDataSource(bind.getDataSource())).getDataSourceType() == 2 && dsc.getDataStore().getRowCount() > 0 && dsc.getCurrentBindRow() >= 0 && dsc.getCurrentBindRow() == subRow - 1) {
                                            g.setColor(SelectedHeaderBackgroundColor);
                                            g.fillRect(subRect.x + 1, subRect.y + 1, subRect.width - 1, subRect.height - 1);
                                            font_bold = true;
                                        }
                                        ++col2;
                                    }
                                    g.setColor(Color.GRAY);
                                    g.draw(subRect);
                                    Tools.DrawString(g, subRect, String.valueOf(subRow), 0, null, Color.BLACK, "\u5b8b\u4f53", 12, font_bold, false, false, 2, 2);
                                    subRect.y = subY;
                                }
                            }
                            if (!this.RPM.isColumnScrollEnabled(row)) {
                                g.drawImage(Tools.GetImageFromURL(this, "excel/img/pin.png"), cellRect.x + cellRect.width - 12, cellRect.y, this);
                            }
                        }
                        y += h;
                        ++row;
                    }
                }
            }
            catch (Exception exception) {
                Tools.setClip(g, oc);
            }
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    private void DrawColumnRowHeader(boolean isPrint, Rectangle2D rect, Rectangle client, Graphics2D g, int startRow, int startCol, int endRow, int endCol) {
        Rectangle rcClip = new Rectangle();
        rcClip.x = 0;
        rcClip.y = 0;
        rcClip.width = (isPrint ? 0 : this.RPM.getRowHeadWidth()) + this.CPM.getFixedColumnWidth() + 1;
        rcClip.height = (isPrint ? 0 : this.CPM.getColumnHeadHeight()) + this.RPM.getFixedRowHeight() + 1;
        Shape oc = g.getClip();
        Rectangle2D.Double realClip = new Rectangle2D.Double(rcClip.x, rcClip.y, rcClip.width, rcClip.height);
        if (!rcClip.intersects(oc.getBounds())) {
            return;
        }
        try {
            try {
                int w;
                int x;
                int h;
                int y0;
                Tools.clip(g, realClip);
                Rectangle cellRect = new Rectangle();
                int x0 = isPrint ? 0 : this.RPM.getRowHeadWidth();
                int y = y0 = isPrint ? 0 : this.CPM.getColumnHeadHeight();
                int row = 0;
                while (row < this.RPM.getFixedRowCount()) {
                    h = this.RPM.getRowHeight(row);
                    x = x0;
                    int col = 0;
                    while (col < this.CPM.getFixedColumnCount()) {
                        boolean needDraw = true;
                        int drawRow = row;
                        int drawCol = col;
                        Cell drawCell = this.Sheet.$Cells(row, col);
                        w = this.CPM.getColumnWidth(col);
                        cellRect.setBounds(x, y, w, h);
                        if (drawCell != null && drawCell.isMerged()) {
                            Range r = ((MergedRange)this.Sheet.getMergeMap().get(drawCell)).getMergedRange();
                            drawRow = r.getStartRow();
                            drawCol = r.getStartCol();
                            drawCell = this.Sheet.Cells(drawRow, drawCol);
                            needDraw = false;
                            if (drawRow == row && drawCol == col) {
                                needDraw = true;
                            }
                            cellRect = this.getRectangleOfRange(isPrint, r);
                        }
                        if (needDraw && realClip.intersects(cellRect)) {
                            this.DrawCell(isPrint, drawCell, cellRect, rect, client, g, drawRow, drawCol);
                        }
                        x += w;
                        ++col;
                    }
                    y += h;
                    ++row;
                }
                if (!isPrint) {
                    x = this.RPM.getRowHeadWidth();
                    y = 0;
                    h = this.CPM.getColumnHeadHeight();
                    int SelectedStartCol = this.Sheet.getSelection().getStartCol();
                    int SelectedEndCol = this.Sheet.getSelection().getEndCol();
                    int col = 0;
                    while (col < this.CPM.getFixedColumnCount()) {
                        w = this.CPM.getColumnWidth(col);
                        cellRect.setBounds(x, y, w, h);
                        if (realClip.intersects(cellRect)) {
                            g.setColor(col >= SelectedStartCol && col <= SelectedEndCol ? SelectedHeaderBackgroundColor : NormalHeaderBackgroundColor);
                            g.fill(cellRect);
                            g.setColor(Color.GRAY);
                            g.draw(cellRect);
                            Tools.DrawString(g, cellRect, this.CPM.getColumnShowText(col), 0, null, Color.BLACK, "\u5b8b\u4f53", 16, false, false, false, 2, 2);
                        }
                        x += w;
                        ++col;
                    }
                    y = this.CPM.getColumnHeadHeight();
                    x = 0;
                    w = this.RPM.getRowHeadWidth();
                    int SelectedStartRow = this.Sheet.getSelection().getStartRow();
                    int SelectedEndRow = this.Sheet.getSelection().getEndRow();
                    int row2 = 0;
                    while (row2 < this.RPM.getFixedRowCount()) {
                        h = this.RPM.getRowHeight(row2);
                        cellRect.setBounds(x, y, w, h);
                        if (realClip.intersects(cellRect)) {
                            g.setColor(row2 >= SelectedStartRow && row2 <= SelectedEndRow ? SelectedHeaderBackgroundColor : NormalHeaderBackgroundColor);
                            g.fill(cellRect);
                            g.setColor(Color.GRAY);
                            g.draw(cellRect);
                            Tools.DrawString(g, cellRect, String.valueOf(row2 + 1), 0, null, Color.BLACK, "\u5b8b\u4f53", 16, false, false, false, 2, 2);
                        }
                        if (!this.RPM.isColumnScrollEnabled(row2)) {
                            g.drawImage(Tools.GetImageFromURL(this, "excel/img/pin.png"), cellRect.x + cellRect.width - 12, cellRect.y, this);
                        }
                        y += h;
                        ++row2;
                    }
                    cellRect.setBounds(0, 0, x0, y0);
                    g.setColor(NormalHeaderBackgroundColor);
                    g.fill(cellRect);
                    g.setColor(Color.GRAY);
                    g.draw(cellRect);
                }
                if (this.CPM.getColumnHeadHeight() == 0 && this.RPM.getRowHeadWidth() == 0) {
                    g.setColor(Color.white);
                    g.drawLine(0, 0, 0, 0);
                }
            }
            catch (Exception exception) {
                Tools.setClip(g, oc);
            }
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    private void DrawCells(boolean isPrint, Rectangle2D rect, Rectangle client, Graphics2D g, int startRow, int startCol, int endRow, int endCol) {
        int x0 = (isPrint ? 0 : this.RPM.getRowHeadWidth()) + this.CPM.getColumnX(startCol) - (isPrint ? this.Sheet.getXPrintOffset() : this.Sheet.getXOffset());
        int y0 = (isPrint ? 0 : this.CPM.getColumnHeadHeight()) + this.RPM.getRowY(startRow) - (isPrint ? this.Sheet.getYPrintOffset() : this.Sheet.getYOffset());
        Rectangle rcClip = new Rectangle();
        rcClip.x = (isPrint ? 0 : this.RPM.getRowHeadWidth()) + this.CPM.getFixedColumnWidth();
        rcClip.y = (isPrint ? 0 : this.CPM.getColumnHeadHeight()) + this.RPM.getFixedRowHeight();
        rcClip.width = client.width - rcClip.x;
        rcClip.height = client.height - rcClip.y;
        Shape oc = g.getClip();
        Rectangle2D.Double realClip = new Rectangle2D.Double(rcClip.x, rcClip.y, rcClip.width, rcClip.height);
        if (!rcClip.intersects(oc.getBounds())) {
            return;
        }
        try {
            try {
                Tools.clip(g, realClip);
                Rectangle cellRect = new Rectangle();
                int y = y0;
                int row = startRow;
                while (row <= endRow) {
                    if (row == 1) {
                        boolean bl = true;
                    }
                    int h = this.RPM.getRowHeight(row);
                    int x = x0;
                    if (!this.RPM.isColumnScrollEnabled(row)) {
                        x = (isPrint ? 0 : this.RPM.getRowHeadWidth()) + this.CPM.getColumnX(startCol) - (isPrint ? this.Sheet.getXPrintOffset() : 0);
                    }
                    int col = startCol;
                    while (col <= endCol) {
                        boolean needDraw = true;
                        int drawRow = row;
                        int drawCol = col;
                        Cell drawCell = this.Sheet.$Cells(row, col);
                        int w = this.CPM.getColumnWidth(col);
                        cellRect.setBounds(x, y, w, h);
                        Point p = new Point(row, col);
                        if (drawCell != null && drawCell.isMerged()) {
                            Range r = ((MergedRange)this.Sheet.getMergeMap().get(drawCell)).getMergedRange();
                            drawRow = r.getStartRow();
                            drawCol = r.getStartCol();
                            drawCell = this.Sheet.Cells(drawRow, drawCol);
                            needDraw = false;
                            if (drawRow == row && drawCol == col) {
                                needDraw = true;
                            }
                            if (row == startRow && col == drawCol) {
                                needDraw = true;
                            }
                            if (row == drawRow && col == startCol) {
                                needDraw = true;
                            }
                            cellRect = this.getRectangleOfRange(isPrint, r);
                        }
                        if (needDraw && realClip.intersects(cellRect)) {
                            this.DrawCell(isPrint, drawCell, cellRect, rect, client, g, drawRow, drawCol);
                        }
                        x += w;
                        ++col;
                    }
                    y += h;
                    ++row;
                }
            }
            catch (Exception exception) {
                Tools.setClip(g, oc);
            }
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    void AddDrawCellBorderLine(HashMap map, Graphics2D g, int border_style, int border_width, Color border_color, int x1, int y1, int x2, int y2) {
        ArrayList taskList;
        Shape clip = g.getClip();
        if (map.containsKey(clip)) {
            taskList = (ArrayList)map.get(clip);
        } else {
            taskList = new ArrayList();
            map.put(clip, taskList);
        }
        DrawBorderTask task = new DrawBorderTask();
        task.border_style = border_style;
        task.border_width = border_width;
        task.border_color = border_color;
        task.x1 = x1;
        task.y1 = y1;
        task.x2 = x2;
        task.y2 = y2;
        taskList.add(task);
    }

    void AddDrawRectangle(Graphics2D g, int border_style, int border_width, Color border_color, Rectangle rect) {
        this.AddDrawCellBorderLine(this.drawBindBorderMap, g, border_style, border_width, border_color, rect.x, rect.y, rect.x, rect.y + rect.height);
        this.AddDrawCellBorderLine(this.drawBindBorderMap, g, border_style, border_width, border_color, rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
        this.AddDrawCellBorderLine(this.drawBindBorderMap, g, border_style, border_width, border_color, rect.x + rect.width, rect.y + rect.height, rect.x + rect.width, rect.y);
        this.AddDrawCellBorderLine(this.drawBindBorderMap, g, border_style, border_width, border_color, rect.x + rect.width, rect.y, rect.x, rect.y);
    }

    public static void DrawCellBorderLine(Graphics2D g, int border_style, int border_width, Color border_color, int x1, int y1, int x2, int y2, WorkSheet Sheet) {
        if (border_style == 0) {
            return;
        }
        if (border_width == 0 && border_style != 5) {
            return;
        }
        if (border_color == null) {
            return;
        }
        Shape oc = g.getClip();
        if (border_width > 3) {
            border_width = 3;
        }
        float[] dash = new float[]{border_style - 1};
        Stroke oldStroke = g.getStroke();
        if (border_style == 1) {
            g.setStroke(Tools.getStroke(border_width, 2, 2));
        }
        if (border_style >= 2 && border_style <= 4) {
            g.setColor(Sheet.getPaperColor());
            g.drawLine(x1, y1, x2, y2);
            g.setStroke(Tools.getStroke(border_width, 0, 0, 10.0f, dash, 1.0f));
        }
        if (border_style == 5) {
            g.setStroke(Tools.getStroke(3.0f, 0, 0));
        }
        g.setColor(border_color);
        g.drawLine(x1, y1, x2, y2);
        g.setStroke(oldStroke);
        if (border_style == 5) {
            g.setColor(Sheet.getPaperColor());
            g.drawLine(x1, y1, x2, y2);
        }
    }

    private void DrawCell(boolean isPrint, Cell cell, Rectangle cellRect, Rectangle2D rect, Rectangle client, Graphics2D g, int row, int col) {
        if (this.Sheet.getGridLineVisible()) {
            g.setColor(this.Sheet.getGridLineColor());
            g.drawRect(cellRect.x, cellRect.y, cellRect.width, cellRect.height);
        }
        if (cell == null) {
            return;
        }
        ((Cell_)cell).drawBackground(g, cellRect);
        ((Cell_)cell).drawBorder(g, cellRect);
        ((Cell_)cell).draw(isPrint, g, cellRect);
    }

    public int GetColAtPoint(boolean isPrint, int x) {
        return this.GetColAtPoint(isPrint, x, -1);
    }

    public int GetColAtPoint(boolean isPrint, int x, int row) {
        int w;
        int n = w = isPrint ? 0 : this.RPM.getRowHeadWidth();
        if (x < w) {
            return -1;
        }
        int FCC = this.CPM.getFixedColumnCount();
        int i = 0;
        while (i < FCC) {
            if (x >= w && x < w + this.CPM.getColumnWidth(i)) {
                return i;
            }
            w += this.CPM.getColumnWidth(i);
            ++i;
        }
        int CC = this.CPM.getColumnCount();
        int i2 = FCC;
        while (i2 < CC) {
            if (x >= w - (isPrint ? this.Sheet.getXPrintOffset() : this.Sheet.getXOffset()) && x < w + this.CPM.getColumnWidth(i2) - (isPrint ? this.Sheet.getXPrintOffset() : (this.RPM.isColumnScrollEnabled(row) ? this.Sheet.getXOffset() : 0))) {
                return i2;
            }
            w += this.CPM.getColumnWidth(i2);
            ++i2;
        }
        return -1;
    }

    public int GetRowAtPoint(boolean isPrint, int y) {
        int h;
        int n = h = isPrint ? 0 : this.CPM.getColumnHeadHeight();
        if (y < h) {
            return -1;
        }
        int FRC = this.RPM.getFixedRowCount();
        int i = 0;
        while (i < FRC) {
            if (y >= h && y < h + this.RPM.getRowHeight(i)) {
                return i;
            }
            h += this.RPM.getRowHeight(i);
            ++i;
        }
        int RC = this.RPM.getRowCount();
        int i2 = FRC;
        while (i2 < RC) {
            if (y >= h - (isPrint ? this.Sheet.getYPrintOffset() : this.Sheet.getYOffset()) && y < h + this.RPM.getRowHeight(i2) - (isPrint ? this.Sheet.getYPrintOffset() : this.Sheet.getYOffset())) {
                return i2;
            }
            h += this.RPM.getRowHeight(i2);
            ++i2;
        }
        return -1;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.RPM.getRowCount() == 0) {
            return;
        }
        int wr = e.getWheelRotation();
        if (e.isAltDown()) {
            int n = e.getScrollAmount() * wr;
            this.Sheet.setViewScale(this.Sheet.getViewScale() + n);
            return;
        }
        int n = e.getScrollAmount() * wr * (e.isShiftDown() ? 1 : 21);
        WorkSheet sheet = this.getWorkSheet();
        if (sheet.getContainerCellPanel() != null) {
            sheet.getContainerCellPanel().VScroll(n);
        } else {
            sheet.getWorkBook().getWorkBookView().VScroll(n);
        }
    }

    public int GetColumnHeadRect(Point point, Rectangle rect) {
        Rectangle rc = new Rectangle();
        rc.x = this.RPM.getRowHeadWidth();
        rc.width = this.getWidth() - rc.x;
        rc.y = 0;
        rc.height = this.CPM.getColumnHeadHeight();
        int col = this.GetColAtPoint(false, point.x);
        rect.width = this.CPM.getColumnWidth(col);
        rect.y = 0;
        rect.height = rc.height;
        rect.x = this.RPM.getRowHeadWidth() + this.CPM.getColumnX(col);
        if (col >= this.CPM.getFixedColumnCount()) {
            rect.x -= this.Sheet.getXOffset();
        }
        return col;
    }

    public boolean IsOnColumnHeader(Point point) {
        Rectangle rc = new Rectangle();
        rc.x = this.RPM.getRowHeadWidth();
        rc.width = this.getWidth() - rc.x;
        rc.y = 0;
        rc.height = this.CPM.getColumnHeadHeight();
        return rc.contains(point);
    }

    public int GetRowHeadRect(Point point, Rectangle rect) {
        Rectangle rc = new Rectangle();
        rc.x = 0;
        rc.width = this.RPM.getRowHeadWidth();
        rc.y = this.CPM.getColumnHeadHeight();
        rc.height = this.getHeight() - rc.y;
        int row = this.GetRowAtPoint(false, point.y);
        rect.width = rc.width;
        rect.x = 0;
        rect.height = this.RPM.getRowHeight(row);
        rect.y = this.CPM.getColumnHeadHeight() + this.RPM.getRowY(row);
        if (row >= this.RPM.getFixedRowCount()) {
            rect.y -= this.Sheet.getYOffset();
        }
        return row;
    }

    public boolean IsOnRowHeader(Point point) {
        Rectangle rc = new Rectangle();
        rc.x = 0;
        rc.y = this.CPM.getColumnHeadHeight();
        rc.width = this.RPM.getRowHeadWidth();
        rc.height = this.getHeight() - rc.y;
        return rc.contains(point);
    }

    public void DrawXorLine(int x1, int y1, int x2, int y2) {
        Graphics2D dc = (Graphics2D)this.getGraphics();
        dc.setColor(new Color(36, 121, 162));
        dc.setXORMode(new Color(255, 255, 255));
        dc.drawLine(x1, y1, x2, y2);
        dc.setPaintMode();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        ActionTool pTool = DrawTool.CurrentTool();
        if (pTool != null) {
            pTool.OnMouseDrag(this, e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        ActionTool pTool = DrawTool.CurrentTool();
        if (pTool != null) {
            pTool.OnMouseMove(this, e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        final MouseEvent e1 = e;
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                WorkSheetView_.this.$mouseClicked(e1);
                return "";
            }

            protected void done() {
            }
        };
        worker.execute();
    }

    private void $mouseClicked(MouseEvent e) {
        this.splash(false);
        Cell cell = null;
        Edit lastEdit = this.$getCurrentEditingEdit();
        if (lastEdit != null) {
            lastEdit.giveUpFocus();
        }
        e.getButton();
        if (e.getButton() == 1) {
            ActionTool pTool;
            if (e.getClickCount() == 1 && (pTool = DrawTool.CurrentTool()) != null) {
                pTool.OnLButtonClick(this, e);
            }
            if (e.getClickCount() == 2 && (pTool = DrawTool.CurrentTool()) != null) {
                pTool.OnLButtonDblClk(this, e);
            }
        }
        if (e.getButton() == 3 && !this.Sheet.isDesignMode()) {
            DBBindConfig dbc;
            JPopupMenu popupMenu = new JPopupMenu("popup");
            Border border = BorderFactory.createLineBorder(new Color(88, 88, 103));
            popupMenu.setBorder(border);
            Tools.addContextMenu(this.Sheet, popupMenu, ((WorkBook_)this.Sheet.getWorkBook()).contextMenuMap, 0);
            Tools.addContextMenu(this.Sheet, popupMenu, this.Sheet.contextMenuMap, 0);
            JMenuItem mi_copy = new JMenuItem("\u590d\u5236", new ImageIcon(Tools.GetImageFromURL(this, "excel/img/copy.gif")));
            Point p = e.getPoint();
            JMenuItem mi_refreshddlb = new JMenuItem("\u5237\u65b0\u5355\u5143\u683c\u683c\u5f0f", new ImageIcon(Tools.GetImageFromURL(this, "excel/img/refresh.gif")));
            JMenuItem mi_find = new JMenuItem("\u67e5\u627e      <Ctrl>+F", new ImageIcon(Tools.GetImageFromURL(this, "excel/img/search5.gif")));
            if (p != null) {
                int col;
                boolean isPrint = false;
                int row = this.GetRowAtPoint(false, p.y);
                cell = this.Sheet.cells(row, col = this.GetColAtPoint(false, p.x, row));
                if (cell != null) {
                    cell = cell.getLeftTopCorner();
                }
            }
            JMenu mi_prop = new JMenu("\u5c5e\u6027");
            if (cell != null) {
                EditStyle es;
                Brick brick;
                final Cell $cell = cell;
                final WorkSheetView_ self = this;
                JMenuItem mi_prop_1 = new JMenuItem("\u5355\u5143\u683c");
                mi_prop.add(mi_prop_1);
                String name = cell.getAlias();
                if (name.equals("")) {
                    name = cell.getName();
                }
                mi_prop_1.setText("\u5355\u5143\u683c:" + cell.getName() + "\u522b\u540d\uff1a" + cell.getAlias());
                mi_prop_1.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
                        StringSelection contents = new StringSelection(String.valueOf($cell.getAlias()) + " " + $cell.getName());
                        sysc.setContents(contents, WorkSheetView_.this.Sheet);
                        Tools.ShowInfo(self, "\u5355\u5143\u683c\u522b\u540d\u53ca\u540d\u79f0\u5df2\u7ecf\u590d\u5236\u5230\u526a\u8d34\u677f\u4e0a");
                    }
                });
                DBBindConfig bind = cell.getBind();
                if (bind != null) {
                    JMenuItem mi_prop_2 = new JMenuItem("\u7ed1\u5b9a");
                    mi_prop.add(mi_prop_2);
                    final String info = "\u7ed1\u5b9a\u5230:" + bind.getDataSource() + "  \u5b57\u6bb5\uff1a" + bind.getDBCol();
                    mi_prop_2.setText(info);
                    mi_prop_2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
                            StringSelection contents = new StringSelection(info);
                            sysc.setContents(contents, WorkSheetView_.this.Sheet);
                            Tools.ShowInfo(self, "\u5355\u5143\u683c\u7ed1\u5b9a\u4fe1\u606f\u5df2\u7ecf\u590d\u5236\u5230\u526a\u8d34\u677f\u4e0a");
                        }
                    });
                    JMenuItem mi_prop_3 = new JMenuItem("\u6570\u636e\u6e90Select\u8bed\u53e5");
                    mi_prop.add(mi_prop_3);
                    final String info3 = this.Sheet.getWorkBook().getDataSource(bind.getDataSource()).getDataStore().getSelectLastRetrieved();
                    mi_prop_3.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
                            StringSelection contents = new StringSelection(info3);
                            sysc.setContents(contents, WorkSheetView_.this.Sheet);
                            Tools.ShowInfo(self, "\u6570\u636e\u6e90\u7684select\u4fe1\u606f\u5df2\u7ecf\u590d\u5236\u5230\u526a\u8d34\u677f\u4e0a");
                        }
                    });
                }
                if ((brick = cell.getBrickAt(p)) != null) {
                    JMenuItem mi_prop_4 = new JMenuItem("\u5c0f\u63a7\u4ef6\uff1a" + brick.getName() + "/" + brick.getCaption());
                    mi_prop.add(mi_prop_4);
                    final String info4 = "\u5c0f\u63a7\u4ef6\uff1a" + brick.getName() + "/" + brick.getCaption();
                    mi_prop_4.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
                            StringSelection contents = new StringSelection(info4);
                            sysc.setContents(contents, WorkSheetView_.this.Sheet);
                            Tools.ShowInfo(self, "\u5c0f\u63a7\u5236\u4fe1\u606f\u5df2\u7ecf\u590d\u5236\u5230\u526a\u8d34\u677f\u4e0a");
                        }
                    });
                }
                if ((es = cell.getEditStyle()) != null) {
                    final String info5 = "\u7f16\u8f91\u65b9\u5f0f\uff1a" + es.getName() + "  " + es.getDDLBName();
                    JMenuItem mi_prop_5 = new JMenuItem("\u7f16\u8f91\u65b9\u5f0f\uff1a" + es.getEditTypeName() + " " + es.getDDLBName());
                    mi_prop.add(mi_prop_5);
                    mi_prop_5.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
                            StringSelection contents = new StringSelection(info5);
                            sysc.setContents(contents, WorkSheetView_.this.Sheet);
                            Tools.ShowInfo(self, "\u7f16\u8f91\u65b9\u5f0f\u4fe1\u606f\u5df2\u7ecf\u590d\u5236\u5230\u526a\u8d34\u677f\u4e0a");
                        }
                    });
                }
            }
            mi_copy.setFocusable(false);
            mi_copy.setToolTipText("\u5feb\u6377\u952e\uff1aCtrl + C");
            mi_copy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WorkSheetView_.this.Sheet.copy();
                }
            });
            if (cell != null && (dbc = cell.getBind()) != null && this.Sheet.getWorkBook().getDataSource(dbc.getDataSource()).isBalloonTipEditable()) {
                final int innerRow = ((Cell_)cell).getInnerRowAtPoint(p);
                JMenuItem mi_tipedit = new JMenuItem("\u6279\u6ce8", new ImageIcon(Tools.GetImageFromURL(this, "excel/img/copy.gif")));
                mi_tipedit.setFocusable(false);
                mi_tipedit.setToolTipText("\u7f16\u8f91\u6279\u6ce8");
                mi_tipedit.setBackground(Color.white);
                mi_tipedit.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        WorkSheetView_.this.Sheet.balloonTipEdit(dbc.getDataSource(), dbc.getDBCol(), innerRow);
                    }
                });
                popupMenu.add(mi_tipedit);
                popupMenu.addSeparator();
            }
            mi_refreshddlb.setToolTipText("\u5f53\u5355\u5143\u683c\u7f16\u8f91\u683c\u5f0f\u662f\u5217\u8868\u65f6\uff0c\u53ef\u4ee5\u4f7f\u7528\u672c\u529f\u80fd\u6765\u5237\u65b0\u5217\u8868\u9879\u76ee");
            mi_refreshddlb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WorkSheetView_.this.Sheet.refreshEditStyleOfCellAtPoint();
                }
            });
            mi_find.setFocusable(false);
            mi_find.setToolTipText("\u5feb\u6377\u952e\uff1aCtrl + F");
            mi_find.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WorkSheetView_.this.Sheet.getWorkBook().showFindDialog();
                }
            });
            popupMenu.add(mi_copy);
            popupMenu.add(mi_refreshddlb);
            popupMenu.add(mi_find);
            if (cell != null) {
                popupMenu.addSeparator();
                popupMenu.add(mi_prop);
            }
            popupMenu.setFocusable(false);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        ActionTool pTool = DrawTool.CurrentTool();
        if (pTool != null) {
            pTool.OnMouseEntered(this, e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        ActionTool pTool = DrawTool.CurrentTool();
        if (pTool != null) {
            pTool.OnMouseExited(this, e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ActionTool pTool = DrawTool.CurrentTool();
        if (pTool != null) {
            if (e.getButton() == 1) {
                pTool.OnLButtonDown(this, e);
            } else if (e.getButton() == 3) {
                pTool.OnRButtonDown(this, e);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        ActionTool pTool = DrawTool.CurrentTool();
        if (pTool != null && e.getButton() == 1) {
            pTool.OnLButtonUp(this, e);
        }
    }

    public Point getLeftTopOfCell(boolean isPrint, int row, int col) {
        int x = (isPrint ? 0 : this.RPM.getRowHeadWidth()) + this.CPM.getColumnX(col);
        if (col >= this.CPM.getFixedColumnCount()) {
            x -= isPrint ? this.Sheet.getXPrintOffset() : (this.RPM.isColumnScrollEnabled(row) ? this.Sheet.getXOffset() : 0);
        }
        int y = (isPrint ? 0 : this.CPM.getColumnHeadHeight()) + this.RPM.getRowY(row);
        if (row >= this.RPM.getFixedRowCount()) {
            y -= isPrint ? this.Sheet.getYPrintOffset() : this.Sheet.getYOffset();
        }
        return new Point(x, y);
    }

    public Rectangle getRectangleOfCell(boolean isPrint, int row, int col) {
        Point p = this.getLeftTopOfCell(isPrint, row, col);
        return new Rectangle(p.x, p.y, this.CPM.getColumnWidth(col), this.RPM.getRowHeight(row));
    }

    public Rectangle getShowRectangleOfCell(boolean isPrint, int row, int col) {
        Cell cell = this.Sheet.$Cells(row, col);
        if (cell != null && cell.isMerged()) {
            Range r = ((MergedRange)this.Sheet.getMergeMap().get(cell)).getMergedRange();
            return this.getRectangleOfRange(isPrint, r);
        }
        return this.getRectangleOfCell(isPrint, row, col);
    }

    public Point getLeftTopPointOfSelection() {
        Range_ r = (Range_)this.Sheet.getSelection();
        Point lt = this.getLeftTopOfCell(false, r.StartRow, r.StartCol);
        return lt;
    }

    public Point getRightBottomPointOfSelection() {
        Range_ r = (Range_)this.Sheet.getSelection();
        Point rb = this.getLeftTopOfCell(false, r.EndRow, r.EndCol);
        rb.x += this.CPM.getColumnWidth(r.EndCol);
        rb.y += this.RPM.getRowHeight(r.EndRow);
        return rb;
    }

    public Rectangle getRectangleOfSelection() {
        Range sel;
        if (this.Sheet == null) {
            System.out.println("\u5f02\u5e38\uff1agetRectangleOfSelection\u4e2d sheet=null");
        }
        if ((sel = this.Sheet.getSelection()) == null) {
            System.out.println("\u5f02\u5e38\uff1agetRectangleOfSelection\u4e2d selection=null");
            sel = new Range_(1, 1, 1, 1);
        }
        return this.getRectangleOfRange(false, sel);
    }

    public Rectangle getRectangleOfRange(boolean isPrint, Range range) {
        Range_ r = (Range_)range;
        int StartRow = Math.max(0, r.StartRow);
        int StartCol = Math.max(0, r.StartCol);
        int EndRow = Math.min(this.RPM.getRowCount() - 1, r.EndRow);
        int EndCol = Math.min(this.CPM.getColumnCount() - 1, r.EndCol);
        Point lt = this.getLeftTopOfCell(isPrint, StartRow, StartCol);
        Point rb = this.getLeftTopOfCell(isPrint, EndRow, EndCol);
        rb.x += this.CPM.getColumnWidth(EndCol);
        rb.y += this.RPM.getRowHeight(EndRow);
        int w = rb.x - lt.x;
        int h = rb.y - lt.y;
        if (w < 0) {
            w = this.getFixedPointX() - lt.x;
        }
        if (h < 0) {
            h = this.getFixedPointY() - lt.y;
        }
        return new Rectangle(lt.x, lt.y, Math.max(0, w), Math.max(0, h));
    }

    public Rectangle getEditRectangleOfRange(Range range) {
        Range_ r = (Range_)range;
        int row = r.StartRow;
        int col = r.StartCol;
        Rectangle rect = this.getShowRectangleOfCell(false, row, col);
        Rectangle editRC = (Rectangle)rect.clone();
        Cell_ cell = (Cell_)this.Sheet.Cells(row, col);
        editRC = cell.getTextRectangleOfCell(editRC);
        BasicEdit.adjustBounds(editRC, 1);
        DBBindConfig bind = cell.getBind();
        RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
        boolean groupRowVisible = RPM.isGroupRowVisible(row);
        int dbRowHeight = RPM.getDBRowHeight(row);
        int yOffset = RPM.getRowScrolledRowCount(row) * RPM.getDBRowHeight(row);
        boolean isBindToMultiRowDataSource = false;
        if (bind != null) {
            DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(bind.getDataSource());
            int innerRow = 0;
            if (bind.getDataSourceType() == 1) {
                innerRow = 0;
            } else if (bind.getDataSourceType() == 4) {
                innerRow = 0;
            } else {
                innerRow = dsc.getCurrentBindRow();
                Rectangle rctemp = this.getShowRectangleOfCell(false, row, col);
                if (!groupRowVisible) {
                    editRC.y += innerRow * dbRowHeight - yOffset;
                } else {
                    DataStore ds = cell.getDataStore();
                    Hashtable MapGroups = (Hashtable)ds.getFriendlyProperty("m_MapGroups");
                    int height = 0;
                    int i = 0;
                    while (i < innerRow) {
                        height += dbRowHeight;
                        Integer key = new Integer(i);
                        if (MapGroups.containsKey(key)) {
                            ArrayList pVec = (ArrayList)MapGroups.get(key);
                            int gc = pVec.size();
                            height += gc * dbRowHeight;
                        }
                        ++i;
                    }
                    editRC.y += height - yOffset;
                }
                editRC.height = dbRowHeight - 1;
            }
        }
        return editRC;
    }

    public Point getFixedPoint() {
        Point ret = new Point();
        ret.x = this.getFixedPointX();
        ret.y = this.getFixedPointY();
        return ret;
    }

    public int getFixedPointX() {
        return this.RPM.getRowHeadWidth() + this.CPM.getFixedColumnWidth();
    }

    public int getFixedPointY() {
        return this.CPM.getColumnHeadHeight() + this.RPM.getFixedRowHeight();
    }

    public Rectangle getClipRectangleOfRange(Range range) {
        Range_ r = (Range_)range;
        Rectangle ret = this.getBounds();
        if (r.StartRow >= this.RPM.getFixedRowCount()) {
            ret.y = this.CPM.getColumnHeadHeight() + this.RPM.getFixedRowHeight() - 1;
        }
        if (r.StartCol >= this.CPM.getFixedColumnCount()) {
            ret.x = this.RPM.getRowHeadWidth() + this.CPM.getFixedColumnWidth() - 1;
        }
        ret.height -= ret.y;
        ret.width -= ret.x;
        ret.height = Math.max(0, ret.height);
        ret.width = Math.max(0, ret.width);
        return ret;
    }

    private void DrawSelection(Graphics2D g) {
        Range r = this.Sheet.getSelection();
        Cell cell = null;
        cell = this.Sheet.$Cells(r.getStartRow(), r.getStartCol());
        if (cell != null && cell.isEditing() && cell.getDecorate() == null) {
            Edit edit = this.$getCurrentEditingEdit();
            if (edit != null && edit instanceof DropDownListBox && (((DropDownListBox)edit).ES.isListShowAsCheckBox() || ((DropDownListBox)edit).ES.isListShowAsRadioButton()) && !this.Sheet.isDesignMode()) {
                return;
            }
            g.setColor(new Color(148, 181, 125));
            g.setColor(Color.WHITE);
            if (this.CurrentEditControlBounds == null) {
                return;
            }
            Rectangle rc = this.CurrentEditControlBounds;
            float f = this.Sheet.getGridLineVisible() ? 0.0f : 0.0f;
            AlphaComposite ac = AlphaComposite.getInstance(3, 0.3f + f);
            g.setComposite(ac);
            g.drawRect(rc.x - 1, rc.y - 1, rc.width + 1, rc.height + 1);
            g.setColor(new Color(186));
            g.drawRect(rc.x - 1, rc.y - 1, rc.width + 1, rc.height + 1);
            ac = AlphaComposite.getInstance(3, 0.1f + f);
            g.setComposite(ac);
            g.drawRect(rc.x - 2, rc.y - 2, rc.width + 3, rc.height + 3);
            ac = AlphaComposite.getInstance(3, 0.05f + f);
            g.setComposite(ac);
            g.drawRect(rc.x - 3, rc.y - 3, rc.width + 5, rc.height + 5);
            ac = AlphaComposite.getInstance(3, 0.01f + f);
            g.setComposite(ac);
            g.drawRect(rc.x - 4, rc.y - 4, rc.width + 7, rc.height + 7);
            ac = AlphaComposite.getInstance(3, 1.0f);
            g.setComposite(ac);
            return;
        }
        if (!this.Sheet.isDesignMode()) {
            return;
        }
        Rectangle rc = this.getRectangleOfSelection();
        Rectangle clip = this.getClipRectangleOfRange(r);
        Shape oldClip = g.getClip();
        try {
            try {
                Tools.clip(g, clip);
                AlphaComposite ac = AlphaComposite.getInstance(3, 0.3f);
                g.setComposite(ac);
                g.setColor(new Color(92, 108, 150));
                g.fill(rc);
                ac = AlphaComposite.getInstance(3, 0.9f);
                g.setComposite(ac);
                Stroke oldStroke = g.getStroke();
                g.setStroke(Tools.getStroke(3.0f, 0, 0));
                g.setColor(Color.BLACK);
                g.draw(new Rectangle2D.Float(rc.x, rc.y, rc.width, rc.height));
                g.setStroke(oldStroke);
                g.setColor(Color.WHITE);
                g.drawRect(rc.x + 2, rc.y + 2, rc.width - 4, rc.height - 4);
                Point p = this.getRightBottomPointOfSelection();
                if (rc.x + rc.width == p.x && rc.y + rc.height == p.y) {
                    Rectangle rect = new Rectangle();
                    rect.x = rc.x + rc.width - 3;
                    rect.y = rc.y + rc.height - 3;
                    rect.width = 6;
                    rect.height = 6;
                    g.setColor(Color.WHITE);
                    g.fill(rect);
                    ++rect.x;
                    ++rect.y;
                    rect.width = 5;
                    rect.height = 5;
                    g.setColor(Color.BLACK);
                    g.fill(rect);
                }
            }
            catch (Exception exception) {
                Tools.setClip(g, oldClip);
            }
        }
        finally {
            Tools.setClip(g, oldClip);
        }
    }

    private void DrawSplash(Graphics2D g) {
        if (!this.splashOn) {
            return;
        }
        Range r = this.Sheet.getSelection();
        if (r == null) {
            return;
        }
        Rectangle rc = this.getEditRectangleOfRange(r);
        Rectangle clip = this.getClipRectangleOfRange(r);
        Shape oldClip = g.getClip();
        try {
            try {
                Tools.clip(g, clip);
                AlphaComposite ac = AlphaComposite.getInstance(3, 0.7f);
                g.setComposite(ac);
                g.setColor(new Color(255, 0, 0));
                g.fill(rc);
            }
            catch (Exception exception) {
                Tools.setClip(g, oldClip);
            }
        }
        finally {
            Tools.setClip(g, oldClip);
        }
    }

    private void DrawMovingSelection(Graphics2D g) {
        Range r = this.Sheet.getMovingSelection();
        if (r == null) {
            return;
        }
        Rectangle rc = this.getRectangleOfRange(false, r);
        Rectangle clip = this.getClipRectangleOfRange(r);
        Shape oldClip = g.getClip();
        try {
            try {
                Tools.clip(g, clip);
                AlphaComposite ac = AlphaComposite.getInstance(3, 0.3f);
                g.setComposite(ac);
                g.setColor(new Color(147, 215, 0));
                g.fill(rc);
                ac = AlphaComposite.getInstance(3, 0.5f);
                g.setComposite(ac);
                Stroke oldStroke = g.getStroke();
                float[] dash = new float[]{1.0f};
                g.setStroke(Tools.getStroke(3.0f, 0, 0, 10.0f, dash, 1.0f));
                g.setColor(Color.GRAY);
                g.draw(new Rectangle2D.Float(rc.x, rc.y, rc.width, rc.height));
            }
            catch (Exception exception) {
                Tools.setClip(g, oldClip);
            }
        }
        finally {
            Tools.setClip(g, oldClip);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyPressed(e, -1, -1, -1);
    }

    public void keyPressed(KeyEvent e, int editingRow, int editingCol, int dbRow) {
        ((WorkBookView_)this.getWorkSheet().getWorkBook().getWorkBookView()).lastKeyEvent = e;
        switch (e.getKeyCode()) {
            case 117: {
                if (e.isControlDown()) {
                    ColumnPropertyManage CPM = this.Sheet.getColumnPropertyManage();
                    int h = CPM.getColumnHeadHeight();
                    h = h == 0 ? 21 : 0;
                    CPM.setColumnHeadHeight(h);
                    this.repaint();
                }
                if (!e.isShiftDown()) break;
                RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
                int w = RPM.getRowHeadWidth();
                w = w == 0 ? 40 : 0;
                RPM.setRowHeadWidth(w);
                this.repaint();
                break;
            }
            case 118: {
                if (!e.isControlDown()) break;
                boolean b = this.Sheet.getColumnPropertyManage().isShowColumnIndex();
                this.Sheet.getColumnPropertyManage().setShowColumnIndex(!b);
                break;
            }
            case 70: {
                if (!e.isControlDown()) break;
                this.Sheet.getWorkBook().showFindDialog();
                break;
            }
            case 90: {
                if (!e.isControlDown()) break;
                this.Sheet.getCommandManage().Undo();
                break;
            }
            case 89: {
                if (!e.isControlDown()) break;
                this.Sheet.getCommandManage().Redo();
                break;
            }
            case 67: {
                System.out.println(" CTRL +C \u6309\u4e0b");
                if (!e.isControlDown()) break;
                this.Sheet.copy();
                break;
            }
            case 86: {
                if (!e.isControlDown()) break;
                this.Sheet.paste();
                break;
            }
            case 88: {
                if (!e.isControlDown()) break;
                this.Sheet.cut();
                break;
            }
            case 38: {
                this.OnKeyDownVK_UP(e);
                break;
            }
            case 40: {
                this.OnKeyDownVK_DOWN(e);
                break;
            }
            case 37: {
                this.OnKeyDownVK_LEFT(e);
                break;
            }
            case 39: {
                this.OnKeyDownVK_RIGHT(e);
                break;
            }
            case 10: {
                if (e.isControlDown()) {
                    this.OnKeyDownVK_DOWN(e);
                    break;
                }
                this.OnKeyDownVK_TAB(e);
                break;
            }
            case 9: {
                this.OnKeyDownVK_TAB(e);
                break;
            }
            case 33: {
                this.OnKeyDownVK_PAGEUP(e);
                break;
            }
            case 34: {
                this.OnKeyDownVK_PAGEDOWN(e);
                break;
            }
        }
        ActionTool pTool = DrawTool.CurrentTool();
        if (pTool != null) {
            pTool.keyPressed(this, e);
        }
        this.Sheet.getWorkBook().getEM().fireKeyPressed(this.Sheet, e, editingRow, editingCol, dbRow);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyReleased(e, -1, -1, -1);
    }

    public void keyReleased(KeyEvent e, int editingRow, int editingCol, int dbRow) {
        ((WorkBookView_)this.getWorkSheet().getWorkBook().getWorkBookView()).lastKeyEvent = e;
        ActionTool pTool = DrawTool.CurrentTool();
        if (pTool != null) {
            pTool.keyReleased(this, e);
        }
        this.Sheet.getWorkBook().getEM().fireKeyReleased(this.Sheet, e, editingRow, editingCol, dbRow);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        ((WorkBookView_)this.getWorkSheet().getWorkBook().getWorkBookView()).lastKeyEvent = e;
        char keyChar = e.getKeyChar();
        if ((e.isAltDown() || e.isControlDown() || e.isShiftDown()) && keyChar != '\n') {
            return;
        }
        Range r = this.Sheet.getSelection();
        int row = r.getStartRow();
        int col = r.getStartCol();
        String value = null;
        if (keyChar == '\u001b') {
            return;
        }
        if (keyChar == '\t') {
            return;
        }
        if (keyChar != '\b' && keyChar != ' ' && keyChar != '\n') {
            value = String.valueOf(keyChar);
        }
        this.$beginEdit(row, col, value, null, -1);
    }

    @Override
    public void beginEdit() {
        Edit edit = this.$getCurrentEditingEdit();
        if (edit != null) {
            edit.reloadEdit();
        } else {
            Range r = this.Sheet.getSelection();
            int row = r.getEndRow();
            int col = r.getEndCol();
            this.$beginEdit(row, col, null, null, -1);
        }
    }

    @Override
    public void beginEdit(int row, int col) {
        this.$beginEdit(row, col, null, null, -1);
    }

    @Override
    public void beginEditNextCell() {
        this.OnKeyDownVK_TAB(null);
        this.beginEdit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void $beginEdit(int row, int col, String value, MouseEvent mouseEvent, int innerRow) {
        Edit lastEdit = this.$getCurrentEditingEdit();
        int lastRow = -1;
        int lastCol = -1;
        int lastInnerRow = -1;
        Cell cell = this.Sheet.$Cells(row, col);
        if (!this.Sheet.isDesignMode() && cell == null) {
            return;
        }
        cell = this.Sheet.Cells(row, col);
        this.Sheet.setSelection(cell);
        DBBindConfig dbc = cell.getBind();
        if (dbc != null) {
            if (this.Sheet.getWorkBook().getDataSource(dbc.getDataSource()).getDataStore().getRowCount() == 0) {
                return;
            }
            DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(dbc.getDataSource());
            if (dbc.getDataSourceType() == 1) {
                innerRow = 0;
            } else if (dbc.getDataSourceType() == 4) {
                innerRow = dsc.getCurrentBindRow();
            } else if (innerRow == -1) {
                innerRow = dsc.getCurrentBindRow();
            }
            if (innerRow < 0) {
                return;
            }
        }
        boolean readOnlyMode = false;
        EditStyle es = cell.getEditStyle();
        if (!this.Sheet.isDesignMode()) {
            boolean canEdit = cell.isEditable();
            if (canEdit) {
                canEdit = this.Sheet.getWorkBook().getEM().fireIsCellEditable(this.Sheet, cell, innerRow);
            }
            if (!canEdit) {
                if (mouseEvent == null) {
                    this.OnKeyDownVK_TAB(null);
                }
                if (lastEdit != null) {
                    lastEdit.giveUpFocus();
                }
                if (es == null) return;
                if (es.getEditType() != 2 && (es.getEditType() != 7 || cell.getBind() == null)) return;
                readOnlyMode = true;
            }
        }
        Edit NE = this.getWorkSheet().getWorkBook().createEditComponent(es);
        this.InsureSelectionOnScreen(mouseEvent == null ? null : mouseEvent.getPoint());
        this.add(NE.getComponent());
        if (lastEdit != null) {
            lastEdit.stopFocusTimer();
            lastEdit.removeSelf();
            lastEdit.getCell().repaint();
            lastEdit.giveUpFocus();
            lastRow = lastEdit.getCell().getRowIndex();
            lastCol = lastEdit.getCell().getColumnIndex();
            lastInnerRow = lastEdit.getCurrentDBRow();
        }
        this.$setCurrentEditingEdit(NE);
        if (dbc != null) {
            this.$setCurrentEditintDSN(dbc.getDataSource());
        }
        this.Sheet.moveToFocusRange(row, col);
        Rectangle rc = this.getShowRectangleOfCell(false, row, col);
        NE.beginEdit(this.Sheet, this, row, col, value, rc, mouseEvent, innerRow, readOnlyMode);
        if (lastRow == row && lastCol == col && lastInnerRow == innerRow) {
            NE.giveUpFocus();
        }
        this.Sheet.getWorkBook().getEM().fireEditFocusChanged(this.Sheet, lastRow, lastCol, row, col);
    }

    public Edit $getCurrentEditingEdit() {
        if (this.currentEditingEdit != null) {
            return this.currentEditingEdit;
        }
        ArrayList<WorkSheetView> already = new ArrayList<WorkSheetView>();
        return this.$getCurrentEditingEdit(already);
    }

    private Edit $getCurrentEditingEdit(ArrayList<WorkSheetView> already) {
        Edit edit;
        WorkSheetView_ view;
        if (this.currentEditingEdit != null) {
            return this.currentEditingEdit;
        }
        if (already.contains(this)) {
            return null;
        }
        already.add(this);
        int i = 0;
        while (i < this.Sheet.cellPanelList.size()) {
            view = (WorkSheetView_)this.Sheet.cellPanelList.get(i).getInnerSheet().getWorkSheetView();
            edit = view.$getCurrentEditingEdit(already);
            if (edit != null) {
                return edit;
            }
            ++i;
        }
        CellPanel cp = this.Sheet.getContainerCellPanel();
        if (cp != null) {
            if (cp.getParentSheet() == null) {
                return null;
            }
            view = (WorkSheetView_)cp.getParentSheet().getWorkSheetView();
            edit = view.$getCurrentEditingEdit(already);
            return edit;
        }
        return null;
    }

    public void $setCurrentEditingEdit(Edit edit) {
        if (edit == null) {
            return;
        }
        this.currentEditingEdit = edit;
    }

    public void $clearCurrentEditingEdit(Edit edit) {
        if (edit == this.currentEditingEdit) {
            this.currentEditingEdit = null;
        }
    }

    @Override
    public void InsureSelectionOnScreen() {
        this.InsureSelectionOnScreen(null);
    }

    public void InsureSelectionOnScreen(Point mouse) {
        Range r = this.Sheet.getSelection();
        Rectangle rc = this.getRectangleOfRange(false, r);
        int row = r.getStartRow();
        int col = r.getStartCol();
        if (row >= this.RPM.getFixedRowCount()) {
            DBBindConfig bind;
            boolean innerRowInsured = false;
            Cell_ cell = (Cell_)this.Sheet.$Cells(row, col);
            int dbRowHeight = this.RPM.getDBRowHeight(row);
            if (cell != null && (bind = cell.getBind()) != null) {
                WorkBook_ book = (WorkBook_)this.Sheet.getWorkBook();
                DataSourceConfig dsc = book.getDataSource(bind.getDataSource());
                if (bind.getDataSourceType() == 2) {
                    Rectangle rect = this.getShowRectangleOfCell(false, row, col);
                    int dbRow = mouse != null ? (rect.contains(mouse) ? (mouse.y - rect.y) / dbRowHeight : 0) : dsc.getCurrentBindRow();
                    boolean groupRowVisible = this.RPM.isGroupRowVisible(row);
                    int innerRowY = rect.y + (dbRow - this.RPM.getRowScrolledRowCount(row)) * dbRowHeight;
                    int innerDelta = innerRowY - (this.CPM.getColumnHeadHeight() + this.RPM.getFixedRowHeight());
                    if (innerDelta < 0) {
                        this.Sheet.setYOffset(this.Sheet.getYOffset() + innerDelta);
                        if (mouse != null) {
                            mouse.y -= innerDelta;
                        }
                    }
                    rect = this.getShowRectangleOfCell(false, row, col);
                    int innerRowY2 = rect.y + (dbRow - this.RPM.getRowScrolledRowCount(row)) * dbRowHeight;
                    int innerDelta2 = (innerRowY2 += dbRowHeight) - this.getHeight();
                    if (innerDelta2 >= 0) {
                        this.Sheet.setYOffset(this.Sheet.getYOffset() + innerDelta2 + 10);
                        if (mouse != null) {
                            mouse.y -= innerDelta2;
                        }
                    }
                    innerRowInsured = true;
                }
            }
            if (!innerRowInsured) {
                int delta = rc.y - (this.CPM.getColumnHeadHeight() + this.RPM.getFixedRowHeight());
                if (delta < 0) {
                    this.Sheet.setYOffset(this.Sheet.getYOffset() + delta);
                }
                rc = this.getRectangleOfRange(false, r);
                int delta2 = rc.y + rc.height - this.getHeight();
                if (delta2 >= 0) {
                    this.Sheet.setYOffset(this.Sheet.getYOffset() + delta2 + 10);
                }
            }
        }
        rc = this.getRectangleOfRange(false, r);
        if (col >= this.CPM.getFixedColumnCount()) {
            int delta = rc.x - (this.RPM.getRowHeadWidth() + this.CPM.getFixedColumnWidth());
            if (delta < 0) {
                this.Sheet.setXOffset(this.Sheet.getXOffset() + delta);
            }
            rc = this.getRectangleOfRange(false, r);
            delta = rc.x + rc.width - this.getWidth();
            if (delta >= 0) {
                this.Sheet.setXOffset(this.Sheet.getXOffset() + delta + 2);
            }
        }
    }

    public void OnKeyDownVK_UP(KeyEvent e) {
        if (this.Sheet.isDesignMode()) {
            this.OnKeyDownVK_UP_DesignMode(e);
        } else {
            this.OnKeyDownVK_UP_RunMode(e);
        }
    }

    public void OnKeyDownVK_UP_RunMode(KeyEvent e) {
        Range r = this.Sheet.getSelection();
        int row = r.getStartRow();
        int col = r.getStartCol();
        this.JumpToPriorRowEditableObject(row, col);
        this.InsureSelectionOnScreen(null);
    }

    public void OnKeyDownVK_UP_DesignMode(KeyEvent e) {
        Range r = this.Sheet.getSelection();
        if (e.isShiftDown()) {
            int row = r.getEndRow();
            if (row <= r.getStartRow()) {
                return;
            }
            this.Sheet.setSelection(new Range_(r.getStartRow(), r.getStartCol(), --row, r.getEndCol()));
        } else {
            int row = r.getStartRow();
            if (row == 0) {
                return;
            }
            this.Sheet.setSelection(new Range_(--row, r.getStartCol(), row, r.getEndCol()));
        }
        this.InsureSelectionOnScreen(null);
    }

    public void OnKeyDownVK_DOWN(KeyEvent e) {
        if (this.Sheet.isDesignMode()) {
            this.OnKeyDownVK_DOWN_DesignMode(e);
        } else {
            this.OnKeyDownVK_DOWN_RunMode(e);
        }
    }

    public void OnKeyDownVK_DOWN_RunMode(KeyEvent e) {
        Range r = this.Sheet.getSelection();
        int row = r.getEndRow();
        int col = r.getEndCol();
        this.JumpToNextRowEditableObject(row, col);
        this.InsureSelectionOnScreen(null);
    }

    public void OnKeyDownVK_DOWN_DesignMode(KeyEvent e) {
        Range r = this.Sheet.getSelection();
        int row = r.getEndRow();
        if (row + 1 == this.RPM.getRowCount()) {
            return;
        }
        this.Sheet.setSelection(new Range_(e.isShiftDown() ? r.getStartRow() : ++row, r.getStartCol(), row, r.getEndCol()));
        this.InsureSelectionOnScreen(null);
    }

    public void OnKeyDownVK_LEFT(KeyEvent e) {
        Range r = this.Sheet.getSelection();
        if (e.isShiftDown()) {
            int col = r.getEndCol();
            if (col <= r.getStartCol()) {
                return;
            }
            this.Sheet.setSelection(new Range_(r.getStartRow(), r.getStartCol(), r.getEndRow(), --col));
        } else {
            int col = r.getStartCol();
            if (col == 0) {
                return;
            }
            this.Sheet.setSelection(new Range_(r.getStartRow(), --col, r.getEndRow(), col));
        }
        this.InsureSelectionOnScreen(null);
    }

    public void OnKeyDownVK_RIGHT(KeyEvent e) {
        Range r = this.Sheet.getSelection();
        int col = r.getEndCol();
        if (col + 1 == this.CPM.getColumnCount()) {
            return;
        }
        this.Sheet.setSelection(new Range_(r.getStartRow(), e.isShiftDown() ? r.getStartCol() : ++col, r.getEndRow(), col));
        this.InsureSelectionOnScreen(null);
    }

    public void OnKeyDownVK_PAGEUP(KeyEvent e) {
    }

    public void OnKeyDownVK_PAGEDOWN(KeyEvent e) {
    }

    public void OnKeyDownVK_TAB(KeyEvent e) {
        if (this.Sheet.isDesignMode()) {
            this.OnKeyDownVK_TAB_DesignMode(e);
        } else {
            this.OnKeyDownVK_TAB_RunMode(e);
        }
    }

    @Override
    public boolean findNext(String key, boolean caseSensitive, boolean fullMatch, boolean onlyDB) {
        this.Sheet.setPaintPermit(false);
        Range r = this.Sheet.getSelection();
        int row = r.getEndRow();
        int col = r.getEndCol();
        boolean b = this.JumpToNextColumnFind(row, col, key, caseSensitive, fullMatch, onlyDB);
        this.InsureSelectionOnScreen(null);
        this.Sheet.setPaintPermit(true);
        return b;
    }

    @Override
    public boolean findPrior(String key, boolean caseSensitive, boolean fullMatch, boolean onlyDB) {
        this.Sheet.setPaintPermit(false);
        Range r = this.Sheet.getSelection();
        int row = r.getEndRow();
        int col = r.getEndCol();
        boolean b = this.JumpToPriorColumnFind(row, col, key, caseSensitive, fullMatch, onlyDB);
        this.InsureSelectionOnScreen(null);
        this.Sheet.setPaintPermit(true);
        return b;
    }

    public boolean JumpToNextColumnFind(int row, int col, String key, boolean caseSensitive, boolean fullMatch, boolean onlyDB) {
        Cell cell;
        Range focusRange;
        int leftTopCornerRow = row;
        Cell leftTopCornerOfCurrentCell = this.Sheet.cells(row, col);
        if (leftTopCornerOfCurrentCell != null) {
            leftTopCornerOfCurrentCell = leftTopCornerOfCurrentCell.getLeftTopCorner();
            leftTopCornerRow = leftTopCornerOfCurrentCell.getRowIndex();
        }
        if (col >= (focusRange = this.Sheet.getCurrentFocusRange()).getEndCol()) {
            DBBindConfig bind;
            int lastCol = Cell_.findLastColumnWhichBindToSomeDataSource(this.Sheet, leftTopCornerRow, "", focusRange.getStartCol(), focusRange.getEndCol(), false);
            Cell cell2 = this.Sheet.$Cells(leftTopCornerRow, lastCol);
            if (cell2 != null && (bind = (cell2 = cell2.getLeftTopCorner()).getBind()) != null) {
                int firstCol;
                int RC;
                int currentRow;
                DataStore ds;
                DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(bind.getDataSource());
                if (bind.getDataSourceType() == 2 && (ds = dsc.getDataStore()).getRowCount() > 0 && (currentRow = dsc.getCurrentBindRow() + 1) < (RC = ds.getRowCount()) && (firstCol = Cell_.findFirstColumnWhichBindToSomeDataSource(this.Sheet, leftTopCornerRow, bind.getDataSource(), focusRange.getStartCol(), focusRange.getEndCol(), false)) >= 0) {
                    this.Sheet.setSelection(new Range_(row, firstCol, row, firstCol));
                    dsc.setCurrentBindRow(currentRow);
                    return this.JumpToNextColumnFind(row, firstCol, key, caseSensitive, fullMatch, onlyDB);
                }
            }
            if (row == focusRange.getEndRow() || row == this.Sheet.getRowCount() - 1 || leftTopCornerRow == focusRange.getEndRow() || leftTopCornerRow == this.Sheet.getRowCount() - 1) {
                if (this.Sheet.isInLastFocusRange()) {
                    return false;
                }
                this.Sheet.moveToNextFocusRange();
                focusRange = this.Sheet.getCurrentFocusRange();
                return this.JumpToNextColumnFind(focusRange.getStartRow(), focusRange.getStartCol() - 1, key, caseSensitive, fullMatch, onlyDB);
            }
            col = focusRange.getStartCol() - 1;
            return this.JumpToNextColumnFind(++row, col, key, caseSensitive, fullMatch, onlyDB);
        }
        if ((cell = this.Sheet.$Cells(row, ++col)) != null) {
            DBBindConfig dbc = (cell = cell.getLeftTopCorner()).getBind();
            if (dbc == null) {
                if (!onlyDB && Tools.stringMatch(cell.getValue(), cell.getShowText(), key, caseSensitive, fullMatch)) {
                    this.Sheet.setSelection(new Range_(row, col, row, col));
                    return true;
                }
            } else {
                DataStore ds = this.Sheet.getWorkBook().getDataSource(dbc.getDataSource()).getDataStore();
                String dsn = dbc.getDataSource();
                DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(dsn);
                int dbRow = dsc.getCurrentBindRow();
                if (ds.getRowCount() > 0 && Tools.stringMatch(ds.getValue(dbRow, dbc.getDBCol()), cell.getShowText(dbRow), key, caseSensitive, fullMatch)) {
                    this.Sheet.setSelection(new Range_(row, col, row, col));
                    this.splash(true);
                    return true;
                }
            }
        }
        return this.JumpToNextColumnFind(row, col, key, caseSensitive, fullMatch, onlyDB);
    }

    public boolean JumpToPriorColumnFind(int row, int col, String key, boolean caseSensitive, boolean fullMatch, boolean onlyDB) {
        Cell cell;
        Range focusRange;
        int leftTopCornerRow = row;
        int leftTopCornerCol = col;
        Cell leftTopCornerOfCurrentCell = this.Sheet.cells(row, col);
        if (leftTopCornerOfCurrentCell != null) {
            leftTopCornerOfCurrentCell = leftTopCornerOfCurrentCell.getLeftTopCorner();
            leftTopCornerRow = leftTopCornerOfCurrentCell.getRowIndex();
            leftTopCornerCol = leftTopCornerOfCurrentCell.getColumnIndex();
        }
        if (col <= (focusRange = this.Sheet.getCurrentFocusRange()).getStartCol()) {
            DBBindConfig bind;
            int lastCol = Cell_.findLastColumnWhichBindToSomeDataSource(this.Sheet, leftTopCornerRow, "", focusRange.getStartCol(), focusRange.getEndCol(), false);
            Cell cell2 = this.Sheet.$Cells(leftTopCornerRow, lastCol);
            if (cell2 != null && (bind = (cell2 = cell2.getLeftTopCorner()).getBind()) != null) {
                int currentRow;
                DataStore ds;
                int RC;
                DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(bind.getDataSource());
                if (bind.getDataSourceType() == 2 && (RC = (ds = dsc.getDataStore()).getRowCount()) > 0 && (currentRow = dsc.getCurrentBindRow() - 1) >= 0 && (lastCol = Cell_.findLastColumnWhichBindToSomeDataSource(this.Sheet, leftTopCornerRow, bind.getDataSource(), focusRange.getStartCol(), focusRange.getEndCol(), false)) >= 0) {
                    this.Sheet.setSelection(new Range_(row, lastCol, row, lastCol));
                    dsc.setCurrentBindRow(currentRow);
                    return this.JumpToPriorColumnFind(row, lastCol, key, caseSensitive, fullMatch, onlyDB);
                }
            }
            if (row == focusRange.getStartRow() || leftTopCornerRow == focusRange.getStartRow() || row == 0 || leftTopCornerRow == 0) {
                if (this.Sheet.isInFirstFocusRange()) {
                    return false;
                }
                this.Sheet.moveToPriorFocusRange();
                focusRange = this.Sheet.getCurrentFocusRange();
                return this.JumpToPriorColumnFind(focusRange.getEndRow(), focusRange.getEndCol() + 1, key, caseSensitive, fullMatch, onlyDB);
            }
            row = leftTopCornerRow;
            col = focusRange.getEndCol() + 1;
            return this.JumpToPriorColumnFind(--row, col, key, caseSensitive, fullMatch, onlyDB);
        }
        col = leftTopCornerCol;
        if ((cell = this.Sheet.$Cells(row, --col)) != null) {
            DBBindConfig dbc = (cell = cell.getLeftTopCorner()).getBind();
            if (dbc == null) {
                if (!onlyDB && Tools.stringMatch(cell.getValue(), cell.getShowText(), key, caseSensitive, fullMatch)) {
                    this.Sheet.setSelection(new Range_(row, col, row, col));
                    return true;
                }
            } else if (this.Sheet.getWorkBook().getDataSource(dbc.getDataSource()).getDataStore().getRowCount() > 0) {
                this.Sheet.setSelection(new Range_(row, col, row, col));
                String dsn = dbc.getDataSource();
                DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(dsn);
                DataStore ds = this.Sheet.getWorkBook().getDataSource(dbc.getDataSource()).getDataStore();
                int dbRow = dsc.getCurrentBindRow();
                int rc = dsc.getDataStore().getRowCount();
                if (rc > 0 && Tools.stringMatch(ds.getValue(dbRow, dbc.getDBCol()), cell.getShowText(dbRow), key, caseSensitive, fullMatch)) {
                    this.Sheet.setSelection(new Range_(row, col, row, col));
                    this.splash(true);
                    return true;
                }
            }
        }
        return this.JumpToPriorColumnFind(row, col, key, caseSensitive, fullMatch, onlyDB);
    }

    public void OnKeyDownVK_TAB_RunMode(KeyEvent e) {
        this.Sheet.setPaintPermit(false);
        Range r = this.Sheet.getSelection();
        boolean isShiftDown = false;
        if (e != null) {
            isShiftDown = e.isShiftDown();
        }
        if (isShiftDown) {
            int row = r.getEndRow();
            int col = r.getEndCol();
            this.JumpToPriorColumnEditableObject(row, col);
        } else {
            int row = r.getEndRow();
            int col = r.getEndCol();
            this.JumpToNextColumnEditableObject(row, col);
        }
        this.InsureSelectionOnScreen(null);
        this.Sheet.setPaintPermit(true);
    }

    public void JumpToNextColumnEditableObject(int row, int col) {
        Cell cell;
        Range focusRange;
        int leftTopCornerRow = row;
        Cell leftTopCornerOfCurrentCell = this.Sheet.cells(row, col);
        if (leftTopCornerOfCurrentCell != null) {
            leftTopCornerOfCurrentCell = leftTopCornerOfCurrentCell.getLeftTopCorner();
            leftTopCornerRow = leftTopCornerOfCurrentCell.getRowIndex();
        }
        if (col >= (focusRange = this.Sheet.getCurrentFocusRange()).getEndCol()) {
            DBBindConfig bind;
            int lastCol = Cell_.findLastColumnWhichBindToSomeDataSource(this.Sheet, leftTopCornerRow, this.$getCurrentEditintDSN(), focusRange.getStartCol(), focusRange.getEndCol(), true);
            Cell cell2 = this.Sheet.$Cells(leftTopCornerRow, lastCol);
            if (cell2 != null && (bind = (cell2 = cell2.getLeftTopCorner()).getBind()) != null) {
                int firstCol;
                int RC;
                int currentRow;
                DataStore ds;
                DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(bind.getDataSource());
                if (bind.getDataSourceType() == 2 && (ds = dsc.getDataStore()).getRowCount() > 0 && (currentRow = dsc.getCurrentBindRow() + 1) < (RC = ds.getRowCount()) && (firstCol = Cell_.findFirstColumnWhichBindToSomeDataSource(this.Sheet, leftTopCornerRow, bind.getDataSource(), focusRange.getStartCol(), focusRange.getEndCol(), true)) >= 0) {
                    this.Sheet.setSelection(new Range_(row, firstCol, row, firstCol));
                    dsc.setCurrentBindRow(currentRow);
                    return;
                }
            }
            if (row == focusRange.getEndRow() || row == this.Sheet.getRowCount() - 1 || leftTopCornerRow == focusRange.getEndRow() || leftTopCornerRow == this.Sheet.getRowCount() - 1) {
                if (this.Sheet.isInLastFocusRange()) {
                    return;
                }
                this.Sheet.moveToNextFocusRange();
                focusRange = this.Sheet.getCurrentFocusRange();
                this.JumpToNextColumnEditableObject(focusRange.getStartRow(), focusRange.getStartCol() - 1);
                return;
            }
            col = focusRange.getStartCol() - 1;
            this.JumpToNextColumnEditableObject(++row, col);
            return;
        }
        if ((cell = this.Sheet.$Cells(row, ++col)) != null && (cell = cell.getLeftTopCorner()).isEditable()) {
            DBBindConfig dbc = cell.getBind();
            if (dbc == null) {
                this.Sheet.setSelection(new Range_(row, col, row, col));
                return;
            }
            if (this.Sheet.getWorkBook().getDataSource(dbc.getDataSource()).getDataStore().getRowCount() > 0) {
                this.Sheet.setSelection(new Range_(row, col, row, col));
                String dsn = dbc.getDataSource();
                DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(dsn);
                if (!dsn.equals(this.$getCurrentEditintDSN()) && dbc.getDataSourceType() == 2) {
                    dsc.setCurrentBindRow(0);
                }
                return;
            }
        }
        this.JumpToNextColumnEditableObject(row, col);
    }

    public void JumpToPriorColumnEditableObject(int row, int col) {
        Cell cell;
        Range focusRange;
        int leftTopCornerRow = row;
        int leftTopCornerCol = col;
        Cell leftTopCornerOfCurrentCell = this.Sheet.cells(row, col);
        if (leftTopCornerOfCurrentCell != null) {
            leftTopCornerOfCurrentCell = leftTopCornerOfCurrentCell.getLeftTopCorner();
            leftTopCornerRow = leftTopCornerOfCurrentCell.getRowIndex();
            leftTopCornerCol = leftTopCornerOfCurrentCell.getColumnIndex();
        }
        if (col <= (focusRange = this.Sheet.getCurrentFocusRange()).getStartCol()) {
            DBBindConfig bind;
            int lastCol = Cell_.findLastColumnWhichBindToSomeDataSource(this.Sheet, leftTopCornerRow, this.$getCurrentEditintDSN(), focusRange.getStartCol(), focusRange.getEndCol(), true);
            Cell cell2 = this.Sheet.$Cells(leftTopCornerRow, lastCol);
            if (cell2 != null && (bind = (cell2 = cell2.getLeftTopCorner()).getBind()) != null) {
                int currentRow;
                DataStore ds;
                int RC;
                DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(bind.getDataSource());
                if (bind.getDataSourceType() == 2 && (RC = (ds = dsc.getDataStore()).getRowCount()) > 0 && (currentRow = dsc.getCurrentBindRow() - 1) >= 0 && (lastCol = Cell_.findLastColumnWhichBindToSomeDataSource(this.Sheet, leftTopCornerRow, bind.getDataSource(), focusRange.getStartCol(), focusRange.getEndCol(), true)) >= 0) {
                    this.Sheet.setSelection(new Range_(row, lastCol, row, lastCol));
                    dsc.setCurrentBindRow(currentRow);
                    return;
                }
            }
            if (row == focusRange.getStartRow() || leftTopCornerRow == focusRange.getStartRow() || row == 0 || leftTopCornerRow == 0) {
                if (this.Sheet.isInFirstFocusRange()) {
                    return;
                }
                this.Sheet.moveToPriorFocusRange();
                focusRange = this.Sheet.getCurrentFocusRange();
                this.JumpToPriorColumnEditableObject(focusRange.getEndRow(), focusRange.getEndCol() + 1);
                return;
            }
            row = leftTopCornerRow;
            col = focusRange.getEndCol() + 1;
            this.JumpToPriorColumnEditableObject(--row, col);
            return;
        }
        col = leftTopCornerCol;
        if ((cell = this.Sheet.$Cells(row, --col)) != null && (cell = cell.getLeftTopCorner()).isEditable()) {
            DBBindConfig dbc = cell.getBind();
            if (dbc == null) {
                this.Sheet.setSelection(new Range_(row, col, row, col));
                return;
            }
            if (this.Sheet.getWorkBook().getDataSource(dbc.getDataSource()).getDataStore().getRowCount() > 0) {
                this.Sheet.setSelection(new Range_(row, col, row, col));
                String dsn = dbc.getDataSource();
                DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(dsn);
                int rc = dsc.getDataStore().getRowCount();
                if (rc > 0) {
                    if (!dsn.equals(this.$getCurrentEditintDSN())) {
                        dsc.setCurrentBindRow(rc - 1);
                    }
                    return;
                }
            }
        }
        this.JumpToPriorColumnEditableObject(row, col);
    }

    public void JumpToNextRowEditableObject(int row, int col) {
        DBBindConfig bind;
        int leftTopCornerRow = row;
        Cell leftTopCornerOfCurrentCell = this.Sheet.cells(row, col);
        if (leftTopCornerOfCurrentCell != null) {
            leftTopCornerOfCurrentCell = leftTopCornerOfCurrentCell.getLeftTopCorner();
            leftTopCornerRow = leftTopCornerOfCurrentCell.getRowIndex();
        }
        Range focusRange = this.Sheet.getCurrentFocusRange();
        Cell cell = this.Sheet.$Cells(leftTopCornerRow, col);
        if (cell != null && (bind = cell.getBind()) != null) {
            DataStore ds;
            int rc;
            String dsn = bind.getDataSource();
            DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(dsn);
            if (bind.getDataSourceType() == 2 && (rc = (ds = dsc.getDataStore()).getRowCount()) > 0) {
                RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
                if (dsn.equals(this.$getCurrentEditintDSN())) {
                    int RC;
                    int currentRow = dsc.getCurrentBindRow() + 1;
                    if (currentRow < (RC = ds.getRowCount())) {
                        this.Sheet.setSelection(new Range_(row, col, row, col));
                        dsc.setCurrentBindRow(currentRow);
                        return;
                    }
                } else {
                    this.Sheet.setSelection(new Range_(row, col, row, col));
                    dsc.setCurrentBindRow(0);
                    return;
                }
            }
        }
        if (row == this.Sheet.getRowCount() - 1 || row == focusRange.getEndRow() || leftTopCornerRow == focusRange.getEndRow()) {
            if (this.Sheet.isInLastFocusRange()) {
                return;
            }
            this.Sheet.moveToNextFocusRange();
            focusRange = this.Sheet.getCurrentFocusRange();
            this.JumpToNextRowEditableObject(focusRange.getStartRow() - 1, focusRange.getStartCol());
            return;
        }
        ++row;
        int findCol = col;
        boolean find = false;
        findCol = col;
        while (findCol <= focusRange.getEndCol()) {
            cell = this.Sheet.$Cells(row, findCol);
            if (cell != null && (!cell.isMerged() || cell.getLeftTopCorner() == cell) && cell.isEditable()) {
                find = true;
                break;
            }
            ++findCol;
        }
        if (!find) {
            findCol = 0;
            while (findCol < col) {
                cell = this.Sheet.$Cells(row, findCol);
                if (cell != null && (!cell.isMerged() || cell.getLeftTopCorner() == cell) && cell.isEditable()) {
                    find = true;
                    break;
                }
                ++findCol;
            }
        }
        if (find) {
            cell = this.Sheet.$Cells(row, findCol);
            DBBindConfig dbc = cell.getBind();
            if (dbc == null) {
                this.Sheet.setSelection(new Range_(row, findCol, row, findCol));
                return;
            }
            if (this.Sheet.getWorkBook().getDataSource(dbc.getDataSource()).getDataStore().getRowCount() > 0) {
                this.Sheet.setSelection(new Range_(row, findCol, row, findCol));
                String dsn = dbc.getDataSource();
                DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(dsn);
                if (dbc.getDataSourceType() == 2) {
                    dsc.setCurrentBindRow(0);
                    this.Sheet.getRowPropertyManage().setRowScrolledRowCount(row, 0);
                }
                return;
            }
        }
        this.JumpToNextRowEditableObject(row, col);
    }

    public void JumpToPriorRowEditableObject(int row, int col) {
        DBBindConfig bind;
        int leftTopCornerRow = row;
        Cell leftTopCornerOfCurrentCell = this.Sheet.cells(row, col);
        if (leftTopCornerOfCurrentCell != null) {
            leftTopCornerOfCurrentCell = leftTopCornerOfCurrentCell.getLeftTopCorner();
            leftTopCornerRow = leftTopCornerOfCurrentCell.getRowIndex();
        }
        Range focusRange = this.Sheet.getCurrentFocusRange();
        Cell cell = this.Sheet.$Cells(leftTopCornerRow, col);
        if (cell != null && (bind = cell.getBind()) != null) {
            DataStore ds;
            int rc;
            String dsn = bind.getDataSource();
            DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(dsn);
            if (bind.getDataSourceType() == 2 && (rc = (ds = dsc.getDataStore()).getRowCount()) > 0) {
                if (dsn.equals(this.$getCurrentEditintDSN())) {
                    int currentRow = dsc.getCurrentBindRow() - 1;
                    if (currentRow >= 0) {
                        this.Sheet.setSelection(new Range_(row, col, row, col));
                        dsc.setCurrentBindRow(currentRow);
                        return;
                    }
                } else {
                    this.Sheet.setSelection(new Range_(row, col, row, col));
                    dsc.setCurrentBindRow(rc - 1);
                    return;
                }
            }
        }
        if (row == 0 || row == focusRange.getStartRow() || leftTopCornerRow == focusRange.getStartRow()) {
            if (this.Sheet.isInFirstFocusRange()) {
                return;
            }
            this.Sheet.moveToPriorFocusRange();
            focusRange = this.Sheet.getCurrentFocusRange();
            this.JumpToPriorRowEditableObject(focusRange.getEndRow() + 1, focusRange.getEndCol());
            return;
        }
        row = leftTopCornerRow;
        --row;
        int findCol = col;
        boolean find = false;
        findCol = col;
        while (findCol >= focusRange.getStartCol()) {
            cell = this.Sheet.$Cells(row, findCol);
            if (cell != null && (!cell.isMerged() || cell.getLeftTopCorner() == cell) && cell.isEditable()) {
                find = true;
                break;
            }
            --findCol;
        }
        if (!find) {
            findCol = focusRange.getEndCol();
            while (findCol > col) {
                cell = this.Sheet.$Cells(row, findCol);
                if (cell != null && (!cell.isMerged() || cell.getLeftTopCorner() == cell) && cell.isEditable()) {
                    find = true;
                    break;
                }
                --findCol;
            }
        }
        if (find) {
            cell = this.Sheet.$Cells(row, findCol);
            DBBindConfig dbc = cell.getBind();
            if (dbc == null) {
                this.Sheet.setSelection(new Range_(row, findCol, row, findCol));
                return;
            }
            if (this.Sheet.getWorkBook().getDataSource(dbc.getDataSource()).getDataStore().getRowCount() > 0) {
                this.Sheet.setSelection(new Range_(row, findCol, row, findCol));
                String dsn = dbc.getDataSource();
                DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(dsn);
                if (dbc.getDataSourceType() == 2) {
                    dsc.setCurrentBindRow(dsc.getDataStore().getRowCount() - 1);
                }
                return;
            }
        }
        this.JumpToPriorRowEditableObject(row, col);
    }

    public void OnKeyDownVK_TAB_DesignMode(KeyEvent e) {
        Range r = this.Sheet.getSelection();
        int col = r.getEndCol();
        if (col + 1 == this.CPM.getColumnCount()) {
            int row = r.getEndRow();
            if (row + 1 == this.RPM.getRowCount()) {
                return;
            }
            this.Sheet.setSelection(new Range_(++row, 0, row, 0));
            this.Sheet.setXOffset(0);
        } else {
            this.Sheet.setSelection(new Range_(r.getEndRow(), ++col, r.getEndRow(), col));
        }
        this.InsureSelectionOnScreen(null);
    }

    public void $setCurrentEditControlBounds(Rectangle rect) {
        this.CurrentEditControlBounds = new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public boolean print() {
        return this.$printPreview(false, false);
    }

    @Override
    public boolean printWithDefaultDevice() {
        return this.$printPreview(false, true);
    }

    @Override
    public boolean printPreview() {
        return this.$printPreview(true, false);
    }

    @Override
    public boolean printPreviewWithDefaultDevice() {
        return this.$printPreview(true, true);
    }

    private boolean $printPreview(boolean needPreview, boolean dontShowPrintSettingDialog) {
        if (!this.Sheet.isPrintable()) {
            Tools.ShowInfo(this, "\u60a8\u65e0\u6b64\u6743\u9650\u3002");
            return false;
        }
        this.Sheet.getWorkBook().getEM().fireLoadPrintConfig(this.Sheet);
        PrintService[] services = PrinterJob.lookupPrintServices();
        if (services.length == 0) {
            Tools.ShowInfo(this, "\u8bf7\u5b89\u88c5\u6253\u5370\u673a\uff08\u5982\u679c\u4ec5\u505a\u9884\u89c8\uff0c\u90a3\u4e48\u8bf7\u968f\u610f\u5b89\u88c5\u4e00\u4e2a\u6253\u5370\u673a\u9a71\u52a8\u7a0b\u5e8f\uff09");
            return false;
        }
        if (dontShowPrintSettingDialog) {
            String t = this.Sheet.getPageConfig();
            JSONObject js = new JSONObject(t);
            js.remove("range");
            this.Sheet.setPageConfig(js.toString());
        } else {
            String cf = this.Sheet.getPageConfig();
            JSONObject printConfig = new JSONObject(cf);
            printConfig.put("needpreview", needPreview ? 1 : 0);
            PrintSetupDialog psd = new PrintSetupDialog(JOptionPane.getFrameForComponent(this), this.Sheet.getPrintServiceName(), services, printConfig.toString());
            if (!psd.showDialog()) {
                return false;
            }
            printConfig = psd.getPrintConfig();
            this.Sheet.setPageConfig(printConfig.toString());
            this.Sheet.setPrintServiceName(printConfig.getString("service", ""));
            this.Sheet.getWorkBook().getEM().FireSavePrintConfig(this.Sheet);
            needPreview = printConfig.getInt("needpreview", 0) == 1;
        }
        PrintService service = Tools.findPrintService(services, this.Sheet.getPrintServiceName());
        PrintPreview pp = new PrintPreview(this, needPreview);
        PrinterJob pj = PrinterJob.getPrinterJob();
        String pageConfig = this.Sheet.getPageConfig();
        PageFormat page = Tools.createPageFormat(pj, pageConfig);
        HashPrintRequestAttributeSet config = Tools.createHashPrintRequestAttributeSet(pageConfig, this.Sheet.getName());
        pj.setPrintable(pp, page);
        pp.setPrintParameter(service, page, config);
        try {
            pj.setPrintService(service);
            if (needPreview) {
                pp.run(page);
            } else {
                pj.print(config);
            }
        }
        catch (PrinterException pe) {
            pe.printStackTrace();
        }
        return true;
    }

    public String $getCurrentEditintDSN() {
        return this.currentEditintDSN;
    }

    public void $setCurrentEditintDSN(String currentEditintDSN) {
        this.currentEditintDSN = currentEditintDSN;
    }

    public void forceCurrentEditControlGiveUpFocus() {
        Edit edit = this.$getCurrentEditingEdit();
        if (edit != null) {
            edit.giveUpFocus();
        }
        this.$clearCurrentEditingEdit(edit);
        this.requestFocusInWindow();
    }

    public void forceCurrentEditControlFillBack() {
        Edit edit = this.$getCurrentEditingEdit();
        if (edit != null) {
            edit.fillBack();
        }
    }

    private void F(Component obj) {
        if (obj.getParent() == null) {
            obj.requestFocusInWindow();
            return;
        }
        boolean cfr_ignored_0 = obj instanceof JApplet;
        this.F(obj.getParent());
        obj.requestFocusInWindow();
    }

    @Override
    public boolean requestFocusInWindow() {
        if (EventQueue.isDispatchThread()) {
            return this.requestFocusInWindow_in_EDT();
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    WorkSheetView_.this.requestFocusInWindow_in_EDT();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private boolean requestFocusInWindow_in_EDT() {
        this.F(this.getParent());
        return super.requestFocusInWindow();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int col;
        boolean isPrint;
        int row;
        Cell cell;
        Point p = event.getPoint();
        if (p != null && (cell = this.Sheet.cells(row = this.GetRowAtPoint(isPrint = false, p.y), col = this.GetColAtPoint(isPrint, p.x, row))) != null) {
            String scriptTip;
            String toolTip;
            if (cell.isMerged()) {
                cell = cell.getLeftTopCorner();
            }
            int innerRow = ((Cell_)cell).getInnerRowAtPoint(p, false);
            if (this.lastToolTipShowOnCellRow == row && this.lastToolTipShowOnCellCol == col && this.lastToolTipShowOnCellInnerRow == innerRow) {
                if (this.lastToolTipText == null) {
                    return null;
                }
                if (this.lastToolTipText.equals("")) {
                    this.lastToolTipText = null;
                }
                return this.lastToolTipText;
            }
            this.lastToolTipShowOnCellRow = row;
            this.lastToolTipShowOnCellCol = col;
            this.lastToolTipShowOnCellInnerRow = innerRow;
            this.lastToolTipText = toolTip = cell.getToolTip();
            if (toolTip == null) {
                return null;
            }
            if (toolTip.startsWith("=")) {
                Object v = this.Sheet.evaluate(this.lastToolTipText, innerRow);
                if (v == null) {
                    this.lastToolTipText = null;
                    return null;
                }
                this.lastToolTipText = v.toString();
            }
            if ((scriptTip = this.Sheet.getWorkBook().getEM().fireBuildToolTip(this.Sheet, cell, innerRow)) != null) {
                this.lastToolTipText = scriptTip;
            }
            if (this.lastToolTipText.equals("")) {
                return null;
            }
            return this.lastToolTipText;
        }
        return null;
    }

    @Override
    public void showFloatToolbar(int x, int y, int width, int height, boolean onRight, int padding) {
        int h = this.floatToolBar.getBounds().height;
        int w = this.floatToolBar.getBounds().width;
        this.floatToolBar.setBounds(x + width - w, y - h - 2, w, h);
        this.add(this.floatToolBar);
        this.floatToolBar.repaint();
    }

    @Override
    public void hideFloatToolbar() {
        Rectangle rc = this.floatToolBar.getBounds();
        this.remove(this.floatToolBar);
        this.repaint(rc);
    }

    @Override
    public void splash(boolean b) {
        if (!b) {
            if (this.findSplashTimer == null) {
                return;
            }
            this.findSplashTimer.cancel();
            this.findSplashTimer = null;
            this.splashOn = false;
            this.repaint();
            return;
        }
        if (this.findSplashTimer != null) {
            return;
        }
        this.findSplashTimer = new Timer();
        this.findSplashTimer.schedule(new TimerTask(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        (this).WorkSheetView_.this.splashOn = !(this).WorkSheetView_.this.splashOn;
                        WorkSheetView_.this.repaint(WorkSheetView_.this.getRectangleOfSelection());
                        System.out.println("splash:" + (this).WorkSheetView_.this.splashOn);
                    }
                });
            }
        }, 500L, 500L);
    }

    public boolean save2Image(String imgFile) {
        int w = this.Sheet.getColumnPropertyManage().getAllColumnsWidth() + 5;
        int h = this.Sheet.getRowPropertyManage().getAllRowsHeight() + 5;
        BufferedImage img = new BufferedImage(w, h, 1);
        Graphics2D g = (Graphics2D)img.getGraphics();
        Rectangle rc = new Rectangle(0, 0, w, h);
        this.OnDraw(g, rc, rc);
        try {
            ImageIO.write((RenderedImage)img, "jpg", new File(imgFile));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean includeStretchColumn() {
        int CN = this.Sheet.getColumnCount();
        ColumnPropertyManage CPM = this.Sheet.getColumnPropertyManage();
        int i = 0;
        while (i < CN) {
            int t = CPM.getColumnStretchWidth(i);
            if (t > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean includeStretchRow() {
        int RN = this.Sheet.getRowCount();
        RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
        int i = 0;
        while (i < RN) {
            int t = RPM.getRowStretchHeight(i);
            if (t > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void reCalcuColumnsWidth() {
        int totalLeftWidth;
        if (this.Sheet.isDesignMode()) {
            return;
        }
        Rectangle rc = this.getBounds();
        if (rc.width <= 0 || rc.height == 0) {
            return;
        }
        int totalWidth = rc.width - this.Sheet.getRowPropertyManage().getRowHeadWidth();
        int noStretchWidth = 0;
        int totalStretchPercent = 0;
        int CN = this.Sheet.getColumnCount();
        ColumnPropertyManage CPM = this.Sheet.getColumnPropertyManage();
        ArrayList<Integer> stretchColumnIndex = new ArrayList<Integer>();
        int i = 0;
        while (i < CN) {
            int t = CPM.getColumnStretchWidth(i);
            int width = CPM.getColumnWidth(i);
            if (t > 0) {
                totalStretchPercent += t;
                stretchColumnIndex.add(i);
            } else {
                noStretchWidth += width;
            }
            ++i;
        }
        if (totalWidth <= noStretchWidth) {
            return;
        }
        int stretchColumnCount = stretchColumnIndex.size();
        int leftWidth = totalLeftWidth = totalWidth - noStretchWidth;
        int i2 = 0;
        while (i2 < stretchColumnCount) {
            if (i2 == stretchColumnCount - 1) {
                CPM.setColumnWidth((Integer)stretchColumnIndex.get(i2), leftWidth);
            } else {
                int t = CPM.getColumnStretchWidth(i2);
                int thisWidth = (int)((double)(totalLeftWidth * t) * 1.0 / (double)totalStretchPercent);
                leftWidth -= thisWidth;
                CPM.setColumnWidth((Integer)stretchColumnIndex.get(i2), thisWidth);
            }
            ++i2;
        }
    }

    @Override
    public void reCalcuRowsHeight() {
        int totalLeftHeight;
        if (this.Sheet.isDesignMode()) {
            return;
        }
        Rectangle rc = this.getBounds();
        if (rc.width <= 0 || rc.height == 0) {
            return;
        }
        int totalHeight = rc.height - this.Sheet.getColumnPropertyManage().getColumnHeadHeight();
        int noStretchHeight = 0;
        int totalStretchPercent = 0;
        int RN = this.Sheet.getRowCount();
        RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
        ArrayList<Integer> stretchRowIndex = new ArrayList<Integer>();
        int i = 0;
        while (i < RN) {
            int t = RPM.getRowStretchHeight(i);
            int Height = RPM.getRowHeight(i);
            if (t > 0) {
                totalStretchPercent += t;
                stretchRowIndex.add(i);
            } else {
                noStretchHeight += Height;
            }
            ++i;
        }
        if (totalHeight <= noStretchHeight) {
            return;
        }
        int stretchRowCount = stretchRowIndex.size();
        int leftHeight = totalLeftHeight = totalHeight - noStretchHeight;
        int i2 = 0;
        while (i2 < stretchRowCount) {
            if (i2 == stretchRowCount - 1) {
                RPM.setRowHeight((Integer)stretchRowIndex.get(i2), leftHeight);
            } else {
                int t = RPM.getRowStretchHeight(i2);
                int thisHeight = (int)((double)(totalLeftHeight * t) * 1.0 / (double)totalStretchPercent);
                leftHeight -= thisHeight;
                RPM.setRowHeight((Integer)stretchRowIndex.get(i2), thisHeight);
            }
            ++i2;
        }
    }

    private class HideAWTListener
    implements AWTEventListener {
        WorkSheetView_ pFrame;

        public HideAWTListener(WorkSheetView_ pf) {
            this.pFrame = pf;
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mv;
            if (aWTEvent instanceof MouseEvent && (mv = (MouseEvent)aWTEvent).getClickCount() > 0) {
                if (!(aWTEvent.getSource() instanceof Component)) {
                    return;
                }
                Component comp = (Component)aWTEvent.getSource();
                Container par = SwingUtilities.getAncestorNamed("jpopuppane", comp);
                Container barpar = SwingUtilities.getAncestorOfClass(this.pFrame.getClass(), comp);
                if (par == null) {
                    // empty if block
                }
            }
        }
    }
}

