/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.brick.Chart;
import excel.brick.DBBar;
import excel.brick.Line;
import excel.brick.LoadCameraImageToCellButton;
import excel.brick.LoadCameraImageToDSButton;
import excel.brick.LoadImageToCellButton;
import excel.brick.LoadImageToDSButton;
import excel.brick.OnlyBorder;
import excel.brick.PageBar;
import excel.brick.RetrieveButton;
import excel.brick.RotatedText;
import excel.brick.ScrollBar;
import excel.brick.StaticImage;
import excel.brick.SwitchHandle;
import excel.brick.Tree;
import excel.brick.TreeDataProvider;
import excel.brick.VirtualButton;
import excel.brick.impl.Chart_;
import excel.brick.impl.DBBar_;
import excel.brick.impl.Line_;
import excel.brick.impl.LoadCameraImageToCellButton_;
import excel.brick.impl.LoadCameraImageToDSButton_;
import excel.brick.impl.LoadImageToCellButton_;
import excel.brick.impl.LoadImageToDSButton_;
import excel.brick.impl.OnlyBorder_;
import excel.brick.impl.PageBar_;
import excel.brick.impl.RetrieveButton_;
import excel.brick.impl.RotatedText_;
import excel.brick.impl.ScrollBar_;
import excel.brick.impl.StaticImage_;
import excel.brick.impl.SwitchHandle_;
import excel.brick.impl.Tree_;
import excel.brick.impl.VirtualButton_;
import excel.core.CellDecorate;
import excel.core.ClipBoard;
import excel.core.DataSourceConfig;
import excel.core.EditStyle;
import excel.core.Range;
import excel.core.WorkBook;
import excel.core.WorkBookView;
import excel.core.WorkSheet;
import excel.core.impl.ContextMenuConfig;
import excel.core.impl.DataSourceConfig_;
import excel.core.impl.DataStoreEventAdapter;
import excel.core.impl.DecorateDDLB;
import excel.core.impl.DecorateNormal;
import excel.core.impl.DecorateStar;
import excel.core.impl.EditStyle_;
import excel.core.impl.FindDialog;
import excel.core.impl.PropertyManage;
import excel.core.impl.Range_;
import excel.core.impl.RedefineBecause;
import excel.core.impl.WorkBookView_;
import excel.core.impl.WorkSheetView_;
import excel.core.impl.WorkSheet_;
import excel.dragdrop.DragAndDrop;
import excel.edit.CheckBoxEdit;
import excel.edit.DatetimeEdit;
import excel.edit.DropDownListBox;
import excel.edit.DropDownTree;
import excel.edit.Edit;
import excel.edit.HTMLDocumentEditor;
import excel.edit.MultilineEdit;
import excel.edit.NormalEdit;
import excel.edit.NumericEdit;
import excel.event.WorkBookEventManage;
import excel.event.impl.WorkSheetEventManage_;
import excel.jep.JEP;
import excel.jep.function.JepFunctionProxy;
import excel.jep.function.PostfixMathCommand;
import excel.jep.function.PostfixMathCommandI;
import excel.util.Tools;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jun.db.core.DataStore;
import jun.db.core.DataStoreListener;
import jun.db.util.Base64Coder;
import org.json.JSONArray;

public final class WorkBook_
implements WorkBook {
    private Vector idleJepPool = new Vector();
    private HashMap jepFunctionProxyMap = new HashMap();
    private ArrayList sheetList;
    private WorkSheet ActiveSheet;
    private WorkBookView BookView = null;
    private boolean WithGUI = false;
    private boolean undoEnabled = true;
    private boolean tabVisible = true;
    private WorkBookEventManage EM = new WorkSheetEventManage_();
    private PropertyManage PM = new PropertyManage();
    private HashMap DataSource = new HashMap();
    private HashMap EditStyleMap = new HashMap();
    private boolean CellShowBind = false;
    private ClipBoard clipBoard;
    public LinkedHashMap<String, ContextMenuConfig> contextMenuMap = new LinkedHashMap();
    private HashMap extendFunction = new HashMap();
    private boolean highlightDataSourceCurrentRow = true;
    private boolean showDefineIfInDesignMode = false;
    private boolean showTabOnBottom = true;
    private String theme = "";
    private boolean focusRangeVisible = false;
    FindDialog findDialog = null;
    private boolean initOK = true;
    private boolean allBrickDisabled = false;

    public void _$WorkBook_() {
        int si = 0;
        while (si < this.sheetList.size()) {
            WorkSheet sheet = (WorkSheet)this.sheetList.get(si);
            ((WorkSheet_)sheet)._$WorkSheet_();
            ++si;
        }
        this.sheetList.clear();
        this.ActiveSheet = null;
        this.DataSource.clear();
        this.EditStyleMap.clear();
        this.contextMenuMap.clear();
        this.idleJepPool.clear();
        this.extendFunction.clear();
    }

    public WorkBook_(int defaultSheetCount, boolean withGUI, int[] RC, int[] CC, String[] guids, String[] codes) {
        int i;
        this.WithGUI = withGUI;
        if (RC == null) {
            RC = new int[defaultSheetCount];
            i = 0;
            while (i < defaultSheetCount) {
                RC[i] = 100;
                ++i;
            }
        }
        if (CC == null) {
            CC = new int[defaultSheetCount];
            i = 0;
            while (i < defaultSheetCount) {
                CC[i] = 10;
                ++i;
            }
        }
        if (guids == null) {
            guids = new String[defaultSheetCount];
            i = 0;
            while (i < defaultSheetCount) {
                guids[i] = Tools.newGUID();
                ++i;
            }
        }
        if (codes == null) {
            codes = new String[defaultSheetCount];
            i = 0;
            while (i < defaultSheetCount) {
                codes[i] = null;
                ++i;
            }
        }
        if (this.WithGUI) {
            this.BookView = new WorkBookView_(this);
        }
        if (defaultSheetCount < 1) {
            defaultSheetCount = 1;
        }
        this.sheetList = new ArrayList();
        i = 0;
        while (i < defaultSheetCount) {
            String name = "\u5de5\u4f5c\u672c" + (i + 1);
            int rowCount = 100;
            int colCount = 10;
            String guid = "";
            String code = null;
            if (i < RC.length) {
                rowCount = RC[i];
            }
            if (i < CC.length) {
                colCount = CC[i];
            }
            if (i < guids.length) {
                guid = guids[i];
            }
            if (i < codes.length) {
                code = codes[i];
            }
            this.newWorkSheet(name, rowCount, colCount, guid, code);
            ++i;
        }
        this.setActiveSheet(0);
    }

    public synchronized JEP getIdleJEPInstance() {
        if (this.idleJepPool.size() > 0) {
            JEP jep = (JEP)this.idleJepPool.get(0);
            this.idleJepPool.remove(0);
            return jep;
        }
        JEP jep = JEP.newJEP();
        jep.setAllowUndeclared(true);
        for (String funcName : this.extendFunction.keySet()) {
            PostfixMathCommand func = (PostfixMathCommand)this.extendFunction.get(funcName);
            jep.$addFunction(funcName, func);
        }
        return jep;
    }

    public synchronized void releaseJEPInstance(JEP jep) {
        if (jep == null) {
            return;
        }
        jep.attachCell(null);
        jep.attachWorkSheet(null);
        jep.resetCellInnerRow();
        this.idleJepPool.add(jep);
    }

    public int getWorkSheetCount() {
        return this.sheetList.size();
    }

    public WorkSheet getWorkSheet(int index) {
        if (index < 0) {
            return null;
        }
        if (index > this.getWorkSheetCount()) {
            return null;
        }
        return (WorkSheet)this.sheetList.get(index);
    }

    public WorkSheet getWorkSheet(String sheetName) {
        int si = 0;
        while (si < this.sheetList.size()) {
            WorkSheet sheet = (WorkSheet)this.sheetList.get(si);
            if (sheet.getName().equals(sheetName)) {
                return sheet;
            }
            ++si;
        }
        return null;
    }

    public WorkSheet getWorkSheetByGuid(String guid) {
        int si = 0;
        while (si < this.sheetList.size()) {
            WorkSheet sheet = (WorkSheet)this.sheetList.get(si);
            if (sheet.getGUID().equals(guid)) {
                return sheet;
            }
            ++si;
        }
        return null;
    }

    public WorkSheet getWorkSheetByCode(String code) {
        int si = 0;
        while (si < this.sheetList.size()) {
            WorkSheet sheet = (WorkSheet)this.sheetList.get(si);
            if (sheet.getCode().equals(code)) {
                return sheet;
            }
            ++si;
        }
        return null;
    }

    public WorkSheet getActiveSheet() {
        return this.ActiveSheet;
    }

    public void setActiveSheet(int index) {
        Range r;
        if (this.ActiveSheet != null && index == this.ActiveSheet.getIndex()) {
            return;
        }
        WorkSheet deActiveSheet = this.ActiveSheet;
        if (this.ActiveSheet != null) {
            r = this.ActiveSheet.getSelection();
            this.getEM().fireCellFocusLost(this.ActiveSheet, r.getStartRow(), r.getStartCol());
        }
        int i = 0;
        while (i < this.getWorkSheetCount()) {
            boolean v;
            WorkSheet_ sheet = (WorkSheet_)this.sheetList.get(i);
            boolean bl = v = i == index;
            if (v) {
                this.ActiveSheet = sheet;
            }
            sheet.Active(v);
            ++i;
        }
        r = this.ActiveSheet.getSelection();
        this.getEM().fireCellFocusGained(this.ActiveSheet, r.getStartRow(), r.getStartCol());
        this.getEM().fireSheetActiveStateChanged(this.ActiveSheet, deActiveSheet);
    }

    public WorkSheet newWorkSheet(String name) {
        return this.newWorkSheet(name, 100, 10, Tools.newGUID(), null);
    }

    public WorkSheet newWorkSheet(String name, int rowCount, int colCount) {
        return this.newWorkSheet(name, rowCount, colCount, Tools.newGUID(), null);
    }

    public WorkSheet newWorkSheet(String name, int rowCount, int colCount, String guid, String code) {
        if (name == null) {
            name = "";
        }
        if (name.equals("")) {
            name = "\u5de5\u4f5c\u672c";
            int n = this.getWorkSheetCount() + 1;
            String t = String.valueOf(name) + n;
            while (this.getWorkSheet(t) != null) {
                t = String.valueOf(name) + ++n;
            }
            name = t;
        }
        WorkSheet_ sheet = new WorkSheet_(name, this, this.WithGUI, rowCount, colCount, guid, code);
        WorkBookView_ view = (WorkBookView_)this.getWorkBookView();
        if (view != null) {
            view.getWorkSheetTabContainer().AddTab(sheet);
            view.add(sheet.getWorkSheetView());
            Rectangle sheetRC = view.getSheetRect();
            sheet.getWorkSheetView().setBounds(sheetRC);
        }
        this.sheetList.add(sheet);
        this.getEM().fireAfterNewWorkSheet(sheet);
        return sheet;
    }

    public boolean deleteWorkSheet(String sheetName) {
        if (this.getWorkSheetCount() == 0) {
            return false;
        }
        WorkSheet sheet = this.getWorkSheet(sheetName);
        if (sheet == null) {
            return false;
        }
        if (!this.getEM().fireWorkSheetDeletePermit(sheet)) {
            return false;
        }
        int index = sheet.getIndex();
        WorkBookView_ view = (WorkBookView_)this.getWorkBookView();
        if (view != null) {
            view.getWorkSheetTabContainer().RemoveTab(sheet);
            view.remove(sheet.getWorkSheetView());
        }
        this.sheetList.remove(sheet);
        this.RebuildAllDefine(sheet, new RedefineBecause(6, 0, 0, 0, 0));
        if (index == this.getWorkSheetCount()) {
            --index;
        }
        ((WorkSheet_)sheet).clear();
        sheet = null;
        this.ActiveSheet = null;
        this.setActiveSheet(index);
        return true;
    }

    public WorkBookView getWorkBookView() {
        return this.BookView;
    }

    public boolean getWithGUI() {
        return this.WithGUI;
    }

    public int getWorkSheetIndex(WorkSheet sheet) {
        return this.sheetList.indexOf(sheet);
    }

    public void setWorkSheetIndex(WorkSheet sheet, int newIndex) {
        if (this.getWorkSheetIndex(sheet) == newIndex) {
            return;
        }
        if (newIndex < 0) {
            return;
        }
        if (newIndex >= this.getWorkSheetCount()) {
            return;
        }
        this.sheetList.remove(sheet);
        this.sheetList.add(newIndex, sheet);
        if (this.WithGUI) {
            this.getWorkBookView().getWorkSheetTabContainer().setTabIndex(sheet, newIndex);
        }
    }

    public PropertyManage getPropertyManage() {
        return this.PM;
    }

    public boolean AddDataSource(String name, DataStore ds, int dsType) {
        if (this.DataSource.containsKey(name = name.trim().toLowerCase())) {
            return false;
        }
        DataSourceConfig_ dsc = new DataSourceConfig_(name, ds, dsType);
        this.DataSource.put(name, dsc);
        DataStoreEventAdapter dsa = new DataStoreEventAdapter(this, dsc);
        int eventLabel = 10;
        ds.getEvent().addDataStoreEventListener((DataStoreListener)dsa, eventLabel, name);
        return true;
    }

    public boolean removeDataSource(String name) {
        if (!this.DataSource.containsKey(name = name.trim().toLowerCase())) {
            return false;
        }
        DataSourceConfig dsc = (DataSourceConfig)this.DataSource.get(name);
        DataStoreEventAdapter dsa = (DataStoreEventAdapter)dsc.getDataStore().getEvent().findListener(name);
        dsa.UnRegisterAllCells();
        dsc.getDataStore().getEvent().removeDataStoreEventListener(name);
        this.DataSource.remove(name);
        return true;
    }

    public boolean AddEditStyle(EditStyle editStyle) {
        String name = editStyle.getName().toLowerCase().trim();
        if (this.EditStyleMap.containsKey(name)) {
            return false;
        }
        this.EditStyleMap.put(name, editStyle);
        return true;
    }

    public EditStyle getEditStyle(String editStyleName) {
        if (!this.EditStyleMap.containsKey(editStyleName = editStyleName.toLowerCase().trim())) {
            return null;
        }
        return (EditStyle)this.EditStyleMap.get(editStyleName);
    }

    public void RebuildAllDefine(WorkSheet trigger, RedefineBecause because) {
        int i = 0;
        while (i < this.getWorkSheetCount()) {
            WorkSheet_ sheet = (WorkSheet_)this.sheetList.get(i);
            sheet.RebuildCellsDefine(trigger, because);
            ++i;
        }
    }

    public ClipBoard getClipBoard() {
        return this.clipBoard;
    }

    public void setClipBoard(ClipBoard cb) {
        this.clipBoard = cb;
    }

    public DataSourceConfig getDataSource(String name) {
        if ((name = name.trim().toLowerCase()).equals("")) {
            return null;
        }
        if (!this.DataSource.containsKey(name)) {
            return null;
        }
        return (DataSourceConfig)this.DataSource.get(name);
    }

    public DataSourceConfig[] getDataSources() {
        int c = this.getDataSourceCount();
        if (c == 0) {
            DataSourceConfig[] ret = new DataSourceConfig[]{};
            return ret;
        }
        DataSourceConfig[] ret = new DataSourceConfig[c];
        ret = this.DataSource.values().toArray(ret);
        return ret;
    }

    public int getDataSourceCount() {
        return this.DataSource.size();
    }

    public String getDataSourceName(int i) {
        if (i >= this.DataSource.size() || i < 0) {
            return "";
        }
        DataSourceConfig[] dss = this.getDataSources();
        return dss[i].getName();
    }

    public DataSourceConfig getDataSource(int i) {
        if (i >= this.DataSource.size() || i < 0) {
            return null;
        }
        DataSourceConfig[] dss = this.getDataSources();
        return dss[i];
    }

    public WorkBookEventManage getEM() {
        return this.EM;
    }

    public void setCellShowBind(boolean show) {
        this.CellShowBind = show;
        if (this.BookView != null) {
            this.BookView.repaint();
        }
    }

    public boolean isCellShowBind() {
        return this.CellShowBind;
    }

    protected LinkedHashMap getContextMenuMap() {
        return this.contextMenuMap;
    }

    public void addFunction(String functionName, PostfixMathCommandI function) {
        this.extendFunction.put(functionName, function);
    }

    public boolean isUndoEnabled() {
        return this.undoEnabled;
    }

    public void setUndoEnabled(boolean undoEnabled) {
        this.undoEnabled = undoEnabled;
    }

    public boolean isHighlightDataSourceCurrentRow() {
        return this.highlightDataSourceCurrentRow;
    }

    public void setHighlightDataSourceCurrentRow(boolean hightlight) {
        this.highlightDataSourceCurrentRow = hightlight;
        if (this.BookView != null) {
            this.BookView.repaint();
        }
    }

    public boolean isShowDefineIfInDesignMode() {
        return this.showDefineIfInDesignMode;
    }

    public void setShowDefineIfInDesignMode(boolean yesOrNot) {
        this.showDefineIfInDesignMode = yesOrNot;
        if (this.WithGUI) {
            int i = 0;
            while (i < this.getWorkSheetCount()) {
                this.getWorkSheet(i).getWorkSheetView().repaint();
                ++i;
            }
        }
    }

    public void setJepFunctionProxy(String funcName, JepFunctionProxy proxy) {
        this.jepFunctionProxyMap.put(funcName, proxy);
    }

    public JepFunctionProxy getJepFunctionProxy(String funcName) {
        if (!this.jepFunctionProxyMap.containsKey(funcName)) {
            return null;
        }
        return (JepFunctionProxy)this.jepFunctionProxyMap.get(funcName);
    }

    public void loadImageToDataSource(String dsn, int row, String col) {
        WorkSheetView_ pView = (WorkSheetView_)this.ActiveSheet.getWorkSheetView();
        if (pView != null) {
            pView.forceCurrentEditControlGiveUpFocus();
        }
        JFrame f = new JFrame();
        FileDialog dlg = new FileDialog((Frame)f, "\u9009\u62e9\u56fe\u7247\u6587\u4ef6", 0);
        dlg.setVisible(true);
        f.dispose();
        if (dlg.getFile() == null) {
            return;
        }
        String filename = String.valueOf(dlg.getDirectory()) + dlg.getFile();
        byte[] b = Tools.ReadFile(filename);
        StringBuffer sb = new StringBuffer(1024);
        sb.append("$#{image}#$");
        sb.append(Base64Coder.encode((byte[])b));
        DataSourceConfig dsc = this.getDataSource(dsn);
        if (dsc != null) {
            DataStore ds = dsc.getDataStore();
            ds.setValue(row, col, (Object)sb.toString());
        }
    }

    public EditStyle newEditStyle(WorkBook book, String name, int et) {
        EditStyle es = EditStyle_.newEditStyle(book, name, et);
        return es;
    }

    public Edit createEditComponent(EditStyle es) {
        if (es == null) {
            return new NormalEdit();
        }
        switch (es.getEditType()) {
            case 1: {
                int DecimalCount = es.getDecimalCount();
                boolean ShowComma = es.isShowComma();
                return new NumericEdit(DecimalCount, ShowComma);
            }
            case 2: {
                return new MultilineEdit(es.isAutoWordWrap());
            }
            case 3: {
                String format = es.getDatetimeFormat();
                return new DatetimeEdit(format);
            }
            case 4: {
                DropDownListBox ddlb = new DropDownListBox(es);
                return ddlb;
            }
            case 5: {
                CheckBoxEdit chk = new CheckBoxEdit(es);
                return chk;
            }
            case 7: {
                HTMLDocumentEditor he = new HTMLDocumentEditor();
                return he;
            }
            case 9: {
                DropDownTree dropDownTree = new DropDownTree(es);
            }
        }
        return new NormalEdit();
    }

    public OnlyBorder createOnlyBorderBrick(String name, Color color, int style, int weight) {
        OnlyBorder_ brick = new OnlyBorder_(name, color, style, weight);
        return brick;
    }

    public Tree createTreeBrick(String name, boolean multi, String rootCaption, String rootValue, JSONArray data) {
        final JSONArray $data = data;
        TreeDataProvider provider = new TreeDataProvider(){

            @Override
            public ArrayList<String> getGroups() {
                return null;
            }

            @Override
            public JSONArray buildData(String group) {
                return $data;
            }

            @Override
            public JSONArray buildLevelData(String group, String id) {
                return null;
            }

            @Override
            public String parseRootValue(String rootValue) {
                return rootValue;
            }
        };
        Tree_ brick = new Tree_(name, multi, rootCaption, rootValue, provider, this.getWorkBookView(), true, false);
        return brick;
    }

    public Tree createTreeBrick(String name, boolean multi, String rootCaption, String rootValue, TreeDataProvider provider, boolean autoLoad, boolean expandOneByOne) {
        Tree_ brick = new Tree_(name, multi, rootCaption, rootValue, provider, this.getWorkBookView(), autoLoad, expandOneByOne);
        return brick;
    }

    public StaticImage createStaticImage(String name, String fileName) {
        StaticImage_ brick = new StaticImage_(name, fileName);
        return brick;
    }

    public Line createLine(String name, Color color, int style, int weight) {
        Line_ brick = new Line_(name, color, style, weight);
        return brick;
    }

    public DBBar createDBBarBrick(String name, String dataSource, int action) {
        DBBar_ brick = new DBBar_(name, dataSource, action);
        return brick;
    }

    public PageBar createPageBar(String name, String dataSource, int pageRowCount) {
        PageBar_ brick = new PageBar_(name, dataSource, pageRowCount);
        return brick;
    }

    public VirtualButton createVirtualButton(String name, String caption) {
        VirtualButton_ brick = new VirtualButton_(name, caption);
        return brick;
    }

    public RetrieveButton createRetrieveButton(String name, String caption, String dataSource) {
        RetrieveButton_ brick = new RetrieveButton_(name, caption, dataSource);
        return brick;
    }

    public SwitchHandle createSwitchHandle(String name) {
        SwitchHandle_ brick = new SwitchHandle_(name);
        return brick;
    }

    public RotatedText createRotatedText(String name, String caption, int angle) {
        RotatedText_ brick = new RotatedText_(name, caption, angle);
        return brick;
    }

    public Chart createChart(String type, String name, String caption, String categoryAxisLabel, String valueAxisLabel, float alpha, boolean serialAngled, String range) {
        Chart_ brick = new Chart_(type, name, caption, categoryAxisLabel, valueAxisLabel, alpha, serialAngled, range);
        return brick;
    }

    public Chart createChart(String type, String name, String caption, String categoryAxisLabel, String valueAxisLabel, float alpha, boolean serialAngled, String range, String serialCol, String categoryCol, String valueCol, String valueCol2) {
        Chart_ brick = new Chart_(type, name, caption, categoryAxisLabel, valueAxisLabel, alpha, serialAngled, range, serialCol, categoryCol, valueCol, valueCol2);
        return brick;
    }

    public LoadImageToDSButton createLoadImageToDSVirtualButton(String name, String caption, String dataSource, String col) {
        LoadImageToDSButton_ brick = new LoadImageToDSButton_(name, caption, dataSource, col);
        return brick;
    }

    public LoadImageToCellButton createLoadImageToCellVirtualButton(String name, String caption, String toSheetName, int toRow, int toCol) {
        LoadImageToCellButton_ brick = new LoadImageToCellButton_(name, caption, toSheetName, toRow, toCol);
        return brick;
    }

    public LoadCameraImageToCellButton createLoadCameraToCellVirtualButton(String name, String caption, String toSheetName, int toRow, int toCol, int W, int H, int CW, int CH) {
        LoadCameraImageToCellButton_ brick = new LoadCameraImageToCellButton_(name, caption, toSheetName, toRow, toCol, W, H, CW, CH);
        return brick;
    }

    public LoadCameraImageToDSButton createLoadCameraToDSVirtualButton(String name, String caption, String dataSource, String col, int W, int H, int CW, int CH) {
        LoadCameraImageToDSButton_ brick = new LoadCameraImageToDSButton_(name, caption, dataSource, col, W, H, CW, CH);
        return brick;
    }

    public Color newColor(int r, int g, int b) {
        return new Color(r, g, b);
    }

    public Range newRange(int startRow, int startCol, int endRow, int endCol) {
        return new Range_(startRow, startCol, endRow, endCol);
    }

    public ScrollBar createScrollBar(String name, String dsn) {
        ScrollBar_ sb = new ScrollBar_(this, name, dsn);
        return sb;
    }

    public boolean isShowTabOnBottom() {
        return this.showTabOnBottom;
    }

    public void setShowTabOnBottom(boolean showTabOnBottom) {
        if (this.showTabOnBottom == showTabOnBottom) {
            return;
        }
        this.showTabOnBottom = showTabOnBottom;
        if (this.WithGUI && this.getWorkBookView() != null) {
            ((WorkBookView_)this.getWorkBookView()).showTabOnWhereChanged();
        }
    }

    public CellDecorate createDefaultCellDecorate() {
        return null;
    }

    public CellDecorate createNormalCellDecorate(int ph, int pv) {
        return this.createNormalCellDecorate(ph, pv, "normal");
    }

    public CellDecorate createNormalCellDecorate(int ph, int pv, String theme) {
        return new DecorateNormal(ph, pv, theme);
    }

    public CellDecorate createStarCellDecorate(int align, int ph, int pv) {
        return new DecorateStar(align, ph, pv);
    }

    public CellDecorate createDDLBCellDecorate(int ph, int pv) {
        return this.createDDLBCellDecorate(ph, pv, "normal");
    }

    public CellDecorate createDDLBCellDecorate(int ph, int pv, String theme) {
        return new DecorateDDLB(ph, pv, theme);
    }

    public void setInitOK(boolean b) {
        this.initOK = b;
    }

    public boolean isInitOK() {
        return this.initOK;
    }

    public String decodeToImageFile(String value, String toFile) {
        if (value.startsWith("$#{image}#$")) {
            value = value.substring("$#{image}#$".length());
        }
        char[] cs = value.toCharArray();
        byte[] b = Base64Coder.decode((char[])cs);
        try {
            FileOutputStream fos = new FileOutputStream(new File(toFile));
            fos.write(b);
            fos.close();
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "";
    }

    public KeyEvent getKeyEvent() {
        return ((WorkBookView_)this.getWorkBookView()).lastKeyEvent;
    }

    public void showDragDropWindow(String type, String title, JSONArray treeData, int x, int y, int width, int height) {
        DragAndDrop dad = new DragAndDrop(type, title, this.getWorkBookView(), treeData, x, y, width, height);
    }

    public void setTabVisible(boolean v) {
        this.tabVisible = v;
        if (this.BookView != null) {
            ((WorkBookView_)this.BookView).componentResized(null);
            this.BookView.repaint();
        }
    }

    public boolean isTabVisible() {
        return this.tabVisible;
    }

    public void addContextMenu(String name, String caption) {
        this.addContextMenu(name, caption, "");
    }

    ContextMenuConfig findContextMenu(LinkedHashMap map, String name) {
        if (map == null) {
            return null;
        }
        if (map.containsKey(name)) {
            return (ContextMenuConfig)map.get(name);
        }
        for (String s : map.keySet()) {
            ContextMenuConfig cmc = (ContextMenuConfig)map.get(s);
            ContextMenuConfig ret = this.findContextMenu(cmc.subMenu, name);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public void addContextMenu(String name, String caption, String parentMenuName) {
        if (this.contextMenuMap == null) {
            this.contextMenuMap = new LinkedHashMap();
        }
        if (this.findContextMenu(this.contextMenuMap, name) != null) {
            System.out.println(String.valueOf(name) + "\u83dc\u5355\u5df2\u7ecf\u5b58\u5728 ");
            return;
        }
        LinkedHashMap parentMap = null;
        ContextMenuConfig pmc = null;
        if (parentMenuName.equals("")) {
            parentMap = this.contextMenuMap;
            pmc = null;
        } else {
            pmc = this.findContextMenu(this.contextMenuMap, parentMenuName);
            if (pmc == null) {
                System.out.println(String.valueOf(parentMenuName) + "\u83dc\u5355\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0\u5b50\u83dc\u5355 ");
                return;
            }
            if (pmc.subMenu == null) {
                pmc.subMenu = new LinkedHashMap();
            }
            parentMap = pmc.subMenu;
        }
        ContextMenuConfig cmc = new ContextMenuConfig();
        cmc.name = name;
        cmc.caption = caption;
        cmc.enabled = true;
        cmc.parentMenu = pmc;
        parentMap.put(name, cmc);
    }

    public void removeContextMenu(String name) {
        ContextMenuConfig pmc = this.findContextMenu(this.contextMenuMap, name);
        if (pmc == null) {
            return;
        }
        pmc.parentMenu.subMenu.remove(name);
        pmc.parentMenu = null;
        pmc.subMenu = null;
    }

    public void setContextMenuEnabled(String name, boolean enabled) {
        ContextMenuConfig cmc = this.findContextMenu(this.contextMenuMap, name);
        cmc.enabled = enabled;
    }

    public boolean isContextMenuEnabled(String name) {
        ContextMenuConfig cmc = this.findContextMenu(this.contextMenuMap, name);
        if (cmc == null) {
            return false;
        }
        return cmc.enabled;
    }

    public void showFindDialog() {
        if (this.findDialog != null) {
            return;
        }
        this.findDialog = new FindDialog(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WorkBook_.this.findDialog.setVisible(true);
            }
        });
    }

    public void setTheme(String theme) {
        this.theme = theme;
        if (this.theme == null) {
            this.theme = "";
        }
    }

    public String getTheme() {
        return this.theme;
    }

    public void setFocusRangeVisible(boolean v) {
        if (this.focusRangeVisible == v) {
            return;
        }
        this.focusRangeVisible = v;
        this.getActiveSheet().getWorkSheetView().repaint();
    }

    public boolean isFocusRangeVisible() {
        return this.focusRangeVisible;
    }

    public void do_addFocusRange() {
        WorkSheet sheet = this.getActiveSheet();
        Range_ r = (Range_)sheet.getSelection();
        sheet.addFocusRange(r.StartRow, r.StartCol, r.EndRow, r.EndCol);
        this.setFocusRangeVisible(true);
        sheet.getWorkSheetView().repaint();
    }

    public void do_removeFocusRange() {
        WorkSheet sheet = this.getActiveSheet();
        Range_ r = (Range_)sheet.getSelection();
        if (!Tools.confirm(sheet.getWorkSheetView(), "\u786e\u4fe1\u8981\u628a\u5f53\u524d\u9009\u4e2d\u533a\u57df\u4ece\u7126\u70b9\u533a\u57df\u4e2d\u79fb\u9664\u5417?")) {
            return;
        }
        boolean b = sheet.removeFocusRange(r.StartRow, r.StartCol, r.EndRow, r.EndCol);
        if (!b) {
            Tools.ShowInfo(sheet.getWorkSheetView(), "\u9009\u4e2d\u533a\u57df\u4e0d\u662f\u7126\u70b9\u533a\u57df\uff0c\u6240\u4ee5\u65e0\u6cd5\u5220\u9664\u3002");
        }
        this.setFocusRangeVisible(true);
        sheet.getWorkSheetView().repaint();
    }

    public void do_setFocusRangeNo() {
        WorkSheet_ sheet = (WorkSheet_)this.getActiveSheet();
        Object[] message = new Object[]{"\u8bbe\u7f6e\u65b0\u5e8f\u53f7[1-" + sheet.getFocusRangeList().size() + "]\uff0c\u5e8f\u53f7\u8d8a\u5c0f\u8d8a\u65e9\u5f97\u5230\u7f16\u8f91\u7126\u70b9\uff1a", new JTextField("")};
        ((JTextField)message[1]).requestFocus();
        int result = JOptionPane.showOptionDialog(this.getWorkBookView(), message, "\u8bbe\u7f6e\u5e8f\u53f7", 0, 1, null, null, null);
        if (result == 0) {
            String s = ((JTextField)message[1]).getText().toLowerCase().trim();
            int n = Tools.String2Int(s);
            if (n <= 0) {
                return;
            }
            Range_ r = (Range_)sheet.getSelection();
            sheet.setFocusRangeNo(r.StartRow, r.StartCol, r.EndRow, r.EndCol, n - 1);
            sheet.getWorkSheetView().repaint();
        }
    }

    public boolean isAllBrickDisabled() {
        return this.allBrickDisabled;
    }

    public void setAllBrickDisabled(boolean allBrickDisabled) {
        this.allBrickDisabled = allBrickDisabled;
        WorkSheet_ sheet = (WorkSheet_)this.getActiveSheet();
        sheet.getWorkSheetView().doLayout();
        sheet.getWorkSheetView().repaint();
        if (sheet.cellPanelList != null) {
            int i = 0;
            while (i < sheet.cellPanelList.size()) {
                WorkSheetView_ view = sheet.cellPanelList.get((int)i).innerSheetView;
                view.doLayout();
                view.repaint();
                ++i;
            }
        }
    }
}

