/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.brick.Brick;
import excel.brick.ScrollBar;
import excel.core.Cell;
import excel.core.DBBindConfig;
import excel.core.DataSourceConfig;
import excel.core.Range;
import excel.core.RowProperty;
import excel.core.RowPropertyManage;
import excel.core.WorkBook;
import excel.core.WorkSheet;
import excel.core.WorkSheetView;
import excel.core.impl.Cell_;
import excel.core.impl.WorkSheetView_;
import excel.core.impl.WorkSheet_;
import excel.util.Tools;
import java.util.ArrayList;
import jun.db.core.DataStore;

public final class RowPropertyManage_
implements RowPropertyManage {
    private ArrayList<RowProperty> heightList;
    private int RowHeadWidth = 40;
    private WorkSheet Sheet;

    public RowPropertyManage_(int rc, WorkSheet sheet) {
        this.Sheet = sheet;
        this.heightList = new ArrayList();
        int i = 0;
        while (i < rc) {
            RowProperty RP = new RowProperty();
            this.heightList.add(RP);
            ++i;
        }
    }

    public void _$RowPropertyManage_() {
        this.heightList = null;
    }

    public void $$insertBefore(int beforeRow) {
        if (beforeRow < 0) {
            beforeRow = 0;
        }
        RowProperty RP = new RowProperty();
        int rc = this.getRowCount();
        if (beforeRow >= rc) {
            this.heightList.add(RP);
        } else {
            this.heightList.add(beforeRow, RP);
        }
    }

    public void $insertMultiRow(int startRow, int endRow) {
        int i = startRow;
        while (i <= endRow) {
            this.$$insertBefore(i);
            ++i;
        }
    }

    public void $deleteRow(int row) {
        if (row < 0) {
            return;
        }
        int rc = this.getRowCount();
        if (row >= rc) {
            return;
        }
        this.heightList.remove(row);
    }

    public RowProperty getRowProperty(int row) {
        if (row < 0) {
            return null;
        }
        int rc = this.getRowCount();
        if (row >= rc) {
            return null;
        }
        return this.heightList.get(row);
    }

    public void $setRowProperty(int row, RowProperty rp) {
        if (row < 0) {
            return;
        }
        int rc = this.getRowCount();
        if (row >= rc) {
            return;
        }
        this.heightList.set(row, rp);
    }

    public int getRowCount() {
        return this.heightList.size();
    }

    public int getFixedRowCount() {
        Cell cell = this.Sheet.getFreezedCell();
        if (cell == null) {
            return 0;
        }
        return cell.getRowIndex();
    }

    public int getRowHeadWidth() {
        return this.RowHeadWidth;
    }

    public void setRowHeadWidth(int Width) {
        this.RowHeadWidth = Math.max(0, Width);
    }

    public int getRowHeight(int row) {
        return this.getRowHeight(row, false);
    }

    public int getRowHeight(int row, boolean originalHeight) {
        if (row < 0) {
            return 0;
        }
        if (row >= this.getRowCount()) {
            return 0;
        }
        if (originalHeight) {
            return this.heightList.get((int)row).height;
        }
        if (this.heightList.get((int)row).isHidden) {
            return 0;
        }
        return this.heightList.get((int)row).height;
    }

    public int getRowStretchHeight(int row) {
        if (row < 0) {
            return 0;
        }
        if (row >= this.getRowCount()) {
            return 0;
        }
        return this.heightList.get((int)row).stretchHeight;
    }

    public void setRowStretchHeight(int row, int newHeight) {
        if (row < 0) {
            return;
        }
        if (row >= this.getRowCount()) {
            return;
        }
        if (newHeight == this.heightList.get((int)row).stretchHeight) {
            return;
        }
        if (newHeight < 0) {
            return;
        }
        this.heightList.get((int)row).stretchHeight = newHeight;
        WorkSheetView_ view = (WorkSheetView_)this.Sheet.getWorkSheetView();
        if (view != null) {
            view.reCalcuRowsHeight();
        }
    }

    public int getRowScrolledRowCount(int row) {
        if (row < 0) {
            return 0;
        }
        if (row >= this.getRowCount()) {
            return 0;
        }
        return this.heightList.get((int)row).scrolledRowCount;
    }

    public boolean isGroupRowVisible(int row) {
        if (row < 0) {
            return false;
        }
        if (row > this.getRowCount()) {
            return false;
        }
        boolean b = this.heightList.get((int)row).groupRowHeight > 0;
        DataSourceConfig dsc = this.getMaximalDataSourceConfig(row);
        if (dsc != null) {
            if (dsc.getDataStore().getGroupRole().equals("")) {
                b = false;
            }
        } else {
            b = false;
        }
        return b;
    }

    public int getDBRowHeight(int row) {
        if (row < 0) {
            return 0;
        }
        if (row > this.getRowCount()) {
            return 0;
        }
        return this.heightList.get((int)row).dbrowheight;
    }

    public int getGroupRowHeight(int row) {
        if (row < 0) {
            return 0;
        }
        if (row > this.getRowCount()) {
            return 0;
        }
        return this.heightList.get((int)row).groupRowHeight;
    }

    public int getRowY(int row) {
        int ret = 0;
        int i = 0;
        while (i < row) {
            ret += this.getRowHeight(i);
            ++i;
        }
        return ret;
    }

    public void setRowScrolledRowCount(int row, int scrolledRowCount) {
        if (row < 0) {
            return;
        }
        if (row >= this.getRowCount()) {
            return;
        }
        if (scrolledRowCount < 0) {
            return;
        }
        this.heightList.get((int)row).scrolledRowCount = scrolledRowCount;
        int CC = this.Sheet.getColumnCount();
        int col = 0;
        while (col < CC) {
            Cell cell = ((WorkSheet_)this.Sheet).$Cells(row, col);
            if (cell != null) {
                Brick[] bs = cell.getBricks();
                int i = 0;
                while (i < bs.length) {
                    Brick b = bs[i];
                    if (b instanceof ScrollBar) {
                        ((ScrollBar)b).setValue(scrolledRowCount);
                    }
                    ++i;
                }
            }
            ++col;
        }
    }

    public void setGroupRowVisible(int row, boolean v) {
        int h = this.getDBRowHeight(row);
        this.setGroupRowHeight(row, v ? h : 0);
    }

    public void setGroupRowHeight(int row, int height) {
        if (row < 0) {
            return;
        }
        if (row >= this.getRowCount()) {
            return;
        }
        int oldHeight = this.heightList.get((int)row).groupRowHeight;
        if (height == oldHeight) {
            return;
        }
        if (height < 0) {
            return;
        }
        this.heightList.get((int)row).groupRowHeight = height;
        int dbh = this.getDBRowHeight(row);
        this.reCalcuRowHeight(row, dbh, dbh, height);
    }

    public void setRowHeight(int row, int newHeight) {
        if (row < 0) {
            return;
        }
        if (row >= this.getRowCount()) {
            return;
        }
        if (newHeight == this.heightList.get((int)row).height) {
            return;
        }
        if (newHeight < 0) {
            return;
        }
        int groupRowCount = this.getDBGroupRowCount(row);
        int groupRowHeight = this.getGroupRowHeight(row);
        int oldHeight = this.heightList.get((int)row).height;
        int oldDBHeight = this.heightList.get((int)row).dbrowheight;
        this.heightList.get((int)row).height = newHeight;
        if (this.heightList.get((int)row).dbColCount > 0) {
            int MaxRowCount = this.getMaxDBRowCount(row);
            if (this.isAutoAsyncHeightWithDBRowHeight(row)) {
                if (MaxRowCount * this.getDBRowHeight(row) + groupRowCount * groupRowHeight == newHeight) {
                    this.heightList.get((int)row).height = newHeight;
                } else {
                    int delta = newHeight - oldHeight;
                    int delta2 = Math.abs(delta);
                    int k = (delta2 - 1) / MaxRowCount + 1;
                    k *= MaxRowCount;
                    if (delta > 0) {
                        newHeight = oldHeight + k;
                    }
                    if (delta < 0) {
                        newHeight = oldHeight - k;
                    }
                    this.heightList.get((int)row).height = newHeight;
                    this.setDBRowHeight(row, (int)((double)newHeight * 1.0 / (double)MaxRowCount));
                }
            } else {
                int delta = newHeight - oldHeight;
                int deltaRow = delta > 0 ? (int)Math.ceil((double)delta * 1.0 / (double)oldDBHeight) : (int)Math.floor((double)delta * 1.0 / (double)oldDBHeight);
                this.heightList.get((int)row).height = oldHeight + deltaRow * oldDBHeight;
            }
        }
        WorkSheetView view = this.Sheet.getWorkSheetView();
        ((WorkSheet_)this.Sheet).resetInnerCellPanelSize();
        if (view != null) {
            view.repaint();
            view.EM().FireRowHeightChanged(row, oldHeight, newHeight);
        }
    }

    public void setDBRowHeight(int row, int height) {
        if (row < 0) {
            return;
        }
        if (row >= this.getRowCount()) {
            return;
        }
        int oldHeight = this.heightList.get((int)row).dbrowheight;
        if (height == oldHeight) {
            return;
        }
        if (height < 0) {
            return;
        }
        this.heightList.get((int)row).dbrowheight = height;
        this.reCalcuRowHeight(row, oldHeight, height, this.getGroupRowHeight(row));
    }

    private void reCalcuRowHeight(int row, int oldHeight, int height, int groupHeight) {
        WorkSheetView view;
        if (this.heightList.get((int)row).dbColCount > 0) {
            int MaxRowCount = this.getMaxDBRowCount(row);
            int groupRowCount = this.getDBGroupRowCount(row);
            if (this.isAutoAsyncHeightWithDBRowHeight(row)) {
                this.setRowHeight(row, MaxRowCount * height + groupRowCount * groupHeight);
            } else {
                int h = this.getRowHeight(row);
                int rate = (int)Math.floor((double)h * 1.0 / (double)oldHeight);
                this.setRowHeight(row, rate * height);
            }
        }
        if ((view = this.Sheet.getWorkSheetView()) != null) {
            view.repaint();
        }
    }

    public int getDBGroupRowCount(int row) {
        ArrayList<String> dsNameList = new ArrayList<String>();
        WorkBook book = this.Sheet.getWorkBook();
        int MaxRowCount = 0;
        int col = 0;
        while (col < this.Sheet.getColumnPropertyManage().getColumnCount()) {
            String dsName;
            DBBindConfig bind;
            Cell_ cell = (Cell_)((WorkSheet_)this.Sheet).$Cells(row, col);
            if (cell != null && (bind = cell.getBind()) != null && !dsNameList.contains(dsName = bind.getDataSource())) {
                dsNameList.add(dsName);
                DataSourceConfig dsc = book.getDataSource(dsName);
                if (dsc.getDataSourceType() == 2) {
                    DataStore ds = dsc.getDataStore();
                    Range mr = cell.getMergedRange();
                    int gr = 0;
                    if (this.isGroupRowVisible(row)) {
                        gr = Tools.getGroupsRowCount(ds);
                    }
                    if (mr != null) {
                        if (mr.getEndRow() == cell.getRowIndex()) {
                            MaxRowCount = Math.max(MaxRowCount, gr);
                        }
                    } else {
                        MaxRowCount = Math.max(MaxRowCount, gr);
                    }
                }
            }
            ++col;
        }
        dsNameList.clear();
        dsNameList = null;
        return MaxRowCount;
    }

    public int getMaxDBRowCount(int row) {
        ArrayList<String> dsNameList = new ArrayList<String>();
        WorkBook book = this.Sheet.getWorkBook();
        int MaxRowCount = 1;
        int col = 0;
        while (col < this.Sheet.getColumnPropertyManage().getColumnCount()) {
            String dsName;
            DBBindConfig bind;
            Cell_ cell = (Cell_)((WorkSheet_)this.Sheet).$Cells(row, col);
            if (cell != null && (bind = cell.getBind()) != null && !dsNameList.contains(dsName = bind.getDataSource())) {
                dsNameList.add(dsName);
                DataSourceConfig dsc = book.getDataSource(dsName);
                if (dsc.getDataSourceType() == 2) {
                    DataStore ds = dsc.getDataStore();
                    Range mr = cell.getMergedRange();
                    if (mr != null) {
                        if (mr.getEndRow() == cell.getRowIndex()) {
                            MaxRowCount = Math.max(MaxRowCount, ds.getRowCount());
                        }
                    } else {
                        MaxRowCount = Math.max(MaxRowCount, ds.getRowCount());
                    }
                }
            }
            ++col;
        }
        dsNameList.clear();
        dsNameList = null;
        return MaxRowCount;
    }

    public DataSourceConfig getMaximalDataSourceConfig(int row) {
        ArrayList<String> dsNameList = new ArrayList<String>();
        WorkBook book = this.Sheet.getWorkBook();
        int MaxRowCount = 1;
        DataSourceConfig MaxDSC = null;
        int col = 0;
        while (col < this.Sheet.getColumnPropertyManage().getColumnCount()) {
            String dsName;
            DBBindConfig bind;
            Cell_ cell = (Cell_)((WorkSheet_)this.Sheet).$Cells(row, col);
            if (cell != null && (bind = cell.getBind()) != null && !dsNameList.contains(dsName = bind.getDataSource())) {
                dsNameList.add(dsName);
                DataSourceConfig dsc = book.getDataSource(dsName);
                int mrc = dsc.getDataStore().getRowCount();
                if (mrc > MaxRowCount) {
                    MaxRowCount = mrc;
                    MaxDSC = dsc;
                }
            }
            ++col;
        }
        dsNameList.clear();
        dsNameList = null;
        return MaxDSC;
    }

    public int getFixedRowHeight() {
        return this.getRowY(this.getFixedRowCount());
    }

    public int getAllRowsHeight() {
        int ret = 0;
        int n = this.getRowCount();
        int i = 0;
        while (i < n) {
            ret += this.heightList.get((int)i).height;
            ++i;
        }
        return ret;
    }

    public void AddBindCount(int row) {
        if (row < 0) {
            return;
        }
        if (row >= this.getRowCount()) {
            return;
        }
        ++this.heightList.get((int)row).dbColCount;
    }

    public void ReleaseBindCount(int row) {
        if (row < 0) {
            return;
        }
        if (row >= this.getRowCount()) {
            return;
        }
        --this.heightList.get((int)row).dbColCount;
    }

    public int getBindedCount(int row) {
        if (row < 0) {
            return 0;
        }
        if (row >= this.getRowCount()) {
            return 0;
        }
        return this.heightList.get((int)row).dbColCount;
    }

    public boolean isRowHidden(int row) {
        if (row < 0) {
            return false;
        }
        int rc = this.getRowCount();
        if (row >= rc) {
            return false;
        }
        return this.heightList.get((int)row).isHidden;
    }

    public void setRowHidden(int row, boolean hidden) {
        if (row < 0) {
            return;
        }
        int rc = this.getRowCount();
        if (row >= rc) {
            return;
        }
        if (this.heightList.get((int)row).isHidden == hidden) {
            return;
        }
        this.heightList.get((int)row).isHidden = hidden;
        WorkSheetView view = this.Sheet.getWorkSheetView();
        if (view != null) {
            view.repaint();
        }
    }

    public boolean isAutoAsyncHeightWithDBRowHeight(int row) {
        if (row < 0) {
            return true;
        }
        int rc = this.getRowCount();
        if (row >= rc) {
            return true;
        }
        return this.heightList.get((int)row).autoAsyncHeightWithDBRowHeight;
    }

    public void setAutoAsyncHeightWithDBRowHeight(int row, boolean auto) {
        if (row < 0) {
            return;
        }
        int rc = this.getRowCount();
        if (row >= rc) {
            return;
        }
        if (this.heightList.get((int)row).autoAsyncHeightWithDBRowHeight == auto) {
            return;
        }
        this.heightList.get((int)row).autoAsyncHeightWithDBRowHeight = auto;
        WorkSheetView view = this.Sheet.getWorkSheetView();
        if (view != null) {
            view.repaint();
        }
    }

    public void setColumnScrollEnable(int row, boolean enable) {
        if (row < 0) {
            return;
        }
        int rc = this.getRowCount();
        if (row >= rc) {
            return;
        }
        if (this.heightList.get((int)row).columnScrollEnabled == enable) {
            return;
        }
        this.heightList.get((int)row).columnScrollEnabled = enable;
    }

    public boolean isColumnScrollEnabled(int row) {
        if (row < 0) {
            return true;
        }
        int rc = this.getRowCount();
        if (row >= rc) {
            return true;
        }
        return this.heightList.get((int)row).columnScrollEnabled;
    }
}

