/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.core.Property;
import excel.util.Tools;
import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import jun.db.core.ObjectTool;

public class Property_
implements Property,
Serializable {
    public static Property_ defaultProperty = new Property_();
    private int refCount = 0;
    private String GUID = Tools.newGUID();
    private HashMap property = new HashMap();

    static {
        defaultProperty.put("border-left-style", 0);
        defaultProperty.put("border-left-width", 0);
        defaultProperty.put("border-left-color", Color.BLACK);
        defaultProperty.put("border-right-color", Color.BLACK);
        defaultProperty.put("border-right-style", 0);
        defaultProperty.put("border-right-width", 0);
        defaultProperty.put("border-top-color", Color.BLACK);
        defaultProperty.put("border-top-style", 0);
        defaultProperty.put("border-top-width", 0);
        defaultProperty.put("border-bottom-color", Color.BLACK);
        defaultProperty.put("border-bottom-style", 0);
        defaultProperty.put("border-bottom-width", 0);
        defaultProperty.put("padding-bottom", 1);
        defaultProperty.put("padding-left", 1);
        defaultProperty.put("padding-right", 1);
        defaultProperty.put("padding-top", 1);
        defaultProperty.put("background-mode", 0);
        defaultProperty.put("background-color", Color.WHITE);
        defaultProperty.put("background-image", "");
        defaultProperty.put("background-position-x", 0);
        defaultProperty.put("background-position-y", 0);
        defaultProperty.put("background-repeat-x", false);
        defaultProperty.put("background-repeat-y", false);
        defaultProperty.put("font-name", "\u5b8b\u4f53");
        defaultProperty.put("font-size", 12);
        defaultProperty.put("font-bold", false);
        defaultProperty.put("font-italic", false);
        defaultProperty.put("font-underline", false);
        defaultProperty.put("word-wrap", false);
        defaultProperty.put("font-color", Color.BLACK);
        defaultProperty.put("align-h", 999);
        defaultProperty.put("align-v", 2);
        defaultProperty.put("auto-fit-height", false);
        defaultProperty.put("auto-fit-width", false);
        defaultProperty.put("show-corner-sign", false);
        defaultProperty.put("show-corner-sign-color", Color.red);
        defaultProperty.put("display", true);
        defaultProperty.put("display-expression", "");
        defaultProperty.put("font-color-expression", "");
        defaultProperty.put("background-color-expression", "");
    }

    public boolean get(String propertyName, boolean defaultValue) {
        Object v = this.get(propertyName, (Object)null);
        if (v == null) {
            return defaultValue;
        }
        try {
            if (v instanceof Boolean) {
                return (Boolean)v;
            }
            return Boolean.valueOf(v.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Color get(String propertyName, Color defaultValue) {
        Object v = this.get(propertyName, (Object)null);
        if (v == null) {
            return defaultValue;
        }
        try {
            if (v instanceof Color) {
                return (Color)v;
            }
            return Tools.Hex2Color(v.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int get(String propertyName, int defaultValue) {
        Object v = this.get(propertyName, (Object)null);
        if (v == null) {
            return defaultValue;
        }
        try {
            if (v instanceof Number) {
                return ((Number)v).intValue();
            }
            return new Integer(v.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public String get(String propertyName, String defaultValue) {
        Object v = this.get(propertyName, (Object)defaultValue);
        if (v == null) {
            return defaultValue;
        }
        try {
            String s = (String)ObjectTool.ChangeType((Object)v, (String)"java.lang.String");
            return s;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Object get(String propertyName, Object defaultValue) {
        if (!this.property.containsKey(propertyName)) {
            return defaultValue;
        }
        try {
            Object v = this.property.get(propertyName);
            if (v == null) {
                v = defaultValue;
            }
            return v;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public void put(String propertyName, boolean value) {
        this.property.put(propertyName, value);
    }

    public void put(String propertyName, Color value) {
        this.property.put(propertyName, value);
    }

    public void put(String propertyName, int value) {
        this.property.put(propertyName, new Integer(value));
    }

    public void put(String propertyName, String value) {
        this.property.put(propertyName, value);
    }

    public void put(String propertyName, Object value) {
        this.property.put(propertyName, value);
    }

    public void AddRef() {
        ++this.refCount;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public void ReleaseRef() {
        --this.refCount;
    }

    public String getGUID() {
        return this.GUID;
    }

    public boolean equals(Property p) {
        if (p == null) {
            return false;
        }
        Set pk = p.getPropertyNames();
        Set k = this.getPropertyNames();
        if (pk.size() != k.size()) {
            return false;
        }
        if (!pk.equals(k)) {
            return false;
        }
        for (String key : pk) {
            Object p1 = this.get(key, (Object)null);
            Object p2 = p.get(key, (Object)null);
            if (p1 == null && p2 == null) continue;
            if (p1 != null && p2 == null) {
                return false;
            }
            if (p1 == null && p2 != null) {
                return false;
            }
            if (p1.equals(p2)) continue;
            return false;
        }
        return true;
    }

    public Set getPropertyNames() {
        return this.property.keySet();
    }

    public Object clone() {
        Property_ temp = new Property_();
        Set k = this.getPropertyNames();
        for (String key : k) {
            Object p = this.get(key, (Object)null);
            temp.put(key, p);
        }
        return temp;
    }
}

