/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.core.WorkSheet;
import excel.core.WorkSheetView;
import excel.core.impl.CellPanel_;
import excel.util.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PopupContainer
extends JDialog {
    JLabel title;
    JButton jb_ok;
    JButton jb_exit;
    private Point origin = new Point();
    WorkSheet sheet;
    JPanel cc = new JPanel();
    Container oldParent;

    public PopupContainer(WorkSheet sheet, String caption, int borderThick, Color borderColor, int width, int height, boolean modal, int x, int y, boolean showTitleBar, boolean showButtonBar) {
        super(JOptionPane.getFrameForComponent(sheet.getWorkBook().getWorkBookView()), caption, modal);
        super.setTitle(caption);
        this.setUndecorated(true);
        this.sheet = sheet;
        JPanel outBorder = new JPanel();
        if (borderColor == null) {
            borderColor = new Color(13481215);
        }
        outBorder.setBorder(BorderFactory.createLineBorder(borderColor, borderThick));
        outBorder.setLayout(new BorderLayout());
        this.getContentPane().add((Component)outBorder, "Center");
        this.setDefaultCloseOperation(2);
        this.cc.setBorder(BorderFactory.createLineBorder(new Color(10317055), 1));
        this.cc.setLayout(new BorderLayout());
        outBorder.add((Component)this.cc, "Center");
        this.title = new JLabel();
        this.title.setPreferredSize(new Dimension(width, 20));
        this.title.setOpaque(true);
        this.title.setBackground(borderColor);
        this.title.setForeground(Color.white);
        this.title.setCursor(new Cursor(13));
        this.title.setText(" " + caption);
        this.title.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                Point p = PopupContainer.this.getLocation();
                PopupContainer.this.setLocation(p.x + e.getX() - ((PopupContainer)PopupContainer.this).origin.x, p.y + e.getY() - ((PopupContainer)PopupContainer.this).origin.y);
            }
        });
        this.title.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ((PopupContainer)PopupContainer.this).origin.x = e.getX();
                ((PopupContainer)PopupContainer.this).origin.y = e.getY();
            }
        });
        JLabel jb_exit2 = new JLabel();
        jb_exit2.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/res/cancel2.gif")));
        jb_exit2.setToolTipText("\u5173\u95ed");
        jb_exit2.setOpaque(true);
        jb_exit2.setBackground(borderColor);
        jb_exit2.setBorder(null);
        jb_exit2.setPreferredSize(new Dimension(16, 16));
        jb_exit2.setCursor(new Cursor(12));
        jb_exit2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                PopupContainer.this.exit();
            }
        });
        JPanel titleBar = new JPanel();
        titleBar.setLayout(new BorderLayout());
        titleBar.add((Component)this.title, "Center");
        titleBar.add((Component)jb_exit2, "East");
        if (showTitleBar) {
            this.cc.add((Component)titleBar, "North");
        }
        this.jb_ok = new JButton("\u786e\u5b9a");
        this.jb_ok.setPreferredSize(new Dimension(80, 32));
        this.jb_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupContainer.this.onOK();
            }
        });
        this.jb_exit = new JButton("\u53d6\u6d88");
        this.jb_exit.setPreferredSize(new Dimension(80, 32));
        this.jb_exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupContainer.this.exit();
            }
        });
        JPanel toolbar = new JPanel();
        WorkSheetView view = sheet.getWorkSheetView();
        this.oldParent = view.getParent();
        sheet.getWorkSheetView().setVisible(true);
        if (showButtonBar) {
            this.cc.add((Component)toolbar, "South");
        }
        CellPanel_ cp = new CellPanel_(sheet, this.cc, false, false);
        toolbar.add(this.jb_ok);
        toolbar.add(this.jb_exit);
        this.setSize(width, height);
        if (x != 0 && y != 0) {
            this.setLocation(x, y);
        } else {
            Tools.MoveToScreenCenter(this);
        }
    }

    public void onOK() {
        this.cc.remove(this.sheet.getWorkSheetView());
        this.dispose();
        this.oldParent.add(this.sheet.getWorkSheetView());
        this.sheet.popupDispose();
        this.sheet.getWorkBook().getEM().firePopupedWorkSheetOnOK(this.sheet);
    }

    public void exit() {
        this.cc.remove(this.sheet.getWorkSheetView());
        this.dispose();
        this.oldParent.add(this.sheet.getWorkSheetView());
        this.sheet.popupDispose();
        this.sheet.getWorkBook().getEM().firePopupedWorkSheetOnCancel(this.sheet);
    }
}

