/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.core.EditStyle;
import excel.core.WorkBook;
import java.util.Map;
import java.util.TreeMap;

public class EditStyle_
implements EditStyle {
    private WorkBook book;
    private int ET = 0;
    private String Name = "";
    private String ddlbName = "";
    private boolean valueMustInDDLB;
    private boolean AutoWordWrap = true;
    private boolean ShowComma = true;
    private int DecimalCount = 2;
    private boolean ZeroVisibleWhenEditable = true;
    private boolean ZeroVisibleWhenUneditable = true;
    private String DatetimeFormat = "YYYY.MM.DD";
    private boolean DropDownListEditable = false;
    private Map DropDownDataMap = new TreeMap();
    private String ddlbFilterBy = null;
    private boolean showRealData = false;
    private int widthPercent = 100;
    private Object CheckOnValue = null;
    private Object CheckOffValue = null;
    private String CheckBoxTipText = "";
    private DDLB_STYLE ddlbStyle = DDLB_STYLE.DDLB;
    private int columnCount = 1;
    private boolean readOnly = false;

    public static EditStyle newEditStyle(WorkBook book, String name, int et) {
        EditStyle_ es = new EditStyle_(book, name, et);
        return es;
    }

    private EditStyle_(WorkBook book, String name, int et) {
        this.book = book;
        this.Name = name.toLowerCase().trim();
        this.ET = et;
    }

    public int getEditType() {
        return this.ET;
    }

    public String getEditTypeName() {
        switch (this.ET) {
            case 5: {
                return "checkbox";
            }
            case 3: {
                return "datetime";
            }
            case 4: {
                return "ddlb";
            }
            case 8: {
                return "multicheckbox";
            }
            case 1: {
                return "numeric";
            }
            case 6: {
                return "radio";
            }
            case 7: {
                return "richtext";
            }
            case 9: {
                return "tree";
            }
        }
        return "unnamed " + this.ET;
    }

    public String getName() {
        return this.Name;
    }

    public String getCheckBoxTipText() {
        return this.CheckBoxTipText;
    }

    public void setCheckBoxTipText(String checkBoxTipText) {
        this.CheckBoxTipText = checkBoxTipText;
    }

    public Object getCheckOffValue() {
        return this.CheckOffValue;
    }

    public void setCheckOffValue(Object checkOffValue) {
        this.CheckOffValue = checkOffValue;
    }

    public Object getCheckOnValue() {
        return this.CheckOnValue;
    }

    public void setCheckOnValue(Object checkOnValue) {
        this.CheckOnValue = checkOnValue;
    }

    public void setCheckOnValue(int checkOnValue) {
        this.CheckOnValue = new Integer(checkOnValue);
    }

    public void setCheckOnValue(String checkOnValue) {
        this.CheckOnValue = checkOnValue;
    }

    public String getDatetimeFormat() {
        return this.DatetimeFormat;
    }

    public void setDatetimeFormat(String datetimeFormat) {
        this.DatetimeFormat = datetimeFormat;
    }

    public int getDecimalCount() {
        return this.DecimalCount;
    }

    public void setDecimalCount(int decimalCount) {
        this.DecimalCount = decimalCount;
    }

    public void setDDLBFilterBy(String ddlbFilterBy_) {
        this.ddlbFilterBy = ddlbFilterBy_;
        if (this.ddlbFilterBy == null) {
            return;
        }
        this.ddlbFilterBy = this.ddlbFilterBy.trim();
        if (this.ddlbFilterBy.equals("")) {
            this.ddlbFilterBy = null;
        }
    }

    public String getDDLBFilterBy() {
        return this.ddlbFilterBy;
    }

    public Map getDropDownData2ViewMap() {
        return this.DropDownDataMap;
    }

    public Map getDropDownData2ViewMapForEdit(int innerRow) {
        if (this.ddlbFilterBy == null) {
            return this.DropDownDataMap;
        }
        Map map = this.book.getEM().fireGetDynamicDDLB(this.ddlbFilterBy, innerRow);
        if (map != null) {
            return map;
        }
        return this.DropDownDataMap;
    }

    public void setDropDownData2ViewMap(Map dropDownDataMap) {
        this.DropDownDataMap = dropDownDataMap;
    }

    public boolean isDropDownListEditable() {
        return this.DropDownListEditable;
    }

    public void setDropDownListEditable(boolean dropDownListEditable) {
        this.DropDownListEditable = dropDownListEditable;
    }

    public boolean isShowComma() {
        return this.ShowComma;
    }

    public void setShowComma(boolean showComma) {
        this.ShowComma = showComma;
    }

    public boolean isAutoWordWrap() {
        return this.AutoWordWrap;
    }

    public void setAutoWordWrap(boolean autoWordWrap) {
        this.AutoWordWrap = autoWordWrap;
    }

    public int getColumnCountOnRow() {
        return Math.max(1, this.columnCount);
    }

    public boolean isListShowAsDDLB() {
        return this.ddlbStyle == DDLB_STYLE.DDLB;
    }

    public boolean isListShowAsCheckBox() {
        return this.ddlbStyle == DDLB_STYLE.CHECKBOX;
    }

    public boolean isListShowAsDropdownCheckBox() {
        return this.ddlbStyle == DDLB_STYLE.DDCHECKBOX;
    }

    public boolean isListShowAsRadioButton() {
        return this.ddlbStyle == DDLB_STYLE.RADIO;
    }

    public void setColumnCountOnRow(int columnCount) {
        this.columnCount = columnCount;
    }

    public void setListShowAsDDLB() {
        this.ddlbStyle = DDLB_STYLE.DDLB;
    }

    public void setListShowAsDropdownCheckBox() {
        this.ddlbStyle = DDLB_STYLE.DDCHECKBOX;
    }

    public void setListShowAsCheckBox() {
        this.ddlbStyle = DDLB_STYLE.CHECKBOX;
    }

    public void setListShowAsRadioButton() {
        this.ddlbStyle = DDLB_STYLE.RADIO;
    }

    public boolean isShowRealData() {
        return this.showRealData;
    }

    public void setShowRealData(boolean showRealData) {
        this.showRealData = showRealData;
    }

    public int getDDLBWidthPercent() {
        return this.widthPercent;
    }

    public void setDDLBWidthPercent(int p) {
        this.widthPercent = p;
    }

    public String getDDLBName() {
        return this.ddlbName;
    }

    public void setDDLBName(String ddlbName) {
        this.ddlbName = ddlbName;
    }

    public boolean isValueMustInDDLB() {
        return this.valueMustInDDLB;
    }

    public void setValueMustInDDLB(boolean valueMustInDDLB) {
        this.valueMustInDDLB = valueMustInDDLB;
    }

    public boolean isZeroVisibleWhenEditable() {
        return this.ZeroVisibleWhenEditable;
    }

    public void setZeroVisibleWhenEditable(boolean zeroVisible) {
        this.ZeroVisibleWhenEditable = zeroVisible;
    }

    public boolean isZeroVisibleWhenUneditable() {
        return this.ZeroVisibleWhenUneditable;
    }

    public void setZeroVisibleWhenUneditable(boolean zeroVisible) {
        this.ZeroVisibleWhenUneditable = zeroVisible;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DDLB_STYLE {
        DDLB,
        RADIO,
        CHECKBOX,
        DDCHECKBOX;

    }
}

