/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.brick.Brick;
import excel.brick.ScrollBar;
import excel.brick.impl.ScrollBar_;
import excel.core.Cell;
import excel.core.CellPanel;
import excel.core.ColumnPropertyManage;
import excel.core.RowPropertyManage;
import excel.core.WorkSheet;
import excel.core.WorkSheetView;
import excel.core.impl.Cell_;
import excel.core.impl.WorkBook_;
import excel.core.impl.WorkSheetView_;
import excel.core.impl.WorkSheet_;
import excel.util.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;

public class CellPanel_
extends JPanel
implements CellPanel,
ComponentListener,
AdjustmentListener,
KeyListener {
    public static int MODE_INNER = 1;
    public static int MODE_DIALOG = 2;
    int mode;
    public KeyEvent lastKeyEvent = null;
    Container pContainer = null;
    Cell_ pCell;
    WorkSheet_ pSheet;
    WorkSheet_ innerSheet;
    WorkSheetView_ innerSheetView;
    WorkBook_ Book;
    public JScrollBar vScrollBar;
    public JScrollBar hScrollBar;
    boolean appendRight;
    boolean appendBottom;
    JLabel jb_appendRight = null;
    JLabel jb_appendBottom = null;
    JLabel jb_appendBoth = null;
    boolean appendRightChecked = false;
    boolean appendBottomChecked = false;
    Timer paintTimer = null;
    ScrollTask paintTask = null;
    ImageIcon icon_r;
    ImageIcon icon_l;
    ImageIcon icon_b;
    ImageIcon icon_t;
    ImageIcon icon_expand;
    ImageIcon icon_collpase;

    public CellPanel_(WorkSheet targetSheet, Container cc, boolean appendRight, boolean appendBottom) {
        this.mode = MODE_DIALOG;
        this.pContainer = cc;
        this.innerSheet = (WorkSheet_)targetSheet;
        this.innerSheet.setContainerCellPanel(this);
        this.innerSheetView = (WorkSheetView_)this.innerSheet.getWorkSheetView();
        this.Book = (WorkBook_)targetSheet.getWorkBook();
        if (!(this.pContainer.getLayout() instanceof BorderLayout)) {
            this.pContainer.setLayout(new BorderLayout());
        }
        this.pContainer.add((Component)this, "Center");
        this.appendBottom = appendBottom;
        this.appendRight = appendRight;
        this.init();
    }

    public CellPanel_(WorkSheet targetSheet, Cell parentCell, boolean appendRight, boolean appendBottom) {
        this.appendBottom = appendBottom;
        this.appendRight = appendRight;
        this.mode = MODE_INNER;
        this.pCell = (Cell_)parentCell;
        this.pSheet = (WorkSheet_)this.pCell.getWorkSheet();
        this.innerSheet = (WorkSheet_)targetSheet;
        this.innerSheet.setContainerCellPanel(this);
        this.innerSheet.setVisible(false);
        this.innerSheetView = (WorkSheetView_)this.innerSheet.getWorkSheetView();
        this.Book = (WorkBook_)targetSheet.getWorkBook();
        WorkSheetView_ pView = (WorkSheetView_)this.pSheet.getWorkSheetView();
        pView.add(this);
        this.setBackground(this.pSheet.getPaperColor());
        this.init();
    }

    public void init() {
        Tools.initAllFontSon9();
        this.setLayout(null);
        this.vScrollBar = new JScrollBar(1);
        int w = 18;
        int h = 16;
        if (this.appendBottom && this.appendRight) {
            this.icon_expand = new ImageIcon(Tools.GetImageFromURL(this, "excel/res/e.png"));
            this.icon_collpase = new ImageIcon(Tools.GetImageFromURL(this, "excel/res/c.png"));
            this.jb_appendBoth = new JLabel();
            this.jb_appendBoth.setIcon(this.icon_expand);
            this.jb_appendBoth.setToolTipText("\u5c55\u5f00/\u6536\u7f29");
            this.jb_appendBoth.setOpaque(true);
            this.jb_appendBoth.setBackground(this.innerSheet.getPaperColor());
            this.jb_appendBoth.setBorder(null);
            this.jb_appendBoth.setPreferredSize(new Dimension(16, 16));
            this.jb_appendBoth.setCursor(new Cursor(12));
            this.jb_appendBoth.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    CellPanel_.this.appendBottomChecked = CellPanel_.this.appendRightChecked = !CellPanel_.this.appendRightChecked;
                    CellPanel_.this.jb_appendBoth.setIcon(CellPanel_.this.appendRightChecked ? CellPanel_.this.icon_collpase : CellPanel_.this.icon_expand);
                    CellPanel_.this.reCalcuSize();
                }
            });
            this.jb_appendBoth.setBounds(0, 0, h, h);
            this.add(this.jb_appendBoth);
        }
        if (this.appendRight && !this.appendBottom) {
            this.icon_r = new ImageIcon(Tools.GetImageFromURL(this, "excel/res/r.png"));
            this.icon_l = new ImageIcon(Tools.GetImageFromURL(this, "excel/res/l.png"));
            this.jb_appendRight = new JLabel();
            this.jb_appendRight.setIcon(this.icon_r);
            this.jb_appendRight.setToolTipText("\u5411\u53f3\u5c55\u5f00/\u5411\u5de6\u6536\u7f29");
            this.jb_appendRight.setOpaque(true);
            this.jb_appendRight.setBackground(this.innerSheet.getPaperColor());
            this.jb_appendRight.setBorder(null);
            this.jb_appendRight.setPreferredSize(new Dimension(16, 16));
            this.jb_appendRight.setCursor(new Cursor(12));
            this.jb_appendRight.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    CellPanel_.this.appendRightChecked = !CellPanel_.this.appendRightChecked;
                    CellPanel_.this.jb_appendRight.setIcon(CellPanel_.this.appendRightChecked ? CellPanel_.this.icon_l : CellPanel_.this.icon_r);
                    CellPanel_.this.reCalcuSize();
                }
            });
            this.jb_appendRight.setBounds(0, 0, h, h);
            this.add(this.jb_appendRight);
        }
        if (this.appendBottom && !this.appendRight) {
            this.icon_b = new ImageIcon(Tools.GetImageFromURL(this, "excel/res/b.png"));
            this.icon_t = new ImageIcon(Tools.GetImageFromURL(this, "excel/res/t.png"));
            this.jb_appendBottom = new JLabel();
            this.jb_appendBottom.setIcon(this.icon_b);
            this.jb_appendBottom.setToolTipText("\u5411\u4e0b\u5c55\u5f00/\u5411\u4e0a\u6536\u7f29");
            this.jb_appendBottom.setOpaque(true);
            this.jb_appendBottom.setBackground(this.innerSheet.getPaperColor());
            this.jb_appendBottom.setBorder(null);
            this.jb_appendBottom.setPreferredSize(new Dimension(16, 16));
            this.jb_appendBottom.setCursor(new Cursor(12));
            this.jb_appendBottom.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    CellPanel_.this.appendBottomChecked = !CellPanel_.this.appendBottomChecked;
                    CellPanel_.this.jb_appendBottom.setIcon(CellPanel_.this.appendBottomChecked ? CellPanel_.this.icon_t : CellPanel_.this.icon_b);
                    CellPanel_.this.reCalcuSize();
                }
            });
            this.jb_appendBottom.setBounds(0, 0, h, h);
            this.add(this.jb_appendBottom);
        }
        this.vScrollBar.setBounds(0, 0, h, h);
        this.vScrollBar.addAdjustmentListener(this);
        this.hScrollBar = new JScrollBar(0);
        this.hScrollBar.setBounds(0, 0, w, w);
        this.hScrollBar.addAdjustmentListener(this);
        this.innerSheetView.setVisible(true);
        this.add(this.innerSheetView);
        this.add(this.hScrollBar);
        this.add(this.vScrollBar);
        this.addComponentListener(this);
        this.addKeyListener(this);
        this.reCalcuSize();
    }

    public WorkSheet getInnerSheet() {
        return this.innerSheet;
    }

    public WorkSheet getParentSheet() {
        return this.pSheet;
    }

    public void reCalcuSize() {
        if (this.mode == MODE_INNER) {
            int x;
            int fc;
            int y;
            WorkSheetView_ pView = (WorkSheetView_)this.pSheet.getWorkSheetView();
            Rectangle pRC = pView.getBounds();
            Rectangle rc = pView.getShowRectangleOfCell(false, this.pCell.getRowIndex(), this.pCell.getColumnIndex());
            RowPropertyManage RPM = this.pSheet.getRowPropertyManage();
            ColumnPropertyManage CPM = this.pSheet.getColumnPropertyManage();
            int fr = RPM.getFixedRowCount();
            if (fr > 0 && this.pCell.getRowIndex() > fr && rc.y < (y = RPM.getFixedRowHeight() + CPM.getColumnHeadHeight())) {
                rc.height -= y - rc.y;
                rc.y = y;
            }
            if ((fc = CPM.getFixedColumnCount()) > 0 && this.pCell.getColumnIndex() > fc && rc.x < (x = CPM.getFixedColumnWidth() + RPM.getRowHeadWidth())) {
                rc.width -= x - rc.x;
                rc.x = x;
            }
            if (this.appendRight && this.appendRightChecked) {
                rc.width = pRC.width - rc.x;
            }
            if (this.appendBottom && this.appendBottomChecked) {
                rc.height = pRC.height - rc.y;
            }
            ++rc.x;
            ++rc.y;
            --rc.width;
            --rc.height;
            this.setBounds(rc);
            this.componentResized(null);
        } else {
            this.componentResized(null);
        }
    }

    public Rectangle getSheetRect() {
        Rectangle rc = this.getBounds();
        int x = 0;
        int y = 0;
        int w = rc.width - (this.vScrollBar.isVisible() ? this.vScrollBar.getWidth() : 0);
        int h = rc.height - y - (this.hScrollBar.isVisible() ? this.hScrollBar.getHeight() : 0);
        if (this.appendBottom || this.appendRight) {
            y += 18;
            h -= 18;
        }
        Rectangle sheetRC = new Rectangle(x, y, w, h);
        return sheetRC;
    }

    public void componentResized(ComponentEvent e) {
        Rectangle rc = this.getBounds();
        if (this.appendRight && this.appendBottom) {
            this.jb_appendBoth.setBounds(rc.width - 16, 0, 16, 16);
        }
        if (this.appendRight && !this.appendBottom) {
            this.jb_appendRight.setBounds(rc.width - 16, 0, 16, 16);
        }
        if (this.appendBottom && !this.appendRight) {
            this.jb_appendBottom.setBounds(rc.width - 16, 0, 16, 16);
        }
        if (this.innerSheetView.includeStretchColumn()) {
            this.hScrollBar.setVisible(false);
        }
        if (this.innerSheetView.includeStretchRow()) {
            this.vScrollBar.setVisible(false);
        }
        Rectangle sheetRC = this.getSheetRect();
        if (this.vScrollBar.isVisible()) {
            this.vScrollBar.setBounds(rc.width - this.vScrollBar.getWidth(), sheetRC.y, this.vScrollBar.getWidth(), sheetRC.height);
        }
        if (this.hScrollBar.isVisible()) {
            this.hScrollBar.setBounds(0, rc.height - this.hScrollBar.getHeight(), rc.width - (this.vScrollBar.isVisible() ? this.vScrollBar.getWidth() : 0), this.hScrollBar.getHeight());
        }
        this.innerSheetView.setBounds(sheetRC);
        if (this.innerSheetView.includeStretchColumn()) {
            this.innerSheetView.reCalcuColumnsWidth();
        }
        if (this.innerSheetView.includeStretchRow()) {
            this.innerSheetView.reCalcuRowsHeight();
        }
        this.ResetHScrollBarScrollRange();
        this.ResetVScrollBarScrollRange();
        this.vScrollBar.revalidate();
        this.hScrollBar.revalidate();
        this.innerSheetView.revalidate();
        this.innerSheet.resetInnerCellPanelSize();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public JComponent toJComponent() {
        return this;
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.SimulateAdjustmentValueChanged(e, e.getAdjustable().equals(this.hScrollBar));
        WorkSheetView_ view = this.innerSheetView;
        view.forceCurrentEditControlGiveUpFocus();
        view.$setCurrentEditingEdit(null);
        view.requestFocusInWindow();
    }

    private boolean SimulateAdjustmentValueChanged(AdjustmentEvent e, int delta) {
        boolean wheelInner = false;
        WorkSheet_ sheet = this.innerSheet;
        if (e.getAdjustable().equals(this.hScrollBar)) {
            sheet.setXOffset(e.getValue());
        } else {
            String dsn = sheet.getDataSourceNameAtCurrentMousePoint();
            if (!dsn.equals("") && this.Book.getDataSource(dsn).getDataSourceType() == 2) {
                int RC = sheet.getRowCount();
                int CC = sheet.getColumnCount();
                Brick brick = null;
                int row = 0;
                while (row < RC) {
                    int col = 0;
                    while (col < CC) {
                        Cell cell = sheet.$Cells(row, col);
                        if (cell != null) {
                            int bc = cell.getBrickCount();
                            int bi = 0;
                            while (bi < bc) {
                                brick = cell.getBrick(bi);
                                if (brick instanceof ScrollBar && ((ScrollBar)brick).getDataSource().equals(dsn)) {
                                    int v = delta;
                                    if (v > 0) {
                                        ((ScrollBar_)brick).moveDown(1);
                                    } else {
                                        ((ScrollBar_)brick).moveUp(1);
                                    }
                                    wheelInner = true;
                                }
                                ++bi;
                            }
                        }
                        ++col;
                    }
                    ++row;
                }
            }
            if (!wheelInner) {
                sheet.setYOffset(e.getValue());
            }
        }
        if (this.paintTimer != null && !wheelInner) {
            this.paintTimer.cancel();
            this.paintTimer = null;
            this.paintTask = null;
        }
        return wheelInner;
    }

    private void SimulateAdjustmentValueChanged(AdjustmentEvent e, boolean immediately) {
        if (immediately) {
            this.SimulateAdjustmentValueChanged(e, e.getValue());
        } else {
            if (this.paintTimer != null) {
                this.paintTask.cancel();
                this.paintTask = null;
            }
            this.paintTimer = new Timer(true);
            this.paintTask = new ScrollTask(e);
            this.paintTimer.schedule((TimerTask)this.paintTask, 20L);
        }
    }

    public void ResetHScrollBarScrollRange() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CellPanel_.this.$ResetHScrollBarScrollRange();
            }
        });
    }

    private void $ResetHScrollBarScrollRange() {
        boolean oldVisible;
        WorkSheet_ sheet = this.innerSheet;
        if (sheet == null) {
            return;
        }
        WorkSheetView view = sheet.getWorkSheetView();
        if (view == null) {
            return;
        }
        Rectangle rc = view.getBounds();
        ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
        RowPropertyManage RPM = sheet.getRowPropertyManage();
        int all = CPM.getAllColumnsWidth();
        boolean newVisible = oldVisible = this.hScrollBar.isVisible();
        if (all + RPM.getRowHeadWidth() <= rc.width) {
            newVisible = false;
            this.hScrollBar.setVisible(newVisible);
            sheet.setXOffset(0);
        } else {
            newVisible = true;
            this.hScrollBar.setVisible(newVisible);
        }
        if (oldVisible != newVisible) {
            this.componentResized(null);
        }
        int oneScreen = rc.width - RPM.getRowHeadWidth() - CPM.getFixedColumnWidth();
        int UnitIncrement = 72;
        this.hScrollBar.removeAdjustmentListener(this);
        this.hScrollBar.setMinimum(0);
        int maxSize = Math.max(0, all - oneScreen + 10 - CPM.getFixedColumnWidth());
        float bl = 0.5f;
        maxSize = (int)((float)maxSize / (1.0f - bl));
        this.hScrollBar.setMaximum(maxSize);
        this.hScrollBar.setVisibleAmount((int)((float)this.hScrollBar.getMaximum() * bl));
        this.hScrollBar.setBlockIncrement(oneScreen);
        this.hScrollBar.setUnitIncrement(UnitIncrement);
        this.hScrollBar.setValue(sheet.getXOffset());
        this.hScrollBar.addAdjustmentListener(this);
    }

    public void ResetVScrollBarScrollRange() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CellPanel_.this.$ResetVScrollBarScrollRange();
            }
        });
    }

    private void $ResetVScrollBarScrollRange() {
        boolean oldVisible;
        WorkSheet_ sheet = this.innerSheet;
        if (sheet == null) {
            return;
        }
        WorkSheetView view = sheet.getWorkSheetView();
        if (view == null) {
            return;
        }
        Rectangle rc = view.getBounds();
        ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
        RowPropertyManage RPM = sheet.getRowPropertyManage();
        int all = RPM.getAllRowsHeight();
        int oneScreen = rc.height - CPM.getColumnHeadHeight() - RPM.getFixedRowHeight();
        boolean newVisible = oldVisible = this.vScrollBar.isVisible();
        if (all + CPM.getColumnHeadHeight() <= rc.height) {
            newVisible = false;
            this.vScrollBar.setVisible(newVisible);
            sheet.setYOffset(0);
        } else {
            newVisible = true;
            this.vScrollBar.setVisible(newVisible);
        }
        if (oldVisible != newVisible) {
            this.componentResized(null);
            return;
        }
        int UnitIncrement = 21;
        this.vScrollBar.removeAdjustmentListener(this);
        this.vScrollBar.setMinimum(0);
        int maxSize = Math.max(0, all - oneScreen + 50 - RPM.getFixedRowHeight());
        float bl = (float)(10000 - maxSize) / 10000.0f;
        if (bl > 0.9f) {
            bl = 0.9f;
        }
        if (bl < 0.0f) {
            bl = 0.1f;
        }
        maxSize = (int)((float)maxSize / (1.0f - bl));
        this.vScrollBar.setMaximum(maxSize);
        this.vScrollBar.setVisibleAmount((int)((float)this.vScrollBar.getMaximum() * bl));
        this.vScrollBar.setBlockIncrement(oneScreen);
        this.vScrollBar.setUnitIncrement(UnitIncrement);
        this.vScrollBar.setValue(sheet.getYOffset());
        this.vScrollBar.addAdjustmentListener(this);
    }

    public void VScroll(int delta) {
        AdjustmentEvent evt;
        boolean inner;
        int max;
        if (delta == 0) {
            return;
        }
        int v = this.vScrollBar.getValue();
        if ((v += delta) < 0) {
            v = 0;
        }
        if (v > (max = this.vScrollBar.getMaximum())) {
            v = max;
        }
        if (!(inner = this.SimulateAdjustmentValueChanged(evt = new AdjustmentEvent(this.vScrollBar, 0, 0, v), delta))) {
            this.vScrollBar.setValue(v);
        }
    }

    public void HScroll(int delta) {
        int max;
        if (delta == 0) {
            return;
        }
        int v = this.hScrollBar.getValue();
        if ((v += delta) < 0) {
            v = 0;
        }
        if (v > (max = this.hScrollBar.getMaximum())) {
            v = max;
        }
        this.hScrollBar.setValue(v);
        AdjustmentEvent evt = new AdjustmentEvent(this.hScrollBar, 0, 0, v);
        this.SimulateAdjustmentValueChanged(evt, delta);
    }

    public void keyPressed(KeyEvent e) {
        this.lastKeyEvent = e;
    }

    public void keyReleased(KeyEvent e) {
        this.lastKeyEvent = e;
    }

    public void keyTyped(KeyEvent e) {
        this.lastKeyEvent = e;
    }

    public boolean isVScrollBarVisible() {
        return this.vScrollBar.isVisible();
    }

    public boolean isHScrollBarVisible() {
        return this.hScrollBar.isVisible();
    }

    class ScrollTask
    extends TimerTask {
        AdjustmentEvent E;

        public ScrollTask(AdjustmentEvent e) {
            this.E = e;
        }

        public void run() {
            CellPanel_.this.SimulateAdjustmentValueChanged(this.E, this.E.getValue());
            if (CellPanel_.this.paintTimer != null) {
                CellPanel_.this.paintTimer.cancel();
            }
            CellPanel_.this.paintTimer = null;
        }
    }
}

