/*
 * Decompiled with CFR 0.152.
 */
package excel.command;

import excel.command.CommandBase;
import excel.command.CommandScene;
import excel.core.Cell;
import excel.core.MergedRange;
import excel.core.Range;
import excel.core.WorkSheet;
import java.util.HashMap;

public class CMD_UnMerge
extends CommandBase {
    public CMD_UnMerge(WorkSheet sheet, CommandScene scene) {
        super(sheet, scene);
    }

    public void $SaveScene() {
        int startRow = this.Scene.getInt("startrow");
        int startCol = this.Scene.getInt("startcol");
        int endRow = this.Scene.getInt("endrow");
        int endCol = this.Scene.getInt("endcol");
        HashMap MergeMap = this.Sheet.getMergeMap();
        HashMap<Range, String> mergedRange = new HashMap<Range, String>();
        int row = startRow;
        while (row <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                Cell cell = this.Sheet.$Cells(row, col);
                if (cell != null && cell.isMerged()) {
                    mergedRange.put(((MergedRange)MergeMap.get(cell)).getMergedRange(), "");
                }
                ++col;
            }
            ++row;
        }
        this.Scene.put("mergedrange", mergedRange);
    }

    public boolean $Execute() {
        int startRow = this.Scene.getInt("startrow");
        int startCol = this.Scene.getInt("startcol");
        int endRow = this.Scene.getInt("endrow");
        int endCol = this.Scene.getInt("endcol");
        return this.Sheet.$UnMerge(startRow, startCol, endRow, endCol);
    }

    public boolean $Undo() {
        HashMap mergedRange = (HashMap)this.Scene.get("mergedrange");
        for (Range r : mergedRange.keySet()) {
            this.Sheet.$Merge(r.getStartRow(), r.getStartCol(), r.getEndRow(), r.getEndCol());
        }
        return true;
    }
}

