/*
 * Decompiled with CFR 0.152.
 */
package excel.command;

import excel.command.CommandBase;
import excel.command.CommandScene;
import excel.core.Cell;
import excel.core.Range;
import excel.core.WorkSheet;
import excel.core.impl.Cell_;
import java.awt.Point;
import java.util.HashMap;

public class CMD_SetRangeProperty
extends CommandBase {
    public CMD_SetRangeProperty(WorkSheet sheet, CommandScene scene) {
        super(sheet, scene);
    }

    public void $SaveScene() {
        Range range = (Range)this.Scene.get("range");
        String propertyName = this.Scene.get("propertyname", "");
        HashMap<Point, Object> oldPropertyMap = new HashMap<Point, Object>();
        int row = range.getStartRow();
        while (row <= range.getEndRow()) {
            int col = range.getStartCol();
            while (col <= range.getEndCol()) {
                Cell cell = this.Sheet.CreateCell(row, col);
                Object oldPropertyValue = cell.getPropertyValue(propertyName, null);
                oldPropertyMap.put(new Point(row, col), oldPropertyValue);
                ++col;
            }
            ++row;
        }
        this.Scene.put("oldpropertymap", oldPropertyMap);
    }

    public boolean $Execute() {
        Range range = (Range)this.Scene.get("range");
        String propertyName = this.Scene.get("propertyname", "");
        Object propertyValue = this.Scene.get("propertyvalue", (Object)null);
        int row = range.getStartRow();
        while (row <= range.getEndRow()) {
            int col = range.getStartCol();
            while (col <= range.getEndCol()) {
                Cell_ cell = (Cell_)this.Sheet.Cells(row, col);
                if (propertyValue == null || !propertyValue.equals(cell.getPropertyValue(propertyName))) {
                    cell.$setProperty(propertyName, propertyValue);
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    public boolean $Undo() {
        Range range = (Range)this.Scene.get("range");
        String propertyName = this.Scene.get("propertyname", "");
        HashMap oldPropertyMap = (HashMap)this.Scene.get("oldpropertymap");
        int row = range.getStartRow();
        while (row <= range.getEndRow()) {
            int col = range.getStartCol();
            while (col <= range.getEndCol()) {
                Object oldPropertyValue;
                Cell_ cell = (Cell_)this.Sheet.Cells(row, col);
                if (!(cell == null || (oldPropertyValue = oldPropertyMap.get(new Point(row, col))) != null && oldPropertyValue.equals(cell.getPropertyValue(propertyName)))) {
                    cell.$setProperty(propertyName, oldPropertyValue);
                }
                ++col;
            }
            ++row;
        }
        return true;
    }
}

