/*
 * Decompiled with CFR 0.152.
 */
package excel.brick.impl;

import excel.brick.VirtualButton;
import excel.brick.impl.BasicBrick;
import excel.core.WorkBook;
import excel.core.impl.WorkSheetView_;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class VirtualButton_
extends BasicBrick
implements VirtualButton {
    private static final int $Normal = 0;
    private static final int $MouseEnter = 1;
    private static final int $MouseExited = 2;
    private static final int $Down = 3;
    private ArrayList actionList = null;
    private int State = 0;
    int He;
    int Wi;
    int left;
    int top;
    private String DataSource;
    private int Row;
    private String Col;
    private int cellRow;
    private int cellCol;
    private int W;
    private int H;
    private int CW;
    private int CH;

    public void paint(boolean isPrint, Graphics2D g, Rectangle parentRC) {
        if (!this.isVisible()) {
            return;
        }
        if (isPrint && !this.Printable) {
            return;
        }
        Rectangle rc = this.getBounds(parentRC);
        Shape oc = g.getClip();
        try {
            try {
                Tools.clip(g, rc);
                this.He = rc.height - 1;
                this.Wi = rc.width - 1;
                this.left = rc.x;
                this.top = rc.y;
                Color cFace = this.State != 2 ? new Color(14278585) : new Color(0xE9FFF9);
                double stepXP1 = 25.0 / (double)this.He;
                Color XPface = this.ShiftColor(cFace, 48);
                Color disbledColor = Color.gray;
                if (this.isEnabled()) {
                    int i;
                    if (this.State != 3) {
                        i = 1;
                        while (i <= this.He) {
                            this.DrawLine((Graphics)g, 2, i, this.Wi - 2, i, this.m_Enabled ? this.ShiftColor(XPface, -((int)(stepXP1 * (double)i))) : disbledColor);
                            ++i;
                        }
                    } else {
                        i = 1;
                        while (i <= this.He) {
                            this.DrawLine((Graphics)g, 2, i, this.Wi - 2, i, this.m_Enabled ? this.ShiftColor(XPface, -((int)(stepXP1 * (double)(this.He - i)))) : disbledColor);
                            ++i;
                        }
                    }
                    XPface = this.ShiftColor(new Color(64, 64, 128), 48);
                    if (this.State != 3) {
                        this.DrawLine((Graphics)g, 2, 1, this.Wi - 2, 1, 0xFFFFFF);
                        this.DrawLine((Graphics)g, 1, 2, this.Wi - 1, 2, 0xFFFFFF);
                        this.DrawLine((Graphics)g, 1, 2, 1, this.He - 2, new Color(250, 250, 245));
                        this.DrawLine((Graphics)g, 2, 3, 2, this.He - 3, new Color(245, 245, 238));
                        this.DrawLine((Graphics)g, 2, this.He - 1, this.Wi - 1, this.He - 1, new Color(207, 207, 189));
                        this.DrawLine((Graphics)g, 2, this.He - 2, this.Wi - 1, this.He - 2, new Color(223, 223, 210));
                        this.DrawLine((Graphics)g, this.Wi - 1, 2, this.Wi - 1, this.He - 1, new Color(207, 207, 189));
                        this.DrawLine((Graphics)g, this.Wi - 2, 3, this.Wi - 2, this.He - 2, new Color(223, 223, 210));
                    }
                    if (this.State == 3) {
                        this.DrawLine((Graphics)g, 2, 1, this.Wi - 2, 1, new Color(207, 207, 189));
                        this.DrawLine((Graphics)g, 1, 2, this.Wi - 1, 2, new Color(223, 223, 210));
                        this.DrawLine((Graphics)g, 1, 2, 1, this.He - 2, new Color(207, 207, 189));
                        this.DrawLine((Graphics)g, 2, 3, 2, this.He - 3, new Color(223, 223, 210));
                        this.DrawLine((Graphics)g, 2, this.He - 1, this.Wi - 1, this.He - 1, 0xFFFFFF);
                        this.DrawLine((Graphics)g, 2, this.He - 2, this.Wi - 1, this.He - 2, new Color(250, 250, 245));
                        this.DrawLine((Graphics)g, this.Wi - 1, 2, this.Wi - 1, this.He - 1, 0xFFFFFF);
                        this.DrawLine((Graphics)g, this.Wi - 2, 3, this.Wi - 2, this.He - 2, new Color(250, 250, 245));
                    }
                }
                Color borderColor = this.isEnabled() ? new Color(21628) : new Color(10527916);
                this.DrawLine((Graphics)g, 2, this.He, this.Wi - 3, this.He, borderColor);
                this.DrawLine((Graphics)g, this.Wi, 2, this.Wi, this.He - 3, borderColor);
                this.DrawLine((Graphics)g, 2, 0, this.Wi - 3, 0, borderColor);
                this.DrawLine((Graphics)g, 0, 2, 0, this.He - 3, borderColor);
                this.DrawLine((Graphics)g, 0, 2, 2, 0, borderColor);
                this.DrawLine((Graphics)g, 0, this.He - 2, 2, this.He, borderColor);
                this.DrawLine((Graphics)g, this.Wi - 2, 0, this.Wi, 2, borderColor);
                this.DrawLine((Graphics)g, this.Wi - 2, this.He, this.Wi, this.He - 2, borderColor);
                if (this.State == 1 && this.isEnabled()) {
                    this.DrawLine((Graphics)g, 2, this.He - 1, this.Wi - 3, this.He - 1, 0xF0AA00);
                }
                rc.x = rc.x + (this.State == 3 ? 1 : 0);
                ++rc.y;
                Tools.DrawString(g, rc, this.Caption, 0, null, new Color(224, 224, 224), "\u5b8b\u4f53", this.getFontSize(), false, false, false, 2, 2, false);
                --rc.y;
                if (this.isEnabled()) {
                    Tools.DrawString(g, rc, this.Caption, 0, null, Color.BLACK, "\u5b8b\u4f53", this.getFontSize(), false, false, false, 2, 2, false);
                }
            }
            catch (Exception exception) {
                Tools.setClip(g, oc);
            }
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    public VirtualButton_(String name, String caption) {
        super(name, 4);
        this.Caption = caption;
        this.setPrintable(false);
    }

    public VirtualButton_(String name, String caption, String dataSource) {
        super(name, 13);
        this.setDataSource(dataSource);
        this.Caption = caption;
        this.setPrintable(false);
    }

    void DrawLine(Graphics g, int x1, int y1, int x2, int y2, int color) {
        this.DrawLine(g, x1, y1, x2, y2, new Color(color));
    }

    void DrawLine(Graphics g, int x1, int y1, int x2, int y2, Color color) {
        g.setColor(color);
        g.drawLine(this.left + x1, this.top + y1, this.left + x2, this.top + y2);
    }

    Color ShiftColor(Color color, int value) {
        return new Color(Math.min(255, color.getRed() + value), Math.min(255, color.getGreen() + value), Math.min(255, color.getBlue() + value));
    }

    public void OnMouseMove(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.isLocked()) {
            pView.setCursor(WaitCursor);
            return;
        }
        pView.setCursor(HandCursor);
    }

    public void OnClick() {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.isLocked()) {
            return;
        }
        WorkBook book = this.pCell.getWorkSheet().getWorkBook();
        WorkSheetView_ pView = (WorkSheetView_)this.pCell.getWorkSheet().getWorkSheetView();
        pView.forceCurrentEditControlGiveUpFocus();
        if (this.actionList != null) {
            int i = 0;
            while (i < this.actionList.size()) {
                ActionListener action = (ActionListener)this.actionList.get(i);
                action.actionPerformed(null);
                ++i;
            }
        }
        book.getEM().fireVirtualButtonClicked(this.pCell.getWorkSheet(), this.pCell, this.Name);
    }

    public void OnLButtonClick(WorkSheetView_ pView, MouseEvent e) {
    }

    public void OnMouseEntered(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.isLocked()) {
            return;
        }
        this.State = 1;
        this.pCell.repaint();
    }

    public void OnMouseExited(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.isLocked()) {
            return;
        }
        this.State = 2;
        this.pCell.repaint();
    }

    public void OnLButtonDown(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.isLocked()) {
            return;
        }
        this.State = 3;
        this.pCell.repaint();
        pView.setCursor(HandCursor);
        super.OnLButtonDown(pView, e);
    }

    public void OnLButtonUp(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.isLocked()) {
            return;
        }
        this.State = 0;
        this.pCell.repaint();
        pView.setCursor(HandCursor);
        super.OnLButtonUp(pView, e);
    }

    public String getCaption() {
        return this.Caption;
    }

    public void setCaption(String caption) {
        this.Caption = caption;
    }

    public void addActionListener(ActionListener action) {
        if (this.actionList == null) {
            this.actionList = new ArrayList();
        }
        if (!this.actionList.contains(action)) {
            this.actionList.add(action);
        }
    }
}

