/*
 * Decompiled with CFR 0.152.
 */
package excel.brick.impl;

import excel.brick.SwitchHandle;
import excel.brick.impl.VirtualButton_;
import excel.core.ColumnPropertyManage;
import excel.core.RowPropertyManage;
import excel.core.WorkSheet;
import excel.util.Tools;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;

public class SwitchHandle_
extends VirtualButton_
implements SwitchHandle {
    private boolean expanded = true;
    private transient Image plusImg = null;
    private transient Image minusImg = null;
    private transient ActionListener action = null;
    private ArrayList rowList = new ArrayList();
    private ArrayList colList = new ArrayList();
    private HashMap rowHeightMap = new HashMap();
    private HashMap colWidthMap = new HashMap();

    public SwitchHandle_(String name) {
        super(name, "");
    }

    public void addRow(int row) {
        Integer R = new Integer(row);
        if (this.rowList.contains(R)) {
            return;
        }
        this.rowList.add(R);
    }

    public void addColumn(int col) {
        Integer C = new Integer(col);
        if (this.colList.contains(C)) {
            return;
        }
        this.colList.add(C);
    }

    public void addColumns(int startCol, int endCol) {
        int i = startCol;
        while (i <= endCol) {
            this.addColumn(i);
            ++i;
        }
    }

    public void addRows(int startRow, int endRow) {
        int i = startRow;
        while (i <= endRow) {
            this.addRow(i);
            ++i;
        }
    }

    public void paint(boolean isPrint, Graphics2D g, Rectangle parentRC) {
        if (!this.isVisible()) {
            return;
        }
        if (isPrint && !this.Printable) {
            return;
        }
        Rectangle rc = this.getBounds(parentRC);
        Shape oc = g.getClip();
        try {
            try {
                Tools.clip(g, rc);
                this.He = rc.height - 1;
                this.Wi = rc.width - 1;
                this.left = rc.x;
                this.top = rc.y;
                this.LoadImage();
                if (this.expanded) {
                    g.drawImage(this.minusImg, this.left, this.top, this.pCell.getWorkSheet().getWorkSheetView());
                }
                if (!this.expanded) {
                    g.drawImage(this.plusImg, this.left, this.top, this.pCell.getWorkSheet().getWorkSheetView());
                }
            }
            catch (Exception exception) {
                Tools.setClip(g, oc);
            }
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    private void LoadImage() {
        if (this.plusImg == null) {
            this.plusImg = Tools.GetImageFromURL(this.pCell.getWorkSheet().getWorkSheetView(), "excel/img/plus.gif");
        }
        if (this.minusImg == null) {
            this.minusImg = Tools.GetImageFromURL(this.pCell.getWorkSheet().getWorkSheetView(), "excel/img/minus.gif");
        }
    }

    public void OnClick() {
        if (this.expanded) {
            this.collapse();
        } else {
            this.expand();
        }
        super.OnClick();
    }

    public void collapse() {
        if (!this.expanded) {
            return;
        }
        this.expanded = false;
        WorkSheet sheet = this.pCell.getWorkSheet();
        RowPropertyManage RPM = sheet.getRowPropertyManage();
        int rc = sheet.getRowCount();
        this.rowHeightMap.clear();
        int i = 0;
        while (i < this.rowList.size()) {
            int row = (Integer)this.rowList.get(i);
            if (row < 0 || row >= rc) break;
            this.rowHeightMap.put(new Integer(row), new Integer(RPM.getRowHeight(row)));
            RPM.setRowHeight(row, 0);
            ++i;
        }
        int cc = sheet.getColumnCount();
        ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
        this.colWidthMap.clear();
        int i2 = 0;
        while (i2 < this.colList.size()) {
            int col = (Integer)this.colList.get(i2);
            if (col < 0 || col >= cc) break;
            this.colWidthMap.put(new Integer(col), new Integer(CPM.getColumnWidth(col)));
            CPM.setColumnWidth(col, 0);
            ++i2;
        }
        this.pCell.repaint();
    }

    public void expand() {
        if (this.expanded) {
            return;
        }
        this.expanded = true;
        WorkSheet sheet = this.pCell.getWorkSheet();
        RowPropertyManage RPM = sheet.getRowPropertyManage();
        int rc = sheet.getRowCount();
        int i = 0;
        while (i < this.rowList.size()) {
            int row = (Integer)this.rowList.get(i);
            if (row < 0 || row >= rc) break;
            RPM.setRowHeight(row, (Integer)this.rowHeightMap.get(new Integer(row)));
            ++i;
        }
        int cc = sheet.getColumnCount();
        ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
        int i2 = 0;
        while (i2 < this.colList.size()) {
            int col = (Integer)this.colList.get(i2);
            if (col < 0 || col >= cc) break;
            CPM.setColumnWidth(col, (Integer)this.colWidthMap.get(new Integer(col)));
            ++i2;
        }
        this.pCell.repaint();
    }

    public boolean isCollapsed() {
        return !this.expanded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setStateExpanded(boolean expanded) {
        this.expanded = expanded;
    }
}

