/*
 * Decompiled with CFR 0.152.
 */
package excel.brick.impl;

import excel.brick.ScrollBar;
import excel.brick.impl.BasicBrick;
import excel.core.ChangeListener;
import excel.core.RowPropertyManage;
import excel.core.WorkBook;
import excel.core.WorkSheet;
import excel.core.WorkSheetView;
import excel.core.impl.DataStoreEventAdapter;
import excel.core.impl.WorkSheetView_;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import jun.db.core.DataStore;

public class ScrollBar_
extends BasicBrick
implements ScrollBar,
ChangeListener {
    private Point lastPoint = null;
    public static final int W = 14;
    private static final Color lineColor = Color.gray;
    private transient Image upImg = null;
    private transient Image downImg = null;
    private transient Image scrollblockTopImg = null;
    private transient Image scrollblockBottomImg = null;
    private transient Image scrollblockBodyImg = null;
    private transient Image scrollblockCenterImg = null;
    private static final int ON_UPBUTTON = 1;
    private static final int ON_DOWNBUTTON = 2;
    private static final int ON_UPOFBLOCK = 3;
    private static final int ON_DOWNOFBLOCK = 4;
    private static final int ON_BLOCK = 5;
    private static final int ON_OUTOFSCROLLBAR = 0;
    private int maxSize = 0;
    private int blockSize = 0;
    private int blockOffset = 0;
    private int rowCountPerPage = 1;
    private static final int minBlockSize = 17;
    private int value = 0;
    private DataStoreEventAdapter registedToDSEA = null;
    private Timer timer = new Timer();
    private ClickTask clickTask = null;
    private Rectangle bound = new Rectangle();
    public static final int ACTION_CLICKUP = 1;
    public static final int ACTION_CLICKDOWN = 2;
    public static final int ACTION_PAGEUP = 3;
    public static final int ACTION_PAGEDOWN = 4;

    public Rectangle getBounds(Rectangle pRect) {
        Rectangle rc = super.getBounds(pRect);
        ++rc.y;
        --rc.height;
        rc.width = 15;
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    public void paint(boolean isPrint, Graphics2D g, Rectangle parentRC) {
        if (!this.isVisible()) {
            return;
        }
        if (isPrint && !this.Printable) {
            return;
        }
        this.registedToDSEA(this.pCell.getWorkSheet().getWorkBook());
        rc = this.getBounds(parentRC);
        oc = g.getClip();
        try {
            block16: {
                Tools.clip(g, rc);
                --rc.height;
                if (rc.width > 14) {
                    rc.width = 14;
                }
                this.bound.x = rc.x;
                this.bound.y = rc.y;
                this.bound.width = rc.width;
                this.bound.height = rc.height;
                g.setColor(new Color(0xFEFEFE));
                g.fillRect(rc.x, rc.y, rc.width, rc.height);
                g.setColor(ScrollBar_.lineColor);
                g.drawRoundRect(rc.x, rc.y, rc.width, rc.height, 3, 3);
                g.drawLine(rc.x, rc.y + 14, rc.x + rc.width, rc.y + 14);
                g.drawLine(rc.x, rc.y + rc.height - 14, rc.x + rc.width, rc.y + rc.height - 14);
                this.loadImage();
                view = this.pCell.getWorkSheet().getWorkSheetView();
                g.drawImage(this.upImg, rc.x + 1, rc.y + 1, view);
                g.drawImage(this.downImg, rc.x + 1, rc.y + rc.height - 14 + 1, view);
                dsc = this.pCell.getWorkSheet().getWorkBook().getDataSource(this.getDataSource());
                RPM = this.pCell.getWorkSheet().getRowPropertyManage();
                row = this.pCell.getRowIndex();
                RPM.setAutoAsyncHeightWithDBRowHeight(row, false);
                dbRowHeight = RPM.getDBRowHeight(row);
                this.rowCountPerPage = parentRC.height / dbRowHeight;
                if (dsc != null) break block16;
                this.maxSize = 0;
                this.blockSize = 0;
                ** GOTO lbl52
            }
            this.maxSize = dsc.getDataStore().getRowCount() - this.rowCountPerPage;
            if (this.value > this.maxSize) {
                this.value = this.maxSize;
                this.repaintRow();
                return;
            }
            try {
                scrollAreaHeight = rc.height - 28;
                if (scrollAreaHeight < 0 || this.maxSize < 0) {
                    this.maxSize = 0;
                    this.blockSize = 0;
                } else {
                    this.blockSize = scrollAreaHeight > this.maxSize + 17 ? scrollAreaHeight - this.maxSize : 17;
                }
lbl52:
                // 3 sources

                if (this.blockSize > 0) {
                    this.blockOffset = (int)((double)((rc.height - 28 - this.blockSize) * this.value) * 1.0 / (double)this.maxSize) + 1;
                    if (this.blockOffset < 0) {
                        this.blockSize += this.blockOffset;
                        this.blockOffset = 0;
                    }
                    g.drawImage(this.scrollblockTopImg, rc.x, rc.y + 14 + this.blockOffset, view);
                    i = 3;
                    while (i < this.blockSize - 3) {
                        g.drawImage(this.scrollblockBodyImg, rc.x, rc.y + 14 + this.blockOffset + i, view);
                        ++i;
                    }
                    g.drawImage(this.scrollblockBottomImg, rc.x, rc.y + 14 + this.blockOffset + this.blockSize - 4, view);
                    g.drawImage(this.scrollblockCenterImg, rc.x, rc.y + 14 + this.blockOffset + this.blockSize / 2 - 5, view);
                }
            }
            catch (Exception var6_7) {}
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    public void loadImage() {
        if (this.upImg != null) {
            return;
        }
        this.upImg = Tools.GetImageFromURL(this.pCell.getWorkSheet().getWorkSheetView(), "excel/res/up15.gif");
        this.downImg = Tools.GetImageFromURL(this.pCell.getWorkSheet().getWorkSheetView(), "excel/res/down15.gif");
        this.scrollblockTopImg = Tools.GetImageFromURL(this.pCell.getWorkSheet().getWorkSheetView(), "excel/res/scrollblocktop.gif");
        this.scrollblockBottomImg = Tools.GetImageFromURL(this.pCell.getWorkSheet().getWorkSheetView(), "excel/res/scrollblockbottom.gif");
        this.scrollblockBodyImg = Tools.GetImageFromURL(this.pCell.getWorkSheet().getWorkSheetView(), "excel/res/scrollblockbody.gif");
        this.scrollblockCenterImg = Tools.GetImageFromURL(this.pCell.getWorkSheet().getWorkSheetView(), "excel/res/scrollblockcenter.gif");
    }

    public ScrollBar_(WorkBook book, String name, String dsn) {
        super(name, 0);
        this.setDataSource(dsn);
        this.registedToDSEA(book);
    }

    private void registedToDSEA(WorkBook book) {
        if (this.registedToDSEA == null) {
            return;
        }
        if (book.getDataSource(this.getDataSource()) != null) {
            DataStore ds = book.getDataSource(this.getDataSource()).getDataStore();
            if (ds == null) {
                return;
            }
            this.registedToDSEA = (DataStoreEventAdapter)ds.getEvent().findListener(this.getDataSource());
            if (this.registedToDSEA != null) {
                this.registedToDSEA.addSubscriber(this);
            }
        }
    }

    public void OnMouseMove(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        pView.setCursor(HandCursor);
    }

    public void changed() {
        if (this.pCell != null) {
            DataStore ds = this.pCell.getWorkSheet().getWorkBook().getDataSource(this.getDataSource()).getDataStore();
            if (ds.getRowCount() == this.maxSize + 1) {
                return;
            }
            Tools.log("\u91cd\u65b0\u8ba1\u7b97");
            this.pCell.repaint();
        }
    }

    public int mouseOnWhere(Point p) {
        if (new Rectangle(this.bound.x, this.bound.y, this.bound.width, 14).contains(p)) {
            return 1;
        }
        if (new Rectangle(this.bound.x, this.bound.y + this.bound.height - 14, this.bound.width, 14).contains(p)) {
            return 2;
        }
        if (new Rectangle(this.bound.x, this.bound.y + 14, this.bound.width, this.blockOffset).contains(p)) {
            return 3;
        }
        if (new Rectangle(this.bound.x, this.bound.y + 14 + this.blockOffset + this.blockSize, this.bound.width, this.bound.height - 14 - 14 - this.blockOffset - this.blockSize).contains(p)) {
            return 4;
        }
        if (new Rectangle(this.bound.x, this.bound.y + 14 + this.blockOffset, this.bound.width, this.blockSize).contains(p)) {
            return 5;
        }
        return 0;
    }

    public void OnLButtonDown(WorkSheetView_ pView, MouseEvent e) {
        this.lastPoint = e.getPoint();
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        pView.setCursor(HandCursor);
        Point p = e.getPoint();
        int onWhere = this.mouseOnWhere(p);
        if (onWhere == 1) {
            this.timer.cancel();
            this.timer = new Timer();
            this.clickTask = new ClickTask(1);
            this.timer.schedule((TimerTask)this.clickTask, 300L, 50L);
        }
        if (onWhere == 2) {
            this.timer.cancel();
            this.timer = new Timer();
            this.clickTask = new ClickTask(2);
            this.timer.schedule((TimerTask)this.clickTask, 300L, 50L);
        }
        if (onWhere == 3) {
            this.timer.cancel();
            this.timer = new Timer();
            this.clickTask = new ClickTask(3);
            this.timer.schedule((TimerTask)this.clickTask, 300L, 50L);
        }
        if (onWhere == 4) {
            this.timer.cancel();
            this.timer = new Timer();
            this.clickTask = new ClickTask(4);
            this.timer.schedule((TimerTask)this.clickTask, 300L, 50L);
        }
    }

    public void OnLButtonUp(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        pView.setCursor(HandCursor);
        this.timer.cancel();
        Point p = e.getPoint();
        int onWhere = this.mouseOnWhere(p);
        if (onWhere == 1) {
            this.moveUp(1);
        }
        if (onWhere == 2) {
            this.moveDown(1);
        }
        if (onWhere == 3) {
            this.moveUp(this.rowCountPerPage);
        }
        if (onWhere == 4) {
            this.moveDown(this.rowCountPerPage);
        }
    }

    public void OnMouseDrag(WorkSheetView_ pView, MouseEvent e) {
        Point p = e.getPoint();
        if (this.lastPoint == null) {
            this.lastPoint = p;
        }
        int delta = p.y - this.lastPoint.y;
        this.lastPoint = p;
        this.setValue(this.value + delta);
    }

    public void moveUp(int step) {
        Tools.log("move up");
        if (this.value == 0) {
            return;
        }
        this.value -= step;
        if (this.value < 0) {
            this.value = 0;
        }
        this.repaintRow();
    }

    public void moveDown(int step) {
        Tools.log("move down");
        if (this.value == this.maxSize) {
            return;
        }
        this.value += step;
        if (this.value > this.maxSize) {
            this.value = this.maxSize;
        }
        this.repaintRow();
    }

    public void repaintRow() {
        int row = this.pCell.getRowIndex();
        WorkSheet pSheet = this.pCell.getWorkSheet();
        RowPropertyManage RPM = pSheet.getRowPropertyManage();
        RPM.setRowScrolledRowCount(row, this.value);
        WorkSheetView pView = pSheet.getWorkSheetView();
        Rectangle cellRC = ((WorkSheetView_)pView).getShowRectangleOfCell(false, row, this.pCell.getColumnIndex());
        Rectangle rc = pView.getBounds();
        pView.repaint(rc.x, cellRC.y, rc.width, cellRC.height);
    }

    public void setValue(int v) {
        if (v < 0 || v > this.maxSize) {
            return;
        }
        if (this.value == v) {
            return;
        }
        this.value = v;
        this.repaintRow();
    }

    class ClickTask
    extends TimerTask {
        private int action = 0;

        public ClickTask(int action_) {
            this.action = action_;
        }

        public void run() {
            if (this.action == 1) {
                ScrollBar_.this.moveUp(1);
            }
            if (this.action == 2) {
                ScrollBar_.this.moveDown(1);
            }
            if (this.action == 3) {
                ScrollBar_.this.moveUp(ScrollBar_.this.rowCountPerPage);
            }
            if (this.action == 4) {
                ScrollBar_.this.moveDown(ScrollBar_.this.rowCountPerPage);
            }
        }
    }
}

