/*
 * Decompiled with CFR 0.152.
 */
package excel.brick.impl;

import excel.brick.ImageButton;
import excel.brick.impl.BasicBrick;
import excel.core.WorkBook;
import excel.core.impl.WorkSheetView_;
import excel.util.Tools;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class ImageButton_
extends BasicBrick
implements ImageButton {
    private int Action = 0;
    private ArrayList actionList = null;
    String normalImageFile;
    String focusImageFile;
    String downImageFile;
    String disabledImageFile;
    private transient Image currentImg = null;
    private transient Image normalImg = null;
    private transient Image disabledImg = null;
    private transient Image downImg = null;
    private transient Image focusImg = null;
    private transient Cursor HandCursor = null;

    public void paint(boolean isPrint, Graphics2D g, Rectangle parentRC) {
        if (!this.isVisible()) {
            return;
        }
        if (isPrint && !this.Printable) {
            return;
        }
        this.LoadImage();
        Rectangle rc = this.getBounds(parentRC);
        Shape oc = g.getClip();
        try {
            try {
                Tools.clip(g, rc);
                g.drawImage(this.currentImg, rc.x, rc.y, this.getWorkSheetView());
            }
            catch (Exception exception) {
                Tools.setClip(g, oc);
            }
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    public ImageButton_(String name, String normalImage, String focusImage, String downImage, String disabledImage) {
        super(name, 18);
        this.normalImageFile = normalImage;
        this.focusImageFile = focusImage;
        this.downImageFile = downImage;
        this.disabledImageFile = disabledImage;
        this.setPrintable(false);
    }

    private void LoadImage() {
        if (this.currentImg != null) {
            return;
        }
        this.FixedSize = true;
        WorkSheetView_ pView = (WorkSheetView_)this.getWorkSheetView();
        this.normalImg = Tools.GetImageFromURL(pView, this.normalImageFile);
        this.downImg = Tools.GetImageFromURL(pView, this.downImageFile);
        this.focusImg = Tools.GetImageFromURL(pView, this.focusImageFile);
        this.disabledImg = Tools.GetImageFromURL(pView, this.disabledImageFile);
        this.Width = this.normalImg.getWidth(pView);
        this.Height = this.normalImg.getHeight(pView);
        this.currentImg = this.isEnabled() ? this.normalImg : this.disabledImg;
        this.HandCursor = new Cursor(12);
    }

    public void OnMouseMove(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        pView.setCursor(this.HandCursor);
    }

    public void OnClick() {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.isLocked()) {
            return;
        }
        if (this.pCell != null) {
            WorkBook book = this.pCell.getWorkSheet().getWorkBook();
            WorkSheetView_ pView = (WorkSheetView_)this.getWorkSheetView();
            pView.forceCurrentEditControlGiveUpFocus();
        }
        this.$OnClick();
    }

    public void $OnClick() {
        if (this.actionList != null) {
            int i = 0;
            while (i < this.actionList.size()) {
                ActionListener action = (ActionListener)this.actionList.get(i);
                action.actionPerformed(null);
                ++i;
            }
        }
        if (this.pCell != null) {
            WorkBook book = this.pCell.getWorkSheet().getWorkBook();
            book.getEM().fireVirtualButtonClicked(this.pCell.getWorkSheet(), this.pCell, this.Name);
        }
    }

    public void addActionListener(ActionListener action) {
        if (this.actionList == null) {
            this.actionList = new ArrayList();
        }
        if (!this.actionList.contains(action)) {
            this.actionList.add(action);
        }
    }

    public void OnLButtonClick(WorkSheetView_ pView, MouseEvent e) {
    }

    public void OnMouseEntered(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.currentImg = this.focusImg;
        if (this.pCell != null) {
            this.pCell.repaint();
        }
    }

    public void OnMouseExited(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.currentImg = this.normalImg;
        if (this.pCell != null) {
            this.pCell.repaint();
        }
    }

    public void OnLButtonDown(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.currentImg = this.downImg;
        if (this.pCell != null) {
            this.pCell.repaint();
        }
        pView.setCursor(this.HandCursor);
        super.OnLButtonDown(pView, e);
    }

    public void OnLButtonUp(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.currentImg = this.UpAtMe ? this.focusImg : this.normalImg;
        if (this.pCell != null) {
            this.pCell.repaint();
        }
        pView.setCursor(this.HandCursor);
        super.OnLButtonUp(pView, e);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.currentImg != null) {
            this.currentImg = null;
            this.LoadImage();
        }
        if (this.pCell != null) {
            this.pCell.repaint();
        }
    }
}

