/*
 * Decompiled with CFR 0.152.
 */
package org2.mozilla.javascript.tools.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org2.mozilla.javascript.Context;
import org2.mozilla.javascript.ContextAction;
import org2.mozilla.javascript.EvaluatorException;
import org2.mozilla.javascript.GeneratedClassLoader;
import org2.mozilla.javascript.Kit;
import org2.mozilla.javascript.NativeArray;
import org2.mozilla.javascript.RhinoException;
import org2.mozilla.javascript.Script;
import org2.mozilla.javascript.Scriptable;
import org2.mozilla.javascript.ScriptableObject;
import org2.mozilla.javascript.SecurityController;
import org2.mozilla.javascript.WrappedException;
import org2.mozilla.javascript.tools.ToolErrorReporter;
import org2.mozilla.javascript.tools.shell.Global;
import org2.mozilla.javascript.tools.shell.SecurityProxy;
import org2.mozilla.javascript.tools.shell.ShellContextFactory;

public class Main {
    public static final ShellContextFactory shellContextFactory = new ShellContextFactory();
    protected static final Global global = new Global();
    protected static ToolErrorReporter errorReporter;
    protected static int exitCode;
    private static final int EXITCODE_RUNTIME_ERROR = 3;
    private static final int EXITCODE_FILE_NOT_FOUND = 4;
    static boolean processStdin;
    static boolean sealedStdLib;
    static Vector fileList;
    private static SecurityProxy securityImpl;

    static {
        exitCode = 0;
        processStdin = true;
        sealedStdLib = false;
        fileList = new Vector(5);
    }

    public static void main(String[] args) {
        int result;
        try {
            if (Boolean.getBoolean("rhino.use_java_policy_security")) {
                Main.initJavaPolicySecuritySupport();
            }
        }
        catch (SecurityException ex) {
            ex.printStackTrace(System.err);
        }
        if ((result = Main.exec(args)) != 0) {
            System.exit(result);
        }
    }

    public static int exec(String[] origArgs) {
        int i = 0;
        while (i < origArgs.length) {
            String arg = origArgs[i];
            if (arg.equals("-sealedlib")) {
                sealedStdLib = true;
                break;
            }
            ++i;
        }
        errorReporter = new ToolErrorReporter(false, global.getErr());
        shellContextFactory.setErrorReporter(errorReporter);
        String[] args = Main.processOptions(origArgs);
        if (processStdin) {
            fileList.addElement(null);
        }
        IProxy iproxy = new IProxy(1);
        iproxy.args = args;
        shellContextFactory.call(iproxy);
        return exitCode;
    }

    static void processFiles(Context cx, String[] args) {
        if (!Main.global.initialized) {
            global.init(cx);
        }
        Object[] array = new Object[args.length];
        System.arraycopy(args, 0, array, 0, args.length);
        Scriptable argsObj = cx.newArray((Scriptable)global, array);
        global.defineProperty("arguments", argsObj, 2);
        int i = 0;
        while (i < fileList.size()) {
            Main.processSource(cx, (String)fileList.elementAt(i));
            ++i;
        }
    }

    public static Global getGlobal() {
        return global;
    }

    public static String[] processOptions(String[] args) {
        String usageError;
        int i = 0;
        while (true) {
            if (i == args.length) {
                return new String[0];
            }
            String arg = args[i];
            if (!arg.startsWith("-")) {
                processStdin = false;
                fileList.addElement(arg);
                String[] result = new String[args.length - i - 1];
                System.arraycopy(args, i + 1, result, 0, args.length - i - 1);
                return result;
            }
            if (arg.equals("-version")) {
                int version;
                if (++i == args.length) {
                    usageError = arg;
                    break;
                }
                try {
                    version = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    usageError = args[i];
                    break;
                }
                if (!Context.isValidLanguageVersion(version)) {
                    usageError = args[i];
                    break;
                }
                shellContextFactory.setLanguageVersion(version);
            } else if (arg.equals("-opt") || arg.equals("-O")) {
                int opt;
                if (++i == args.length) {
                    usageError = arg;
                    break;
                }
                try {
                    opt = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    usageError = args[i];
                    break;
                }
                if (opt == -2) {
                    opt = -1;
                } else if (!Context.isValidOptimizationLevel(opt)) {
                    usageError = args[i];
                    break;
                }
                shellContextFactory.setOptimizationLevel(opt);
            } else if (arg.equals("-strict")) {
                shellContextFactory.setStrictMode(true);
            } else if (arg.equals("-e")) {
                processStdin = false;
                if (++i == args.length) {
                    usageError = arg;
                    break;
                }
                IProxy iproxy = new IProxy(2);
                iproxy.scriptText = args[i];
                shellContextFactory.call(iproxy);
            } else if (arg.equals("-w")) {
                errorReporter.setIsReportingWarnings(true);
            } else if (arg.equals("-f")) {
                processStdin = false;
                if (++i == args.length) {
                    usageError = arg;
                    break;
                }
                fileList.addElement(args[i].equals("-") ? null : args[i]);
            } else if (arg.equals("-sealedlib")) {
                if (!sealedStdLib) {
                    Kit.codeBug();
                }
            } else {
                usageError = arg;
                break;
            }
            ++i;
        }
        Main.p(ToolErrorReporter.getMessage("msg.shell.usage", usageError));
        System.exit(1);
        return null;
    }

    private static void initJavaPolicySecuritySupport() {
        Throwable exObj;
        try {
            Class<?> cl = Class.forName("org2.mozilla.javascript.tools.shell.JavaPolicySecurity");
            securityImpl = (SecurityProxy)cl.newInstance();
            SecurityController.initGlobal(securityImpl);
            return;
        }
        catch (ClassNotFoundException ex) {
            exObj = ex;
        }
        catch (IllegalAccessException ex) {
            exObj = ex;
        }
        catch (InstantiationException ex) {
            exObj = ex;
        }
        catch (LinkageError ex) {
            exObj = ex;
        }
        throw Kit.initCause(new IllegalStateException("Can not load security support: " + exObj), exObj);
    }

    public static void processSource(Context cx, String filename) {
        if (filename == null || filename.equals("-")) {
            if (filename == null) {
                Main.getOut().println(cx.getImplementationVersion());
            }
            cx.setOptimizationLevel(-1);
            BufferedReader in = new BufferedReader(new InputStreamReader(global.getIn()));
            int lineno = 1;
            boolean hitEOF = false;
            while (!hitEOF) {
                int startline = lineno;
                if (filename == null) {
                    global.getErr().print("js> ");
                }
                global.getErr().flush();
                String source = "";
                do {
                    String newline;
                    try {
                        newline = in.readLine();
                    }
                    catch (IOException ioe) {
                        global.getErr().println(ioe.toString());
                        break;
                    }
                    if (newline == null) {
                        hitEOF = true;
                        break;
                    }
                    source = String.valueOf(source) + newline + "\n";
                    ++lineno;
                } while (!cx.stringIsCompilableUnit(source));
                Script script = Main.loadScriptFromSource(cx, source, "<stdin>", lineno, null);
                if (script == null) continue;
                Object result = Main.evaluateScript(script, cx, global);
                if (result != Context.getUndefinedValue()) {
                    try {
                        global.getErr().println(Context.toString(result));
                    }
                    catch (RhinoException rex) {
                        errorReporter.reportException(rex);
                    }
                }
                NativeArray h = Main.global.history;
                h.put((int)h.getLength(), (Scriptable)h, (Object)source);
            }
            global.getErr().println();
        } else {
            Main.processFile(cx, global, filename);
        }
        System.gc();
    }

    public static void processFile(Context cx, Scriptable scope, String filename) {
        if (securityImpl == null) {
            Main.processFileSecure(cx, scope, filename, null);
        } else {
            securityImpl.callProcessFileSecure(cx, scope, filename);
        }
    }

    static void processFileSecure(Context cx, Scriptable scope, String path, Object securityDomain) {
        Script script;
        if (path.endsWith(".class")) {
            script = Main.loadCompiledScript(cx, path, securityDomain);
        } else {
            String source = (String)Main.readFileOrUrl(path, true);
            if (source == null) {
                exitCode = 4;
                return;
            }
            if (source.length() > 0 && source.charAt(0) == '#') {
                int i = 1;
                while (i != source.length()) {
                    char c = source.charAt(i);
                    if (c == '\n' || c == '\r') {
                        source = source.substring(i);
                        break;
                    }
                    ++i;
                }
            }
            script = Main.loadScriptFromSource(cx, source, path, 1, securityDomain);
        }
        if (script != null) {
            Main.evaluateScript(script, cx, scope);
        }
    }

    public static Script loadScriptFromSource(Context cx, String scriptSource, String path, int lineno, Object securityDomain) {
        try {
            return cx.compileString(scriptSource, path, lineno, securityDomain);
        }
        catch (WrappedException we) {
            global.getErr().println(we.getWrappedException().toString());
            we.printStackTrace();
        }
        catch (EvaluatorException ee) {
            exitCode = 3;
        }
        catch (RhinoException rex) {
            errorReporter.reportException(rex);
            exitCode = 3;
        }
        catch (VirtualMachineError ex) {
            ex.printStackTrace();
            String msg = ToolErrorReporter.getMessage("msg.uncaughtJSException", ex.toString());
            exitCode = 3;
            Context.reportError(msg);
        }
        return null;
    }

    private static Script loadCompiledScript(Context cx, String path, Object securityDomain) {
        byte[] data = (byte[])Main.readFileOrUrl(path, false);
        if (data == null) {
            exitCode = 4;
            return null;
        }
        int nameStart = path.lastIndexOf(47);
        nameStart = nameStart < 0 ? 0 : ++nameStart;
        int nameEnd = path.lastIndexOf(46);
        if (nameEnd < nameStart) {
            nameEnd = path.length();
        }
        String name = path.substring(nameStart, nameEnd);
        try {
            GeneratedClassLoader loader = SecurityController.createLoader(cx.getApplicationClassLoader(), securityDomain);
            Class clazz = loader.defineClass(name, data);
            loader.linkClass(clazz);
            if (!Script.class.isAssignableFrom(clazz)) {
                throw Context.reportRuntimeError("msg.must.implement.Script");
            }
            return (Script)clazz.newInstance();
        }
        catch (RhinoException rex) {
            errorReporter.reportException(rex);
            exitCode = 3;
        }
        catch (IllegalAccessException iaex) {
            exitCode = 3;
            Context.reportError(iaex.toString());
        }
        catch (InstantiationException inex) {
            exitCode = 3;
            Context.reportError(inex.toString());
        }
        return null;
    }

    public static Object evaluateScript(Script script, Context cx, Scriptable scope) {
        if (!Main.global.initialized) {
            global.init(cx);
        }
        try {
            return script.exec(cx, scope);
        }
        catch (WrappedException we) {
            global.getErr().println(we.getWrappedException().toString());
            we.printStackTrace();
        }
        catch (RhinoException rex) {
            errorReporter.reportException(rex);
            exitCode = 3;
        }
        catch (VirtualMachineError ex) {
            ex.printStackTrace();
            String msg = ToolErrorReporter.getMessage("msg.uncaughtJSException", ex.toString());
            exitCode = 3;
            Context.reportError(msg);
        }
        return Context.getUndefinedValue();
    }

    private static void p(String s) {
        global.getOut().println(s);
    }

    public static ScriptableObject getScope() {
        if (!Main.global.initialized) {
            global.init(Context.getCurrentContext());
        }
        return global;
    }

    public static InputStream getIn() {
        return Global.getInstance(Main.getGlobal()).getIn();
    }

    public static void setIn(InputStream in) {
        Global.getInstance(Main.getGlobal()).setIn(in);
    }

    public static PrintStream getOut() {
        return Global.getInstance(Main.getGlobal()).getOut();
    }

    public static void setOut(PrintStream out) {
        Global.getInstance(Main.getGlobal()).setOut(out);
    }

    public static PrintStream getErr() {
        return Global.getInstance(Main.getGlobal()).getErr();
    }

    public static void setErr(PrintStream err) {
        Global.getInstance(Main.getGlobal()).setErr(err);
    }

    private static Object readFileOrUrl(String path, boolean convertToString) {
        byte[] data;
        URL url = null;
        if (path.indexOf(58) >= 2) {
            try {
                url = new URL(path);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        InputStream is = null;
        int capacityHint = 0;
        if (url == null) {
            File file = new File(path);
            capacityHint = (int)file.length();
            try {
                is = new FileInputStream(file);
            }
            catch (IOException ex) {
                Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open", path));
                return null;
            }
        }
        try {
            URLConnection uc = url.openConnection();
            is = uc.getInputStream();
            capacityHint = uc.getContentLength();
            if (capacityHint > 0x100000) {
                capacityHint = -1;
            }
        }
        catch (IOException ex) {
            Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open.url", url.toString(), ex.toString()));
            return null;
        }
        if (capacityHint <= 0) {
            capacityHint = 4096;
        }
        try {
            try {
                data = Kit.readStream(is, capacityHint);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            Context.reportError(ex.toString());
            return null;
        }
        Object result = !convertToString ? data : (Object)new String(data);
        return result;
    }

    private static class IProxy
    implements ContextAction {
        private static final int PROCESS_FILES = 1;
        private static final int EVAL_INLINE_SCRIPT = 2;
        private int type;
        String[] args;
        String scriptText;

        IProxy(int type) {
            this.type = type;
        }

        public Object run(Context cx) {
            if (this.type == 1) {
                Main.processFiles(cx, this.args);
            } else if (this.type == 2) {
                Script script = Main.loadScriptFromSource(cx, this.scriptText, "<command>", 1, null);
                if (script != null) {
                    Main.evaluateScript(script, cx, Main.getGlobal());
                }
            } else {
                throw Kit.codeBug();
            }
            return null;
        }
    }
}

