/*
 * Decompiled with CFR 0.152.
 */
package excel.ui.chktree;

import excel.ui.chktree.CheckBoxTreeLabel;
import excel.ui.chktree.CheckBoxTreeNode;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class CheckBoxTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    protected JCheckBox check;
    protected CheckBoxTreeLabel label;
    Icon rootIcon;
    Icon nodeOpen;
    Icon nodeClose;
    Icon leafIcon;

    public CheckBoxTreeCellRenderer(Component v) {
        this.setLayout(null);
        this.rootIcon = new ImageIcon(Tools.GetImageFromURL(v, "excel/img/tree.gif"));
        this.nodeOpen = new ImageIcon(Tools.GetImageFromURL(v, "excel/img/folderopened.gif"));
        this.nodeClose = new ImageIcon(Tools.GetImageFromURL(v, "excel/img/folderclosed.gif"));
        this.leafIcon = new ImageIcon(Tools.GetImageFromURL(v, "excel/img/rename.gif"));
        this.check = new JCheckBox();
        this.add(this.check);
        this.label = new CheckBoxTreeLabel();
        this.add(this.label);
        this.check.setBackground(UIManager.getColor("Tree.textBackground"));
        this.label.setForeground(UIManager.getColor("Tree.textForeground"));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        this.setEnabled(tree.isEnabled());
        if (value instanceof CheckBoxTreeNode) {
            this.check.setSelected(((CheckBoxTreeNode)value).isSelected());
        }
        this.label.setFont(tree.getFont());
        this.label.setText(stringValue);
        this.label.setSelected(selected);
        this.label.setFocus(hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.isRoot()) {
            this.label.setIcon(this.rootIcon);
            return this;
        }
        if (node.isLeaf()) {
            this.label.setIcon(null);
            return this;
        }
        if (expanded) {
            this.label.setIcon(this.nodeOpen);
        } else {
            this.label.setIcon(this.nodeClose);
        }
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension dCheck = this.check.getPreferredSize();
        Dimension dLabel = this.label.getPreferredSize();
        return new Dimension(dCheck.width + dLabel.width, Math.max(dCheck.height, dLabel.height));
    }

    public void doLayout() {
        Dimension dCheck = this.check.getPreferredSize();
        Dimension dLabel = this.label.getPreferredSize();
        int yCheck = 0;
        int yLabel = 0;
        if (dCheck.height < dLabel.height) {
            yCheck = (dLabel.height - dCheck.height) / 2;
        } else {
            yLabel = (dCheck.height - dLabel.height) / 2;
        }
        this.check.setLocation(0, 0);
        this.check.setBounds(0, 0, dCheck.width, dCheck.height - 2);
        this.label.setLocation(dCheck.width, 0);
        this.label.setBounds(dCheck.width, 0, dLabel.width, dLabel.height);
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(Color.white);
    }
}

