/*
 * Decompiled with CFR 0.152.
 */
package excel.tab;

import excel.core.WorkBookView;
import excel.core.WorkSheet;
import excel.core.WorkSheetTab;
import excel.core.WorkSheetTabContainer;
import excel.core.impl.WorkBookView_;
import excel.tab.NavigateButton;
import excel.tab.TabButton;
import excel.tab.TransparentFrame;
import excel.util.Tools;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class TabContainer
extends JLayeredPane
implements WorkSheetTabContainer,
ComponentListener,
MouseListener,
MouseMotionListener,
Serializable,
KeyListener {
    TransparentFrame m_TransFrame = null;
    private NavigateButton jb_First;
    private NavigateButton jb_Prior;
    private NavigateButton jb_Next;
    private NavigateButton jb_Last;
    private ArrayList TabList = new ArrayList();
    private int FirstViewButtonIndex = 0;
    private int CanMoveToButtonIndex = 0;
    private int ActiveTabIndex = 0;
    private WorkBookView_ BookView;

    public TabContainer(WorkBookView_ view) {
        this.BookView = view;
        this.setLayout(null);
        this.jb_First = new NavigateButton("excel/res/first.gif", this, 0);
        this.jb_Prior = new NavigateButton("excel/res/prior.gif", this, 1);
        this.jb_Next = new NavigateButton("excel/res/next.gif", this, 2);
        this.jb_Last = new NavigateButton("excel/res/last.gif", this, 3);
        int w = 15;
        int h = 15;
        this.jb_First.setBounds(0, 2, w, h);
        this.jb_Prior.setBounds(w + 1, 2, w, h);
        this.jb_Next.setBounds(2 * (w + 1), 2, w, h);
        this.jb_Last.setBounds(3 * (w + 1), 2, w, h);
        this.add(this.jb_First);
        this.add(this.jb_Prior);
        this.add(this.jb_Next);
        this.add(this.jb_Last);
        Dimension pd = new Dimension(1024, 18);
        this.setSize(pd);
        this.setPreferredSize(pd);
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.setFocusable(false);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public void showTabOnWhereChanged() {
        this.showTabOnWhereChanged(15, 15);
    }

    public void showTabOnWhereChanged(int w, int h) {
        if (this.getWorkBookView().getWorkBook().isShowTabOnBottom()) {
            this.jb_First.setBounds(0, 2, w, h);
            this.jb_Prior.setBounds(w + 1, 2, w, h);
            this.jb_Next.setBounds(2 * (w + 1), 2, w, h);
            this.jb_Last.setBounds(3 * (w + 1), 2, w, h);
        } else {
            this.jb_First.setBounds(0, 1, w, h);
            this.jb_Prior.setBounds(w + 1, 1, w, h);
            this.jb_Next.setBounds(2 * (w + 1), 1, w, h);
            this.jb_Last.setBounds(3 * (w + 1), 1, w, h);
        }
    }

    public WorkBookView getWorkBookView() {
        return this.BookView;
    }

    public void AddTab(WorkSheet sheet) {
        TabButton button = new TabButton(sheet, this);
        this.TabList.add(button);
        this.add(button.toJComponent());
        this.Layout();
    }

    public void RemoveTab(WorkSheet sheet) {
        int i = 0;
        while (i < this.TabList.size()) {
            WorkSheetTab button = (WorkSheetTab)this.TabList.get(i);
            if (button.getWorkSheet() == sheet) {
                this.TabList.remove(i);
                this.remove(button.toJComponent());
                break;
            }
            ++i;
        }
        this.Layout();
    }

    public void CalculateTabWidth() {
        WorkSheetTab button;
        int w = this.jb_Last.getX() + this.jb_Last.getWidth();
        int cw = this.getWidth() - w;
        int n = this.TabList.size();
        int[] tabWidth = new int[n];
        int i = 0;
        while (i < n) {
            WorkSheetTab button2 = (WorkSheetTab)this.TabList.get(i);
            if (!button2.getWorkSheet().isVisible()) {
                tabWidth[i] = 0;
            } else {
                Graphics2D g = (Graphics2D)this.getGraphics();
                Rectangle rc = Tools.getStringBounds(g, button2.getWorkSheet().getName(), "\u5b8b\u4f53", 12, false, false, false);
                tabWidth[i] = rc.width + 17;
                if (this.nextVisibleTabIndex(i) == -1) {
                    tabWidth[i] = tabWidth[i] + 8;
                }
            }
            ++i;
        }
        int totalWidth = 0;
        int i2 = 0;
        while (i2 < n) {
            totalWidth += tabWidth[i2];
            ++i2;
        }
        if (totalWidth < cw + w) {
            this.showTabOnWhereChanged(0, 0);
            w = 0;
            cw = this.getWidth() - w;
        } else {
            this.showTabOnWhereChanged(15, 15);
            w = this.jb_Last.getX() + this.jb_Last.getWidth();
            cw = this.getWidth() - w;
        }
        int w2 = 0;
        int i3 = n - 1;
        while (i3 >= 0) {
            button = (WorkSheetTab)this.TabList.get(i3);
            if ((w2 += tabWidth[i3]) > cw) break;
            this.CanMoveToButtonIndex = i3--;
        }
        if (this.FirstViewButtonIndex > this.CanMoveToButtonIndex) {
            this.FirstViewButtonIndex = this.CanMoveToButtonIndex;
        }
        w = this.jb_Last.getX() + this.jb_Last.getWidth() + 5;
        i3 = 0;
        while (i3 < n) {
            button = (WorkSheetTab)this.TabList.get(i3);
            if (i3 < this.FirstViewButtonIndex) {
                button.toJComponent().setBounds(0, 0, 0, 0);
            } else {
                button.toJComponent().setBounds(w, 0, tabWidth[i3], 18);
                button.toJComponent().setToolTipText(button.getWorkSheet().getName());
                w += tabWidth[i3];
            }
            ++i3;
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.setBackground(this.BookView.getBackground());
        super.paint(g);
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
        g2.setComposite(ac);
        g.setColor(Color.BLACK);
        this.DrawBorderLine(g, 0);
        g.setColor(Color.LIGHT_GRAY);
        this.DrawBorderLine(g, 1);
    }

    public void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        if (!this.getWorkBookView().getWorkBook().isShowTabOnBottom()) {
            y1 = 18 - y1 - 1;
            y2 = 18 - y2 - 1;
        }
        g.drawLine(x1, y1, x2, y2);
    }

    private void DrawBorderLine(Graphics g, int yOffset) {
        Rectangle rc = this.getBounds();
        int w = this.jb_Last.getX() + this.jb_Last.getWidth() + 4;
        WorkSheetTab tab = (WorkSheetTab)this.TabList.get(this.getActiveTabIndex());
        int ti = tab.getWorkSheet().getIndex();
        JComponent obj = tab.toJComponent();
        if (ti >= this.FirstViewButtonIndex) {
            this.drawLine(g, 0, yOffset, ((Component)obj).getX(), yOffset);
            this.drawLine(g, ((Component)obj).getX() + ((Component)obj).getWidth() + (this.nextVisibleTabIndex(ti) == -1 ? 0 : 8), yOffset, rc.width, yOffset);
        } else if (ti + 1 == this.FirstViewButtonIndex) {
            this.drawLine(g, 0, yOffset, w, yOffset);
            this.drawLine(g, w + 1 + 8, yOffset, rc.width, yOffset);
        } else {
            this.drawLine(g, 0, yOffset, rc.width, yOffset);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.CalculateTabWidth();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public int getActiveTabIndex() {
        return this.ActiveTabIndex;
    }

    public void setActiveTabIndex(int sheetIndex) {
        if (sheetIndex < 0) {
            return;
        }
        if (sheetIndex >= this.TabList.size()) {
            return;
        }
        this.ActiveTabIndex = sheetIndex;
        this.repaint();
    }

    public int getTabIndex(WorkSheetTab tab) {
        return this.TabList.indexOf(tab);
    }

    public ArrayList getTabList() {
        return this.TabList;
    }

    public int getTabCount() {
        return this.TabList.size();
    }

    public void ScrollTab(int action) {
        switch (action) {
            case 0: {
                this.FirstViewButtonIndex = this.firstVisibleTabIndex();
                break;
            }
            case 1: {
                this.FirstViewButtonIndex = this.priorVisibleTabIndex(this.FirstViewButtonIndex);
                break;
            }
            case 2: {
                this.FirstViewButtonIndex = this.nextVisibleTabIndex(this.FirstViewButtonIndex);
                if (this.FirstViewButtonIndex <= this.CanMoveToButtonIndex) break;
                this.FirstViewButtonIndex = this.CanMoveToButtonIndex;
                break;
            }
            case 3: {
                this.FirstViewButtonIndex = this.CanMoveToButtonIndex;
            }
        }
        this.Layout();
    }

    int firstVisibleTabIndex() {
        int n = this.TabList.size();
        int i = 0;
        while (i < n) {
            if (((WorkSheetTab)this.TabList.get(i)).getWorkSheet().isVisible()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int priorVisibleTabIndex(int n) {
        int i = n - 1;
        while (i >= 0) {
            if (((WorkSheetTab)this.TabList.get(i)).getWorkSheet().isVisible()) {
                return i;
            }
            --i;
        }
        return -1;
    }

    int nextVisibleTabIndex(int n) {
        int i = n + 1;
        while (i < this.TabList.size()) {
            if (((WorkSheetTab)this.TabList.get(i)).getWorkSheet().isVisible()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int lastVisibleTabIndex() {
        int i = this.TabList.size() - 1;
        while (i >= 0) {
            if (((WorkSheetTab)this.TabList.get(i)).getWorkSheet().isVisible()) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public void Layout() {
        this.CalculateTabWidth();
        this.repaint();
    }

    public JComponent toJComponeht() {
        return this;
    }

    int[] getTabWidthArray() {
        int n = this.TabList.size();
        int[] tabWidth = new int[n];
        int i = 0;
        while (i < n) {
            WorkSheetTab button = (WorkSheetTab)this.TabList.get(i);
            tabWidth[i] = button.toJComponent().getWidth();
            ++i;
        }
        return tabWidth;
    }

    int getFirstTabX() {
        return this.jb_Last.getX() + this.jb_Last.getWidth() + 5;
    }

    public void setTabIndex(WorkSheet sheet, int newIndex) {
        int i = 0;
        while (i < this.TabList.size()) {
            WorkSheetTab button = (WorkSheetTab)this.TabList.get(i);
            if (button.getWorkSheet() == sheet) {
                this.TabList.remove(i);
                this.TabList.add(newIndex, button);
                break;
            }
            ++i;
        }
        this.Layout();
    }

    public void keyPressed(KeyEvent e) {
        this.BookView.keyPressed(e);
    }

    public void keyReleased(KeyEvent e) {
        this.BookView.keyReleased(e);
    }

    public void keyTyped(KeyEvent e) {
        this.BookView.keyTyped(e);
    }
}

