/*
 * Decompiled with CFR 0.152.
 */
package excel.tab;

import excel.core.WorkBook;
import excel.core.WorkSheet;
import excel.core.WorkSheetTab;
import excel.core.ZExcel;
import excel.core.impl.WorkBookView_;
import excel.tab.TabContainer;
import excel.tab.TabNameEdit;
import excel.tab.TransparentFrame;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;

public class TabButton
extends JComponent
implements WorkSheetTab,
ComponentListener,
MouseListener,
MouseMotionListener,
Serializable,
KeyListener {
    private TabContainer tabContainer;
    private WorkSheet Sheet;
    private static Color FocusColor = new Color(128, 128, 255);
    private static Color FocusColor2 = new Color(255, 194, 72);
    private static Color NormalBackColor = new Color(15789025);
    private static Color BorderColor = new Color(64, 64, 64);
    private static Color LightBorderColor = new Color(228, 228, 238);
    private static Color Color_light = new Color(0xF8F8F8);
    private boolean m_IsDraging = false;
    private int newIndex;
    private TransparentFrame m_TransFrame = null;
    private Point m_MouseDownPoint = new Point(0, 0);
    private Point m_RootPoint = new Point(0, 0);

    public TabButton(WorkSheet sheet, TabContainer pContainer) {
        this.Sheet = sheet;
        this.tabContainer = pContainer;
        this.setFocusable(false);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public WorkSheet getWorkSheet() {
        return this.Sheet;
    }

    boolean noVisibleTabOnLeftOf(int n) {
        int i = 0;
        while (i < n) {
            if (((WorkSheetTab)this.tabContainer.getTabList().get(i)).getWorkSheet().isVisible()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        if (!this.tabContainer.getWorkBookView().getWorkBook().isShowTabOnBottom()) {
            y1 = 18 - y1;
            y2 = 18 - y2;
        }
        g.drawLine(x1, y1, x2, y2);
    }

    public void fillPolygon(Graphics g, int[] x, int[] y, int count) {
        if (!this.tabContainer.getWorkBookView().getWorkBook().isShowTabOnBottom()) {
            int i = 0;
            while (i < count) {
                y[i] = 18 - y[i];
                ++i;
            }
        }
        g.fillPolygon(x, y, count);
    }

    public void paint(Graphics g) {
        LightBorderColor = this.tabContainer.getBackground();
        Rectangle rc = this.getBounds();
        Rectangle prc = this.tabContainer.toJComponeht().getBounds();
        if (rc.x + rc.width > prc.width) {
            rc.width = prc.width - rc.x;
        }
        Graphics2D g2 = (Graphics2D)g;
        int ci = this.tabContainer.getActiveTabIndex();
        int ti = this.tabContainer.getTabIndex(this);
        int w = rc.width;
        boolean x = false;
        g.setColor(this.tabContainer.getBackground());
        g.fillRect(0, 0, rc.width, rc.height);
        g.setColor(NormalBackColor);
        int[] nArray = new int[4];
        nArray[1] = 8;
        nArray[2] = w;
        nArray[3] = w;
        int[] nArray2 = new int[4];
        nArray2[1] = 15;
        nArray2[2] = 15;
        this.fillPolygon(g, nArray, nArray2, 4);
        if (ti == 0 || this.noVisibleTabOnLeftOf(ti)) {
            if (ti == ci) {
                g.setColor(((WorkSheetTab)this.tabContainer.getTabList().get(ci)).getWorkSheet().getPaperColor());
                int[] nArray3 = new int[4];
                nArray3[1] = 8;
                nArray3[2] = w;
                nArray3[3] = w;
                int[] nArray4 = new int[4];
                nArray4[1] = 15;
                nArray4[2] = 15;
                this.fillPolygon(g, nArray3, nArray4, 4);
                g.setColor(BorderColor);
                this.drawLine(g, 0, 0, 8, 15);
                g.setColor(BorderColor);
                this.drawLine(g, 9, 16, w, 16);
                g.setColor(FocusColor2);
                this.drawLine(g, 9, 15, w - (this.tabContainer.nextVisibleTabIndex(ti) == -1 ? 8 : 0), 15);
                g.setColor(FocusColor);
                this.drawLine(g, 10, 17, w - (this.tabContainer.nextVisibleTabIndex(ti) == -1 ? 8 : 0), 17);
            } else {
                g.setColor(BorderColor);
                this.drawLine(g, 0, 0, 8, 15);
                g.setColor(BorderColor);
                this.drawLine(g, 9, 16, w, 16);
                g.setColor(this.tabContainer.getWorkBookView().getWorkBook().isShowTabOnBottom() ? Color.LIGHT_GRAY : Color_light);
                this.drawLine(g, 9, 15, w, 15);
            }
        } else {
            g.setColor(NormalBackColor);
            int[] nArray5 = new int[3];
            nArray5[1] = 5;
            int[] nArray6 = new int[3];
            nArray6[1] = 9;
            nArray6[2] = 15;
            this.fillPolygon(g, nArray5, nArray6, 3);
            if (ti == ci) {
                g.setColor(((WorkSheetTab)this.tabContainer.getTabList().get(ci)).getWorkSheet().getPaperColor());
                int[] nArray7 = new int[4];
                nArray7[1] = 8;
                nArray7[2] = w;
                nArray7[3] = w;
                int[] nArray8 = new int[4];
                nArray8[1] = 15;
                nArray8[2] = 15;
                this.fillPolygon(g, nArray7, nArray8, 4);
                g.setColor(BorderColor);
                this.drawLine(g, 0, 0, 8, 15);
                g.setColor(LightBorderColor);
                this.drawLine(g, 1, 0, 9, 15);
                g.setColor(BorderColor);
                this.drawLine(g, 9, 16, w, 16);
                this.drawLine(g, 1, 15, 4, 8);
                g.setColor(FocusColor2);
                this.drawLine(g, 9, 15, w - (this.tabContainer.nextVisibleTabIndex(ti) == -1 ? 8 : 0), 15);
                g.setColor(FocusColor);
                this.drawLine(g, 10, 17, w - (this.tabContainer.nextVisibleTabIndex(ti) == -1 ? 8 : 0), 17);
                g.setColor(Color.LIGHT_GRAY);
                this.drawLine(g, 0, 15, 3, 8);
                g.setColor(BorderColor);
                this.drawLine(g, 0, 15, 1, 15);
                g.setColor(this.tabContainer.getBackground());
                this.drawLine(g, 1, 15, 1, 15);
            } else {
                if (this.tabContainer.nextVisibleTabIndex(ci) == ti) {
                    g.setColor(((WorkSheetTab)this.tabContainer.getTabList().get(ci)).getWorkSheet().getPaperColor());
                    int[] nArray9 = new int[3];
                    nArray9[2] = 8;
                    int[] nArray10 = new int[3];
                    nArray10[1] = 15;
                    this.fillPolygon(g, nArray9, nArray10, 3);
                }
                g.setColor(BorderColor);
                this.drawLine(g, 0, 15, 8, 0);
                this.drawLine(g, 4, 8, 8, 15);
                g.setColor(LightBorderColor);
                this.drawLine(g, 1, 15, 9, 0);
                g.setColor(LightBorderColor);
                this.drawLine(g, 5, 8, 9, 15);
                g.setColor(BorderColor);
                this.drawLine(g, 9, 16, w, 16);
                g.setColor(this.tabContainer.getWorkBookView().getWorkBook().isShowTabOnBottom() ? Color.LIGHT_GRAY : Color_light);
                this.drawLine(g, 9, 15, w - (this.tabContainer.nextVisibleTabIndex(ti) == -1 ? 8 : 0), 15);
                g.setColor(LightBorderColor);
                this.drawLine(g, 9, 17, w, 17);
            }
        }
        if (this.tabContainer.nextVisibleTabIndex(ti) == -1) {
            rc.width -= 8;
            this.DrawCaption((Graphics2D)g, Color.BLACK, rc, 7);
            g.setColor(this.tabContainer.getBackground());
            int[] nArray11 = new int[3];
            nArray11[1] = 18;
            nArray11[2] = 18;
            this.fillPolygon(g, new int[]{w, w - 10, w}, nArray11, 3);
            g.setColor(BorderColor);
            this.drawLine(g, w - 9, 15, w - 1, 0);
            g.setColor(LightBorderColor);
            this.drawLine(g, w - 8, 15, w, 0);
        } else {
            this.DrawCaption((Graphics2D)g, Color.BLACK, rc, 7);
        }
    }

    public void paint2(Graphics g) {
        Rectangle rc = this.getBounds();
        Rectangle oc = g.getClipBounds();
        int ci = this.tabContainer.getActiveTabIndex();
        int ti = this.tabContainer.getTabIndex(this);
        int w = rc.width - 1;
        boolean x = false;
        g.setColor(this.tabContainer.getBackground());
        g.fillRect(0, 0, rc.width, rc.height);
        if (ti == ci) {
            g.setColor(BorderColor);
            this.drawLine(g, 0, 1, 0, 13);
            this.drawLine(g, 0, 13, 2, 15);
            this.drawLine(g, 2, 15, w - 3, 15);
            this.drawLine(g, w - 3, 15, w - 1, 13);
            this.drawLine(g, w - 1, 13, w - 1, 0);
            this.drawLine(g, w - 1, 0, w - 1, 1);
            g.setColor(new Color(225, 225, 225));
            this.drawLine(g, w, 1, w, 13);
            this.drawLine(g, w - 1, 14, w - 1, 14);
            int r = 0;
            while (r < 15) {
                int red = 255 - r * 2;
                int green = 255 - r * 2;
                int blue = 255 - r * 2;
                g.setColor(new Color(red, green, blue));
                if (r == 0) {
                    this.drawLine(g, 0, r, w - 1, r);
                }
                if (r <= 13) {
                    this.drawLine(g, 1, r, w - 2, r);
                }
                if (r == 14) {
                    this.drawLine(g, 2, r, w - 3, r);
                }
                ++r;
            }
            this.DrawCaption((Graphics2D)g, Color.BLACK, rc, 7);
        } else {
            g.setColor(BorderColor);
            if (ti - 1 != ci) {
                if (ti > 0) {
                    g.setColor(new Color(255, 255, 255));
                }
                this.drawLine(g, 0, 3, 0, 14);
            }
            g.setColor(BorderColor);
            if (ti + 1 != ci) {
                this.drawLine(g, w, 3, w, 14);
            }
            this.DrawCaption((Graphics2D)g, Color.BLACK, rc);
        }
        super.paint(g);
    }

    private void DrawCaption(Graphics2D g, Color c, Rectangle rc) {
        this.DrawCaption(g, c, rc, 0);
    }

    private void DrawCaption(Graphics2D g, Color c, Rectangle rc, int delta) {
        Rectangle trc = new Rectangle(rc);
        trc.x = 5 + delta;
        trc.width -= 10 + delta;
        trc.height = 15;
        trc.y = this.tabContainer.getWorkBookView().getWorkBook().isShowTabOnBottom() ? 0 : 2;
        if (this.Sheet.isTabHighLight()) {
            Tools.DrawString(g, trc, this.Sheet.getName(), 0, Color.BLACK, Color.BLACK, "\u5b8b\u4f53", 12, false, false, false, 0, 2, new Color(10547344));
        } else {
            Tools.DrawString(g, trc, this.Sheet.getName(), 0, Color.BLACK, this.Sheet.isTabHighLight() ? new Color(255) : c, "\u5b8b\u4f53", 12, false, false, false, 0, 2);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.Sheet.getWorkBook().getWorkBookView().forceCurrentEditControlGiveUpFocus();
        if (e.getClickCount() == 2) {
            this.Rename();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.Sheet.getWorkBook().setActiveSheet(this.Sheet.getIndex());
            this.requestFocusInWindow();
            this.m_MouseDownPoint = e.getPoint();
            this.m_TransFrame = this.tabContainer.m_TransFrame;
            if (this.m_TransFrame == null) {
                this.tabContainer.m_TransFrame = new TransparentFrame(this.tabContainer);
                this.tabContainer.m_TransFrame.setVisible(false);
                this.tabContainer.add(this.tabContainer.m_TransFrame);
                this.tabContainer.setLayer(this.tabContainer.m_TransFrame, JLayeredPane.DRAG_LAYER);
                this.m_TransFrame = this.tabContainer.m_TransFrame;
            }
        }
        if (e.getButton() == 3) {
            this.ShowMenu(e.getPoint());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.m_IsDraging) {
            if (this.newIndex >= 0) {
                this.Sheet.getWorkBook().setWorkSheetIndex(this.Sheet, this.newIndex);
                this.tabContainer.setActiveTabIndex(this.newIndex);
            }
            if (this.m_TransFrame != null) {
                this.m_TransFrame.setVisible(false);
            }
        }
        this.m_IsDraging = false;
        this.Sheet.getWorkSheetView().requestFocusInWindow();
    }

    public void mouseDragged(MouseEvent e) {
        this.m_IsDraging = true;
        Point p = new Point(e.getX(), e.getY());
        p = this.MapToTabCoordinate(p);
        int[] widthList = this.tabContainer.getTabWidthArray();
        int h = 15;
        this.newIndex = -1;
        Point p1 = null;
        Point p2 = null;
        if (p.y >= 0 && p.y <= h) {
            int w = this.tabContainer.getFirstTabX();
            int wi = 0;
            int thisIndex = this.Sheet.getIndex();
            int i = 0;
            while (i < widthList.length) {
                wi = widthList[i];
                if ((w += wi) > p.x) {
                    if (i == thisIndex) break;
                    this.newIndex = i;
                    if (thisIndex > i) {
                        if (w - wi / 2 < p.x) {
                            p1 = new Point(w - wi / 2, 0);
                            p2 = new Point(w + 8, h);
                            ++this.newIndex;
                        } else {
                            p1 = new Point(w - wi, 0);
                            p2 = new Point(w - wi / 2, h);
                        }
                    }
                    if (thisIndex >= i) break;
                    if (w - wi / 2 > p.x) {
                        p1 = new Point(w - wi, 0);
                        p2 = new Point(w - wi / 2, h);
                        --this.newIndex;
                        break;
                    }
                    p1 = new Point(w - wi / 2, 0);
                    p2 = new Point(w + 8, h);
                    break;
                }
                ++i;
            }
            if (this.newIndex != thisIndex && this.newIndex >= 0 && p1 != null && p2 != null) {
                Rectangle rc = new Rectangle(p1.x - 2, 0, p2.x - p1.x + 1, h);
                this.m_TransFrame.setBounds(rc);
                this.m_TransFrame.setVisible(true);
            }
        }
    }

    private Point MapToTabCoordinate(Point p) {
        return new Point(p.x + this.getX(), p.y + this.getY());
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public JComponent toJComponent() {
        return this;
    }

    public void keyPressed(KeyEvent e) {
        this.tabContainer.keyPressed(e);
    }

    public void keyReleased(KeyEvent e) {
        this.tabContainer.keyReleased(e);
    }

    public void keyTyped(KeyEvent e) {
        this.tabContainer.keyTyped(e);
    }

    public void ShowMenu(Point p) {
        JPopupMenu ret = new JPopupMenu("popup");
        Border border = BorderFactory.createLineBorder(new Color(88, 88, 103));
        ret.setBorder(border);
        JMenuItem m_insert = this.createMenuItem("\u63d2\u5165", "newsheet.gif");
        JMenuItem m_delete = this.createMenuItem("\u5220\u9664", "deletesheet.gif");
        JMenuItem m_rename = this.createMenuItem("\u91cd\u547d\u540d", "renamesheet.gif");
        JMenuItem m_printCurrent = this.createMenuItem(String.valueOf(this.Sheet.getPrintScale() == 0 ? "\u81ea\u9002\u5e94\u9875\u5bbd" : String.valueOf(this.Sheet.getPrintScale()) + "%") + "\u6253\u5370", "print.gif");
        JMenuItem m_print50 = this.createMenuItem("50%\u6253\u5370", "print.gif");
        JMenuItem m_print67 = this.createMenuItem("67%\u6253\u5370", "print.gif");
        JMenuItem m_print75 = this.createMenuItem("75%\u6253\u5370", "print.gif");
        JMenuItem m_print100 = this.createMenuItem("100%\u6253\u5370", "print.gif");
        JMenuItem m_print125 = this.createMenuItem("125%\u6253\u5370", "print.gif");
        JMenuItem m_print133 = this.createMenuItem("133%\u6253\u5370", "print.gif");
        JMenuItem m_print150 = this.createMenuItem("150%\u6253\u5370", "print.gif");
        JMenuItem m_print175 = this.createMenuItem("175%\u6253\u5370", "print.gif");
        JMenuItem m_print200 = this.createMenuItem("200%\u6253\u5370", "print.gif");
        JMenuItem m_print0 = this.createMenuItem("\u81ea\u9002\u5e94\u9875\u5bbd", "print.gif");
        JMenuItem m_printX = this.createMenuItem("\u81ea\u5b9a\u4e49\u6bd4\u4f8b\u6253\u5370", "print.gif");
        ret.add(m_printCurrent);
        JMenu m_printScale = this.createMenu("\u5176\u5b83\u6bd4\u4f8b\u6253\u5370", null);
        m_printScale.add(m_print50);
        m_printScale.add(m_print67);
        m_printScale.add(m_print75);
        m_printScale.add(m_print100);
        m_printScale.add(m_print125);
        m_printScale.add(m_print133);
        m_printScale.add(m_print150);
        m_printScale.add(m_print175);
        m_printScale.add(m_print200);
        m_printScale.add(m_print0);
        m_printScale.add(m_printX);
        ret.add(m_printScale);
        if (this.Sheet.isDesignMode()) {
            ret.add(m_insert);
            ret.add(m_delete);
            ret.add(m_rename);
        }
        m_insert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabButton.this.newWorkSheet();
            }
        });
        m_delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabButton.this.deleteWorkSheet();
            }
        });
        m_rename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabButton.this.Rename();
            }
        });
        m_printCurrent.addActionListener(new PrintAction(this.Sheet.getPrintScale()));
        m_print50.addActionListener(new PrintAction(50));
        m_print67.addActionListener(new PrintAction(67));
        m_print75.addActionListener(new PrintAction(75));
        m_print100.addActionListener(new PrintAction(100));
        m_print125.addActionListener(new PrintAction(125));
        m_print133.addActionListener(new PrintAction(133));
        m_print150.addActionListener(new PrintAction(150));
        m_print175.addActionListener(new PrintAction(175));
        m_print200.addActionListener(new PrintAction(200));
        m_print0.addActionListener(new PrintAction(0));
        m_printX.addActionListener(new PrintAction(-1));
        ret.show(this, p.x, p.y);
    }

    private JMenuItem createMenuItem(String caption, String icon) {
        if (icon == null) {
            icon = "menublack.gif";
        }
        JMenuItem ret = new JMenuItem(" " + caption, new ImageIcon(Tools.GetImageFromURL(this, "excel/img/" + icon)));
        Dimension dim = ret.getPreferredSize();
        dim.height = 19;
        ret.setPreferredSize(dim);
        Insets ins = new Insets(0, -17, 0, 0);
        if (!ZExcel.isJVM16()) {
            ret.setMargin(ins);
        }
        return ret;
    }

    private JMenu createMenu(String caption, String icon) {
        if (icon == null) {
            icon = "menublack.gif";
        }
        JMenu ret = new JMenu(" " + caption);
        ret.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/img/" + icon)));
        Dimension dim = ret.getPreferredSize();
        dim.height = 19;
        ret.setPreferredSize(dim);
        Insets ins = new Insets(0, -17, 0, 0);
        if (!ZExcel.isJVM16()) {
            ret.setMargin(ins);
        }
        return ret;
    }

    public void newWorkSheet() {
        WorkBook book = this.Sheet.getWorkBook();
        WorkSheet newSheet = book.newWorkSheet(null);
        WorkBookView_ view = (WorkBookView_)book.getWorkBookView();
        if (view != null) {
            Rectangle sheetRC = view.getSheetRect();
            newSheet.getWorkSheetView().setBounds(sheetRC);
        }
        int index = this.tabContainer.getTabIndex(this) + 1;
        this.tabContainer.setTabIndex(newSheet, index);
        this.Sheet.getWorkBook().setWorkSheetIndex(newSheet, index);
        this.tabContainer.setActiveTabIndex(index);
        book.setActiveSheet(index);
    }

    public void deleteWorkSheet() {
        WorkBook book = this.Sheet.getWorkBook();
        book.deleteWorkSheet(this.Sheet.getName());
    }

    public void Rename() {
        int ti;
        if (!this.Sheet.isDesignMode()) {
            return;
        }
        this.repaint();
        Rectangle rc = this.getBounds();
        Rectangle trc = new Rectangle(rc);
        int delta = 7;
        trc.x = 5 + delta;
        trc.width -= 10 + delta;
        trc.height = 13;
        if (!this.tabContainer.getWorkBookView().getWorkBook().isShowTabOnBottom()) {
            trc.y = 4;
        }
        if (this.tabContainer.nextVisibleTabIndex(ti = this.tabContainer.getTabIndex(this)) == -1) {
            trc.width -= 8;
        }
        TabNameEdit edit = new TabNameEdit();
        edit.setBounds(trc);
        edit.setBorder(null);
        this.add(edit);
        edit.BeginEdit(this.Sheet, this);
    }

    public void Print() {
        this.Sheet.getWorkSheetView().printPreview();
    }

    class PrintAction
    implements ActionListener {
        int scale;

        public PrintAction(int s) {
            this.scale = s;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.scale < 0) {
                String s = JOptionPane.showInputDialog("\u8f93\u5165\u6253\u5370\u6bd4\u4f8b(100\u8868\u793a1\uff1a1\u6bd4\u4f8b\u6253\u5370\uff0c\u6253\u5370\u8303\u56f4\u4e3a1 - 400)\uff1a ");
                try {
                    Integer i = Integer.valueOf(s);
                    int ii = i;
                    if (ii < 0 || ii > 400) {
                        Tools.ShowInfo(TabButton.this.Sheet.getWorkSheetView(), "\u8bf7\u8f93\u51651\u5230400\u4e4b\u95f4\u7684\u6570\u5b57");
                        return;
                    }
                    TabButton.this.Sheet.setPrintScale(ii);
                    TabButton.this.Print();
                }
                catch (Exception er) {
                    Tools.ShowInfo(TabButton.this.Sheet.getWorkSheetView(), "\u8bf7\u8f93\u51651\u5230400\u4e4b\u95f4\u7684\u6570\u5b57");
                    return;
                }
            } else {
                TabButton.this.Sheet.setPrintScale(this.scale);
                TabButton.this.Print();
            }
        }
    }
}

