/*
 * Decompiled with CFR 0.152.
 */
package excel.tab;

import excel.core.WorkSheetTabContainer;
import excel.tab.TabContainer;
import excel.util.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class NavigateButton
extends JPanel
implements ComponentListener,
MouseListener,
MouseMotionListener,
Serializable,
KeyListener {
    private WorkSheetTabContainer tabContainer;
    private int Action;
    JLabel icon;
    ImageIcon imgNormal;
    ImageIcon imgFocus;
    ImageIcon imgDown;
    Color bkNormal = Color.white;
    Color bkFocus = new Color(182, 189, 210);
    Color bkDown = new Color(133, 146, 181);
    Border borderFocus = BorderFactory.createLineBorder(new Color(0, 87, 128));
    Border borderNormal = null;

    public NavigateButton(String imgName, WorkSheetTabContainer pContainer, int action) {
        this.tabContainer = pContainer;
        this.bkNormal = Color.white;
        this.borderNormal = BorderFactory.createLineBorder(this.bkNormal);
        this.Action = action;
        this.setBorder(this.borderNormal);
        this.setLayout(new BorderLayout());
        this.icon = new JLabel("");
        Image img = Tools.GetImageFromURL(this, imgName);
        BufferedImage bimg = new BufferedImage(16, 16, 1);
        Graphics g = bimg.getGraphics();
        g.setColor(this.bkNormal);
        g.fillRect(0, 0, 16, 16);
        g.drawImage(img, 0, 0, this);
        this.imgNormal = new ImageIcon(bimg);
        g.dispose();
        bimg = new BufferedImage(16, 16, 1);
        g = bimg.getGraphics();
        g.setColor(this.bkFocus);
        g.fillRect(0, 0, 16, 16);
        g.drawImage(img, 0, 0, this);
        this.imgFocus = new ImageIcon(bimg);
        g.dispose();
        bimg = new BufferedImage(16, 16, 1);
        g = bimg.getGraphics();
        g.setColor(this.bkDown);
        g.fillRect(0, 0, 16, 16);
        g.drawImage(img, 1, 1, this);
        this.imgDown = new ImageIcon(bimg);
        g.dispose();
        this.icon.setIcon(this.imgNormal);
        this.setPreferredSize(new Dimension(16, 16));
        this.add(this.icon);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setCursor(new Cursor(12));
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.tabContainer.ScrollTab(this.Action);
    }

    public void mouseEntered(MouseEvent e) {
        this.setBorder(this.borderFocus);
        this.icon.setIcon(this.imgFocus);
    }

    public void mouseExited(MouseEvent e) {
        this.setBorder(this.borderNormal);
        this.icon.setIcon(this.imgNormal);
    }

    public void mousePressed(MouseEvent e) {
        this.setBorder(this.borderFocus);
        this.icon.setIcon(this.imgDown);
    }

    public void mouseReleased(MouseEvent e) {
        Rectangle rc = this.getBounds();
        rc.x = 0;
        rc.y = 0;
        if (rc.contains(e.getX(), e.getY())) {
            this.setBorder(this.borderFocus);
            this.icon.setIcon(this.imgFocus);
        } else {
            this.setBorder(this.borderNormal);
            this.icon.setIcon(this.imgNormal);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        ((TabContainer)this.tabContainer).keyPressed(e);
    }

    public void keyReleased(KeyEvent e) {
        ((TabContainer)this.tabContainer).keyReleased(e);
    }

    public void keyTyped(KeyEvent e) {
        ((TabContainer)this.tabContainer).keyTyped(e);
    }
}

