/*
 * Decompiled with CFR 0.152.
 */
package excel.setting;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ColorMenu
extends JMenu {
    protected Border unselectedBorder;
    protected Border selectedBorder;
    protected Border activeBorder;
    protected Hashtable paneTable;
    protected ColorPane colorPane;

    public ColorMenu(String name) {
        super(name);
        Dimension dim = this.getPreferredSize();
        dim.height = 19;
        this.setPreferredSize(dim);
        this.unselectedBorder = BorderFactory.createLineBorder(Color.GRAY);
        this.selectedBorder = BorderFactory.createLineBorder(new Color(88, 88, 103));
        this.activeBorder = BorderFactory.createLineBorder(Color.blue, 1);
        JPanel p = new JPanel();
        p.setBorder(new EmptyBorder(5, 5, 5, 5));
        Color[] colors = new Color[]{new Color(0, 0, 0), new Color(153, 51, 0), new Color(51, 51, 0), new Color(0, 51, 0), new Color(0, 51, 102), new Color(0, 0, 128), new Color(51, 51, 153), new Color(51, 51, 51), new Color(128, 0, 0), new Color(255, 102, 0), new Color(128, 128, 0), new Color(0, 128, 0), new Color(0, 128, 128), new Color(0, 0, 255), new Color(102, 102, 153), new Color(128, 128, 128), new Color(255, 0, 0), new Color(255, 103, 0), new Color(153, 204, 0), new Color(51, 153, 102), new Color(51, 204, 204), new Color(51, 102, 153), new Color(128, 0, 128), new Color(150, 150, 150), new Color(255, 0, 255), new Color(255, 204, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(0, 204, 255), new Color(153, 51, 102), new Color(192, 192, 192), new Color(255, 153, 204), new Color(255, 204, 153), new Color(255, 255, 153), new Color(204, 255, 204), new Color(204, 255, 255), new Color(153, 204, 255), new Color(247, 247, 247), new Color(255, 255, 255)};
        GridLayout gl = new GridLayout(5, 8);
        gl.setHgap(4);
        gl.setVgap(4);
        p.setLayout(gl);
        p.setBackground(Color.WHITE);
        this.paneTable = new Hashtable();
        int i = 0;
        while (i < colors.length) {
            Color c = colors[i];
            ColorPane pn = new ColorPane(c);
            p.add(pn);
            this.paneTable.put(c, pn);
            ++i;
        }
        this.add(p);
        Border border = BorderFactory.createLineBorder(new Color(88, 88, 103));
        ((JPopupMenu)p.getParent()).setBorder(border);
    }

    public void setColor(Color c) {
        Object obj = this.paneTable.get(c);
        if (obj == null) {
            return;
        }
        if (this.colorPane != null) {
            this.colorPane.setSelected(false);
        }
        this.colorPane = (ColorPane)obj;
        this.colorPane.setSelected(true);
    }

    public Color getColor() {
        if (this.colorPane == null) {
            return null;
        }
        return this.colorPane.getColor();
    }

    public void doSelection() {
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    class ColorPane
    extends JPanel
    implements MouseListener {
        protected Color color;
        protected boolean isSelected;

        public ColorPane(Color c) {
            this.color = c;
            this.setBackground(c);
            this.setBorder(ColorMenu.this.unselectedBorder);
            String msg = "\u7ea2" + c.getRed() + "\u7eff" + c.getGreen() + "\u84dd" + c.getBlue();
            this.setToolTipText(msg);
            this.addMouseListener(this);
        }

        public Color getColor() {
            return this.color;
        }

        public Dimension getPreferredSize() {
            return new Dimension(12, 12);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setSelected(boolean selected) {
            this.isSelected = selected;
            if (this.isSelected) {
                this.setBorder(ColorMenu.this.selectedBorder);
            } else {
                this.setBorder(ColorMenu.this.unselectedBorder);
            }
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            ColorMenu.this.setColor(this.color);
            MenuSelectionManager.defaultManager().clearSelectedPath();
            ColorMenu.this.doSelection();
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.setBorder(ColorMenu.this.activeBorder);
        }

        public void mouseExited(MouseEvent e) {
            this.setBorder(this.isSelected ? ColorMenu.this.selectedBorder : ColorMenu.this.unselectedBorder);
        }
    }
}

