/*
 * Decompiled with CFR 0.152.
 */
package excel.print;

import excel.core.ColumnPropertyManage;
import excel.core.RowPropertyManage;
import excel.core.impl.PrintRange_;
import excel.core.impl.WorkSheetView_;
import excel.core.impl.WorkSheet_;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;

public class PrintBook
implements Pageable {
    private List pages = new ArrayList();
    private List pageFormats = new ArrayList();
    private WorkSheetView_ View;
    private JFrame pFrame;

    public PrintBook(WorkSheetView_ view, JFrame frame) {
        this.View = view;
        this.pFrame = frame;
    }

    public Book getBook() {
        Book book = new Book();
        int numPages = this.getNumberOfPages();
        int i = 0;
        while (i < numPages) {
            Printable printable = this.getPrintable(i);
            PageFormat pageFormat = this.getPageFormat(i);
            book.append(printable, pageFormat);
            ++i;
        }
        return book;
    }

    public void addPage(PageFormat pageFormat) {
        try {
            this.pageFormats.add(pageFormat);
            PagePrintable printable = new PagePrintable();
            this.pages.add(printable);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    public void removePage(int pageIndex) throws IndexOutOfBoundsException {
        this.pages.remove(pageIndex);
        this.pageFormats.remove(pageIndex);
    }

    public int getNumberOfPages() {
        return this.pages.size();
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return (PageFormat)this.pageFormats.get(pageIndex);
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return (Printable)this.pages.get(pageIndex);
    }

    public Rectangle2D.Double getPrintArea(PageFormat pageFormat) {
        WorkSheet_ sheet = (WorkSheet_)this.View.getWorkSheet();
        Rectangle2D.Double client = new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth() * 100.0 / (double)sheet.getPrintScale(pageFormat.getImageableWidth()), pageFormat.getImageableHeight() * 100.0 / (double)sheet.getPrintScale(pageFormat.getImageableWidth()));
        return client;
    }

    public static double round(double num, int i) {
        if (num >= 0.0) {
            return Math.floor(num * Math.pow(10.0, i) + 0.5) / Math.pow(10.0, i);
        }
        return Math.ceil(num * Math.pow(10.0, i) - 0.5) / Math.pow(10.0, i);
    }

    class PagePrintable
    implements Printable {
        PagePrintable() {
        }

        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            Graphics2D g2 = (Graphics2D)graphics;
            WorkSheet_ sheet = (WorkSheet_)PrintBook.this.View.getWorkSheet();
            ArrayList pageRange = sheet.getPageRange();
            if (pageIndex >= pageRange.size()) {
                return 1;
            }
            sheet.setCurrentPrintingPage(pageIndex);
            PrintRange_ range = (PrintRange_)pageRange.get(pageIndex);
            RowPropertyManage RPM = sheet.getRowPropertyManage();
            ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
            int x = Math.max(0, CPM.getColumnX(range.getStartCol()) - CPM.getFixedColumnWidth());
            int y = Math.max(0, RPM.getRowY(range.getStartRow()) + range.getRowOffset() - RPM.getFixedRowHeight());
            sheet.setXPrintOffset(x);
            sheet.setYPrintOffset(y);
            double leftMargin = pageFormat.getImageableX();
            double topMargin = pageFormat.getImageableY();
            Rectangle2D.Double client = PrintBook.this.getPrintArea(pageFormat);
            double f = (float)sheet.getPrintScale(pageFormat.getImageableWidth()) * 1.0f / 100.0f;
            g2.translate(leftMargin, topMargin);
            g2.scale(f, f);
            int headerHeight = sheet.getPageHeader().getHeight();
            int footerHeight = sheet.getPageFooter().getHeight();
            if (headerHeight > 0) {
                Rectangle2D.Double headerRect = new Rectangle2D.Double(client.x, client.y, client.width, headerHeight);
                PrintBook.this.View.OnPrintPageHeader(g2, headerRect);
            }
            client.height = client.height - (double)headerHeight - (double)footerHeight;
            g2.translate(0, headerHeight);
            PrintBook.this.View.OnPrint(g2, client);
            if (footerHeight > 0) {
                Rectangle2D.Double footerRect = new Rectangle2D.Double(client.x, client.y, client.width, footerHeight);
                g2.translate(0.0, client.height);
                PrintBook.this.View.OnPrintPageFooter(g2, footerRect);
            }
            if (pageIndex >= pageRange.size()) {
                return 1;
            }
            return 0;
        }
    }
}

