/*
 * Decompiled with CFR 0.152.
 */
package excel.jep.function.VBScript;

import excel.jep.ParseException;
import excel.jep.function.PostfixMathCommand;
import java.math.BigDecimal;
import java.util.Stack;
import java.util.Vector;

public class Sqrt
extends PostfixMathCommand {
    public Sqrt() {
        this.numberOfParameters = 1;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.sqrt(param));
    }

    public Object sqrt(Object param) throws ParseException {
        if (param instanceof Number) {
            double value = ((Number)param).doubleValue();
            if (value < 0.0) {
                return null;
            }
            if (value >= 0.0) {
                return new BigDecimal(String.valueOf(Math.sqrt(value)));
            }
        }
        if (param instanceof Vector) {
            return this.vectorSqrt(param);
        }
        return null;
    }

    public Object vectorSqrt(Object param) throws ParseException {
        Vector<Object> ret = new Vector<Object>();
        Vector v1 = (Vector)param;
        int cc = v1.size();
        int i = 0;
        while (i < cc) {
            ret.add(this.sqrt(v1.get(i)));
            ++i;
        }
        return ret;
    }
}

