/*
 * Decompiled with CFR 0.152.
 */
package excel.jep.function.VBScript;

import excel.jep.ParseException;
import excel.jep.function.PostfixMathCommand;
import java.math.BigDecimal;
import java.util.Stack;
import java.util.Vector;

public class Round
extends PostfixMathCommand {
    public Round() {
        this.numberOfParameters = 2;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object p2 = inStack.pop();
        Object p1 = inStack.pop();
        inStack.push(this.round(p1, p2));
    }

    public Object round(Object p1, Object p2) {
        if (p1 == null || p2 == null) {
            return null;
        }
        if (!(p2 instanceof Number)) {
            return null;
        }
        if (p1 instanceof Vector) {
            return this.VectorRound(p1, p2);
        }
        BigDecimal b = p1 instanceof BigDecimal ? (BigDecimal)p1 : new BigDecimal(((Number)p1).doubleValue());
        return new Double(Round.round(((Number)p1).doubleValue(), ((Number)p2).intValue()));
    }

    public static double round(double num, int i) {
        double delta = 0.5000000001;
        if (num >= 0.0) {
            return Math.floor(num * Math.pow(10.0, i) + delta) / Math.pow(10.0, i);
        }
        return Math.ceil(num * Math.pow(10.0, i) - delta) / Math.pow(10.0, i);
    }

    public Object VectorRound(Object p1, Object p2) {
        Vector v1 = (Vector)p1;
        int i = 0;
        while (i < v1.size()) {
            v1.set(i, this.round(v1.get(i), p2));
            ++i;
        }
        return v1;
    }
}

