/*
 * Decompiled with CFR 0.152.
 */
package excel.jep.function.VBScript;

import excel.jep.ParseException;
import excel.jep.function.PostfixMathCommand;
import excel.jep.function.VBScript.FuncUtil;
import java.awt.Color;
import java.util.Stack;
import java.util.Vector;
import jun.db.core.ObjectTool;

public class RGB
extends PostfixMathCommand {
    public RGB() {
        this.numberOfParameters = 3;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object b = inStack.pop();
        Object g = inStack.pop();
        Object r = inStack.pop();
        inStack.push(this.rgb(r, g, b));
    }

    private Object rgb(Object r, Object g, Object b) throws ParseException {
        if (r == null) {
            return null;
        }
        if (g == null) {
            return null;
        }
        if (b == null) {
            return null;
        }
        if (r instanceof Vector || g instanceof Vector || b instanceof Vector) {
            return this.vectorRGB(r, g, b);
        }
        try {
            r = ObjectTool.ChangeType((Object)r, (String)"java.lang.Long");
            g = ObjectTool.ChangeType((Object)g, (String)"java.lang.Long");
            b = ObjectTool.ChangeType((Object)b, (String)"java.lang.Long");
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
        return new Color(((Number)r).intValue(), ((Number)g).intValue(), ((Number)b).intValue());
    }

    private Object vectorRGB(Object p1, Object p2, Object p3) throws ParseException {
        int c1 = 0;
        if (p1 instanceof Vector) {
            c1 = ((Vector)p1).size();
        }
        int c2 = 0;
        if (p2 instanceof Vector) {
            c2 = ((Vector)p2).size();
        }
        int c3 = 0;
        if (p3 instanceof Vector) {
            c3 = ((Vector)p3).size();
        }
        int cc = Math.max(Math.max(c1, c2), c3);
        Vector v1 = FuncUtil.checkVectorCount(p1, cc);
        Vector v2 = FuncUtil.checkVectorCount(p2, cc);
        Vector v3 = FuncUtil.checkVectorCount(p3, cc);
        Vector<Object> ret = new Vector<Object>();
        int i = 0;
        while (i < cc) {
            ret.add(this.rgb(v1.get(i), v2.get(i), v3.get(i)));
            ++i;
        }
        return ret;
    }
}

