/*
 * Decompiled with CFR 0.152.
 */
package excel.jep.function.VBScript;

import com.swetake.util.Qrcode;
import excel.jep.ParseException;
import excel.jep.function.PostfixMathCommand;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Stack;
import java.util.Vector;
import javax.imageio.ImageIO;
import jun.db.core.ObjectTool;
import jun.db.util.Base64Coder;

public class QRCoder
extends PostfixMathCommand {
    public QRCoder() {
        this.numberOfParameters = 4;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object p4 = inStack.pop();
        Object p3 = inStack.pop();
        Object p2 = inStack.pop();
        Object p1 = inStack.pop();
        inStack.push(this.QRCoder(p1, p2, p3, p4));
    }

    public Object QRCoder(Object str, Object ver, Object dot_, Object w) throws ParseException {
        if (str == null) {
            return null;
        }
        if (str instanceof Vector) {
            return this.vectorQRCoder(str, ver, dot_, w);
        }
        try {
            int width;
            Qrcode qrcode = new Qrcode();
            qrcode.setQrcodeErrorCorrect('M');
            qrcode.setQrcodeEncodeMode('B');
            qrcode.setQrcodeVersion(((Integer)ObjectTool.ChangeType((Object)ver, (String)"java.lang.Integer")).intValue());
            String qrData = str.toString();
            int height = width = ((Integer)ObjectTool.ChangeType((Object)w, (String)"java.lang.Integer")).intValue();
            BufferedImage bufferedImage = new BufferedImage(width, height, 1);
            Graphics2D gs = bufferedImage.createGraphics();
            gs.setBackground(Color.WHITE);
            gs.setColor(Color.BLACK);
            gs.clearRect(0, 0, width, height);
            int pixoff = 2;
            int dot = (Integer)ObjectTool.ChangeType((Object)dot_, (String)"java.lang.Integer");
            byte[] d = qrData.getBytes("UTF-8");
            boolean[][] s = qrcode.calQrcode(d);
            int i = 0;
            while (i < s.length) {
                int j = 0;
                while (j < s.length) {
                    if (s[j][i]) {
                        gs.fillRect(j * dot + pixoff, i * dot + pixoff, dot, dot);
                    }
                    ++j;
                }
                ++i;
            }
            gs.dispose();
            bufferedImage.flush();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", bos);
            bos.toByteArray();
            StringBuffer sb = new StringBuffer(1024);
            sb.append("$#{image}#$");
            sb.append(Base64Coder.encode((byte[])bos.toByteArray()));
            return sb.toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public Object vectorQRCoder(Object str, Object ver, Object w, Object dot) throws ParseException {
        Vector<Object> ret = new Vector<Object>();
        Vector v1 = (Vector)str;
        int cc = v1.size();
        int i = 0;
        while (i < cc) {
            ret.add(this.QRCoder(v1.get(i), ver, w, dot));
            ++i;
        }
        return ret;
    }
}

