/*
 * Decompiled with CFR 0.152.
 */
package excel.jep.function.VBScript;

import excel.jep.ParseException;
import excel.jep.function.PostfixMathCommand;
import excel.jep.function.VBScript.FuncUtil;
import java.math.BigDecimal;
import java.util.Stack;
import java.util.Vector;

public class Logical
extends PostfixMathCommand {
    int id;

    public Logical(int id_in) {
        this.id = id_in;
        this.numberOfParameters = 2;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        inStack.push(this.logic(param1, param2));
    }

    private Object logic(Object param1, Object param2) throws ParseException {
        if (param1 == null) {
            return null;
        }
        if (param2 == null) {
            return null;
        }
        if (param1 instanceof Vector || param2 instanceof Vector) {
            return this.vectorLogical(param1, param2);
        }
        if (param1 instanceof Boolean) {
            param1 = new Double((Boolean)param1 != false ? 1 : 0);
        }
        if (param2 instanceof Boolean) {
            param2 = new Double((Boolean)param2 != false ? 1 : 0);
        }
        if (param1 instanceof String) {
            param1 = new Double(((String)param1).equalsIgnoreCase("true") ? 1 : 0);
        }
        if (param2 instanceof String) {
            param2 = new Double(((String)param2).equalsIgnoreCase("true") ? 1 : 0);
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            int r;
            BigDecimal x = new BigDecimal(((Number)param1).doubleValue());
            BigDecimal y = new BigDecimal(((Number)param2).doubleValue());
            switch (this.id) {
                case 0: {
                    r = x.intValue() != 0 && y.intValue() != 0 ? 1 : 0;
                    break;
                }
                case 1: {
                    r = x.intValue() != 0 || y.intValue() != 0 ? 1 : 0;
                    break;
                }
                default: {
                    r = 0;
                }
            }
            return new BigDecimal(r);
        }
        throw new ParseException("Invalid parameter type");
    }

    private Object vectorLogical(Object p1, Object p2) throws ParseException {
        int c1 = 0;
        if (p1 instanceof Vector) {
            c1 = ((Vector)p1).size();
        }
        int c2 = 0;
        if (p2 instanceof Vector) {
            c2 = ((Vector)p2).size();
        }
        int cc = Math.max(c1, c2);
        Vector v1 = FuncUtil.checkVectorCount(p1, cc);
        Vector v2 = FuncUtil.checkVectorCount(p2, cc);
        Vector<Object> ret = new Vector<Object>();
        int i = 0;
        while (i < cc) {
            ret.add(this.logic(v1.get(i), v2.get(i)));
            ++i;
        }
        return ret;
    }
}

