/*
 * Decompiled with CFR 0.152.
 */
package excel.jep.function.VBScript;

import excel.jep.ParseException;
import excel.jep.function.PostfixMathCommand;
import java.util.Stack;
import java.util.Vector;

public class If
extends PostfixMathCommand {
    public If() {
        this.numberOfParameters = 3;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object p3 = inStack.pop();
        Object p2 = inStack.pop();
        Object p1 = inStack.pop();
        inStack.push(this.iif(p1, p2, p3));
    }

    public Object iif(Object p1, Object p2, Object p3) throws ParseException {
        if (p1 == null) {
            return null;
        }
        if (p1 instanceof Vector || p2 instanceof Vector || p3 instanceof Vector) {
            return this.vectorIf(p1, p2, p3);
        }
        if (p1 instanceof Number) {
            if (((Number)p1).intValue() > 0) {
                return p2;
            }
            return p3;
        }
        if (p1 instanceof Boolean) {
            if (((Boolean)p1).booleanValue()) {
                return p2;
            }
            return p3;
        }
        return "\u6761\u4ef6\u5fc5\u987b\u662fBoolean\u578b\u6216\u6570\u5b57\u578b";
    }

    public Object vectorIf(Object p1, Object p2, Object p3) throws ParseException {
        int c1 = 0;
        if (p1 instanceof Vector) {
            c1 = ((Vector)p1).size();
        }
        int c2 = 0;
        if (p2 instanceof Vector) {
            c2 = ((Vector)p2).size();
        }
        int c3 = 0;
        if (p3 instanceof Vector) {
            c3 = ((Vector)p3).size();
        }
        int cc = Math.max(Math.max(c1, c2), c3);
        Vector v1 = If.checkVectorCount(p1, cc);
        Vector v2 = If.checkVectorCount(p2, cc);
        Vector v3 = If.checkVectorCount(p3, cc);
        Vector<Object> ret = new Vector<Object>();
        int i = 0;
        while (i < cc) {
            ret.add(this.iif(v1.get(i), v2.get(i), v3.get(i)));
            ++i;
        }
        return ret;
    }

    public static Vector checkVectorCount(Object obj, int c) {
        Vector<Object> v = new Vector<Object>();
        if (obj instanceof Vector) {
            v.addAll((Vector)obj);
        } else {
            v.add(obj);
        }
        if (c == 0) {
            return v;
        }
        if (v.size() >= c) {
            return v;
        }
        Object lastP = null;
        if (v.size() > 0) {
            lastP = v.get(v.size() - 1);
        }
        int delta = c - v.size();
        int i = 0;
        while (i < delta) {
            v.add(lastP);
            ++i;
        }
        return v;
    }
}

