/*
 * Decompiled with CFR 0.152.
 */
package excel.jep.function.VBScript;

import excel.jep.ParseException;
import excel.jep.function.PostfixMathCommand;
import java.math.BigDecimal;
import java.util.Stack;
import java.util.Vector;

public class Divide
extends PostfixMathCommand {
    public Divide() {
        this.numberOfParameters = 2;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        inStack.push(this.div(param1, param2));
    }

    public Object div(Object param1, Object param2) throws ParseException {
        if (param1 == null || param2 == null) {
            return null;
        }
        if (param1 instanceof Vector || param2 instanceof Vector) {
            return this.TwoVectorDiv(param1, param2);
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            return this.div((Number)param1, (Number)param2);
        }
        return null;
    }

    public BigDecimal div(Number d1, Number d2) {
        BigDecimal b1 = new BigDecimal(d1.doubleValue());
        BigDecimal b2 = new BigDecimal(d2.doubleValue());
        if (d2.doubleValue() == 0.0) {
            return null;
        }
        BigDecimal ret = new BigDecimal(b1.doubleValue() / b2.doubleValue());
        return ret;
    }

    public Object TwoVectorDiv(Object p1, Object p2) throws ParseException {
        int i;
        Vector<Object> v1 = new Vector<Object>();
        if (p1 instanceof Vector) {
            v1.addAll((Vector)p1);
        } else {
            v1.add(p1);
        }
        Vector<Object> v2 = new Vector<Object>();
        if (p2 instanceof Vector) {
            v2.addAll((Vector)p2);
        } else {
            v2.add(p2);
        }
        int delta = v1.size() - v2.size();
        if (delta > 0) {
            Object lastP2 = null;
            if (v2.size() > 0) {
                lastP2 = v2.get(v2.size() - 1);
            }
            i = 0;
            while (i < delta) {
                v2.add(lastP2);
                ++i;
            }
        }
        if (delta < 0) {
            Object lastP1 = null;
            if (v1.size() > 0) {
                lastP1 = v1.get(v1.size() - 1);
            }
            i = 0;
            while (i < Math.abs(delta)) {
                v1.add(lastP1);
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < v1.size()) {
            v1.set(i2, this.div(v1.get(i2), v2.get(i2)));
            ++i2;
        }
        v2.clear();
        v2 = null;
        return v1;
    }
}

